/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          CSESLogData.h

Description:

    This file defines class CSESLogData.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Huang Miao  2008/11/29

  =====================================================================

****************************************************************************/

#ifndef CSESLOGDATA_H_
#define CSESLOGDATA_H_

#include <string.h>
#include "SESDataProvider.h"

#define	LOGFILE_DEFAULT "default"
#define	LOGFILE_STUDENT_PROGRAMSEARCH "student_program_search"
#define	LOGFILE_STUDENT_CONNECTTEACHER "student_connect_teacher"
#define	LOGFILE_STUDENT_DISCONNECTTEACHER "student_disconnect_teacher"
#define	LOGFILE_STUDENT_DEPLOYSCHEDULE "student_deploy_schedule"
#define	LOGFILE_STUDENT_DEPLOYTABNAV "student_deploy_tabnav"
#define	LOGFILE_TEACHER_PROGRAMSEARCH "teacher_program_search"
#define	LOGFILE_TEACHER_DEPLOYSCHDULE "teacher_deploy_schedule"
#define	LOGFILE_TEACHER_DEPLOYTABNAV "teacher_deploy_tabnav"
#define	LOGFILE_TEACHER_KICKOFFSTUDENT "teacher_kickoff_student"
#define	LOGFILE_TEACHER_NEWSTUDENT "teacher_newstudent"

namespace LibSESData
{
class CSESLogData: public LibSESData::CSESDataProvider
{
public:
	enum FunctionTag
	{
		LOG_DEFAULT = 0,
		LOG_STUDENT_PROGRAMSEARCH ,
		LOG_STUDENT_CONNECTTEACHER,
		LOG_STUDENT_DISCONNECTTEACHER,
		LOG_STUDENT_DEPLOYSCHEDULE,
		LOG_STUDENT_DEPLOYTABNAV,
		LOG_TEACHER_PROGRAMSEARCH,
		LOG_TEACHER_DEPLOYSCHDULE,
		LOG_TEACHER_DEPLOYTABNAV,
		LOG_TEACHER_KICKOFFSTUDENT,
		LOG_WINDOWS_MANAGER,
		LOG_NETWORK_ERROR //Don't use this.
	};
private:
	long int m_systemtime;
	std::string m_localetime;
	std::string m_value;
	std::string m_functionname;
	FunctionTag m_functiontag;
	std::string m_methodtag;
protected:
		virtual int DOM2Member();
		virtual int Member2DOM();
public:
	CSESLogData();
	virtual ~CSESLogData();

	void SetTime(long int time);
	void SetFunctionTag(FunctionTag Tag);
	void SetMethodTag(std::string Tag);
	void SetValue(std::string Value);

	std::string GetLocaleTime();
	long int GetSystemTime();
	FunctionTag GetFunctionTag();
	std::string GetFunctionName();
	std::string GetMethodTag();
	std::string GetValue();

};
}
#endif /* CSESLOGDATA_H_ */
