/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          IPCStudentDaemonAPI.h

Description:

    This file defines class IPCStudentDaemonAPI.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Sheng Lijie 2008/9/16

  =====================================================================

****************************************************************************/

#ifndef IPCSTUDENTDAEMONAPI_H_
#define IPCSTUDENTDAEMONAPI_H_

#include "IPCCommon.h"
#include "IPCAPIBase.h"
#include "IntfData.h"

namespace IPCAPI
{
class CExpandTeacherInfoData;

class IPCStudentDaemonAPI: public IPCAPI::IPCAPIBase
{
private:
	DBusMessage* m_objCurmsg;
	int m_iMsgType;

private:
	APIResult Initialize();
	APIResult UnInitialize();

	APIResult ReceiveMsg(int& iOPID, std::string& strOPName,	std::string& outArgs);
	APIResult SendMsg(int& iOPID, std::string strOPName, std::string inArgs);
	APIResult ReplyMsg(std::string inArgs);
public:
	IPCStudentDaemonAPI();
	virtual ~IPCStudentDaemonAPI();

	APIResult ReceiveMsg(CIntfData& InfoData);
	APIResult ReplyMsg(CIntfData* InfoData);
	APIResult SendMsg(CIntfData* InfoData);
	bool IsBlock();

	//for communication in deamon
	APIResult PostMessage(std::string MessageType, std::string MessageContent);

	//for callback
	APIResult SearchTeacherCallBack(std::list<CExpandTeacherInfoData>& TeacherList) ;
	APIResult NotifyLockStatusChanged(bool bLock) ;
	APIResult NotifyTabNavPolicyChanged() ;
	APIResult NotifyTeacherStatusChanged(std::string strTeacherID, int iState) ;
	APIResult SearchLocalProgramCallBack(std::string programsXML) ;
	APIResult NotifyTeacherNameChanged(std::string OldName, std::string NewName) ;
	APIResult PopNotifySend(int iMessageID, std::string MessageContent="");
//	APIResult ConnectTeacherCallBack(std::string strTeacherID, int iReturn) ;
//	APIResult NotifySchedulePolicyChanged() ;

};
}
#endif /*IPCSTUDENTDAEMONAPI_H_*/
