/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          TeacherInfoData.h

Description:

    This file defines class TeacherInfoData.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Sheng Lijie 2008/9/16

  =====================================================================

****************************************************************************/

#ifndef __EXPANDTEACHERINFODATA_H__
#define __EXPANDTEACHERINFODATA_H__

#include "SESDataProvider.h"
#include <string>

namespace IPCAPI
{
	class CExpandTeacherInfoData: public LibSESData::CSESDataProvider
	{
	public:
		CExpandTeacherInfoData();
		virtual ~CExpandTeacherInfoData();
		CExpandTeacherInfoData(const CExpandTeacherInfoData& data);
		CExpandTeacherInfoData& operator =(const CExpandTeacherInfoData& data);
	protected:
		int DOM2Member();
		int Member2DOM();

	private:
		std::string m_strTeacherUUID;
		std::string m_strTeacherName;
		std::string m_strCourse;
		std::string m_strIP;
		int m_iPort;
		int m_iDownloadPort;

	public:

		std::string GetTeacherUUID() const;

		void SetTeacherUUID(std::string TeacherUUID);

		std::string GetTeacherName() const;

		void SetTeacherName(std::string m_strTeacherName);

		std::string GetCourse() const;

		void SetCourse(std::string m_strCourse);

		std::string GetIP() const;

		void SetIP(std::string strIP);

		int GetPort() const;
		std::string GetStrPort();
		void SetPort(int iPort);
		void SetPort(std::string strPort);

		int GetDownloadPort() const;
		std::string GetStrDownloadPort();
		void SetDownloadPort(int iDownloadPort);
		void SetDownloadPort(std::string strDownloadPort);
	};

}

#endif /* __TEACHERINFODATA_H__ */
