/*
 * CAToolsWindow.cpp
 *
 *  Created on: Oct 20, 2008
 *      Author: lifeng
 */
#include "CAToolsWindow.h"
#include "CMessageBox.h"
using namespace LibSESGUI;
#include <string>
#include <CSESLog.h>
using namespace LibSESData;
#include <glib/gi18n.h>
#include"LibSESDataCommon.h"
#define SECOND_PAGE_ENTRY_MAX_LENGTH 50
enum
{
	GENERATE_NEW_CA_VALUE, IMPORT_CA_VALUE,
};
enum
{
	FIRST_PAGE_NUMBER,
	SECOND_PAGE_NUMBER,
	THIRD_PAGE_NUMBER,
	FOURTH_PAGE_NUMBER,
	FIFTH_PAGE_NUMBER,
};
using namespace std;
typedef gint (*GtkAssistantPageFunc)(gint current_page, gpointer data);
gint PageFunction(gint current_page, gpointer data)
{
	CAToolsWindow* ptr = (CAToolsWindow*) data;
	switch (current_page)
	{
	case 0:
		ptr->DealWithFirstPagePrepare();
		if (ptr->m_iIsGenerateNewCA == IMPORT_CA_VALUE)
		{
			string filePath;
			ptr->m_pUtil->GetPath(filePath);
			gtk_entry_set_text(GTK_ENTRY(ptr->m_gFilePathEntry), filePath.c_str());
		}
		return 1;
	case 1:
		return ptr->DealWithSecondPagePrepare();
	case 2:
		return ptr->DealWithThirdPagePrepare();
	case 3:
		return ptr->DealWithFourthPagePrepare();
	case 4:
		ptr->DealWithFirstPagePrepare();
		return 5;
	default:
		return -1;
	}
}
void CAToolsWindow::TrimString(string& message)
{
	string::size_type left(message.find_first_not_of(" "));
	if(left != string::npos)
	{
		message.erase(0, left);
	}
	else
	{
		message.erase(message.begin(), message.end());
	}
	string::size_type right(message.find_last_not_of(" "));
	if(right != string::npos)
	{
		message.erase (right+1);
	}
}
CAToolsWindow::CAToolsWindow()
{
	CSESLog::WriteLine("CAToolsWindow::CAToolsWindow()>>Start");
	m_pUtil = NULL;
	m_gAssistant = NULL;
	m_gUpperRadioBtn = NULL;
	m_gLowerRadioBtn = NULL;
	m_gSecondLabel = NULL;
	m_gSecondBtn = NULL;
	m_gPasswordEntry = NULL;
	m_gPassWordAgainEntry = NULL;
	m_gSecondVbox = NULL;
	m_gCheckBtn = NULL;
	m_gFifthLabel = NULL;
	CSESLog::WriteLine("CAToolsWindow::CAToolsWindow()<<End");
}
CAToolsWindow::~CAToolsWindow()
{
	CSESLog::WriteLine("CAToolsWindow::~CAToolsWindow()>>Start");
	if (m_pUtil != NULL)
	{
		delete m_pUtil;
		m_pUtil = NULL;
	}
	CSESLog::WriteLine("CAToolsWindow::~CAToolsWindow()<<End");
}
void CAToolsWindow::Init()
{
	CSESLog::WriteLine("CAToolsWindow::Init()>>Start");
	m_pUtil = new CAToolUtil();
	//m_pCSESDataTools = new CSESDataTools();
	InitWindow();
	CSESLog::WriteLine("CAToolsWindow::Init()<<Start");
}
void CAToolsWindow::InitWindow()
{
	CSESLog::WriteLine("CAToolsWindow::InitWindow()>>Start");
	m_gAssistant = gtk_assistant_new();
	gtk_window_set_resizable(GTK_WINDOW(m_gAssistant),false);
	g_signal_connect (G_OBJECT(m_gAssistant), "cancel", G_CALLBACK (OnAssistantCloseCancel), this);
	g_signal_connect (G_OBJECT (m_gAssistant), "close", G_CALLBACK (OnAssistantCloseCancel), this);
	//g_signal_connect (G_OBJECT (m_gAssistant), "prepare", G_CALLBACK (OnAssistantPrepare), this);
	GtkAssistantPageFunc pf = PageFunction;

	gtk_widget_set_size_request(GTK_WIDGET(m_gAssistant), 420, 250);
	gtk_window_set_position(GTK_WINDOW(m_gAssistant), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(m_gAssistant), _("CA Tool"));
	gtk_window_set_wmclass(GTK_WINDOW(m_gAssistant), _("CA Tool"), "SES");

	//gtk2-docsgtk_window_set_skip_taskbar_hint(GTK_WINDOW(m_gWindow), TRUE);

	CreateFirstPage(m_gAssistant);
	CreateSecondPage(m_gAssistant);
	CreateThirdPage(m_gAssistant);
	CreateFourthPage(m_gAssistant);
	CreateFifthPage(m_gAssistant);
	GtkWidget* current_page = gtk_assistant_get_nth_page(GTK_ASSISTANT(m_gAssistant), 0);
	gtk_assistant_set_page_complete(GTK_ASSISTANT(m_gAssistant), current_page, TRUE);
	CSESLog::WriteLine("CAToolsWindow::InitWindow()<<End");
	gtk_assistant_set_forward_page_func(GTK_ASSISTANT(m_gAssistant), pf, this, NULL);
//	string iconPath("");
//	iconPath.append(SES_RESOURCE_IMAGE_PATH);
//	iconPath.append("catool_main.png");
//	GError** error;
	gtk_window_set_icon_from_file(GTK_WINDOW(m_gAssistant), SES_CATOOL_ICON.c_str(), NULL);
}
void CAToolsWindow::Run()
{
	CSESLog::WriteLine("CAToolsWindow::Run()>>Start");
	if (!GTK_WIDGET_VISIBLE (m_gAssistant))
	{
		gtk_widget_show(m_gAssistant);
	}
	CSESLog::WriteLine("CAToolsWindow::Run()<<End");

}
gint CAToolsWindow::Close()
{
	gtk_widget_destroy(m_gAssistant);
	gtk_main_quit();
	return 0;
}

//void CAToolsWindow::OnWindowClosing(GtkDialog* widget, gint argc1, gpointer data)
//{
//	CAToolsWindow* ptr = (CAToolsWindow*)data;
//	if(-4 == argc1)
//	{
//		ptr->Release();
//	}
//
//}
void CAToolsWindow::Release()
{
	CSESLog::WriteLine("CAToolsWindow::Release()>>Start");
	if (NULL != m_gAssistant)
	{
		gtk_widget_destroy(m_gAssistant);
		m_gAssistant = NULL;
	}
	CSESLog::WriteLine("CAToolsWindow::Release()<<End");
}
void CAToolsWindow::CreateFirstPage(GtkWidget* assistant)
{
	CSESLog::WriteLine("CAToolsWindow::CreateFirstPage>>Start");
	GtkWidget* pVbox = NULL;
	GtkWidget* pHbox = NULL;
	pVbox = gtk_vbox_new(FALSE, 0);
	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 25);

	m_gUpperRadioBtn = gtk_radio_button_new_with_label(NULL, _("Import existed root CA"));
	g_signal_connect(G_OBJECT(m_gUpperRadioBtn), "toggled", G_CALLBACK(SetFirstToggleActive), this);
	gtk_box_pack_start(GTK_BOX(pHbox), m_gUpperRadioBtn, FALSE, FALSE, 10);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(m_gUpperRadioBtn), TRUE);

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 10);

	m_gLowerRadioBtn = gtk_radio_button_new_with_label(gtk_radio_button_get_group(GTK_RADIO_BUTTON(m_gUpperRadioBtn)), _("New root CA"));
	g_signal_connect(G_OBJECT(m_gLowerRadioBtn), "toggled", G_CALLBACK(SetFirstToggleActive), this);
	gtk_box_pack_start(GTK_BOX(pHbox), m_gLowerRadioBtn, FALSE, FALSE, 10);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(m_gLowerRadioBtn), FALSE);

	gtk_widget_show_all(pVbox);

	gtk_assistant_append_page(GTK_ASSISTANT(assistant), pVbox);
	gtk_assistant_set_page_title(GTK_ASSISTANT(assistant), pVbox, _("Configure Root CA"));
	gtk_assistant_set_page_type(GTK_ASSISTANT(assistant), pVbox, GTK_ASSISTANT_PAGE_INTRO);
	CSESLog::WriteLine("CAToolsWindow::CreateFirstPage<<End");
}
void CAToolsWindow::CreateSecondPage(GtkWidget* assistant)
{
	CSESLog::WriteLine("CAToolsWindow::CreateSecondPage>>Start");
	GtkWidget* pHbox = NULL;
	m_gSecondVbox = gtk_vbox_new(FALSE, 0);

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(m_gSecondVbox), pHbox, FALSE, FALSE, 28);

	m_gSecondLabel = gtk_label_new(_("Please select folder of root CA:"));
	gtk_box_pack_start(GTK_BOX(pHbox), m_gSecondLabel, FALSE, FALSE, 20);

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(m_gSecondVbox), pHbox, FALSE, FALSE, 0);

	m_gFilePathEntry = gtk_entry_new();
	gtk_entry_set_editable(GTK_ENTRY(m_gFilePathEntry), true);
	gtk_box_pack_start(GTK_BOX(pHbox), m_gFilePathEntry, FALSE, FALSE, 20);

	g_signal_connect(G_OBJECT(m_gFilePathEntry), "changed", G_CALLBACK(SetEntryActive), this);

	m_gSecondBtn = gtk_button_new_with_label(_("Browse..."));
	g_signal_connect(G_OBJECT(m_gSecondBtn), "clicked", G_CALLBACK(BrowseCallBack), this);
	gtk_box_pack_start(GTK_BOX(pHbox), m_gSecondBtn, FALSE, FALSE, 0);

	gtk_widget_show_all(m_gSecondVbox);

	gtk_assistant_append_page(GTK_ASSISTANT(assistant), m_gSecondVbox);
	gtk_assistant_set_page_title(GTK_ASSISTANT(assistant), m_gSecondVbox, _("Import Root CA"));
	gtk_assistant_set_page_type(GTK_ASSISTANT(assistant), m_gSecondVbox, GTK_ASSISTANT_PAGE_INTRO);

	//int page_number = gtk_assistant_get_current_page(GTK_ASSISTANT(m_gAssistant));
	GtkWidget* current_page = gtk_assistant_get_nth_page(GTK_ASSISTANT(m_gAssistant), 1);
	gtk_assistant_set_page_complete(GTK_ASSISTANT(m_gAssistant), current_page, TRUE);

	CSESLog::WriteLine("CAToolsWindow::CreateSecondPage<<End");
}

void CAToolsWindow::OnAssistantCloseCancel(GtkWidget* assistant, gpointer data)
{
	CSESLog::WriteLine("CAToolsWindow::OnAssistantCloseCancel>>Start");
	CAToolsWindow* ptr = (CAToolsWindow*) data;
	ptr->m_pUtil->Uninit();
	//ptr->Release();
	//gtk_widget_hide(assistant)
	ptr->Close();
	CSESLog::WriteLine("CAToolsWindow::OnAssistantCloseCancel<<End");
}

void CAToolsWindow::CreateThirdPage(GtkWidget* assistant)
{
	CSESLog::WriteLine("CAToolsWindow::CreateThirdPage>>Start");
	GtkWidget* pVbox = NULL;
	GtkWidget* pHbox = NULL;
	GtkWidget* pLabel = NULL;
	pVbox = gtk_vbox_new(FALSE, 0);
	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 22);

	pLabel = gtk_label_new(_("New Password:"));
	gtk_misc_set_alignment(GTK_MISC(pLabel), 1, 0.5);
//	gtk_label_set_width_chars(GTK_LABEL(pLabel), 20);
	gtk_box_pack_start(GTK_BOX(pHbox), pLabel, FALSE, FALSE, 10);

	m_gPasswordEntry = gtk_entry_new();
	g_signal_connect(G_OBJECT(m_gPasswordEntry), "changed", G_CALLBACK(FirstPasswdEntryActive), this);
	gtk_box_pack_end(GTK_BOX(pHbox), m_gPasswordEntry, FALSE, FALSE, 10);
	gtk_widget_set_size_request(GTK_WIDGET(m_gPasswordEntry), 200, 25);
	gtk_entry_set_text(GTK_ENTRY(m_gPasswordEntry), "");
	gtk_entry_set_max_length(GTK_ENTRY(m_gPasswordEntry), 64);
	gtk_entry_set_visibility(GTK_ENTRY(m_gPasswordEntry), FALSE);
	gtk_entry_set_invisible_char(GTK_ENTRY(m_gPasswordEntry), '*');

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 10);

	pLabel = gtk_label_new(_("Confirm New Password:"));
	gtk_misc_set_alignment(GTK_MISC(pLabel), 1, 0.5);
//	gtk_label_set_width_chars(GTK_LABEL(pLabel), 18);
	//gtk_label
	gtk_box_pack_start(GTK_BOX(pHbox), pLabel, FALSE, FALSE, 10);

	m_gPassWordAgainEntry = gtk_entry_new();
	g_signal_connect(G_OBJECT(m_gPassWordAgainEntry), "changed", G_CALLBACK(SecondPasswdEntryActive), this);
	gtk_box_pack_end(GTK_BOX(pHbox), m_gPassWordAgainEntry, FALSE, FALSE, 10);
	gtk_widget_set_size_request(GTK_WIDGET(m_gPassWordAgainEntry), 200, 25);
	gtk_entry_set_max_length(GTK_ENTRY(m_gPassWordAgainEntry), 64);
	gtk_entry_set_visibility(GTK_ENTRY(m_gPassWordAgainEntry), FALSE);
	gtk_entry_set_invisible_char(GTK_ENTRY(m_gPassWordAgainEntry), '*');

	gtk_widget_show_all(pVbox);
	gtk_assistant_append_page(GTK_ASSISTANT(assistant), pVbox);
	gtk_assistant_set_page_title(GTK_ASSISTANT(assistant), pVbox, _("Generate CA for Teacher"));
	gtk_assistant_set_page_type(GTK_ASSISTANT(assistant), pVbox, GTK_ASSISTANT_PAGE_INTRO);
	CSESLog::WriteLine("CAToolsWindow::CreateThirdPage<<End");
}

void CAToolsWindow::CreateFourthPage(GtkWidget* assistant)
{
	CSESLog::WriteLine("CAToolsWindow::CreateFourthPage>>Start");
	GtkWidget* pVbox = NULL;
	GtkWidget* pHbox = NULL;
	GtkWidget* pLabel = NULL;
	GtkWidget* pButton = NULL;
	pVbox = gtk_vbox_new(FALSE, 0);

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 12);

	pLabel = gtk_label_new(_("Please select folder:"));
	gtk_box_pack_start(GTK_BOX(pHbox), pLabel, FALSE, FALSE, 15);

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 0);

	m_gExportEntry = gtk_entry_new();
	gtk_entry_set_editable(GTK_ENTRY(m_gExportEntry), FALSE);
	g_signal_connect(G_OBJECT(m_gExportEntry), "changed", G_CALLBACK(ExportActive), this);
	gtk_box_pack_start(GTK_BOX(pHbox), m_gExportEntry, FALSE, FALSE, 15);

	pButton = gtk_button_new_with_label(_("Browse..."));
	gtk_box_pack_start(GTK_BOX(pHbox), pButton, FALSE, FALSE, 0);
	g_signal_connect(G_OBJECT(pButton), "clicked", G_CALLBACK(ExportCallBack), this);

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_end(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 10);

	m_gCheckBtn = gtk_check_button_new_with_label(_("Backup root CA at the same time"));
	gtk_box_pack_start(GTK_BOX(pHbox), m_gCheckBtn, FALSE, FALSE, 15);
	//g_signal_connect(G_OBJECT(m_gSecondBtn), "clicked", G_CALLBACK(ExportCallBack), this);

	gtk_widget_show_all(pVbox);
	gtk_assistant_append_page(GTK_ASSISTANT(assistant), pVbox);
	gtk_assistant_set_page_title(GTK_ASSISTANT(assistant), pVbox, _("Export Teacher CA"));
	gtk_assistant_set_page_type(GTK_ASSISTANT(assistant), pVbox, GTK_ASSISTANT_PAGE_INTRO);
	CSESLog::WriteLine("CAToolsWindow::CreateFourthPage<<End");
}
void CAToolsWindow::CreateFifthPage(GtkWidget* assistant)
{
	CSESLog::WriteLine("CAToolsWindow::CreateFifthPage>>Start");
	GtkWidget* pVbox = NULL;
	GtkWidget* pHbox = NULL;
	//GtkWidget* pLabel = NULL;
	pVbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_set_size_request(GTK_WIDGET(pVbox),350,100);

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 5);
	pHbox = gtk_hbox_new(FALSE, 0);
	m_gFifthTitle = gtk_label_new(_("CA information"));
	gtk_box_pack_start(GTK_BOX(pHbox),m_gFifthTitle,FALSE,FALSE,15);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 10);
	pHbox = gtk_hbox_new(FALSE, 0);
	m_gFifthDescription = gtk_label_new(_("Description :"));
	m_gFifthDescriptionText = gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(pHbox),m_gFifthDescription,false,false,15);
	gtk_box_pack_start(GTK_BOX(pHbox),m_gFifthDescriptionText,false,false,0);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 0);
	pHbox = gtk_hbox_new(FALSE, 0);
	m_gFifthPath = gtk_label_new(_("Export path :"));
	m_gFifthPathText = gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(pHbox),m_gFifthPath,false,false,15);
	gtk_box_pack_start(GTK_BOX(pHbox),m_gFifthPathText,false,false,0);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 0);
	pHbox = gtk_hbox_new(FALSE, 0);
	m_gFifthFiles = gtk_label_new(_("Export files:"));
	m_gFifthFilesText = gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(pHbox),m_gFifthFiles,false,false,15);
	gtk_box_pack_start(GTK_BOX(pHbox),m_gFifthFilesText,false,false,0);
	gtk_box_pack_start(GTK_BOX(pVbox), pHbox, FALSE, FALSE, 0);
	gtk_label_set_max_width_chars(GTK_LABEL(m_gFifthDescriptionText),30);
	gtk_label_set_ellipsize(GTK_LABEL(m_gFifthDescriptionText),PANGO_ELLIPSIZE_END);
	gtk_label_set_max_width_chars(GTK_LABEL(m_gFifthPathText),30);
	gtk_label_set_ellipsize(GTK_LABEL(m_gFifthPathText),PANGO_ELLIPSIZE_END);
	gtk_label_set_max_width_chars(GTK_LABEL(m_gFifthFilesText),30);
	gtk_label_set_ellipsize(GTK_LABEL(m_gFifthFilesText),PANGO_ELLIPSIZE_END);




    /*
	m_gFifthLabel = gtk_label_new("");
	gtk_widget_set_size_request(GTK_WIDGET(m_gFifthLabel),350,120);
	gtk_box_pack_start(GTK_BOX(pHbox), m_gFifthLabel, FALSE, FALSE, 15);
	gtk_label_set_ellipsize(GTK_LABEL(m_gFifthLabel),PANGO_ELLIPSIZE_END);
	gtk_label_set_line_wrap(GTK_LABEL(m_gFifthLabel), true);
	*/
	gtk_widget_show_all(pVbox);
	gtk_assistant_append_page(GTK_ASSISTANT(assistant), pVbox);
	gtk_assistant_set_page_title(GTK_ASSISTANT(assistant), pVbox, _("Successful"));
	gtk_assistant_set_page_type(GTK_ASSISTANT(assistant), pVbox, GTK_ASSISTANT_PAGE_SUMMARY);
	CSESLog::WriteLine("CAToolsWindow::CreateFifthPage<<End");
}


void CAToolsWindow::SetFirstToggleActive(GtkToggleButton* toggle, gpointer data)
{
	CSESLog::WriteLine("CAToolsWindow::SetFirstToggleActive>>Start");
	CAToolsWindow* ptr = (CAToolsWindow*) data;
	if (FALSE == gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ptr->m_gUpperRadioBtn)))
	{
		gtk_assistant_set_page_title(GTK_ASSISTANT(ptr->m_gAssistant), ptr->m_gSecondVbox, _("New Root CA"));
		gtk_label_set_text(GTK_LABEL(ptr->m_gSecondLabel), _("Please input description of root CA:"));
		gtk_widget_hide(ptr->m_gSecondBtn);
	}
	else
	{
		gtk_assistant_set_page_title(GTK_ASSISTANT(ptr->m_gAssistant), ptr->m_gSecondVbox, _("Import Root CA"));
		gtk_label_set_text(GTK_LABEL(ptr->m_gSecondLabel), _("Please select folder:"));
		gtk_widget_show(ptr->m_gSecondBtn);
	}

	CSESLog::WriteLine("CAToolsWindow::SetFirstToggleActive<<End");
}

void CAToolsWindow::BrowseCallBack(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("CAToolsWindow::BrowseCallBack>>Start");
	CAToolsWindow* ptr = (CAToolsWindow*) data;
	GtkWidget* dialog = NULL;
	dialog = gtk_file_chooser_dialog_new(_("Select Folder"), GTK_WINDOW(ptr->m_gAssistant), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN,
			GTK_RESPONSE_ACCEPT, NULL);
	//gtk_file_chooser_set_local_only(GTK_FILE_CHOOSER(dialog), TRUE);
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(dialog), "/home/");
	int response = gtk_dialog_run(GTK_DIALOG (dialog));
	if (GTK_RESPONSE_ACCEPT == response)
	{
		gtk_entry_set_text(GTK_ENTRY(ptr->m_gFilePathEntry), gtk_file_chooser_get_filename(
				GTK_FILE_CHOOSER(dialog)));
	}
	gtk_widget_destroy(dialog);
	CSESLog::WriteLine("CAToolsWindow::BrowseCallBack<<End");
}

void CAToolsWindow::SetEntryActive(GtkEntry* entry, gpointer data)
{
	CSESLog::WriteLine("CAToolsWindow::SetEntryActive>>Start");
	CAToolsWindow* ptr = (CAToolsWindow*) data;
	int page_number = gtk_assistant_get_current_page(GTK_ASSISTANT(ptr->m_gAssistant));
	GtkWidget* current_page = gtk_assistant_get_nth_page(GTK_ASSISTANT(ptr->m_gAssistant), page_number);
	string tmpString("");
	tmpString = gtk_entry_get_text(GTK_ENTRY(entry));
	if (tmpString.c_str() && *tmpString.c_str())
	{
		gtk_assistant_set_page_complete(GTK_ASSISTANT(ptr->m_gAssistant), current_page, TRUE);
	}
	else
	{
		gtk_assistant_set_page_complete(GTK_ASSISTANT(ptr->m_gAssistant), current_page, FALSE);
	}

	CSESLog::WriteLine("CAToolsWindow::SetEntryActive<<End");
}
void CAToolsWindow::FirstPasswdEntryActive(GtkEntry* entry, gpointer data)
{
	CSESLog::WriteLine("CAToolsWindow::FirstPasswdEntryActive>>Start");
	CAToolsWindow* ptr = (CAToolsWindow*) data;
	string firstPassword("");
	string secondPassword("");
	firstPassword = gtk_entry_get_text(GTK_ENTRY(ptr->m_gPasswordEntry));
	secondPassword = gtk_entry_get_text(GTK_ENTRY(ptr->m_gPassWordAgainEntry));
	int page_number = gtk_assistant_get_current_page(GTK_ASSISTANT(ptr->m_gAssistant));
	GtkWidget* current_page = gtk_assistant_get_nth_page(GTK_ASSISTANT(ptr->m_gAssistant), page_number);
	if (firstPassword.c_str() && *firstPassword.c_str())
	{
		if (0 == firstPassword.compare(secondPassword))
		{
			gtk_assistant_set_page_complete(GTK_ASSISTANT(ptr->m_gAssistant), current_page, TRUE);
		}
		else
		{
			gtk_assistant_set_page_complete(GTK_ASSISTANT(ptr->m_gAssistant), current_page, FALSE);
		}
	}
	else
	{
		gtk_assistant_set_page_complete(GTK_ASSISTANT(ptr->m_gAssistant), current_page, FALSE);
	}
	CSESLog::WriteLine("CAToolsWindow::FirstPasswdEntryActive<<End");
}
void CAToolsWindow::SecondPasswdEntryActive(GtkEntry* entry, gpointer data)
{
	CSESLog::WriteLine("CAToolsWindow::SecondPasswdEntryActive>>Start");
	CAToolsWindow* ptr = (CAToolsWindow*) data;
	//int current_page = gtk_assistant_get_current_page(GTK_ASSISTANT(ptr->m_gAssistant));
	//if(2 == current_page)
	//{
	string firstPassword("");
	string secondPassword("");
	firstPassword = gtk_entry_get_text(GTK_ENTRY(ptr->m_gPasswordEntry));
	secondPassword = gtk_entry_get_text(GTK_ENTRY(ptr->m_gPassWordAgainEntry));
	int page_number = gtk_assistant_get_current_page(GTK_ASSISTANT(ptr->m_gAssistant));
	GtkWidget* current_page = gtk_assistant_get_nth_page(GTK_ASSISTANT(ptr->m_gAssistant), page_number);
	if (secondPassword.c_str() && *secondPassword.c_str())
	{
		if (0 == firstPassword.compare(secondPassword))
		{
			gtk_assistant_set_page_complete(GTK_ASSISTANT(ptr->m_gAssistant), current_page, TRUE);
		}
		else
		{
			gtk_assistant_set_page_complete(GTK_ASSISTANT(ptr->m_gAssistant), current_page, FALSE);
		}
	}
	else
	{
		gtk_assistant_set_page_complete(GTK_ASSISTANT(ptr->m_gAssistant), current_page, FALSE);
	}

	//}
	CSESLog::WriteLine("CAToolsWindow::SecondPasswdEntryActive<<End");
}

void CAToolsWindow::ExportCallBack(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("CAToolsWindow::ExportCallBack>>Start");
	CAToolsWindow* ptr = (CAToolsWindow*) data;
	GtkWidget* dialog = NULL;
	dialog = gtk_file_chooser_dialog_new(_("Select Folder"), GTK_WINDOW(ptr->m_gAssistant), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN,
			GTK_RESPONSE_ACCEPT, NULL);
	int response = gtk_dialog_run(GTK_DIALOG (dialog));
	if (GTK_RESPONSE_ACCEPT == response)
	{
		gtk_entry_set_text(GTK_ENTRY(ptr->m_gExportEntry), gtk_file_chooser_get_filename(
				GTK_FILE_CHOOSER(dialog)));
	}
	gtk_widget_destroy(dialog);
	CSESLog::WriteLine("CAToolsWindow::ExportCallBack<<End");
}

void CAToolsWindow::ExportActive(GtkEntry* entry, gpointer data)
{
	CSESLog::WriteLine("CAToolsWindow::ExportActive>>Start");
	CAToolsWindow* ptr = (CAToolsWindow*) data;
	int page_number = gtk_assistant_get_current_page(GTK_ASSISTANT(ptr->m_gAssistant));
	GtkWidget* current_page = gtk_assistant_get_nth_page(GTK_ASSISTANT(ptr->m_gAssistant), page_number);
	gtk_assistant_set_page_complete(GTK_ASSISTANT(ptr->m_gAssistant), current_page, TRUE);
	CSESLog::WriteLine("CAToolsWindow::ExportActive<<End");
}
void CAToolsWindow::OnAssistantPrepare(GtkAssistant* assistant,
		GtkWidget* widget, gpointer data)
{
	CSESLog::WriteLine("CAToolsWindow::OnAssistantPrepare>>Start");
	CAToolsWindow* ptr = (CAToolsWindow*) data;
	int current_page = gtk_assistant_get_current_page(assistant);
	string compareString("");
	string messageString("");
	if (3 == current_page)
	{
		ptr->DealWithThirdPagePrepare();
	}
	else if (2 == current_page)
	{

		ptr->DealWithSecondPagePrepare();
	}
	else if (1 == current_page)
	{
		ptr->DealWithFirstPagePrepare();
	}
	else if (4 == current_page)
	{

		ptr->DealWithFourthPagePrepare();
	}
	else if (5 == current_page)
	{
		gtk_label_set_text(
				GTK_LABEL(ptr->m_gFifthLabel),
				_("Root CA Description:\nFile Name:\n"
						"File Path:\nServer CA Description:\nFile Name:\nFile Path:\nExport path:"));
	}
	CSESLog::WriteLine("CAToolsWindow::OnAssistantPrepare<<End");
}



void CAToolsWindow::DealWithFirstPagePrepare()
{
	int page_number = gtk_assistant_get_current_page(GTK_ASSISTANT(m_gAssistant));
	GtkWidget* current_page = gtk_assistant_get_nth_page(
			GTK_ASSISTANT(m_gAssistant), 1);
	if (TRUE == gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(m_gLowerRadioBtn)))
	{
		m_iIsGenerateNewCA = GENERATE_NEW_CA_VALUE;
		gtk_assistant_set_page_complete(GTK_ASSISTANT(m_gAssistant), current_page, false);
	}
	else
	{
		m_iIsGenerateNewCA = IMPORT_CA_VALUE;
		gtk_assistant_set_page_complete(GTK_ASSISTANT(m_gAssistant), current_page, true);
	}
}

gint CAToolsWindow::DealWithSecondPagePrepare()
{
	gint pageResult = -1;
	string compareString("");
	string newString = gtk_entry_get_text(GTK_ENTRY(m_gFilePathEntry));
	this->TrimString(newString);
	if (newString.compare(compareString) == 0)
	{
		CMessageBox::Show(_("Description cannot be empty!"), m_gAssistant,
				GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
		return -1;
	}
	else
	{
		if (GENERATE_NEW_CA_VALUE == m_iIsGenerateNewCA)
		{

			string result;
			if (0 != CSESDataTools::IsInputValid(newString, result))
			{
				CMessageBox::Show(result, m_gAssistant, GTK_MESSAGE_WARNING,
						GTK_BUTTONS_OK);

				return -1;

			}
			string s;
			//TODO getpath
			m_pUtil->GetPath(s);
			if (1 != m_pUtil->HaveRootCA(s))
			{
				int result = 0;
				CSESLog::WriteLine(
						"CAToolsWindow::OnAssistantPrepare --GenerateRootCA>>Start");
				result = m_pUtil->GenerateRootCA(newString);
				pageResult = 2;

				CSESLog::WriteLine(
						"CAToolsWindow::OnAssistantPrepare --GenerateRootCA<<End");
				if (1 != result)
				{
					CSESLog::WriteLine(
							"CAToolsWindow::OnAssistantPrepare --GenerateRootCA Failure");
				}
			}
			else
			{
				int result = CMessageBox::Show(_("Do you want to replace root CA?"), m_gAssistant,
						GTK_MESSAGE_WARNING, GTK_BUTTONS_YES_NO);

				if (GTK_RESPONSE_YES == result)
				{
					int result = 0;
					CSESLog::WriteLine(
							"CAToolsWindow::OnAssistantPrepare Dialog--GenerateRootCA>>Start");
					result = m_pUtil->GenerateRootCA(newString);
					CSESLog::WriteLine(
							"CAToolsWindow::OnAssistantPrepare Dialog--GenerateRootCA<<End");
					if (1 != result)
					{
						CSESLog::WriteLine(
								"CAToolsWindow::OnAssistantPrepare Dialog--GenerateRootCA Failure");
					}
					pageResult = 2;
				}
				else
				{
					pageResult = -1;
				}

			}

		}
		else if (IMPORT_CA_VALUE == m_iIsGenerateNewCA)
		{
			string importPath("");
			importPath = gtk_entry_get_text(GTK_ENTRY(m_gFilePathEntry));
			string s;
			if (1 != m_pUtil->HaveRootCA(importPath))
			{
				s = importPath + _(" doesn't contain root CA!");
				CMessageBox::Show(s, m_gAssistant, GTK_MESSAGE_WARNING,
						GTK_BUTTONS_OK);
				return -1;
			}
			//TODO getpath
			m_pUtil->GetPath(s);
			if (1 != m_pUtil->HaveRootCA(s))
			{
				int result = 0;
				CSESLog::WriteLine(
						"CAToolsWindow::OnAssistantPrepare --ImportRootCA>>Start");
				result = m_pUtil->ImportRootCA(importPath);
				pageResult = 2;
				CSESLog::WriteLine(
						"CAToolsWindow::OnAssistantPrepare --ImportRootCA>>Start");
				if (1 == result)
				{

				}
				else if (0 == result)
				{
					CSESLog::WriteLine(
							"CAToolsWindow::OnAssistantPrepare --ImportRootCA dont have root CA");
				}
				else if (-1 == result)
				{
					CSESLog::WriteLine(
							"CAToolsWindow::OnAssistantPrepare --ImportRootCA not SES root CA");
				}
				else
				{
					CSESLog::WriteLine(
							"CAToolsWindow::OnAssistantPrepare --ImportRootCA can not access");
				}
			}
			else
			{
				if(0 != importPath.compare(s))
				{
					int result = CMessageBox::Show(_("Do you want to replace root CA?"), m_gAssistant,
						GTK_MESSAGE_WARNING, GTK_BUTTONS_YES_NO);
					if (GTK_RESPONSE_YES == result)
					{
						int result = 0;
						CSESLog::WriteLine(
								"CAToolsWindow::OnAssistantPrepare Dialog--ImportRootCA>>Start");
						result = m_pUtil->ImportRootCA(importPath);
						CSESLog::WriteLine(
								"CAToolsWindow::OnAssistantPrepare Dialog--ImportRootCA<<End");
						if (1 == result)
						{

						}
						else if (0 == result)
						{
							CSESLog::WriteLine(
									"CAToolsWindow::OnAssistantPrepare Dialog--ImportRootCA dont have root CA");
						}
						else if (-1 == result)
						{
							CSESLog::WriteLine(
									"CAToolsWindow::OnAssistantPrepare Dialog--ImportRootCA not SES root CA");
						}
						else
						{
							CSESLog::WriteLine(
									"CAToolsWindow::OnAssistantPrepare --ImportRootCA can not access");
						}
						pageResult = 2;
					}
					else
					{
						pageResult = -1;
					}
				}
				else
				{
					gint result;
					result = m_pUtil->ImportRootCA(importPath);
					if (1 == result)
					{

					}
					else if (0 == result)
					{
						CSESLog::WriteLine(
								"CAToolsWindow::OnAssistantPrepare Dialog--ImportRootCA dont have root CA");
					}
					else if (-1 == result)
					{
						CSESLog::WriteLine(
								"CAToolsWindow::OnAssistantPrepare Dialog--ImportRootCA not SES root CA");
					}
					else
					{
						CSESLog::WriteLine(
								"CAToolsWindow::OnAssistantPrepare --ImportRootCA can not access");
					}
					pageResult = 2;
				}
			}
		}
	}
	return pageResult;
}
gint CAToolsWindow::DealWithThirdPagePrepare()
{
	gint pageResult = -1;
	string firstPassword("");
	string compareString("");
	string messageString("");
	firstPassword = gtk_entry_get_text(GTK_ENTRY(m_gPasswordEntry));
	TrimString(firstPassword);
	string secondPassword("");
	secondPassword = gtk_entry_get_text(GTK_ENTRY(m_gPassWordAgainEntry));
	TrimString(secondPassword);
	if (0 == firstPassword.compare(secondPassword))
	{
		if (firstPassword.length() <= 0)
		{
			CMessageBox::Show(_("Password cannot be empty!"),
								m_gAssistant, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
			return pageResult;
		}

		if ((firstPassword.length() < 6) || (firstPassword.length() > 64))
		{
			CMessageBox::Show(_("The length of password should be between 6~64 characters!"),
					m_gAssistant, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
			pageResult = -1;
		}
		else
		{
			int result = CSESDataTools::IsStrongPassword(firstPassword,
					messageString);
			if (-1 == result)
			{
				CMessageBox::Show(messageString, m_gAssistant,
						GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
				pageResult = 3;

				m_pUtil->GenerateServerCert(secondPassword);

			}
			else
			{
				int page_number = gtk_assistant_get_current_page(GTK_ASSISTANT(m_gAssistant));
				GtkWidget* current_page = gtk_assistant_get_nth_page(
						GTK_ASSISTANT(m_gAssistant), page_number);
				gtk_assistant_set_page_complete(GTK_ASSISTANT(m_gAssistant), current_page, TRUE);
				string s;
				//TODO getpath
				m_pUtil->GetPath(s);
				int result = 0;
				if (1 != m_pUtil->HaveServerCert(s))
				{
					CSESLog::WriteLine(
							"CAToolsWindow::OnAssistantPrepare --GenerateServerCert>>Start");
					result = m_pUtil->GenerateServerCert(secondPassword);
					pageResult = 3;
					CSESLog::WriteLine(
							"CAToolsWindow::OnAssistantPrepare --GenerateServerCert<<End");
					if (1 != result)
					{
						CSESLog::WriteLine(
								"CAToolsWindow::OnAssistantPrepare --GenerateServerCert Failure");
					}
				}
				else
				{
					int result = CMessageBox::Show(_("Do you want to replace server CA?"), m_gAssistant,
							GTK_MESSAGE_WARNING, GTK_BUTTONS_YES_NO);
					if (GTK_RESPONSE_YES == result)
					{
						int result = 0;
						CSESLog::WriteLine(
								"CAToolsWindow::OnAssistantPrepare Dialog--GenerateServerCert>>Start");
						result = m_pUtil->GenerateServerCert(secondPassword);
						CSESLog::WriteLine(
								"CAToolsWindow::OnAssistantPrepare Dialog--GenerateServerCert<<End");
						if (1 != result)
						{
							CSESLog::WriteLine(
									"CAToolsWindow::OnAssistantPrepare Dialog--GenerateServerCert Failure");
						}
						pageResult = 3;
					}
					else
					{
						pageResult = -1;
					}
					//TODO
					//					CSESLog::WriteLine("CAToolsWindow::OnAssistantPrepare --GenerateServerCert>>Start");
					//									result = m_pUtil->GenerateServerCert(secondPassword);
					//									CSESLog::WriteLine("CAToolsWindow::OnAssistantPrepare --GenerateServerCert<<End");
				}
			}
		}

	}
	return pageResult;
}

gint CAToolsWindow::DealWithFourthPagePrepare()
{
	int pageResult = -1;
	string compareString("");
	string exportPath = gtk_entry_get_text(GTK_ENTRY(m_gExportEntry));
	bool backupCheckBtnValue = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(m_gCheckBtn));
	if (0 != exportPath.compare(compareString))
	{

		//TODO haveServerCert (exportPath);
		int exportResult = 0;
		/*
		 if(1 == m_pUtil->HaveRootCA(exportPath))
		 {
		 GtkWidget* dialog = gtk_message_dialog_new (GTK_WINDOW (m_gAssistant),
		 GTK_DIALOG_MODAL,
		 GTK_MESSAGE_WARNING,
		 GTK_BUTTONS_OK,
		 "have root CA at this path!");
		 gtk_dialog_run (GTK_DIALOG (dialog));
		 gtk_widget_destroy (dialog);
		 }
		 */
		if (1 == m_pUtil->HaveServerCert(exportPath))
		{
			int result = CMessageBox::Show(_("We will replace certificate!"), m_gAssistant,
					GTK_MESSAGE_WARNING, GTK_BUTTONS_YES_NO);
			if (GTK_RESPONSE_YES == result)
			{
				CSESLog::WriteLine(
						"CAToolsWindow::OnAssistantPrepare --ExportRootCA>>Start");
				exportResult = m_pUtil->ExportServerCert(exportPath);
				CSESLog::WriteLine(
						"CAToolsWindow::OnAssistantPrepare --ExportRootCA<<End");
				if (0 == exportResult)
				{
					CSESLog::WriteLine(
							"CAToolsWindow::OnAssistantPrepare --ExportRootCA dont have server ca");
				}
				else if (-2 == exportResult)
				{
					CSESLog::WriteLine(
							"CAToolsWindow::OnAssistantPrepare --ExportRootCA canot access");
				}

			}
			else
			{
				return -1;
			}

		}
		else
		{
			exportResult = m_pUtil->ExportServerCert(exportPath);
		}
		if (1 != exportResult)
		{
			 CMessageBox::Show(_("Export failure! Please select another foder"), m_gAssistant,
					GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
			return -1;

		}
	}
	string showMessage = _("CA information\n");
	string s;
	string path;
	m_pUtil->GetPath(path);
	this->m_pUtil->GetON(s);
	gtk_label_set_text(GTK_LABEL(m_gFifthDescriptionText),s.c_str());
	gtk_widget_set_tooltip_text(GTK_WIDGET(m_gFifthDescriptionText),s.c_str());
	gtk_label_set_text(GTK_LABEL(m_gFifthPathText),exportPath.c_str());
	gtk_widget_set_tooltip_text(GTK_WIDGET(m_gFifthPathText),exportPath.c_str());
	/*
	showMessage = showMessage + _("Description : ");
	showMessage = showMessage + s;
	showMessage = showMessage + "\n\n";
	showMessage.append(_("Export path : "));
	string tempString = showMessage;
	*/
	/*
	 if (m_iIsGenerateNewCA == GENERATE_NEW_CA_VALUE) {
	 tempString = tempString
	 + "cacert.pem ";
	 tempString = tempString + _(" and ");
	 tempString = tempString + "cakey.pem ";
	 tempString = tempString + _("was generated under ");
	 tempString = tempString + path;
	 tempString = tempString + "\n";
	 } else {
	 string filePath = gtk_entry_get_text(GTK_ENTRY(m_gFilePathEntry));
	 tempString = tempString + "cacert.pem";
	 tempString = tempString + _(" and ");
	 tempString = tempString + "cakey.pem";
	 tempString = tempString + _(" was copied from ");
	 tempString = tempString + filePath;
	 tempString = tempString + _(" to ");
	 tempString = tempString + path;
	 tempString = tempString + "\n";
	 }
	 */
	if (TRUE == backupCheckBtnValue)
	{
		//int getPathResult = 0;
		string tmpPath("");
		if (0 == tmpPath.compare(exportPath))
		{
			string s;
			//
			//			if(1 == m_pUtil->HaveRootCA(s)&&1 == m_pUtil->HaveServerCert(s))
			//			{
			//
			//			}
		}
		else
		{
			CSESLog::WriteLine(
					"CAToolsWindow::OnAssistantPrepare --BackUpRootCA>>Start");
			m_pUtil->BackUpRootCA(exportPath);
			/*
			tempString
					= tempString + exportPath + "\n" + _("Export files: ")
							+ "cacert.pem cakey.pem sslservercert.pem sslserverkey.pem\n";
           */
			gtk_label_set_text(GTK_LABEL(m_gFifthFilesText),"cacert.pem cakey.pem sslservercert.pem sslserverkey.pem");
			//gtk_tooltip_set_text(GTK_TOOLTIP(m_gFifthPathText),"cacert.pem cakey.pem sslservercert.pem sslserverkey.pem");
			gtk_widget_set_tooltip_text(GTK_WIDGET(m_gFifthFilesText),"cacert.pem cakey.pem sslservercert.pem sslserverkey.pem");
			CSESLog::WriteLine(
					"CAToolsWindow::OnAssistantPrepare --BackUpRootCA<<End");
		}
	}
	else
	{
		gtk_label_set_text(GTK_LABEL(m_gFifthFilesText),"cacert.pem sslservercert.pem sslserverkey.pem");
		gtk_widget_set_tooltip_text(GTK_WIDGET(m_gFifthFilesText),"cacert.pem sslservercert.pem sslserverkey.pem");
		/*
		tempString = tempString + exportPath + "\n" + _("Export files: ")
				+ "cacert.pem sslservercert.pem sslserverkey.pem\n";
				*/

	}
	/*
	showMessage = tempString;

	gtk_label_set_text(GTK_LABEL(m_gFifthLabel), showMessage.c_str());
	*/
	pageResult = 4;
	return pageResult;

}
/*
 gint CAToolsWindow::PageFunction(gint current_page,gpointer data)
 {
 CSESLog::WriteLine("CAToolsWindow::OnAssistantPrepare>>Start");
 CAToolsWindow* ptr = (CAToolsWindow*)data;
 string compareString("");
 string messageString("");
 if(3 == current_page)
 {
 ptr->DealWithThirdPagePrepare();
 }
 else if(2 == current_page)
 {

 ptr->DealWithSecondPagePrepare();
 }
 else if(1 == current_page)
 {
 ptr->DealWithFirstPagePrepare();
 }
 else if(4 == current_page)
 {

 ptr->DealWithFourthPagePrepare();
 }
 else if(5 == current_page)
 {
 gtk_label_set_text(GTK_LABEL(ptr->m_gFifthLabel), "Root CA Description:\nFile Name:\n"
 "File Path:\nServer CA Description:\nFile Name:\nFile Path:\nExport path:");
 }
 CSESLog::WriteLine("CAToolsWindow::OnAssistantPrepare<<End");
 }
 */
