#ifndef _SMHI_CLIENT_H_
#define _SMHI_CLIENT_H_

#include "sc_sensor_luid.h"
#include "sdt_info.h"
#include "ish_version.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum _ISH_SENSOR_CONFIG_TYPE
{
        ISH_CONFIG_CALIBRATION = 0,
        ISH_CONFIG_CONNECTIVITY = 1,
        ISH_CONFIG_SENSOR_DEVICES = 2,
        ISH_CONFIG_FULL_PDT = 3,
}ISH_SENSOR_CONFIG_TYPE;

typedef ISH_SENSOR_CONFIG_TYPE  smhi_sensor_config_t;
typedef sc_sensor_luid          smhi_luid_t;

int smhi_client_connect();
int smhi_client_disconnect(int handle);
uint64_t smhi_client_get_time(int handle);
ish_version_t smhi_client_get_version(int handle);
int smhi_client_set_sensor_conf(int handle, smhi_luid_t luid, smhi_sensor_config_t config, int num_entries, sc_sdt_info_entry *entries, size_t data_size);

#ifdef __cplusplus
}
#endif

#endif
