#include "sc_sensor_luid.h"
#include <string.h>
#include <stdlib.h>
#include "Log.h"

sc_sensor_luid luid_from_string(const char * luid_str)
{
        sc_sensor_luid luid = { 0 };
        char buf[5];

        if (luid_str == NULL) {
                ALOGE("%s line: %d luid string is NULL!", __FUNCTION__, __LINE__);
                return luid;
        }

        if (strlen(luid_str) != LUID_STRING_LENGTH) {
                ALOGE("%s line: %d invaild luid string length! excepted: %d actual: %d",
                      __FUNCTION__, __LINE__, LUID_STRING_LENGTH, strlen(luid_str));
                return luid;
        }

        strncpy(buf, luid_str, 4);
        buf[4] = 0;
        luid.sensor_type = strtoul(buf, NULL, 16);

        strncpy(buf, luid_str + 4, 4);
        buf[4] = 0;
        luid.vendor_id = strtoul(buf, NULL, 16);

        strncpy(buf, luid_str + 8, 4);
        buf[4] = 0;
        luid.sensor_sub_type = strtoul(buf, NULL, 16);

        strncpy(buf, luid_str + 12, 2);
        buf[2] = 0;
        luid.instance_id = strtoul(buf, NULL, 16);

        strncpy(buf, luid_str + 14, 2);
        buf[2] = 0;
        luid.luid_flags = strtoul(buf, NULL, 16);

        return luid;
}

char * luid_to_string(sc_sensor_luid luid, char * str)
{
        /* Todo: implement this function */
        return NULL;
}
