/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _ISH_SERVICE_H_
#define _ISH_SERVICE_H_

#include "PlatformService.h"
#include "ISHSensor.h"
#include "ish/utils/sc_sensor_luid.h"
#include <string>

class ISHService : public PlatformService {
        std::multimap<std::string, unsigned int> ishSensorsTable; //ishInformationTable;
        std::multimap<std::string, std::string> ishSensorsLUID; //ishInformationTable;
        std::map<unsigned int, Sensor *> mISHSensorSet;
        std::map<std::string, Sensor *> mConfiguredSensors;
        char path[MAX_STRING_LENGTH];
        char valueBuffer[MAX_STRING_LENGTH];
        bool ishDriverReady;
        int dataFd;
        int dataSelectFd;
        int notifyPipeFd[2];
        char *dataBuf;
        bool waitingForISHDriverReady();
        void initializeISHSensorsTable();
        bool isSensorEntry(const char * entry_name);
        bool initializePrivateData(xmlNodePtr node, ish_private_data_t &data);
        bool initializePrivateData(ish_private_data_t &data, bool clean);
        Sensor *constructSensorByType(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data);
        Sensor *constructSensorByReference(const Sensor * refSensor, const uint32_t serial_number);
        Sensor *constructCustomerSensor(SensorEnumerator * enumerator, const uint32_t serial_number, const char * luidString);
public:
        ISHService();
        void getDataFds(std::queue<int> &dataFdQueue);
        dataSelectMode getDataSelectMode() { return SELECT_MODE_READ; }
        bool handleEvents(int fd);
        int enumerateSensors(SensorEnumerator * enumerator, const xmlNodePtr ishRoot, std::vector<Sensor *> &sensors);
        int getNotifyFd();
        void handleNotify(int notification);
};

#endif
