#include "ISHRelativeHumidity.h"
#include "Log.h"

// sc_sensor_type: 0x32

struct humidity_data_t {
        int64_t timestamp;
        int64_t timestamp0;
	uint32_t humidity;
        uint16_t custom_usage;
}__attribute__ ((packed));

ISHRelativeHumidity::ISHRelativeHumidity(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHRelativeHumidity::ISHRelativeHumidity(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHRelativeHumidity::~ISHRelativeHumidity()
{

}

void ISHRelativeHumidity::initialize()
{
        if (information.scale_android.size() == 1) {
                scale = information.scale_android[0];
                ALOGV_IF(VERBOSE, "%s line: %d %f", __FUNCTION__, __LINE__, scale);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scale = 0.01; // defalut scale 10^-2
        }
}

size_t ISHRelativeHumidity::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct humidity_data_t);

        if (bufSize % sizeof(struct humidity_data_t) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct humidity_data_t));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct humidity_data_t *humidity = reinterpret_cast<const struct humidity_data_t *>(buf);
        for (size_t i = 0; i < count; i++) {
                mEvents[i].timestamp = humidity[i].timestamp * US_TO_NS;
                mEvents[i].relative_humidity = humidity[i].humidity * scale;
        }

        return count;
}
