#include "ISHOrientation.h"
#include "Log.h"

struct orientation_raw {
        int64_t timestamp;
        int64_t timestamp0;
        int x;
        int y;
        int z;
        unsigned char accuracy;
        unsigned char error_rad;
} __attribute__ ((packed));

struct orientation_data {
        int64_t timestamp;
        int64_t timestamp0;
        int x;
        int y;
        int z;
        unsigned char accuracy;
        unsigned char error_rad;
} __attribute__ ((packed));

ISHOrientation::ISHOrientation(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHOrientation::ISHOrientation(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHOrientation::~ISHOrientation()
{

}

void ISHOrientation::initialize()
{
        if (information.scale_android.size() == 3) {
                scaleX = information.scale_android[0];
                scaleY = information.scale_android[1];
                scaleZ = information.scale_android[2];
                ALOGV_IF(VERBOSE, "%s line: %d %f %f %f", __FUNCTION__, __LINE__, scaleX, scaleY, scaleZ);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scaleX = 1.0;
                scaleY = 1.0;
                scaleZ = 1.0;
        }
}

size_t ISHOrientation::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct orientation_raw);

        if (bufSize % sizeof(struct orientation_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct orientation_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct orientation_raw *orientation = reinterpret_cast<const struct orientation_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = orientation[i].timestamp * US_TO_NS;
                mEvents[i].orientation.azimuth = orientation[i].x * scaleX;
                mEvents[i].orientation.pitch = orientation[i].y * scaleY;
                mEvents[i].orientation.roll = orientation[i].z * scaleZ;
                mEvents[i].orientation.status = orientation[i].accuracy;
        }
        return count;
}
