#include "ISHDevicePosition.h"
#include "Log.h"

// LUID:020C000000000000

struct device_position_raw {
        int64_t timestamp;
        int64_t timestamp0;
        uint8_t device_position;
        uint16_t custom_usage;
} __attribute__ ((packed));

struct device_position_aware {
        int64_t timestamp;
        uint8_t device_position;
} __attribute__ ((packed));

ISHDevicePosition::ISHDevicePosition(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHDevicePosition::ISHDevicePosition(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHDevicePosition::~ISHDevicePosition()
{

}

void ISHDevicePosition::initialize()
{

}

size_t ISHDevicePosition::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct device_position_raw);

        if (bufSize % sizeof(struct device_position_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct device_position_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct device_position_aware));

        const struct device_position_raw *position = reinterpret_cast<const struct device_position_raw *>(buf);
        struct device_position_aware *aware = reinterpret_cast<struct device_position_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = position[i].timestamp * US_TO_NS;
                aware[i].device_position = position[i].device_position;
        }

        return count * sizeof(struct device_position_aware);
}

size_t ISHDevicePosition::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct device_position_raw);

        if (bufSize % sizeof(struct device_position_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct device_position_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct device_position_raw *position = reinterpret_cast<const struct device_position_raw *>(buf);
        for (size_t i = 0; i < count; i++) {
                mEvents[i].timestamp = position[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = position[i].device_position;
        }

        return count;
}
