#include "ISHAwareSensor.h"
#include "Log.h"
#ifdef ENABLE_CONTEXT_ARBITOR
#include <awarelibs/libcontextarbitor.h>
#endif

ISHAwareSensor::ISHAwareSensor(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data), ctx_handle(NULL), mContextArbitratorInitialized(false)
{

}

ISHAwareSensor::ISHAwareSensor(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number), ctx_handle(NULL), mContextArbitratorInitialized(false)
{

}

ISHAwareSensor::~ISHAwareSensor()
{

}

#ifdef ENABLE_CONTEXT_ARBITOR
bool ISHAwareSensor::startStreaming(Session * session, int64_t samplingPeriodUs, int64_t maxReportLatencyUs)
{
        // open context before session is activated
        checkContextHandle();

        return ISHSensor::startStreaming(session, samplingPeriodUs, maxReportLatencyUs);
}

void ISHAwareSensor::removeSession(Session *session)
{
        Sensor::removeSession(session);

        if (!checkContextHandle())
                return;

        ctx_option_t *out_option = NULL;

        int ret = ctx_close_session(ctx_handle, &out_option);
        if ((ret == 1) && (out_option != NULL)) {
                struct ish_private_property private_property;
                currentPrivateProperties.clear();
                for (int i = 0; i < out_option->len; i++) {
                        private_property.usage_id = out_option->items[i].prop;
                        private_property.property_value = *(reinterpret_cast<int *>(out_option->items[i].value));
                        currentPrivateProperties.push_back(private_property);
                }
                ctx_option_release(out_option);

                setPrivateProperty();
        }
}

bool ISHAwareSensor::setProperty(Session * session, void * property, size_t size)
{
        // open context before session is activated
        if (!checkContextHandle())
                return ISHSensor::setProperty(session, property, size);

        ctx_option_t *out_option = NULL;

        int ret = ctx_set_option(ctx_handle, size, reinterpret_cast<char *>(property), &out_option);
        if (ret == -1)
                return ISHSensor::setProperty(session, property, size);

        if (out_option == NULL) {
                ALOGE("%s line: %d ctx_set_option output NULL!", __FUNCTION__, __LINE__);
                return false;
        }

        struct ish_private_property private_property;
        currentPrivateProperties.clear();
        for (int i = 0; i < out_option->len; i++) {
                private_property.usage_id = out_option->items[i].prop;
                private_property.property_value = *(reinterpret_cast<int *>(out_option->items[i].value));
                currentPrivateProperties.push_back(private_property);
        }
        ctx_option_release(out_option);

        return setPrivateProperty();
}

size_t ISHAwareSensor::getProperty(Session * session, void * command, size_t commandSize, void **property)
{
        // open context before session is activated
        checkContextHandle();

        return ISHSensor::getProperty(session, command, commandSize, property);
}

size_t ISHAwareSensor::convertToStreaming(const char * buf, size_t bufSize)
{
        void *out_data;
        int out_size;

        // open context before session is activated
        if (!checkContextHandle())
                return ISHSensor::convertToStreaming(buf, bufSize);

        if (ctx_dispatch_data(ctx_handle, const_cast<char *>(buf), bufSize, &out_data, &out_size) != 1) {
                return 0;
        }

        if (mStreamingSize < out_size) {
                if (mStreaming != NULL)
                        delete [] mStreaming;
                mStreaming = new char[out_size];
                mStreamingSize = out_size;
        }
        memcpy(mStreaming, out_data, out_size);
        return out_size;
}

bool ISHAwareSensor::checkContextHandle()
{
        if (!mContextArbitratorInitialized) {
                ctx_handle = ctx_open_session(device.stringType);
                mContextArbitratorInitialized = true;
        }

        if (ctx_handle != NULL)
                return true;

        return false;
}

#endif

