/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _SESSION_LIST_H_
#define _SESSION_LIST_H_

#include <vector>
#include <map>
#include "Session.h"
#include "Singleton.h"
#include <pthread.h>

class SessionList : public Singleton<SessionList> {
        friend class Singleton<SessionList>;
        std::vector<Session *> mSessionList;
        std::map<int, Session *> mSessionTable;
        mutable pthread_mutex_t mutex;
        SessionList();
        ~SessionList();
public:
        Session * createSession(int dataFd);
        bool sessionExists(Session * session);
        bool sessionComplete(Session * session);
        void updateSession(Session * session);
        Session * getSession(int ctrlFd);
        bool removeSession(Session * session);
        bool removeSession(int ctrlFd);
        int lockSessions();
        int unlockSessions();
};

#endif
