/* parser auto-generated by pidl */

#include "includes.h"
#include "librpc/gen_ndr/ndr_remact.h"

#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_orpc.h"
static enum ndr_err_code ndr_push_RemoteActivation(struct ndr_push *ndr, int flags, const struct RemoteActivation *r)
{
	uint32_t cntr_pIIDs_1;
	uint32_t cntr_protseq_0;
	uint32_t cntr_ifaces_0;
	uint32_t cntr_results_0;
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.this_object));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->in.Clsid));
		if (r->in.pwszObjectName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszObjectName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.pwszObjectName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.pwszObjectName, ndr_charset_length(r->in.pwszObjectName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		if (r->in.pObjectStorage == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pObjectStorage));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.ClientImpLevel));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Mode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.Interfaces));
		if (r->in.pIIDs == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.Interfaces));
		for (cntr_pIIDs_1 = 0; cntr_pIIDs_1 < r->in.Interfaces; cntr_pIIDs_1++) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->in.pIIDs[cntr_pIIDs_1]));
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.num_protseqs));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.num_protseqs));
		for (cntr_protseq_0 = 0; cntr_protseq_0 < r->in.num_protseqs; cntr_protseq_0++) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.protseq[cntr_protseq_0]));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.that == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.that));
		if (r->out.pOxid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->out.pOxid));
		if (r->out.pdsaOxidBindings == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_DUALSTRINGARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pdsaOxidBindings));
		if (r->out.ipidRemUnknown == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->out.ipidRemUnknown));
		if (r->out.AuthnHint == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.AuthnHint));
		if (r->out.ServerVersion == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_COMVERSION(ndr, NDR_SCALARS, r->out.ServerVersion));
		if (r->out.hr == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, *r->out.hr));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.Interfaces));
		for (cntr_ifaces_0 = 0; cntr_ifaces_0 < r->in.Interfaces; cntr_ifaces_0++) {
			if (r->out.ifaces[cntr_ifaces_0] == NULL) {
				return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
			}
		}
		for (cntr_ifaces_0 = 0; cntr_ifaces_0 < r->in.Interfaces; cntr_ifaces_0++) {
			NDR_CHECK(ndr_push_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ifaces[cntr_ifaces_0]));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.Interfaces));
		for (cntr_results_0 = 0; cntr_results_0 < r->in.Interfaces; cntr_results_0++) {
			NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.results[cntr_results_0]));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_RemoteActivation(struct ndr_pull *ndr, int flags, struct RemoteActivation *r)
{
	uint32_t cntr_pIIDs_1;
	uint32_t cntr_protseq_0;
	uint32_t cntr_ifaces_0;
	uint32_t cntr_results_0;
	TALLOC_CTX *_mem_save_that_0;
	TALLOC_CTX *_mem_save_pObjectStorage_0;
	TALLOC_CTX *_mem_save_pIIDs_1;
	TALLOC_CTX *_mem_save_protseq_0;
	TALLOC_CTX *_mem_save_pOxid_0;
	TALLOC_CTX *_mem_save_pdsaOxidBindings_0;
	TALLOC_CTX *_mem_save_ipidRemUnknown_0;
	TALLOC_CTX *_mem_save_AuthnHint_0;
	TALLOC_CTX *_mem_save_ServerVersion_0;
	TALLOC_CTX *_mem_save_hr_0;
	TALLOC_CTX *_mem_save_ifaces_0;
	TALLOC_CTX *_mem_save_ifaces_1;
	TALLOC_CTX *_mem_save_results_0;
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_ORPCTHIS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.this_object));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->in.Clsid));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pwszObjectName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.pwszObjectName));
		if (ndr_get_array_length(ndr, &r->in.pwszObjectName) > ndr_get_array_size(ndr, &r->in.pwszObjectName)) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", ndr_get_array_size(ndr, &r->in.pwszObjectName), ndr_get_array_length(ndr, &r->in.pwszObjectName));
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, ndr_get_array_length(ndr, &r->in.pwszObjectName), sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.pwszObjectName, ndr_get_array_length(ndr, &r->in.pwszObjectName), sizeof(uint16_t), CH_UTF16));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pObjectStorage);
		}
		_mem_save_pObjectStorage_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pObjectStorage, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pObjectStorage));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pObjectStorage_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.ClientImpLevel));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Mode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.Interfaces));
		if (r->in.Interfaces < 1 || r->in.Interfaces > 32768) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value out of range");
		}
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.pIIDs));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.pIIDs, ndr_get_array_size(ndr, &r->in.pIIDs));
		}
		_mem_save_pIIDs_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pIIDs, 0);
		for (cntr_pIIDs_1 = 0; cntr_pIIDs_1 < r->in.Interfaces; cntr_pIIDs_1++) {
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->in.pIIDs[cntr_pIIDs_1]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pIIDs_1, 0);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.num_protseqs));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.protseq));
		NDR_PULL_ALLOC_N(ndr, r->in.protseq, ndr_get_array_size(ndr, &r->in.protseq));
		_mem_save_protseq_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.protseq, 0);
		for (cntr_protseq_0 = 0; cntr_protseq_0 < r->in.num_protseqs; cntr_protseq_0++) {
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.protseq[cntr_protseq_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_protseq_0, 0);
		NDR_PULL_ALLOC(ndr, r->out.that);
		ZERO_STRUCTP(r->out.that);
		NDR_PULL_ALLOC(ndr, r->out.pOxid);
		ZERO_STRUCTP(r->out.pOxid);
		NDR_PULL_ALLOC(ndr, r->out.pdsaOxidBindings);
		ZERO_STRUCTP(r->out.pdsaOxidBindings);
		NDR_PULL_ALLOC(ndr, r->out.ipidRemUnknown);
		ZERO_STRUCTP(r->out.ipidRemUnknown);
		NDR_PULL_ALLOC(ndr, r->out.AuthnHint);
		ZERO_STRUCTP(r->out.AuthnHint);
		NDR_PULL_ALLOC(ndr, r->out.ServerVersion);
		ZERO_STRUCTP(r->out.ServerVersion);
		NDR_PULL_ALLOC(ndr, r->out.hr);
		ZERO_STRUCTP(r->out.hr);
		if (r->in.pIIDs) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.pIIDs, r->in.Interfaces));
		}
		if (r->in.protseq) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.protseq, r->in.num_protseqs));
		}
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.that);
		}
		_mem_save_that_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.that, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_ORPCTHAT(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.that));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_that_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pOxid);
		}
		_mem_save_pOxid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pOxid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->out.pOxid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pOxid_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pdsaOxidBindings);
		}
		_mem_save_pdsaOxidBindings_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pdsaOxidBindings, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_DUALSTRINGARRAY(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pdsaOxidBindings));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pdsaOxidBindings_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ipidRemUnknown);
		}
		_mem_save_ipidRemUnknown_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ipidRemUnknown, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->out.ipidRemUnknown));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ipidRemUnknown_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.AuthnHint);
		}
		_mem_save_AuthnHint_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.AuthnHint, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.AuthnHint));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_AuthnHint_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ServerVersion);
		}
		_mem_save_ServerVersion_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ServerVersion, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_COMVERSION(ndr, NDR_SCALARS, r->out.ServerVersion));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ServerVersion_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.hr);
		}
		_mem_save_hr_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.hr, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, r->out.hr));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_hr_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.ifaces));
		NDR_PULL_ALLOC_N(ndr, r->out.ifaces, ndr_get_array_size(ndr, &r->out.ifaces));
		_mem_save_ifaces_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ifaces, 0);
		for (cntr_ifaces_0 = 0; cntr_ifaces_0 < r->in.Interfaces; cntr_ifaces_0++) {
			if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
				NDR_PULL_ALLOC(ndr, r->out.ifaces[cntr_ifaces_0]);
			}
		}
		for (cntr_ifaces_0 = 0; cntr_ifaces_0 < r->in.Interfaces; cntr_ifaces_0++) {
			_mem_save_ifaces_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.ifaces[cntr_ifaces_0], LIBNDR_FLAG_REF_ALLOC);
			NDR_CHECK(ndr_pull_MInterfacePointer(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ifaces[cntr_ifaces_0]));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ifaces_1, LIBNDR_FLAG_REF_ALLOC);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ifaces_0, 0);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.results));
		NDR_PULL_ALLOC_N(ndr, r->out.results, ndr_get_array_size(ndr, &r->out.results));
		_mem_save_results_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.results, 0);
		for (cntr_results_0 = 0; cntr_results_0 < r->in.Interfaces; cntr_results_0++) {
			NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.results[cntr_results_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_results_0, 0);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.ifaces) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.ifaces, r->in.Interfaces));
		}
		if (r->out.results) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.results, r->in.Interfaces));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_RemoteActivation(struct ndr_print *ndr, const char *name, int flags, const struct RemoteActivation *r)
{
	uint32_t cntr_pIIDs_1;
	uint32_t cntr_protseq_0;
	uint32_t cntr_ifaces_0;
	uint32_t cntr_results_0;
	ndr_print_struct(ndr, name, "RemoteActivation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "RemoteActivation");
		ndr->depth++;
		ndr_print_ORPCTHIS(ndr, "this_object", &r->in.this_object);
		ndr_print_GUID(ndr, "Clsid", &r->in.Clsid);
		ndr_print_ptr(ndr, "pwszObjectName", r->in.pwszObjectName);
		ndr->depth++;
		ndr_print_string(ndr, "pwszObjectName", r->in.pwszObjectName);
		ndr->depth--;
		ndr_print_ptr(ndr, "pObjectStorage", r->in.pObjectStorage);
		ndr->depth++;
		ndr_print_MInterfacePointer(ndr, "pObjectStorage", r->in.pObjectStorage);
		ndr->depth--;
		ndr_print_uint32(ndr, "ClientImpLevel", r->in.ClientImpLevel);
		ndr_print_uint32(ndr, "Mode", r->in.Mode);
		ndr_print_uint32(ndr, "Interfaces", r->in.Interfaces);
		ndr_print_ptr(ndr, "pIIDs", r->in.pIIDs);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%d)", "pIIDs", (int)r->in.Interfaces);
		ndr->depth++;
		for (cntr_pIIDs_1=0;cntr_pIIDs_1<r->in.Interfaces;cntr_pIIDs_1++) {
			ndr_print_GUID(ndr, "pIIDs", &r->in.pIIDs[cntr_pIIDs_1]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_uint16(ndr, "num_protseqs", r->in.num_protseqs);
		ndr->print(ndr, "%s: ARRAY(%d)", "protseq", (int)r->in.num_protseqs);
		ndr->depth++;
		for (cntr_protseq_0=0;cntr_protseq_0<r->in.num_protseqs;cntr_protseq_0++) {
			ndr_print_uint16(ndr, "protseq", r->in.protseq[cntr_protseq_0]);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "RemoteActivation");
		ndr->depth++;
		ndr_print_ptr(ndr, "that", r->out.that);
		ndr->depth++;
		ndr_print_ORPCTHAT(ndr, "that", r->out.that);
		ndr->depth--;
		ndr_print_ptr(ndr, "pOxid", r->out.pOxid);
		ndr->depth++;
		ndr_print_hyper(ndr, "pOxid", *r->out.pOxid);
		ndr->depth--;
		ndr_print_ptr(ndr, "pdsaOxidBindings", r->out.pdsaOxidBindings);
		ndr->depth++;
		ndr_print_DUALSTRINGARRAY(ndr, "pdsaOxidBindings", r->out.pdsaOxidBindings);
		ndr->depth--;
		ndr_print_ptr(ndr, "ipidRemUnknown", r->out.ipidRemUnknown);
		ndr->depth++;
		ndr_print_GUID(ndr, "ipidRemUnknown", r->out.ipidRemUnknown);
		ndr->depth--;
		ndr_print_ptr(ndr, "AuthnHint", r->out.AuthnHint);
		ndr->depth++;
		ndr_print_uint32(ndr, "AuthnHint", *r->out.AuthnHint);
		ndr->depth--;
		ndr_print_ptr(ndr, "ServerVersion", r->out.ServerVersion);
		ndr->depth++;
		ndr_print_COMVERSION(ndr, "ServerVersion", r->out.ServerVersion);
		ndr->depth--;
		ndr_print_ptr(ndr, "hr", r->out.hr);
		ndr->depth++;
		ndr_print_WERROR(ndr, "hr", *r->out.hr);
		ndr->depth--;
		ndr->print(ndr, "%s: ARRAY(%d)", "ifaces", (int)r->in.Interfaces);
		ndr->depth++;
		for (cntr_ifaces_0=0;cntr_ifaces_0<r->in.Interfaces;cntr_ifaces_0++) {
			ndr_print_ptr(ndr, "ifaces", r->out.ifaces[cntr_ifaces_0]);
			ndr->depth++;
			ndr_print_MInterfacePointer(ndr, "ifaces", r->out.ifaces[cntr_ifaces_0]);
			ndr->depth--;
		}
		ndr->depth--;
		ndr->print(ndr, "%s: ARRAY(%d)", "results", (int)r->in.Interfaces);
		ndr->depth++;
		for (cntr_results_0=0;cntr_results_0<r->in.Interfaces;cntr_results_0++) {
			ndr_print_WERROR(ndr, "results", r->out.results[cntr_results_0]);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call IRemoteActivation_calls[] = {
	{
		"RemoteActivation",
		sizeof(struct RemoteActivation),
		(ndr_push_flags_fn_t) ndr_push_RemoteActivation,
		(ndr_pull_flags_fn_t) ndr_pull_RemoteActivation,
		(ndr_print_function_t) ndr_print_RemoteActivation,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const IRemoteActivation_endpoint_strings[] = {
	"ncalrpc:", 
	"ncacn_ip_tcp:[135]", 
	"ncacn_np:[\\pipe\\epmapper]", 
};

static const struct ndr_interface_string_array IRemoteActivation_endpoints = {
	.count	= 3,
	.names	= IRemoteActivation_endpoint_strings
};

static const char * const IRemoteActivation_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array IRemoteActivation_authservices = {
	.count	= 1,
	.names	= IRemoteActivation_authservice_strings
};


const struct ndr_interface_table ndr_table_IRemoteActivation = {
	.name		= "IRemoteActivation",
	.syntax_id	= {
		{0x4d9f4ab8,0x7d1c,0x11cf,{0x86,0x1e},{0x00,0x20,0xaf,0x6e,0x7c,0x57}},
		NDR_IREMOTEACTIVATION_VERSION
	},
	.helpstring	= NDR_IREMOTEACTIVATION_HELPSTRING,
	.num_calls	= 1,
	.calls		= IRemoteActivation_calls,
	.endpoints	= &IRemoteActivation_endpoints,
	.authservices	= &IRemoteActivation_authservices
};

