/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_drsuapi.h"

NTSTATUS rpccli_drsuapi_DsBind(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct GUID *bind_guid /* [in] [unique] */,
			       struct drsuapi_DsBindInfoCtr *bind_info /* [in,out] [unique] */,
			       struct policy_handle *bind_handle /* [out] [ref] */,
			       WERROR *werror)
{
	struct drsuapi_DsBind r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_guid = bind_guid;
	r.in.bind_info = bind_info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(drsuapi_DsBind, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_DSBIND,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(drsuapi_DsBind, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (bind_info && r.out.bind_info) {
		*bind_info = *r.out.bind_info;
	}
	*bind_handle = *r.out.bind_handle;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_drsuapi_DsUnbind(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *bind_handle /* [in,out] [ref] */,
				 WERROR *werror)
{
	struct drsuapi_DsUnbind r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = bind_handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(drsuapi_DsUnbind, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_DSUNBIND,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(drsuapi_DsUnbind, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*bind_handle = *r.out.bind_handle;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_drsuapi_DsReplicaSync(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *bind_handle /* [in] [ref] */,
				      int32_t level /* [in]  */,
				      union drsuapi_DsReplicaSyncRequest req /* [in] [switch_is(level)] */,
				      WERROR *werror)
{
	struct drsuapi_DsReplicaSync r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = bind_handle;
	r.in.level = level;
	r.in.req = req;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(drsuapi_DsReplicaSync, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_DSREPLICASYNC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(drsuapi_DsReplicaSync, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_drsuapi_DsGetNCChanges(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *bind_handle /* [in] [ref] */,
				       int32_t level /* [in]  */,
				       union drsuapi_DsGetNCChangesRequest *req /* [in] [ref,switch_is(level)] */,
				       int32_t *level_out /* [out] [ref] */,
				       union drsuapi_DsGetNCChangesCtr *ctr /* [out] [ref,switch_is(*level_out)] */,
				       WERROR *werror)
{
	struct drsuapi_DsGetNCChanges r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = bind_handle;
	r.in.level = level;
	r.in.req = req;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(drsuapi_DsGetNCChanges, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_DSGETNCCHANGES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(drsuapi_DsGetNCChanges, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*level_out = *r.out.level_out;
	*ctr = *r.out.ctr;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_drsuapi_DsReplicaUpdateRefs(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *bind_handle /* [in] [ref] */,
					    int32_t level /* [in]  */,
					    union drsuapi_DsReplicaUpdateRefsRequest req /* [in] [switch_is(level)] */,
					    WERROR *werror)
{
	struct drsuapi_DsReplicaUpdateRefs r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = bind_handle;
	r.in.level = level;
	r.in.req = req;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(drsuapi_DsReplicaUpdateRefs, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_DSREPLICAUPDATEREFS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(drsuapi_DsReplicaUpdateRefs, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_DRSUAPI_REPLICA_ADD(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    WERROR *werror)
{
	struct DRSUAPI_REPLICA_ADD r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DRSUAPI_REPLICA_ADD, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_REPLICA_ADD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DRSUAPI_REPLICA_ADD, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_DRSUAPI_REPLICA_DEL(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    WERROR *werror)
{
	struct DRSUAPI_REPLICA_DEL r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DRSUAPI_REPLICA_DEL, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_REPLICA_DEL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DRSUAPI_REPLICA_DEL, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_DRSUAPI_REPLICA_MODIFY(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       WERROR *werror)
{
	struct DRSUAPI_REPLICA_MODIFY r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DRSUAPI_REPLICA_MODIFY, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_REPLICA_MODIFY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DRSUAPI_REPLICA_MODIFY, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_DRSUAPI_VERIFY_NAMES(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     WERROR *werror)
{
	struct DRSUAPI_VERIFY_NAMES r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DRSUAPI_VERIFY_NAMES, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_VERIFY_NAMES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DRSUAPI_VERIFY_NAMES, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_drsuapi_DsGetMemberships(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *bind_handle /* [in] [ref] */,
					 int32_t level /* [in]  */,
					 union drsuapi_DsGetMembershipsRequest *req /* [in] [ref,switch_is(level)] */,
					 int32_t *level_out /* [out] [ref] */,
					 union drsuapi_DsGetMembershipsCtr *ctr /* [out] [ref,switch_is(*level_out)] */,
					 WERROR *werror)
{
	struct drsuapi_DsGetMemberships r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = bind_handle;
	r.in.level = level;
	r.in.req = req;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(drsuapi_DsGetMemberships, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_DSGETMEMBERSHIPS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(drsuapi_DsGetMemberships, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*level_out = *r.out.level_out;
	*ctr = *r.out.ctr;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_DRSUAPI_INTER_DOMAIN_MOVE(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  WERROR *werror)
{
	struct DRSUAPI_INTER_DOMAIN_MOVE r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DRSUAPI_INTER_DOMAIN_MOVE, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_INTER_DOMAIN_MOVE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DRSUAPI_INTER_DOMAIN_MOVE, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_drsuapi_DsGetNT4ChangeLog(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *bind_handle /* [in] [ref] */,
					  uint32_t level /* [in]  */,
					  union drsuapi_DsGetNT4ChangeLogRequest *req /* [in] [ref,switch_is(level)] */,
					  uint32_t *level_out /* [out] [ref] */,
					  union drsuapi_DsGetNT4ChangeLogInfo *info /* [out] [ref,switch_is(*level_out)] */,
					  WERROR *werror)
{
	struct drsuapi_DsGetNT4ChangeLog r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = bind_handle;
	r.in.level = level;
	r.in.req = req;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(drsuapi_DsGetNT4ChangeLog, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_DSGETNT4CHANGELOG,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(drsuapi_DsGetNT4ChangeLog, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*level_out = *r.out.level_out;
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_drsuapi_DsCrackNames(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *bind_handle /* [in] [ref] */,
				     int32_t level /* [in]  */,
				     union drsuapi_DsNameRequest *req /* [in] [ref,switch_is(level)] */,
				     int32_t *level_out /* [out] [ref] */,
				     union drsuapi_DsNameCtr *ctr /* [out] [ref,switch_is(*level_out)] */,
				     WERROR *werror)
{
	struct drsuapi_DsCrackNames r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = bind_handle;
	r.in.level = level;
	r.in.req = req;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(drsuapi_DsCrackNames, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_DSCRACKNAMES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(drsuapi_DsCrackNames, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*level_out = *r.out.level_out;
	*ctr = *r.out.ctr;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_drsuapi_DsWriteAccountSpn(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *bind_handle /* [in] [ref] */,
					  int32_t level /* [in]  */,
					  union drsuapi_DsWriteAccountSpnRequest *req /* [in] [ref,switch_is(level)] */,
					  int32_t *level_out /* [out] [ref] */,
					  union drsuapi_DsWriteAccountSpnResult *res /* [out] [ref,switch_is(*level_out)] */,
					  WERROR *werror)
{
	struct drsuapi_DsWriteAccountSpn r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = bind_handle;
	r.in.level = level;
	r.in.req = req;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(drsuapi_DsWriteAccountSpn, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_DSWRITEACCOUNTSPN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(drsuapi_DsWriteAccountSpn, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*level_out = *r.out.level_out;
	*res = *r.out.res;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_drsuapi_DsRemoveDSServer(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *bind_handle /* [in] [ref] */,
					 int32_t level /* [in]  */,
					 union drsuapi_DsRemoveDSServerRequest *req /* [in] [ref,switch_is(level)] */,
					 int32_t *level_out /* [out] [ref] */,
					 union drsuapi_DsRemoveDSServerResult *res /* [out] [ref,switch_is(*level_out)] */,
					 WERROR *werror)
{
	struct drsuapi_DsRemoveDSServer r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = bind_handle;
	r.in.level = level;
	r.in.req = req;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(drsuapi_DsRemoveDSServer, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_DSREMOVEDSSERVER,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(drsuapi_DsRemoveDSServer, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*level_out = *r.out.level_out;
	*res = *r.out.res;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_DRSUAPI_REMOVE_DS_DOMAIN(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 WERROR *werror)
{
	struct DRSUAPI_REMOVE_DS_DOMAIN r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DRSUAPI_REMOVE_DS_DOMAIN, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_REMOVE_DS_DOMAIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DRSUAPI_REMOVE_DS_DOMAIN, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_drsuapi_DsGetDomainControllerInfo(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  struct policy_handle *bind_handle /* [in] [ref] */,
						  int32_t level /* [in]  */,
						  union drsuapi_DsGetDCInfoRequest *req /* [in] [ref,switch_is(level)] */,
						  int32_t *level_out /* [out] [ref] */,
						  union drsuapi_DsGetDCInfoCtr *ctr /* [out] [ref,switch_is(*level_out)] */,
						  WERROR *werror)
{
	struct drsuapi_DsGetDomainControllerInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = bind_handle;
	r.in.level = level;
	r.in.req = req;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(drsuapi_DsGetDomainControllerInfo, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_DSGETDOMAINCONTROLLERINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(drsuapi_DsGetDomainControllerInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*level_out = *r.out.level_out;
	*ctr = *r.out.ctr;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_drsuapi_DsAddEntry(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *bind_handle /* [in] [ref] */,
				   int32_t level /* [in]  */,
				   union drsuapi_DsAddEntryRequest *req /* [in] [ref,switch_is(level)] */,
				   int32_t *level_out /* [out] [ref] */,
				   union drsuapi_DsAddEntryCtr *ctr /* [out] [ref,switch_is(*level_out)] */,
				   WERROR *werror)
{
	struct drsuapi_DsAddEntry r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = bind_handle;
	r.in.level = level;
	r.in.req = req;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(drsuapi_DsAddEntry, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_DSADDENTRY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(drsuapi_DsAddEntry, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*level_out = *r.out.level_out;
	*ctr = *r.out.ctr;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_DRSUAPI_EXECUTE_KCC(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    WERROR *werror)
{
	struct DRSUAPI_EXECUTE_KCC r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DRSUAPI_EXECUTE_KCC, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_EXECUTE_KCC,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DRSUAPI_EXECUTE_KCC, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_drsuapi_DsReplicaGetInfo(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *bind_handle /* [in] [ref] */,
					 enum drsuapi_DsReplicaGetInfoLevel level /* [in]  */,
					 union drsuapi_DsReplicaGetInfoRequest *req /* [in] [ref,switch_is(level)] */,
					 enum drsuapi_DsReplicaInfoType *info_type /* [out] [ref] */,
					 union drsuapi_DsReplicaInfo *info /* [out] [ref,switch_is(*info_type)] */,
					 WERROR *werror)
{
	struct drsuapi_DsReplicaGetInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = bind_handle;
	r.in.level = level;
	r.in.req = req;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(drsuapi_DsReplicaGetInfo, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_DSREPLICAGETINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(drsuapi_DsReplicaGetInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info_type = *r.out.info_type;
	*info = *r.out.info;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_DRSUAPI_ADD_SID_HISTORY(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					WERROR *werror)
{
	struct DRSUAPI_ADD_SID_HISTORY r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DRSUAPI_ADD_SID_HISTORY, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_ADD_SID_HISTORY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DRSUAPI_ADD_SID_HISTORY, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_drsuapi_DsGetMemberships2(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *bind_handle /* [in] [ref] */,
					  int32_t level /* [in]  */,
					  union drsuapi_DsGetMemberships2Request *req /* [in] [ref,switch_is(level)] */,
					  int32_t *level_out /* [out] [ref] */,
					  union drsuapi_DsGetMemberships2Ctr *ctr /* [out] [ref,switch_is(*level_out)] */,
					  WERROR *werror)
{
	struct drsuapi_DsGetMemberships2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = bind_handle;
	r.in.level = level;
	r.in.req = req;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(drsuapi_DsGetMemberships2, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_DSGETMEMBERSHIPS2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(drsuapi_DsGetMemberships2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*level_out = *r.out.level_out;
	*ctr = *r.out.ctr;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_DRSUAPI_REPLICA_VERIFY_OBJECTS(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       WERROR *werror)
{
	struct DRSUAPI_REPLICA_VERIFY_OBJECTS r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DRSUAPI_REPLICA_VERIFY_OBJECTS, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_REPLICA_VERIFY_OBJECTS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DRSUAPI_REPLICA_VERIFY_OBJECTS, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_DRSUAPI_GET_OBJECT_EXISTENCE(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     WERROR *werror)
{
	struct DRSUAPI_GET_OBJECT_EXISTENCE r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(DRSUAPI_GET_OBJECT_EXISTENCE, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_GET_OBJECT_EXISTENCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(DRSUAPI_GET_OBJECT_EXISTENCE, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_drsuapi_QuerySitesByCost(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *bind_handle /* [in] [ref] */,
					 int32_t level /* [in]  */,
					 union drsuapi_QuerySitesByCostRequest *req /* [in] [ref,switch_is(level)] */,
					 int32_t *level_out /* [out] [ref] */,
					 union drsuapi_QuerySitesByCostCtr *ctr /* [out] [ref,switch_is(*level_out)] */,
					 WERROR *werror)
{
	struct drsuapi_QuerySitesByCost r;
	NTSTATUS status;

	/* In parameters */
	r.in.bind_handle = bind_handle;
	r.in.level = level;
	r.in.req = req;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(drsuapi_QuerySitesByCost, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_drsuapi,
				NDR_DRSUAPI_QUERYSITESBYCOST,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(drsuapi_QuerySitesByCost, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*level_out = *r.out.level_out;
	*ctr = *r.out.ctr;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

