/* SPDX-License-Identifier: GPL-2.0 */
/******************************************************************************
*
* Copyright(c) 2007 - 2011 Realtek Corporation. All rights reserved.
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of version 2 of the GNU General Public License as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful, but WITHOUT
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
* more details.
*
* You should have received a copy of the GNU General Public License along with
* this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
*
*
******************************************************************************/

/*Image2HeaderVersion: 3.4*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

static boolean
check_positive(
	struct PHY_DM_STRUCT *p_dm_odm,
	const u32	condition1,
	const u32	condition2,
	const u32	condition3,
	const u32	condition4
)
{
	u8	_board_type = ((p_dm_odm->board_type & BIT(4)) >> 4) << 0 | /* _GLNA*/
			((p_dm_odm->board_type & BIT(3)) >> 3) << 1 | /* _GPA*/
			((p_dm_odm->board_type & BIT(7)) >> 7) << 2 | /* _ALNA*/
			((p_dm_odm->board_type & BIT(6)) >> 6) << 3 | /* _APA */
			((p_dm_odm->board_type & BIT(2)) >> 2) << 4 | /* _BT*/
			((p_dm_odm->board_type & BIT(1)) >> 1) << 5;  /* _NGFF*/

	u32	cond1 = condition1, cond2 = condition2, cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para = (p_dm_odm->cut_version ==  ODM_CUT_A) ? 15 : p_dm_odm->cut_version;
	u8	pkg_type_for_para = (p_dm_odm->package_type == 0) ? 15 : p_dm_odm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(p_dm_odm->support_interface & 0xF0) << 16 |
			p_dm_odm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(p_dm_odm->support_interface & 0x0F) << 8  |
			_board_type;

	u32	driver2 = (p_dm_odm->type_glna & 0xFF) <<  0 |
			(p_dm_odm->type_gpa & 0xFF)  <<  8 |
			(p_dm_odm->type_alna & 0xFF) << 16 |
			(p_dm_odm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (p_dm_odm->type_glna & 0xFF00) >>  8 |
			(p_dm_odm->type_gpa & 0xFF00) |
			(p_dm_odm->type_alna & 0xFF00) << 8 |
			(p_dm_odm->type_apa & 0xFF00)  << 16;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
	("===> check_positive (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n", cond1, cond2, cond3, cond4));
	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
	("===> check_positive (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n", driver1, driver2, driver3, driver4));

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
	("	(Platform, Interface) = (0x%X, 0x%X)\n", p_dm_odm->support_platform, p_dm_odm->support_interface));
	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_TRACE,
	("	(Board, Package) = (0x%X, 0x%X)\n", p_dm_odm->board_type, p_dm_odm->package_type));

	/*============== value Defined Check ===============*/
	/*QFN type [15:12] and cut version [27:24] need to do value check*/

	if (((cond1 & 0x0000F000) != 0) && ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;
	if (((cond1 & 0x0F000000) != 0) && ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x00FF0FFF;
	driver1 &= 0x00FF0FFF;

	if ((cond1 & driver1) == cond1) {
		u32	bit_mask = 0;

		if ((cond1 & 0x0F) == 0) /* board_type is DONTCARE*/
			return true;

		if ((cond1 & BIT(0)) != 0) /*GLNA*/
			bit_mask |= 0x000000FF;
		if ((cond1 & BIT(1)) != 0) /*GPA*/
			bit_mask |= 0x0000FF00;
		if ((cond1 & BIT(2)) != 0) /*ALNA*/
			bit_mask |= 0x00FF0000;
		if ((cond1 & BIT(3)) != 0) /*APA*/
			bit_mask |= 0xFF000000;

		if (((cond2 & bit_mask) == (driver2 & bit_mask)) && ((cond4 & bit_mask) == (driver4 & bit_mask)))  /* board_type of each RF path is matched*/
			return true;
		else
			return false;
	} else
		return false;
}

/******************************************************************************
*                           agc_tab.TXT
******************************************************************************/

u32 array_mp_8821c_agc_tab[] = {
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFB000003,
		0x81C, 0xFA020003,
		0x81C, 0xF9040003,
		0x81C, 0xF8060003,
		0x81C, 0xF7080003,
		0x81C, 0xF60A0003,
		0x81C, 0xF50C0003,
		0x81C, 0xF40E0003,
		0x81C, 0xF3100003,
		0x81C, 0xF2120003,
		0x81C, 0xF1140003,
		0x81C, 0xF0160003,
		0x81C, 0xEF180003,
		0x81C, 0xEE1A0003,
		0x81C, 0xED1C0003,
		0x81C, 0xEC1E0003,
		0x81C, 0xEB200003,
		0x81C, 0xEA220003,
		0x81C, 0xE9240003,
		0x81C, 0xE8260003,
		0x81C, 0xE7280003,
		0x81C, 0xE62A0003,
		0x81C, 0xE52C0003,
		0x81C, 0xE42E0003,
		0x81C, 0xE3300003,
		0x81C, 0xE2320003,
		0x81C, 0xE1340003,
		0x81C, 0xC4360003,
		0x81C, 0xC3380003,
		0x81C, 0xC23A0003,
		0x81C, 0xC13C0003,
		0x81C, 0x883E0003,
		0x81C, 0x87400003,
		0x81C, 0x86420003,
		0x81C, 0x85440003,
		0x81C, 0x84460003,
		0x81C, 0x83480003,
		0x81C, 0x824A0003,
		0x81C, 0x814C0003,
		0x81C, 0x804E0003,
		0x81C, 0x64500003,
		0x81C, 0x63520003,
		0x81C, 0x62540003,
		0x81C, 0x61560003,
		0x81C, 0x60580003,
		0x81C, 0x475A0003,
		0x81C, 0x465C0003,
		0x81C, 0x455E0003,
		0x81C, 0x44600003,
		0x81C, 0x43620003,
		0x81C, 0x42640003,
		0x81C, 0x41660003,
		0x81C, 0x40680003,
		0x81C, 0x236A0003,
		0x81C, 0x226C0003,
		0x81C, 0x056E0003,
		0x81C, 0x04700003,
		0x81C, 0x03720003,
		0x81C, 0x02740003,
		0x81C, 0x01760003,
		0x81C, 0x01780003,
		0x81C, 0x017A0003,
		0x81C, 0x017C0003,
		0x81C, 0x017E0003,
	0xA0000000,	0x00000000,
		0x81C, 0xFB000003,
		0x81C, 0xFA020003,
		0x81C, 0xF9040003,
		0x81C, 0xF8060003,
		0x81C, 0xF7080003,
		0x81C, 0xF60A0003,
		0x81C, 0xF50C0003,
		0x81C, 0xF40E0003,
		0x81C, 0xF3100003,
		0x81C, 0xF2120003,
		0x81C, 0xF1140003,
		0x81C, 0xF0160003,
		0x81C, 0xEF180003,
		0x81C, 0xEE1A0003,
		0x81C, 0xED1C0003,
		0x81C, 0xEC1E0003,
		0x81C, 0xEB200003,
		0x81C, 0xEA220003,
		0x81C, 0xE9240003,
		0x81C, 0xE8260003,
		0x81C, 0xE7280003,
		0x81C, 0xE62A0003,
		0x81C, 0xCA2C0003,
		0x81C, 0xC92E0003,
		0x81C, 0xC8300003,
		0x81C, 0xC7320003,
		0x81C, 0xC6340003,
		0x81C, 0xC5360003,
		0x81C, 0xC4380003,
		0x81C, 0xC33A0003,
		0x81C, 0xC23C0003,
		0x81C, 0xC13E0003,
		0x81C, 0x88400003,
		0x81C, 0x87420003,
		0x81C, 0x86440003,
		0x81C, 0x85460003,
		0x81C, 0x84480003,
		0x81C, 0x834A0003,
		0x81C, 0x674C0003,
		0x81C, 0x664E0003,
		0x81C, 0x65500003,
		0x81C, 0x64520003,
		0x81C, 0x63540003,
		0x81C, 0x62560003,
		0x81C, 0x61580003,
		0x81C, 0x455A0003,
		0x81C, 0x445C0003,
		0x81C, 0x435E0003,
		0x81C, 0x42600003,
		0x81C, 0x41620003,
		0x81C, 0x25640003,
		0x81C, 0x24660003,
		0x81C, 0x23680003,
		0x81C, 0x226A0003,
		0x81C, 0x216C0003,
		0x81C, 0x016E0003,
		0x81C, 0x01700003,
		0x81C, 0x01720003,
		0x81C, 0x01740003,
		0x81C, 0x01760003,
		0x81C, 0x01780003,
		0x81C, 0x017A0003,
		0x81C, 0x017C0003,
		0x81C, 0x017E0003,
	0xB0000000,	0x00000000,
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFD000103,
		0x81C, 0xFC020103,
		0x81C, 0xFB040103,
		0x81C, 0xFA060103,
		0x81C, 0xF9080103,
		0x81C, 0xF80A0103,
		0x81C, 0xF70C0103,
		0x81C, 0xF60E0103,
		0x81C, 0xF5100103,
		0x81C, 0xF4120103,
		0x81C, 0xF3140103,
		0x81C, 0xF2160103,
		0x81C, 0xF1180103,
		0x81C, 0xF01A0103,
		0x81C, 0xEF1C0103,
		0x81C, 0xEE1E0103,
		0x81C, 0xED200103,
		0x81C, 0xEC220103,
		0x81C, 0xEB240103,
		0x81C, 0xEA260103,
		0x81C, 0xE9280103,
		0x81C, 0xE82A0103,
		0x81C, 0xE72C0103,
		0x81C, 0xE62E0103,
		0x81C, 0xE5300103,
		0x81C, 0xE4320103,
		0x81C, 0xE3340103,
		0x81C, 0xE2360103,
		0x81C, 0xE1380103,
		0x81C, 0xE03A0103,
		0x81C, 0xC33C0103,
		0x81C, 0xC23E0103,
		0x81C, 0xC1400103,
		0x81C, 0xC0420103,
		0x81C, 0xA3440103,
		0x81C, 0xA2460103,
		0x81C, 0xA1480103,
		0x81C, 0xA04A0103,
		0x81C, 0x824C0103,
		0x81C, 0x814E0103,
		0x81C, 0x80500103,
		0x81C, 0x62520103,
		0x81C, 0x61540103,
		0x81C, 0x60560103,
		0x81C, 0x24580103,
		0x81C, 0x235A0103,
		0x81C, 0x225C0103,
		0x81C, 0x215E0103,
		0x81C, 0x20600103,
		0x81C, 0x03620103,
		0x81C, 0x02640103,
		0x81C, 0x01660103,
		0x81C, 0x01680103,
		0x81C, 0x016A0103,
		0x81C, 0x016C0103,
		0x81C, 0x016E0103,
		0x81C, 0x01700103,
		0x81C, 0x01720103,
		0x81C, 0x01740103,
		0x81C, 0x01760103,
		0x81C, 0x01780103,
		0x81C, 0x017A0103,
		0x81C, 0x017C0103,
		0x81C, 0x017E0103,
	0xA0000000,	0x00000000,
		0x81C, 0xFD000103,
		0x81C, 0xFC020103,
		0x81C, 0xFB040103,
		0x81C, 0xFA060103,
		0x81C, 0xF9080103,
		0x81C, 0xF80A0103,
		0x81C, 0xF70C0103,
		0x81C, 0xF60E0103,
		0x81C, 0xF5100103,
		0x81C, 0xF4120103,
		0x81C, 0xF3140103,
		0x81C, 0xF2160103,
		0x81C, 0xF1180103,
		0x81C, 0xF01A0103,
		0x81C, 0xEF1C0103,
		0x81C, 0xEE1E0103,
		0x81C, 0xED200103,
		0x81C, 0xEC220103,
		0x81C, 0xEB240103,
		0x81C, 0xEA260103,
		0x81C, 0xE9280103,
		0x81C, 0xE82A0103,
		0x81C, 0xE72C0103,
		0x81C, 0xE62E0103,
		0x81C, 0xE5300103,
		0x81C, 0xE4320103,
		0x81C, 0xE3340103,
		0x81C, 0xE2360103,
		0x81C, 0xE1380103,
		0x81C, 0xE03A0103,
		0x81C, 0xA83C0103,
		0x81C, 0xA73E0103,
		0x81C, 0xA6400103,
		0x81C, 0xA5420103,
		0x81C, 0xA4440103,
		0x81C, 0xA3460103,
		0x81C, 0xA2480103,
		0x81C, 0xA14A0103,
		0x81C, 0x834C0103,
		0x81C, 0x824E0103,
		0x81C, 0x81500103,
		0x81C, 0x63520103,
		0x81C, 0x62540103,
		0x81C, 0x61560103,
		0x81C, 0x25580103,
		0x81C, 0x245A0103,
		0x81C, 0x235C0103,
		0x81C, 0x225E0103,
		0x81C, 0x04600103,
		0x81C, 0x03620103,
		0x81C, 0x02640103,
		0x81C, 0x01660103,
		0x81C, 0x01680103,
		0x81C, 0x016A0103,
		0x81C, 0x016C0103,
		0x81C, 0x016E0103,
		0x81C, 0x01700103,
		0x81C, 0x01720103,
		0x81C, 0x01740103,
		0x81C, 0x01760103,
		0x81C, 0x01780103,
		0x81C, 0x017A0103,
		0x81C, 0x017C0103,
		0x81C, 0x017E0103,
	0xB0000000,	0x00000000,
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFB000203,
		0x81C, 0xFA020203,
		0x81C, 0xF9040203,
		0x81C, 0xF8060203,
		0x81C, 0xF7080203,
		0x81C, 0xF60A0203,
		0x81C, 0xF50C0203,
		0x81C, 0xF40E0203,
		0x81C, 0xF3100203,
		0x81C, 0xF2120203,
		0x81C, 0xF1140203,
		0x81C, 0xF0160203,
		0x81C, 0xEF180203,
		0x81C, 0xEE1A0203,
		0x81C, 0xED1C0203,
		0x81C, 0xEC1E0203,
		0x81C, 0xEB200203,
		0x81C, 0xEA220203,
		0x81C, 0xE9240203,
		0x81C, 0xE8260203,
		0x81C, 0xE7280203,
		0x81C, 0xE62A0203,
		0x81C, 0xE52C0203,
		0x81C, 0xE42E0203,
		0x81C, 0xE3300203,
		0x81C, 0xE2320203,
		0x81C, 0xE1340203,
		0x81C, 0xC5360203,
		0x81C, 0xC4380203,
		0x81C, 0xC33A0203,
		0x81C, 0xC23C0203,
		0x81C, 0xC13E0203,
		0x81C, 0xA4400203,
		0x81C, 0xA3420203,
		0x81C, 0xA2440203,
		0x81C, 0xA1460203,
		0x81C, 0xA0480203,
		0x81C, 0x834A0203,
		0x81C, 0x824C0203,
		0x81C, 0x814E0203,
		0x81C, 0x63500203,
		0x81C, 0x62520203,
		0x81C, 0x61540203,
		0x81C, 0x60560203,
		0x81C, 0x23580203,
		0x81C, 0x225A0203,
		0x81C, 0x215C0203,
		0x81C, 0x205E0203,
		0x81C, 0x04600203,
		0x81C, 0x03620203,
		0x81C, 0x02640203,
		0x81C, 0x01660203,
		0x81C, 0x01680203,
		0x81C, 0x016A0203,
		0x81C, 0x016C0203,
		0x81C, 0x016E0203,
		0x81C, 0x01700203,
		0x81C, 0x01720203,
		0x81C, 0x01740203,
		0x81C, 0x01760203,
		0x81C, 0x01780203,
		0x81C, 0x017A0203,
		0x81C, 0x017C0203,
		0x81C, 0x017E0203,
	0xA0000000,	0x00000000,
		0x81C, 0xFC000203,
		0x81C, 0xFB020203,
		0x81C, 0xFA040203,
		0x81C, 0xF9060203,
		0x81C, 0xF8080203,
		0x81C, 0xF70A0203,
		0x81C, 0xF60C0203,
		0x81C, 0xF50E0203,
		0x81C, 0xF4100203,
		0x81C, 0xF3120203,
		0x81C, 0xF2140203,
		0x81C, 0xF1160203,
		0x81C, 0xF0180203,
		0x81C, 0xEF1A0203,
		0x81C, 0xEE1C0203,
		0x81C, 0xED1E0203,
		0x81C, 0xEC200203,
		0x81C, 0xEB220203,
		0x81C, 0xEA240203,
		0x81C, 0xE9260203,
		0x81C, 0xE8280203,
		0x81C, 0xE72A0203,
		0x81C, 0xE62C0203,
		0x81C, 0xE52E0203,
		0x81C, 0xE4300203,
		0x81C, 0xE3320203,
		0x81C, 0xE2340203,
		0x81C, 0xE1360203,
		0x81C, 0xC5380203,
		0x81C, 0xC43A0203,
		0x81C, 0xC33C0203,
		0x81C, 0xC23E0203,
		0x81C, 0xA6400203,
		0x81C, 0xA5420203,
		0x81C, 0xA4440203,
		0x81C, 0xA3460203,
		0x81C, 0xA2480203,
		0x81C, 0x844A0203,
		0x81C, 0x834C0203,
		0x81C, 0x824E0203,
		0x81C, 0x64500203,
		0x81C, 0x63520203,
		0x81C, 0x62540203,
		0x81C, 0x61560203,
		0x81C, 0x60580203,
		0x81C, 0x235A0203,
		0x81C, 0x225C0203,
		0x81C, 0x215E0203,
		0x81C, 0x04600203,
		0x81C, 0x03620203,
		0x81C, 0x02640203,
		0x81C, 0x01660203,
		0x81C, 0x01680203,
		0x81C, 0x016A0203,
		0x81C, 0x016C0203,
		0x81C, 0x016E0203,
		0x81C, 0x01700203,
		0x81C, 0x01720203,
		0x81C, 0x01740203,
		0x81C, 0x01760203,
		0x81C, 0x01780203,
		0x81C, 0x017A0203,
		0x81C, 0x017C0203,
		0x81C, 0x017E0203,
	0xB0000000,	0x00000000,
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFB000303,
		0x81C, 0xFA020303,
		0x81C, 0xF9040303,
		0x81C, 0xF8060303,
		0x81C, 0xF7080303,
		0x81C, 0xF60A0303,
		0x81C, 0xF50C0303,
		0x81C, 0xF40E0303,
		0x81C, 0xF3100303,
		0x81C, 0xF2120303,
		0x81C, 0xF1140303,
		0x81C, 0xF0160303,
		0x81C, 0xEF180303,
		0x81C, 0xEE1A0303,
		0x81C, 0xED1C0303,
		0x81C, 0xEC1E0303,
		0x81C, 0xEB200303,
		0x81C, 0xEA220303,
		0x81C, 0xE9240303,
		0x81C, 0xE8260303,
		0x81C, 0xE7280303,
		0x81C, 0xE62A0303,
		0x81C, 0xE52C0303,
		0x81C, 0xE42E0303,
		0x81C, 0xE3300303,
		0x81C, 0xE2320303,
		0x81C, 0xE1340303,
		0x81C, 0xC4360303,
		0x81C, 0xC3380303,
		0x81C, 0xC23A0303,
		0x81C, 0xC13C0303,
		0x81C, 0xA53E0303,
		0x81C, 0xA4400303,
		0x81C, 0xA3420303,
		0x81C, 0xA2440303,
		0x81C, 0xA1460303,
		0x81C, 0x83480303,
		0x81C, 0x824A0303,
		0x81C, 0x814C0303,
		0x81C, 0x644E0303,
		0x81C, 0x63500303,
		0x81C, 0x62520303,
		0x81C, 0x61540303,
		0x81C, 0x60560303,
		0x81C, 0x23580303,
		0x81C, 0x225A0303,
		0x81C, 0x215C0303,
		0x81C, 0x045E0303,
		0x81C, 0x03600303,
		0x81C, 0x02620303,
		0x81C, 0x01640303,
		0x81C, 0x01660303,
		0x81C, 0x01680303,
		0x81C, 0x016A0303,
		0x81C, 0x016C0303,
		0x81C, 0x016E0303,
		0x81C, 0x01700303,
		0x81C, 0x01720303,
		0x81C, 0x01740303,
		0x81C, 0x01760303,
		0x81C, 0x01780303,
		0x81C, 0x017A0303,
		0x81C, 0x017C0303,
		0x81C, 0x017E0303,
	0xA0000000,	0x00000000,
		0x81C, 0xFC000303,
		0x81C, 0xFB020303,
		0x81C, 0xFA040303,
		0x81C, 0xF9060303,
		0x81C, 0xF8080303,
		0x81C, 0xF70A0303,
		0x81C, 0xF60C0303,
		0x81C, 0xF50E0303,
		0x81C, 0xF4100303,
		0x81C, 0xF3120303,
		0x81C, 0xF2140303,
		0x81C, 0xF1160303,
		0x81C, 0xF0180303,
		0x81C, 0xEF1A0303,
		0x81C, 0xEE1C0303,
		0x81C, 0xED1E0303,
		0x81C, 0xEC200303,
		0x81C, 0xEB220303,
		0x81C, 0xEA240303,
		0x81C, 0xE9260303,
		0x81C, 0xE8280303,
		0x81C, 0xE72A0303,
		0x81C, 0xE62C0303,
		0x81C, 0xE52E0303,
		0x81C, 0xE4300303,
		0x81C, 0xE3320303,
		0x81C, 0xE2340303,
		0x81C, 0xE1360303,
		0x81C, 0xC4380303,
		0x81C, 0xC33A0303,
		0x81C, 0xC23C0303,
		0x81C, 0xC13E0303,
		0x81C, 0xA5400303,
		0x81C, 0xA4420303,
		0x81C, 0xA3440303,
		0x81C, 0xA2460303,
		0x81C, 0xA1480303,
		0x81C, 0x834A0303,
		0x81C, 0x824C0303,
		0x81C, 0x814E0303,
		0x81C, 0x64500303,
		0x81C, 0x63520303,
		0x81C, 0x62540303,
		0x81C, 0x61560303,
		0x81C, 0x24580303,
		0x81C, 0x235A0303,
		0x81C, 0x225C0303,
		0x81C, 0x215E0303,
		0x81C, 0x04600303,
		0x81C, 0x03620303,
		0x81C, 0x02640303,
		0x81C, 0x01660303,
		0x81C, 0x01680303,
		0x81C, 0x016A0303,
		0x81C, 0x016C0303,
		0x81C, 0x016E0303,
		0x81C, 0x01700303,
		0x81C, 0x01720303,
		0x81C, 0x01740303,
		0x81C, 0x01760303,
		0x81C, 0x01780303,
		0x81C, 0x017A0303,
		0x81C, 0x017C0303,
		0x81C, 0x017E0303,
	0xB0000000,	0x00000000,
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFC000803,
		0x81C, 0xFB020803,
		0x81C, 0xFA040803,
		0x81C, 0xF9060803,
		0x81C, 0xF8080803,
		0x81C, 0xF70A0803,
		0x81C, 0xF60C0803,
		0x81C, 0xF50E0803,
		0x81C, 0xF4100803,
		0x81C, 0xF3120803,
		0x81C, 0xF2140803,
		0x81C, 0xF1160803,
		0x81C, 0xF0180803,
		0x81C, 0xEF1A0803,
		0x81C, 0xEE1C0803,
		0x81C, 0xED1E0803,
		0x81C, 0xB5200803,
		0x81C, 0xB4220803,
		0x81C, 0xB3240803,
		0x81C, 0xB2260803,
		0x81C, 0xB1280803,
		0x81C, 0xB02A0803,
		0x81C, 0xAF2C0803,
		0x81C, 0xAE2E0803,
		0x81C, 0xAD300803,
		0x81C, 0xAC320803,
		0x81C, 0xAB340803,
		0x81C, 0xAA360803,
		0x81C, 0xA9380803,
		0x81C, 0xA83A0803,
		0x81C, 0xA73C0803,
		0x81C, 0xA63E0803,
		0x81C, 0x88400803,
		0x81C, 0x87420803,
		0x81C, 0x86440803,
		0x81C, 0x85460803,
		0x81C, 0x84480803,
		0x81C, 0x834A0803,
		0x81C, 0x674C0803,
		0x81C, 0x664E0803,
		0x81C, 0x65500803,
		0x81C, 0x64520803,
		0x81C, 0x63540803,
		0x81C, 0x62560803,
		0x81C, 0x61580803,
		0x81C, 0x455A0803,
		0x81C, 0x445C0803,
		0x81C, 0x435E0803,
		0x81C, 0x42600803,
		0x81C, 0x41620803,
		0x81C, 0x25640803,
		0x81C, 0x24660803,
		0x81C, 0x23680803,
		0x81C, 0x226A0803,
		0x81C, 0x216C0803,
		0x81C, 0x016E0803,
		0x81C, 0x01700803,
		0x81C, 0x01720803,
		0x81C, 0x01740803,
		0x81C, 0x01760803,
		0x81C, 0x01780803,
		0x81C, 0x017A0803,
		0x81C, 0x017C0803,
		0x81C, 0x017E0803,
	0xA0000000,	0x00000000,
		0x81C, 0xFC000803,
		0x81C, 0xFB020803,
		0x81C, 0xFA040803,
		0x81C, 0xF9060803,
		0x81C, 0xF8080803,
		0x81C, 0xF70A0803,
		0x81C, 0xF60C0803,
		0x81C, 0xF50E0803,
		0x81C, 0xF4100803,
		0x81C, 0xF3120803,
		0x81C, 0xF2140803,
		0x81C, 0xF1160803,
		0x81C, 0xF0180803,
		0x81C, 0xEF1A0803,
		0x81C, 0xEE1C0803,
		0x81C, 0xED1E0803,
		0x81C, 0xB5200803,
		0x81C, 0xB4220803,
		0x81C, 0xB3240803,
		0x81C, 0xB2260803,
		0x81C, 0xB1280803,
		0x81C, 0xB02A0803,
		0x81C, 0xAF2C0803,
		0x81C, 0xAE2E0803,
		0x81C, 0xAD300803,
		0x81C, 0xAC320803,
		0x81C, 0xAB340803,
		0x81C, 0xAA360803,
		0x81C, 0xA9380803,
		0x81C, 0xA83A0803,
		0x81C, 0xA73C0803,
		0x81C, 0xA63E0803,
		0x81C, 0x88400803,
		0x81C, 0x87420803,
		0x81C, 0x86440803,
		0x81C, 0x85460803,
		0x81C, 0x84480803,
		0x81C, 0x834A0803,
		0x81C, 0x674C0803,
		0x81C, 0x664E0803,
		0x81C, 0x65500803,
		0x81C, 0x64520803,
		0x81C, 0x63540803,
		0x81C, 0x62560803,
		0x81C, 0x61580803,
		0x81C, 0x455A0803,
		0x81C, 0x445C0803,
		0x81C, 0x435E0803,
		0x81C, 0x42600803,
		0x81C, 0x41620803,
		0x81C, 0x25640803,
		0x81C, 0x24660803,
		0x81C, 0x23680803,
		0x81C, 0x226A0803,
		0x81C, 0x216C0803,
		0x81C, 0x016E0803,
		0x81C, 0x01700803,
		0x81C, 0x01720803,
		0x81C, 0x01740803,
		0x81C, 0x01760803,
		0x81C, 0x01780803,
		0x81C, 0x017A0803,
		0x81C, 0x017C0803,
		0x81C, 0x017E0803,
	0xB0000000,	0x00000000,
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000913,
		0x81C, 0xFE020913,
		0x81C, 0xFD040913,
		0x81C, 0xFC060913,
		0x81C, 0xFB080913,
		0x81C, 0xFA0A0913,
		0x81C, 0xF90C0913,
		0x81C, 0xF80E0913,
		0x81C, 0xF7100913,
		0x81C, 0xF6120913,
		0x81C, 0xF5140913,
		0x81C, 0xF4160913,
		0x81C, 0xF3180913,
		0x81C, 0xF21A0913,
		0x81C, 0xF11C0913,
		0x81C, 0x941E0913,
		0x81C, 0x93200913,
		0x81C, 0x92220913,
		0x81C, 0x91240913,
		0x81C, 0x90260913,
		0x81C, 0x8F280913,
		0x81C, 0x8E2A0913,
		0x81C, 0x8D2C0913,
		0x81C, 0x8C2E0913,
		0x81C, 0x8B300913,
		0x81C, 0x8A320913,
		0x81C, 0x89340913,
		0x81C, 0x88360913,
		0x81C, 0x87380913,
		0x81C, 0x863A0913,
		0x81C, 0x853C0913,
		0x81C, 0x843E0913,
		0x81C, 0x83400913,
		0x81C, 0x82420913,
		0x81C, 0x81440913,
		0x81C, 0x07460913,
		0x81C, 0x06480913,
		0x81C, 0x054A0913,
		0x81C, 0x044C0913,
		0x81C, 0x034E0913,
		0x81C, 0x02500913,
		0x81C, 0x01520913,
		0x81C, 0x88540903,
		0x81C, 0x87560903,
		0x81C, 0x86580903,
		0x81C, 0x855A0903,
		0x81C, 0x845C0903,
		0x81C, 0x835E0903,
		0x81C, 0x82600903,
		0x81C, 0x81620903,
		0x81C, 0x07640903,
		0x81C, 0x06660903,
		0x81C, 0x05680903,
		0x81C, 0x046A0903,
		0x81C, 0x036C0903,
		0x81C, 0x026E0903,
		0x81C, 0x01700903,
		0x81C, 0x01720903,
		0x81C, 0x01740903,
		0x81C, 0x01760903,
		0x81C, 0x01780903,
		0x81C, 0x017A0903,
		0x81C, 0x017C0903,
		0x81C, 0x017E0903,
	0xA0000000,	0x00000000,
		0x81C, 0xFF000913,
		0x81C, 0xFE020913,
		0x81C, 0xFD040913,
		0x81C, 0xFC060913,
		0x81C, 0xFB080913,
		0x81C, 0xFA0A0913,
		0x81C, 0xF90C0913,
		0x81C, 0xF80E0913,
		0x81C, 0xF7100913,
		0x81C, 0xF6120913,
		0x81C, 0xF5140913,
		0x81C, 0xF4160913,
		0x81C, 0xF3180913,
		0x81C, 0xF21A0913,
		0x81C, 0xF11C0913,
		0x81C, 0x941E0913,
		0x81C, 0x93200913,
		0x81C, 0x92220913,
		0x81C, 0x91240913,
		0x81C, 0x90260913,
		0x81C, 0x8F280913,
		0x81C, 0x8E2A0913,
		0x81C, 0x8D2C0913,
		0x81C, 0x8C2E0913,
		0x81C, 0x8B300913,
		0x81C, 0x8A320913,
		0x81C, 0x89340913,
		0x81C, 0x88360913,
		0x81C, 0x87380913,
		0x81C, 0x863A0913,
		0x81C, 0x853C0913,
		0x81C, 0x843E0913,
		0x81C, 0x83400913,
		0x81C, 0x82420913,
		0x81C, 0x81440913,
		0x81C, 0x07460913,
		0x81C, 0x06480913,
		0x81C, 0x054A0913,
		0x81C, 0x044C0913,
		0x81C, 0x034E0913,
		0x81C, 0x02500913,
		0x81C, 0x01520913,
		0x81C, 0x88540903,
		0x81C, 0x87560903,
		0x81C, 0x86580903,
		0x81C, 0x855A0903,
		0x81C, 0x845C0903,
		0x81C, 0x835E0903,
		0x81C, 0x82600903,
		0x81C, 0x81620903,
		0x81C, 0x07640903,
		0x81C, 0x06660903,
		0x81C, 0x05680903,
		0x81C, 0x046A0903,
		0x81C, 0x036C0903,
		0x81C, 0x026E0903,
		0x81C, 0x01700903,
		0x81C, 0x01720903,
		0x81C, 0x01740903,
		0x81C, 0x01760903,
		0x81C, 0x01780903,
		0x81C, 0x017A0903,
		0x81C, 0x017C0903,
		0x81C, 0x017E0903,
	0xB0000000,	0x00000000,
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00000022,
		0xC50, 0x00000020,
	0xA0000000,	0x00000000,
		0xC50, 0x00000022,
		0xC50, 0x00000020,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8821c_agc_tab(
	struct	PHY_DM_STRUCT *p_dm_odm
)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len = sizeof(array_mp_8821c_agc_tab)/sizeof(u32);
	u32	*array = array_mp_8821c_agc_tab;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> odm_read_and_config_mp_8821c_agc_tab\n"));

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  = (u8)((v1 & (BIT(29)|BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped?false:true;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (is_skipped == false) {
					if (check_positive(p_dm_odm, pre_v1, pre_v2, v1, v2)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else
					is_matched = false;
			}
		} else {
			if (is_matched)
				odm_config_bb_agc_8821c(p_dm_odm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8821c_agc_tab(void)
{
		return 36;
}

/******************************************************************************
*                           agc_tab_diff.TXT
******************************************************************************/

u32 array_mp_8821c_agc_tab_diff_wlg[] = {
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFB000003,
		0x81C, 0xFA020003,
		0x81C, 0xF9040003,
		0x81C, 0xF8060003,
		0x81C, 0xF7080003,
		0x81C, 0xF60A0003,
		0x81C, 0xF50C0003,
		0x81C, 0xF40E0003,
		0x81C, 0xF3100003,
		0x81C, 0xF2120003,
		0x81C, 0xF1140003,
		0x81C, 0xF0160003,
		0x81C, 0xEF180003,
		0x81C, 0xEE1A0003,
		0x81C, 0xED1C0003,
		0x81C, 0xEC1E0003,
		0x81C, 0xEB200003,
		0x81C, 0xEA220003,
		0x81C, 0xE9240003,
		0x81C, 0xE8260003,
		0x81C, 0xE7280003,
		0x81C, 0xE62A0003,
		0x81C, 0xE52C0003,
		0x81C, 0xE42E0003,
		0x81C, 0xE3300003,
		0x81C, 0xE2320003,
		0x81C, 0xE1340003,
		0x81C, 0xC4360003,
		0x81C, 0xC3380003,
		0x81C, 0xC23A0003,
		0x81C, 0xC13C0003,
		0x81C, 0x883E0003,
		0x81C, 0x87400003,
		0x81C, 0x86420003,
		0x81C, 0x85440003,
		0x81C, 0x84460003,
		0x81C, 0x83480003,
		0x81C, 0x824A0003,
		0x81C, 0x814C0003,
		0x81C, 0x804E0003,
		0x81C, 0x64500003,
		0x81C, 0x63520003,
		0x81C, 0x62540003,
		0x81C, 0x61560003,
		0x81C, 0x60580003,
		0x81C, 0x475A0003,
		0x81C, 0x465C0003,
		0x81C, 0x455E0003,
		0x81C, 0x44600003,
		0x81C, 0x43620003,
		0x81C, 0x42640003,
		0x81C, 0x41660003,
		0x81C, 0x40680003,
		0x81C, 0x236A0003,
		0x81C, 0x226C0003,
		0x81C, 0x056E0003,
		0x81C, 0x04700003,
		0x81C, 0x03720003,
		0x81C, 0x02740003,
		0x81C, 0x01760003,
		0x81C, 0x01780003,
		0x81C, 0x017A0003,
		0x81C, 0x017C0003,
		0x81C, 0x017E0003,
		0x81C, 0xFF000803,
		0x81C, 0xFE020803,
		0x81C, 0xFD040803,
		0x81C, 0xFC060803,
		0x81C, 0xFB080803,
		0x81C, 0xFA0A0803,
		0x81C, 0xF90C0803,
		0x81C, 0xF80E0803,
		0x81C, 0xF7100803,
		0x81C, 0xF6120803,
		0x81C, 0xF5140803,
		0x81C, 0xF4160803,
		0x81C, 0xF3180803,
		0x81C, 0xF21A0803,
		0x81C, 0xF11C0803,
		0x81C, 0xF01E0803,
		0x81C, 0xB7200803,
		0x81C, 0xB6220803,
		0x81C, 0xB5240803,
		0x81C, 0xB4260803,
		0x81C, 0xB3280803,
		0x81C, 0xB22A0803,
		0x81C, 0xB12C0803,
		0x81C, 0xAF2E0803,
		0x81C, 0xAE300803,
		0x81C, 0xAD320803,
		0x81C, 0xAC340803,
		0x81C, 0xAB360803,
		0x81C, 0xAA380803,
		0x81C, 0xA93A0803,
		0x81C, 0xA83C0803,
		0x81C, 0xA73E0803,
		0x81C, 0x88400803,
		0x81C, 0x87420803,
		0x81C, 0x86440803,
		0x81C, 0x85460803,
		0x81C, 0x84480803,
		0x81C, 0x834A0803,
		0x81C, 0x674C0803,
		0x81C, 0x664E0803,
		0x81C, 0x65500803,
		0x81C, 0x64520803,
		0x81C, 0x63540803,
		0x81C, 0x62560803,
		0x81C, 0x61580803,
		0x81C, 0x455A0803,
		0x81C, 0x445C0803,
		0x81C, 0x435E0803,
		0x81C, 0x42600803,
		0x81C, 0x41620803,
		0x81C, 0x25640803,
		0x81C, 0x24660803,
		0x81C, 0x23680803,
		0x81C, 0x226A0803,
		0x81C, 0x216C0803,
		0x81C, 0x016E0803,
		0x81C, 0x01700803,
		0x81C, 0x01720803,
		0x81C, 0x01740803,
		0x81C, 0x01760803,
		0x81C, 0x01780803,
		0x81C, 0x017A0803,
		0x81C, 0x017C0803,
		0x81C, 0x017E0803,
	0xA0000000,	0x00000000,
		0x81C, 0xFB000003,
		0x81C, 0xFA020003,
		0x81C, 0xF9040003,
		0x81C, 0xF8060003,
		0x81C, 0xF7080003,
		0x81C, 0xF60A0003,
		0x81C, 0xF50C0003,
		0x81C, 0xF40E0003,
		0x81C, 0xF3100003,
		0x81C, 0xF2120003,
		0x81C, 0xF1140003,
		0x81C, 0xF0160003,
		0x81C, 0xEF180003,
		0x81C, 0xEE1A0003,
		0x81C, 0xED1C0003,
		0x81C, 0xEC1E0003,
		0x81C, 0xEB200003,
		0x81C, 0xEA220003,
		0x81C, 0xE9240003,
		0x81C, 0xE8260003,
		0x81C, 0xE7280003,
		0x81C, 0xE62A0003,
		0x81C, 0xCA2C0003,
		0x81C, 0xC92E0003,
		0x81C, 0xC8300003,
		0x81C, 0xC7320003,
		0x81C, 0xC6340003,
		0x81C, 0xC5360003,
		0x81C, 0xC4380003,
		0x81C, 0xC33A0003,
		0x81C, 0xC23C0003,
		0x81C, 0xC13E0003,
		0x81C, 0x88400003,
		0x81C, 0x87420003,
		0x81C, 0x86440003,
		0x81C, 0x85460003,
		0x81C, 0x84480003,
		0x81C, 0x834A0003,
		0x81C, 0x674C0003,
		0x81C, 0x664E0003,
		0x81C, 0x65500003,
		0x81C, 0x64520003,
		0x81C, 0x63540003,
		0x81C, 0x62560003,
		0x81C, 0x61580003,
		0x81C, 0x455A0003,
		0x81C, 0x445C0003,
		0x81C, 0x435E0003,
		0x81C, 0x42600003,
		0x81C, 0x41620003,
		0x81C, 0x25640003,
		0x81C, 0x24660003,
		0x81C, 0x23680003,
		0x81C, 0x226A0003,
		0x81C, 0x216C0003,
		0x81C, 0x016E0003,
		0x81C, 0x01700003,
		0x81C, 0x01720003,
		0x81C, 0x01740003,
		0x81C, 0x01760003,
		0x81C, 0x01780003,
		0x81C, 0x017A0003,
		0x81C, 0x017C0003,
		0x81C, 0x017E0003,
		0x81C, 0xFF000803,
		0x81C, 0xFE020803,
		0x81C, 0xFD040803,
		0x81C, 0xFC060803,
		0x81C, 0xFB080803,
		0x81C, 0xFA0A0803,
		0x81C, 0xF90C0803,
		0x81C, 0xF80E0803,
		0x81C, 0xF7100803,
		0x81C, 0xF6120803,
		0x81C, 0xF5140803,
		0x81C, 0xF4160803,
		0x81C, 0xF3180803,
		0x81C, 0xF21A0803,
		0x81C, 0xF11C0803,
		0x81C, 0xF01E0803,
		0x81C, 0xB7200803,
		0x81C, 0xB6220803,
		0x81C, 0xB5240803,
		0x81C, 0xB4260803,
		0x81C, 0xB3280803,
		0x81C, 0xB22A0803,
		0x81C, 0xB12C0803,
		0x81C, 0xAF2E0803,
		0x81C, 0xAE300803,
		0x81C, 0xAD320803,
		0x81C, 0xAC340803,
		0x81C, 0xAB360803,
		0x81C, 0xAA380803,
		0x81C, 0xA93A0803,
		0x81C, 0xA83C0803,
		0x81C, 0xA73E0803,
		0x81C, 0x88400803,
		0x81C, 0x87420803,
		0x81C, 0x86440803,
		0x81C, 0x85460803,
		0x81C, 0x84480803,
		0x81C, 0x834A0803,
		0x81C, 0x674C0803,
		0x81C, 0x664E0803,
		0x81C, 0x65500803,
		0x81C, 0x64520803,
		0x81C, 0x63540803,
		0x81C, 0x62560803,
		0x81C, 0x61580803,
		0x81C, 0x455A0803,
		0x81C, 0x445C0803,
		0x81C, 0x435E0803,
		0x81C, 0x42600803,
		0x81C, 0x41620803,
		0x81C, 0x25640803,
		0x81C, 0x24660803,
		0x81C, 0x23680803,
		0x81C, 0x226A0803,
		0x81C, 0x216C0803,
		0x81C, 0x016E0803,
		0x81C, 0x01700803,
		0x81C, 0x01720803,
		0x81C, 0x01740803,
		0x81C, 0x01760803,
		0x81C, 0x01780803,
		0x81C, 0x017A0803,
		0x81C, 0x017C0803,
		0x81C, 0x017E0803,
	0xB0000000,	0x00000000,
};

u32 array_mp_8821c_agc_tab_diff_btg[] = {
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000013,
		0x81C, 0xFE020013,
		0x81C, 0xFD040013,
		0x81C, 0xFC060013,
		0x81C, 0xFB080013,
		0x81C, 0xFA0A0013,
		0x81C, 0xF90C0013,
		0x81C, 0xF80E0013,
		0x81C, 0xF7100013,
		0x81C, 0xF6120013,
		0x81C, 0xF5140013,
		0x81C, 0xF4160013,
		0x81C, 0xF3180013,
		0x81C, 0xF21A0013,
		0x81C, 0xF11C0013,
		0x81C, 0xF01E0013,
		0x81C, 0xEF200013,
		0x81C, 0xEE220013,
		0x81C, 0xED240013,
		0x81C, 0xEC260013,
		0x81C, 0xEB280013,
		0x81C, 0xEA2A0013,
		0x81C, 0xE92C0013,
		0x81C, 0xE82E0013,
		0x81C, 0xE7300013,
		0x81C, 0x8B320013,
		0x81C, 0x8A340013,
		0x81C, 0x89360013,
		0x81C, 0x88380013,
		0x81C, 0x873A0013,
		0x81C, 0x863C0013,
		0x81C, 0x853E0013,
		0x81C, 0x84400013,
		0x81C, 0x83420013,
		0x81C, 0x82440013,
		0x81C, 0x81460013,
		0x81C, 0x08480013,
		0x81C, 0x074A0013,
		0x81C, 0x064C0013,
		0x81C, 0x054E0013,
		0x81C, 0x04500013,
		0x81C, 0x03520013,
		0x81C, 0x88540003,
		0x81C, 0x87560003,
		0x81C, 0x86580003,
		0x81C, 0x855A0003,
		0x81C, 0x845C0003,
		0x81C, 0x835E0003,
		0x81C, 0x82600003,
		0x81C, 0x81620003,
		0x81C, 0x07640003,
		0x81C, 0x06660003,
		0x81C, 0x05680003,
		0x81C, 0x046A0003,
		0x81C, 0x036C0003,
		0x81C, 0x026E0003,
		0x81C, 0x01700003,
		0x81C, 0x01720003,
		0x81C, 0x01740003,
		0x81C, 0x01760003,
		0x81C, 0x01780003,
		0x81C, 0x017A0003,
		0x81C, 0x017C0003,
		0x81C, 0x017E0003,
		0x81C, 0xFF000813,
		0x81C, 0xFE020813,
		0x81C, 0xFD040813,
		0x81C, 0xFC060813,
		0x81C, 0xFB080813,
		0x81C, 0xFA0A0813,
		0x81C, 0xF90C0813,
		0x81C, 0xF80E0813,
		0x81C, 0xF7100813,
		0x81C, 0xF6120813,
		0x81C, 0xF5140813,
		0x81C, 0xF4160813,
		0x81C, 0xF3180813,
		0x81C, 0xF21A0813,
		0x81C, 0xF11C0813,
		0x81C, 0x941E0813,
		0x81C, 0x93200813,
		0x81C, 0x92220813,
		0x81C, 0x91240813,
		0x81C, 0x90260813,
		0x81C, 0x8F280813,
		0x81C, 0x8E2A0813,
		0x81C, 0x8D2C0813,
		0x81C, 0x8C2E0813,
		0x81C, 0x8B300813,
		0x81C, 0x8A320813,
		0x81C, 0x89340813,
		0x81C, 0x88360813,
		0x81C, 0x87380813,
		0x81C, 0x863A0813,
		0x81C, 0x853C0813,
		0x81C, 0x843E0813,
		0x81C, 0x83400813,
		0x81C, 0x82420813,
		0x81C, 0x81440813,
		0x81C, 0x07460813,
		0x81C, 0x06480813,
		0x81C, 0x054A0813,
		0x81C, 0x044C0813,
		0x81C, 0x034E0813,
		0x81C, 0x02500813,
		0x81C, 0x01520813,
		0x81C, 0x88540803,
		0x81C, 0x87560803,
		0x81C, 0x86580803,
		0x81C, 0x855A0803,
		0x81C, 0x845C0803,
		0x81C, 0x835E0803,
		0x81C, 0x82600803,
		0x81C, 0x81620803,
		0x81C, 0x07640803,
		0x81C, 0x06660803,
		0x81C, 0x05680803,
		0x81C, 0x046A0803,
		0x81C, 0x036C0803,
		0x81C, 0x026E0803,
		0x81C, 0x01700803,
		0x81C, 0x01720803,
		0x81C, 0x01740803,
		0x81C, 0x01760803,
		0x81C, 0x01780803,
		0x81C, 0x017A0803,
		0x81C, 0x017C0803,
		0x81C, 0x017E0803,
	0xA0000000,	0x00000000,
		0x81C, 0xFF000013,
		0x81C, 0xFE020013,
		0x81C, 0xFD040013,
		0x81C, 0xFC060013,
		0x81C, 0xFB080013,
		0x81C, 0xFA0A0013,
		0x81C, 0xF90C0013,
		0x81C, 0xF80E0013,
		0x81C, 0xF7100013,
		0x81C, 0xF6120013,
		0x81C, 0xF5140013,
		0x81C, 0xF4160013,
		0x81C, 0xF3180013,
		0x81C, 0xF21A0013,
		0x81C, 0xF11C0013,
		0x81C, 0xF01E0013,
		0x81C, 0xEF200013,
		0x81C, 0xEE220013,
		0x81C, 0xED240013,
		0x81C, 0xEC260013,
		0x81C, 0xEB280013,
		0x81C, 0xEA2A0013,
		0x81C, 0xE92C0013,
		0x81C, 0xE82E0013,
		0x81C, 0xE7300013,
		0x81C, 0x8A320013,
		0x81C, 0x89340013,
		0x81C, 0x88360013,
		0x81C, 0x87380013,
		0x81C, 0x863A0013,
		0x81C, 0x853C0013,
		0x81C, 0x843E0013,
		0x81C, 0x83400013,
		0x81C, 0x82420013,
		0x81C, 0x81440013,
		0x81C, 0x07460013,
		0x81C, 0x06480013,
		0x81C, 0x054A0013,
		0x81C, 0x044C0013,
		0x81C, 0x034E0013,
		0x81C, 0x02500013,
		0x81C, 0x01520013,
		0x81C, 0x88540003,
		0x81C, 0x87560003,
		0x81C, 0x86580003,
		0x81C, 0x855A0003,
		0x81C, 0x845C0003,
		0x81C, 0x835E0003,
		0x81C, 0x82600003,
		0x81C, 0x81620003,
		0x81C, 0x07640003,
		0x81C, 0x06660003,
		0x81C, 0x05680003,
		0x81C, 0x046A0003,
		0x81C, 0x036C0003,
		0x81C, 0x026E0003,
		0x81C, 0x01700003,
		0x81C, 0x01720003,
		0x81C, 0x01740003,
		0x81C, 0x01760003,
		0x81C, 0x01780003,
		0x81C, 0x017A0003,
		0x81C, 0x017C0003,
		0x81C, 0x017E0003,
		0x81C, 0xFF000813,
		0x81C, 0xFE020813,
		0x81C, 0xFD040813,
		0x81C, 0xFC060813,
		0x81C, 0xFB080813,
		0x81C, 0xFA0A0813,
		0x81C, 0xF90C0813,
		0x81C, 0xF80E0813,
		0x81C, 0xF7100813,
		0x81C, 0xF6120813,
		0x81C, 0xF5140813,
		0x81C, 0xF4160813,
		0x81C, 0xF3180813,
		0x81C, 0xF21A0813,
		0x81C, 0xF11C0813,
		0x81C, 0x961E0813,
		0x81C, 0x95200813,
		0x81C, 0x94220813,
		0x81C, 0x93240813,
		0x81C, 0x92260813,
		0x81C, 0x91280813,
		0x81C, 0x8F2A0813,
		0x81C, 0x8E2C0813,
		0x81C, 0x8D2E0813,
		0x81C, 0x8C300813,
		0x81C, 0x8B320813,
		0x81C, 0x8A340813,
		0x81C, 0x89360813,
		0x81C, 0x88380813,
		0x81C, 0x873A0813,
		0x81C, 0x863C0813,
		0x81C, 0x853E0813,
		0x81C, 0x84400813,
		0x81C, 0x83420813,
		0x81C, 0x82440813,
		0x81C, 0x08460813,
		0x81C, 0x07480813,
		0x81C, 0x064A0813,
		0x81C, 0x054C0813,
		0x81C, 0x044E0813,
		0x81C, 0x03500813,
		0x81C, 0x02520813,
		0x81C, 0x89540803,
		0x81C, 0x88560803,
		0x81C, 0x87580803,
		0x81C, 0x865A0803,
		0x81C, 0x855C0803,
		0x81C, 0x845E0803,
		0x81C, 0x83600803,
		0x81C, 0x82620803,
		0x81C, 0x07640803,
		0x81C, 0x06660803,
		0x81C, 0x05680803,
		0x81C, 0x046A0803,
		0x81C, 0x036C0803,
		0x81C, 0x026E0803,
		0x81C, 0x01700803,
		0x81C, 0x01720803,
		0x81C, 0x01740803,
		0x81C, 0x01760803,
		0x81C, 0x01780803,
		0x81C, 0x017A0803,
		0x81C, 0x017C0803,
		0x81C, 0x017E0803,
	0xB0000000,	0x00000000,
};

void
odm_read_and_config_mp_8821c_agc_tab_diff(
	struct PHY_DM_STRUCT *p_dm_odm,
	u32	array[],
	u32	array_len
)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> odm_read_and_config_mp_8821c_agc_tab_diff\n"));

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  = (u8)((v1 & (BIT(29)|BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped?false:true;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (is_skipped == false) {
					if (check_positive(p_dm_odm, pre_v1, pre_v2, v1, v2)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else
					is_matched = false;
			}
		} else {
			if (is_matched)
				odm_config_bb_agc_8821c(p_dm_odm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8821c_agc_tab_diff(void)
{
		return 36;
}

/******************************************************************************
*                           phy_reg.TXT
******************************************************************************/

u32 array_mp_8821c_phy_reg[] = {
		0x800, 0x9020D010,
		0x804, 0x80018180,
		0x808, 0x04028211,
		0x80C, 0x13D10011,
		0x810, 0x21104255,
		0x814, 0x020C3D10,
		0x818, 0x84A10385,
		0x81C, 0x1E1E081F,
		0x820, 0x0001AAAA,
		0x824, 0x00030FE0,
		0x828, 0x0000CCCC,
		0x82C, 0x75CB7010,
		0x830, 0x79A0EA2A,
		0x834, 0x072E698A,
		0x838, 0x87766461,
		0x83C, 0x9194B2B6,
		0x840, 0x171740E0,
		0x844, 0x4D3D7CDB,
		0x848, 0x4AD0408B,
		0x84C, 0x6AFBF7A5,
		0x850, 0x28A74706,
		0x854, 0x0001520C,
		0x858, 0x4060C000,
		0x85C, 0x74010160,
		0x860, 0x68A7C321,
		0x864, 0x79F27432,
		0x868, 0x8CA7A314,
		0x86C, 0x558C2878,
		0x870, 0x55555555,
		0x874, 0x27612C2E,
		0x878, 0xC0003152,
		0x87C, 0x5C8FC000,
		0x880, 0x00000000,
		0x884, 0x00000000,
		0x888, 0x00000000,
		0x88C, 0x00000000,
		0x890, 0x00000000,
		0x894, 0x00000000,
		0x898, 0x00000000,
		0x89C, 0x00000000,
		0x8A0, 0x00000013,
		0x8A4, 0x7F7F7F7F,
		0x8A8, 0x2202033E,
		0x8AC, 0xF00F000A,
		0x8B0, 0x00000600,
		0x8B4, 0x000FC080,
		0x8B8, 0xEC0057FF,
		0x8BC, 0xACB520A3,
		0x8C0, 0xFFE04020,
		0x8C4, 0x47C00000,
		0x8C8, 0x00025165,
		0x8CC, 0x08108492,
		0x8D0, 0x0000B800,
		0x8D4, 0x860308A0,
		0x8D8, 0x290B5612,
		0x8DC, 0x00000000,
		0x8E0, 0x32D16777,
		0x8E4, 0x49092925,
		0x8E8, 0xFFFFC42C,
		0x8EC, 0x99999999,
		0x8F0, 0x00009999,
		0x8F4, 0x00D80FA1,
		0x8F8, 0x400000C0,
		0x8FC, 0x00000130,
		0x900, 0x00C00000,
		0x904, 0x0FFF0FFF,
		0x908, 0x00000000,
		0x90C, 0x13000000,
		0x910, 0x0000FC00,
		0x914, 0xC6380000,
		0x918, 0x1C1028C0,
		0x91C, 0x64B11A1C,
		0x920, 0xE0767233,
		0x924, 0x855A2500,
		0x928, 0x4AB0E4E4,
		0x92C, 0xFFFEB200,
		0x930, 0xFFFFFFFE,
		0x934, 0x001FFFFF,
		0x938, 0x00008480,
		0x93C, 0xE41C0642,
		0x940, 0x0E470430,
		0x944, 0x00000000,
		0x948, 0xAC000000,
		0x94C, 0x10000083,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0xB2010080,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0x950, 0xB2010080,
	0xA0000000,	0x00000000,
		0x950, 0xF2010080,
	0xB0000000,	0x00000000,
		0x954, 0x86510080,
		0x958, 0x00000181,
		0x95C, 0x04248000,
		0x960, 0x00000000,
		0x964, 0x00000000,
		0x968, 0x00000000,
		0x96C, 0x00000000,
		0x970, 0x00001FFF,
		0x974, 0x04000FFF,
		0x978, 0x00000000,
		0x97C, 0x00000000,
		0x980, 0x00000000,
		0x984, 0x00000000,
		0x988, 0x00000000,
		0x98C, 0x23440000,
		0x990, 0x27100000,
		0x994, 0xFFFF0100,
		0x998, 0xFFFFFF5C,
		0x99C, 0xFFFFFFFF,
		0x9A0, 0x000000FF,
		0x9A4, 0x80000088,
		0x9A8, 0x0C2F0000,
		0x9AC, 0x01560000,
		0x9B0, 0x70000000,
		0x9B4, 0x00000000,
		0x9B8, 0x00000000,
		0x9BC, 0x00000000,
		0x9C0, 0x00000000,
		0x9C4, 0x00000000,
		0x9C8, 0x00000000,
		0x9CC, 0x00000000,
		0x9D0, 0x00000000,
		0x9D4, 0x00000000,
		0x9D8, 0x00000000,
		0x9DC, 0x00000000,
		0x9E0, 0x00000000,
		0x9E4, 0x02000402,
		0x9E8, 0x000022D4,
		0x9EC, 0x00000000,
		0x9F0, 0x00000000,
		0x9F4, 0x00000000,
		0x9F8, 0x00000000,
		0x9FC, 0xEFFFF7FF,
		0xA00, 0x00D040C8,
		0xA04, 0x80FF800C,
		0xA08, 0x9C838300,
		0xA0C, 0x2E20200F,
		0xA10, 0x9500BB78,
		0xA14, 0x1114D028,
		0xA18, 0x00881117,
		0xA1C, 0x89140F00,
		0xA20, 0xE82C0000,
		0xA24, 0x64B80C1C,
		0xA28, 0x00008810,
		0xA2C, 0x00D20000,
		0xA70, 0x101FBF00,
		0xA74, 0x00000107,
		0xA78, 0x00008900,
		0xA7C, 0x225B0606,
		0xA80, 0x21807532,
		0xA84, 0x80200000,
		0xA88, 0x048C0000,
		0xA8C, 0x12345678,
		0xA90, 0xABCDEF00,
		0xA94, 0x001B1B89,
		0xA98, 0x00000000,
		0xA9C, 0x00060000,
		0xAA0, 0x00000000,
		0xAA4, 0x00080000,
		0xAA8, 0xEACF0004,
		0xAAC, 0x01235667,
		0xAB0, 0x00000000,
		0xB00, 0xE1000440,
		0xB04, 0x00800000,
		0xB08, 0xFF02030B,
		0xB0C, 0x01EAA406,
		0xB10, 0x00030690,
		0xB14, 0x006000FA,
		0xB18, 0x00000002,
		0xB1C, 0x00000002,
		0xB20, 0x4B00001F,
		0xB24, 0x4E8E3E40,
		0xB28, 0x03020100,
		0xB2C, 0x07060504,
		0xB30, 0x0B0A0908,
		0xB34, 0x0F0E0D0C,
		0xB38, 0x13121110,
		0xB3C, 0x0000003A,
		0xB40, 0x00000000,
		0xB44, 0x80000000,
		0xB48, 0x3F0000FA,
		0xB4C, 0x88C80020,
		0xB50, 0x00000000,
		0xB54, 0x00004241,
		0xB58, 0xE0008208,
		0xB5C, 0x41EFFFF9,
		0xB60, 0x00000000,
		0xB64, 0x00200063,
		0xB68, 0x0000003A,
		0xB6C, 0x00000102,
		0xB70, 0x4E6D1870,
		0xB74, 0x03020100,
		0xB78, 0x07060504,
		0xB7C, 0x0B0A0908,
		0xB80, 0x0F0E0D0C,
		0xB84, 0x13121110,
		0xB88, 0x00000000,
		0xB8C, 0x00000000,
		0xC00, 0x00000007,
	0x81001000,	0x00000000,	0x40000000,	0x00000000,
		0xC04, 0x03010020,
	0x91000000,	0x00000000,	0x40000000,	0x00000000,
		0xC04, 0x03010020,
	0xA0000000,	0x00000000,
		0xC04, 0x03000020,
	0xB0000000,	0x00000000,
		0xC08, 0x60403231,
		0xC0C, 0x00012345,
		0xC10, 0x00000100,
		0xC14, 0x01000000,
		0xC18, 0x00000000,
		0xC1C, 0x40040053,
		0xC20, 0x400503A3,
		0xC24, 0x00000000,
		0xC28, 0x00000000,
		0xC2C, 0x00000000,
		0xC30, 0x00000000,
		0xC34, 0x00000000,
		0xC38, 0x00000000,
		0xC3C, 0x00000000,
		0xC40, 0x00000000,
		0xC44, 0x00000000,
		0xC48, 0x00000000,
		0xC4C, 0x00000000,
		0xC50, 0x00000020,
		0xC54, 0x00000000,
		0xC58, 0xD8020402,
		0xC5C, 0xDE000120,
		0xC68, 0x00000079,
		0xC6C, 0x0000122A,
		0xC70, 0x00000000,
		0xC74, 0x00000000,
		0xC78, 0x00000000,
		0xC7C, 0x00000000,
		0xC80, 0x00000000,
		0xC84, 0x00000000,
		0xC88, 0x00000000,
		0xC8C, 0x07000000,
		0xC94, 0x01000100,
		0xC98, 0x201C8000,
		0xC9C, 0x00000000,
		0xCA0, 0x0000A555,
		0xCA4, 0x08040201,
		0xCA8, 0x80402010,
		0xCAC, 0x00000000,
		0xCB0, 0x77775747,
		0xCB4, 0x10000077,
		0xCB8, 0x00000000,
		0xCBC, 0x00000000,
		0xCC0, 0x00000000,
		0xCC4, 0x00000000,
		0xCC8, 0x00000000,
		0xCCC, 0x00000000,
		0xCD0, 0x00000000,
		0xCD4, 0x00000000,
		0xCD8, 0x00000000,
		0xCDC, 0x00000000,
		0xCE0, 0x00000000,
		0xCE4, 0x00000000,
		0xCE8, 0x00000000,
		0xCEC, 0x00000000,
		0xE00, 0x00000007,
		0xE04, 0x00000020,
		0xE08, 0x60403231,
		0xE0C, 0x00012345,
		0xE10, 0x00000100,
		0xE14, 0x01000000,
		0xE18, 0x00000000,
		0xE1C, 0x40040053,
		0xE20, 0x00020103,
		0xE24, 0x00000000,
		0xE28, 0x00000000,
		0xE2C, 0x00000000,
		0xE30, 0x00000000,
		0xE34, 0x00000000,
		0xE38, 0x00000000,
		0xE3C, 0x00000000,
		0xE40, 0x00000000,
		0xE44, 0x00000000,
		0xE48, 0x00000000,
		0xE4C, 0x00000000,
		0xE50, 0x00000020,
		0xE54, 0x00000000,
		0xE58, 0xD8020402,
		0xE5C, 0xDE000120,
		0xE68, 0x59799979,
		0xE6C, 0x0000122A,
		0xE70, 0x99795979,
		0xE74, 0x99795979,
		0xE78, 0x99799979,
		0xE7C, 0x99791979,
		0xE80, 0x19791979,
		0xE84, 0x19791979,
		0xE88, 0x00000000,
		0xE8C, 0x07000000,
		0xE94, 0x01000100,
		0xE98, 0x201C8000,
		0xE9C, 0x00000000,
		0xEA0, 0x0000A555,
		0xEA4, 0x08040201,
		0xEA8, 0x80402010,
		0xEAC, 0x00000000,
		0xEB0, 0x98543210,
		0xEB4, 0x000000BA,
		0xEB8, 0x00000000,
		0xEBC, 0x00000000,
		0xEC0, 0x00000000,
		0xEC4, 0x00000000,
		0xEC8, 0x00000000,
		0xECC, 0x00000000,
		0xED0, 0x00000000,
		0xED4, 0x00000000,
		0xED8, 0x00000000,
		0xEDC, 0x00000000,
		0xEE0, 0x00000000,
		0xEE4, 0x00000000,
		0xEE8, 0x00000000,
		0xEEC, 0x00000000,
		0x1900, 0x00000000,
		0x1904, 0x00238000,
		0x1908, 0x00000000,
		0x190C, 0x00000000,
		0x1910, 0x00001800,
		0x1914, 0x00000000,
		0x1918, 0x00000000,
		0x191C, 0x00000000,
		0x1920, 0x00000000,
		0x1924, 0x00000000,
		0x1928, 0x00000000,
		0x192C, 0x00000000,
		0x1930, 0x00000000,
		0x1934, 0x00000000,
		0x1938, 0x00000000,
		0x193C, 0x00000000,
		0x1940, 0x00000000,
		0x1944, 0x00000000,
		0x1948, 0x00000000,
		0x194C, 0x00000000,
		0x1950, 0x00000000,
		0x1954, 0x00000000,
		0x1958, 0x00000000,
		0x195C, 0x00000000,
		0x1960, 0x00000000,
		0x1964, 0x00000000,
		0x1968, 0x00000000,
		0x196C, 0x00000000,
		0x1970, 0x00000000,
		0x1974, 0x00000000,
		0x1978, 0x00000000,
		0x197C, 0x00000000,
		0x1980, 0x00000000,
		0x1984, 0x03000000,
		0x1988, 0x21401E88,
		0x198C, 0x00004000,
		0x1990, 0x00000000,
		0x1994, 0x00000000,
		0x1998, 0x00000053,
		0x199C, 0x00000000,
		0x19A0, 0x00000000,
		0x19A4, 0x00000000,
		0x19A8, 0x010A0000,
		0x19AC, 0x0E47E47F,
		0x19B0, 0x00000000,
		0x19B4, 0x0E47E47F,
		0x19B8, 0x00000000,
		0x19BC, 0x00000000,
		0x19C0, 0x00000000,
		0x19C4, 0x00000000,
		0x19C8, 0x00000000,
		0x19CC, 0x00000000,
		0x19D0, 0x00000000,
		0x19D4, 0x77777777,
		0x19D8, 0x00000777,
		0x19DC, 0x133E0F37,
		0x19E0, 0x00000000,
		0x19E4, 0x00000000,
		0x19E8, 0x00000000,
		0x19EC, 0x00000000,
		0x19F0, 0x00000000,
		0x19F4, 0x00000000,
		0x19F8, 0x01A00000,
		0x19FC, 0x00000000,
		0x1C00, 0x00000100,
		0x1C04, 0x01000000,
		0x1C08, 0x00000100,
		0x1C0C, 0x01000000,
		0x1C10, 0x00000100,
		0x1C14, 0x01000000,
		0x1C18, 0x00000100,
		0x1C1C, 0x01000000,
		0x1C20, 0x00000100,
		0x1C24, 0x01000000,
		0x1C28, 0x00000100,
		0x1C2C, 0x01000000,
		0x1C30, 0x00000100,
		0x1C34, 0x01000000,
		0x1C38, 0x00000000,
		0x1C3C, 0x00000000,
		0x1C40, 0x000C0100,
		0x1C44, 0x000000F3,
		0x1C48, 0x1A8249A8,
		0x1C4C, 0x1461C826,
		0x1C50, 0x0001469E,
		0x1C54, 0x58D158D1,
		0x1C58, 0x04490088,
		0x1C5C, 0x04004400,
		0x1C60, 0x00000000,
		0x1C64, 0x04004400,
		0x1C68, 0x0B7B7B75,
		0x1C6C, 0x01000000,
		0x1C70, 0x00A08145,
		0x1C74, 0x2080E0E0,
		0x1C78, 0x00000000,
		0x1C7C, 0x00000010,
		0x1C80, 0x00000100,
		0x1C84, 0x01000000,
		0x1C88, 0x00000100,
		0x1C8C, 0x01000000,
		0x1C90, 0x00000100,
		0x1C94, 0x01000000,
		0x1C98, 0x00000100,
		0x1C9C, 0x01000000,
		0x1CA0, 0x00000100,
		0x1CA4, 0x01000000,
		0x1CA8, 0x00000100,
		0x1CAC, 0x01000000,
		0x1CB0, 0x00000100,
		0x1CB4, 0x01000000,
		0x1CB8, 0x00000000,
		0x1CBC, 0x00000000,
		0x1CC0, 0x201B0100,
		0x1CC4, 0x00308000,
		0x1CC8, 0x5B74B6E9,
		0x1CCC, 0x01000000,
		0x1CD0, 0x00000400,
		0x1CD4, 0x01000000,
		0x1CD8, 0x01B8ADEB,
		0x1CDC, 0x01000000,
		0x1CE0, 0x00030003,
		0x1CE4, 0x4E4A0306,
		0x1CE8, 0x00000100,
		0x1CEC, 0x01000000,
		0x1CF0, 0x00000100,
		0x1CF4, 0x01000000,
		0x1CF8, 0x01B8ADEB,
		0x1CFC, 0x00000000,
		0xC60, 0x700B8040,
		0xC60, 0x700B8040,
		0xC60, 0x70146040,
		0xC60, 0x70246040,
		0xC60, 0x70346040,
		0xC60, 0x70446040,
		0xC60, 0x705B2040,
		0xC60, 0x70646040,
		0xC60, 0x707B8040,
		0xC60, 0x708B8040,
		0xC60, 0x709B8040,
		0xC60, 0x70AB8040,
		0xC60, 0x70BB6040,
		0xC60, 0x70C06040,
		0xC60, 0x70D06040,
		0xC60, 0x70EF6040,
		0xC60, 0x70F06040,
		0xE60, 0x700B8040,
		0xE60, 0x700B8040,
		0xE60, 0x70146040,
		0xE60, 0x70246040,
		0xE60, 0x70346040,
		0xE60, 0x70446040,
		0xE60, 0x705B2040,
		0xE60, 0x70646040,
		0xE60, 0x707B8040,
		0xE60, 0x708B8040,
		0xE60, 0x709B8040,
		0xE60, 0x70AB8040,
		0xE60, 0x70BB6040,
		0xE60, 0x70C06040,
		0xE60, 0x70D06040,
		0xE60, 0x70EF6040,
		0xE60, 0x70F06040,
		0xC64, 0x00800000,
		0xC64, 0x08800001,
		0xC64, 0x00800002,
		0xC64, 0x00800003,
		0xC64, 0x00800004,
		0xC64, 0x00800005,
		0xC64, 0x00800006,
		0xC64, 0x08800007,
		0xC64, 0x00004000,
		0xE64, 0x00800000,
		0xE64, 0x08800001,
		0xE64, 0x00800002,
		0xE64, 0x00800003,
		0xE64, 0x00800004,
		0xE64, 0x00800005,
		0xE64, 0x00800006,
		0xE64, 0x08800007,
		0xE64, 0x00004000,
		0x1B00, 0xF8000008,
		0x1B00, 0xF80A7008,
		0x1B00, 0xF8015008,
		0x1B00, 0xF8000008,
		0x1B04, 0xE24629D2,
		0x1B08, 0x00000080,
		0x1B0C, 0x00000000,
		0x1B10, 0x00011C00,
		0x1B14, 0x00000000,
		0x1B18, 0x00292903,
		0x1B1C, 0xA2193C32,
		0x1B20, 0x01840008,
		0x1B24, 0x01860008,
		0x1B28, 0x80060300,
		0x1B2C, 0x00000003,
		0x1B30, 0x20000000,
		0x1B34, 0x00000800,
		0x1B3C, 0x20000000,
		0x1BC0, 0x01000000,
		0x1BCC, 0x00000000,
		0x1B90, 0x0001E018,
		0x1B94, 0xF76D9F84,
		0x1BC8, 0x000C44AA,
		0x1BCC, 0x11978200,
		0x1B8C, 0x00002000,
		0x1B9C, 0x5B554F48,
		0x1BA0, 0x6F6B6661,
		0x1BA4, 0x817D7874,
		0x1BA8, 0x908C8884,
		0x1BAC, 0x9D9A9793,
		0x1BB0, 0xAAA7A4A1,
		0x1BB4, 0xB6B3B0AD,
		0x1B40, 0x02CE03E8,
		0x1B44, 0x01FD024C,
		0x1B48, 0x01A101C9,
		0x1B4C, 0x016A0183,
		0x1B50, 0x01430153,
		0x1B54, 0x01280134,
		0x1B58, 0x0112011C,
		0x1B5C, 0x01000107,
		0x1B60, 0x00F200F9,
		0x1B64, 0x00E500EB,
		0x1B68, 0x00DA00E0,
		0x1B6C, 0x00D200D6,
		0x1B70, 0x00C900CD,
		0x1B74, 0x00C200C5,
		0x1B78, 0x00BB00BE,
		0x1B7C, 0x00B500B8,
		0x1BB8, 0x000FFFFF,
		0x1BBC, 0x00000000,
		0x1BDC, 0x40CAFFE1,
		0x1BDC, 0x4080A1E3,
		0x1BDC, 0x405165E5,
		0x1BDC, 0x403340E7,
		0x1BDC, 0x402028E9,
		0x1BDC, 0x401419EB,
		0x1BDC, 0x400D10ED,
		0x1BDC, 0x40080AEF,
		0x1BDC, 0x400506F1,
		0x1BDC, 0x400304F3,
		0x1BDC, 0x400203F5,
		0x1BDC, 0x400102F7,
		0x1BDC, 0x400101F9,
		0x1BDC, 0x400101FB,
		0x1BDC, 0x400101FD,
		0x1BDC, 0x400101FF,
		0x1BDC, 0x00000000,
		0x1BDC, 0xD0000001,
		0x1BDC, 0xD0000003,
		0x1BDC, 0xD0000005,
		0x1BDC, 0xD0000007,
		0x1BDC, 0xD0000009,
		0x1BDC, 0xD000000B,
		0x1BDC, 0xD000000D,
		0x1BDC, 0xD000000F,
		0x1BDC, 0xD0000011,
		0x1BDC, 0xD0000013,
		0x1BDC, 0xD0000015,
		0x1BDC, 0xD0000017,
		0x1BDC, 0xD0000019,
		0x1BDC, 0xD000001B,
		0x1BDC, 0xD000001D,
		0x1BDC, 0xD000001F,
		0x1BDC, 0xD0000021,
		0x1BDC, 0xD0000023,
		0x1BDC, 0xD0000025,
		0x1BDC, 0xD0000027,
		0x1BDC, 0xD0000029,
		0x1BDC, 0xD000002B,
		0x1BDC, 0xD000002D,
		0x1BDC, 0xD000002F,
		0x1BDC, 0xD0000031,
		0x1BDC, 0xD0000033,
		0x1BDC, 0xD0000035,
		0x1BDC, 0xD0000037,
		0x1BDC, 0xD0000039,
		0x1BDC, 0xD000003B,
		0x1BDC, 0xD000003D,
		0x1BDC, 0xD000003F,
		0x1BDC, 0xD0000041,
		0x1BDC, 0xD0000043,
		0x1BDC, 0xD0000045,
		0x1BDC, 0xD0000047,
		0x1BDC, 0xD0000049,
		0x1BDC, 0xD000004B,
		0x1BDC, 0xD000004D,
		0x1BDC, 0xD000004F,
		0x1BDC, 0xD0000051,
		0x1BDC, 0xD0000053,
		0x1BDC, 0xD0000055,
		0x1BDC, 0xD0000057,
		0x1BDC, 0xD0000059,
		0x1BDC, 0xD000005B,
		0x1BDC, 0xD000005D,
		0x1BDC, 0xD000005F,
		0x1BDC, 0xD0000061,
		0x1BDC, 0xD0000063,
		0x1BDC, 0xD0000065,
		0x1BDC, 0xD0000067,
		0x1BDC, 0xD0000069,
		0x1BDC, 0xD000006B,
		0x1BDC, 0xD000006D,
		0x1BDC, 0xD000006F,
		0x1BDC, 0xD0000071,
		0x1BDC, 0xD0000073,
		0x1BDC, 0xD0000075,
		0x1BDC, 0xD0000077,
		0x1BDC, 0xD0000079,
		0x1BDC, 0xD000007B,
		0x1BDC, 0xD000007D,
		0x1BDC, 0xD000007F,
		0x1BDC, 0x90000081,
		0x1BDC, 0x90000083,
		0x1BDC, 0x90000085,
		0x1BDC, 0x90000087,
		0x1BDC, 0x90000089,
		0x1BDC, 0x9000008B,
		0x1BDC, 0x9000008D,
		0x1BDC, 0x9000008F,
		0x1BDC, 0x90000091,
		0x1BDC, 0x90000093,
		0x1BDC, 0x90000095,
		0x1BDC, 0x90000097,
		0x1BDC, 0x90000099,
		0x1BDC, 0x9000009B,
		0x1BDC, 0x9000009D,
		0x1BDC, 0x9000009F,
		0x1BDC, 0x900000A1,
		0x1BDC, 0x900000A3,
		0x1BDC, 0x900000A5,
		0x1BDC, 0x900000A7,
		0x1BDC, 0x900000A9,
		0x1BDC, 0x900000AB,
		0x1BDC, 0x900000AD,
		0x1BDC, 0x900000AF,
		0x1BDC, 0x900000B1,
		0x1BDC, 0x900000B3,
		0x1BDC, 0x900000B5,
		0x1BDC, 0x900000B7,
		0x1BDC, 0x900000B9,
		0x1BDC, 0x900000BB,
		0x1BDC, 0x900000BD,
		0x1BDC, 0x900000BF,
		0x1BDC, 0x900000C1,
		0x1BDC, 0x900000C3,
		0x1BDC, 0x900000C5,
		0x1BDC, 0x900000C7,
		0x1BDC, 0x900000C9,
		0x1BDC, 0x900000CB,
		0x1BDC, 0x900000CD,
		0x1BDC, 0x900000CF,
		0x1BDC, 0x900000D1,
		0x1BDC, 0x900000D3,
		0x1BDC, 0x900000D5,
		0x1BDC, 0x900000D7,
		0x1BDC, 0x900000D9,
		0x1BDC, 0x900000DB,
		0x1BDC, 0x900000DD,
		0x1BDC, 0x900000DF,
		0x1BDC, 0x900000E1,
		0x1BDC, 0x900000E3,
		0x1BDC, 0x900000E5,
		0x1BDC, 0x900000E7,
		0x1BDC, 0x900000E9,
		0x1BDC, 0x900000EB,
		0x1BDC, 0x900000ED,
		0x1BDC, 0x900000EF,
		0x1BDC, 0x900000F1,
		0x1BDC, 0x900000F3,
		0x1BDC, 0x900000F5,
		0x1BDC, 0x900000F7,
		0x1BDC, 0x900000F9,
		0x1BDC, 0x900000FB,
		0x1BDC, 0x900000FD,
		0x1BDC, 0x900000FF,
		0x1BDC, 0x00000000,
		0x1B00, 0xF800000A,
		0x1B1C, 0xA2193C32,
		0x1B20, 0x01840008,
		0x1B24, 0x01860008,
		0x1B28, 0x80060300,
		0x1B2C, 0x00000003,
		0x1B30, 0x20000000,
		0x1B34, 0x00000800,
		0x1B3C, 0x20000000,
		0x1BC0, 0x01000000,
		0x1BCC, 0x00000000,
		0x1B00, 0xF8000008,
		0x1B80, 0x00000007,
		0x1B80, 0x090A0005,
		0x1B80, 0x090A0007,
		0x1B80, 0x0FFE0015,
		0x1B80, 0x0FFE0017,
		0x1B80, 0x00220025,
		0x1B80, 0x00220027,
		0x1B80, 0x00040035,
		0x1B80, 0x00040037,
		0x1B80, 0x05C00045,
		0x1B80, 0x05C00047,
		0x1B80, 0x00070055,
		0x1B80, 0x00070057,
		0x1B80, 0x64000065,
		0x1B80, 0x64000067,
		0x1B80, 0x00020075,
		0x1B80, 0x00020077,
		0x1B80, 0x00080085,
		0x1B80, 0x00080087,
		0x1B80, 0x80000095,
		0x1B80, 0x80000097,
		0x1B80, 0x090800A5,
		0x1B80, 0x090800A7,
		0x1B80, 0x0F0200B5,
		0x1B80, 0x0F0200B7,
		0x1B80, 0x002200C5,
		0x1B80, 0x002200C7,
		0x1B80, 0x000400D5,
		0x1B80, 0x000400D7,
		0x1B80, 0x05C000E5,
		0x1B80, 0x05C000E7,
		0x1B80, 0x48C000F5,
		0x1B80, 0x48C000F7,
		0x1B80, 0x00060105,
		0x1B80, 0x00060107,
		0x1B80, 0x510A0115,
		0x1B80, 0x510A0117,
		0x1B80, 0x00070125,
		0x1B80, 0x00070127,
		0x1B80, 0x64020135,
		0x1B80, 0x64020137,
		0x1B80, 0x56000145,
		0x1B80, 0x56000147,
		0x1B80, 0x00020155,
		0x1B80, 0x00020157,
		0x1B80, 0x00040165,
		0x1B80, 0x00040167,
		0x1B80, 0x4A000175,
		0x1B80, 0x4A000177,
		0x1B80, 0x4B040185,
		0x1B80, 0x4B040187,
		0x1B80, 0x85030195,
		0x1B80, 0x85030197,
		0x1B80, 0x400901A5,
		0x1B80, 0x400901A7,
		0x1B80, 0xE02D01B5,
		0x1B80, 0xE02D01B7,
		0x1B80, 0x4B0501C5,
		0x1B80, 0x4B0501C7,
		0x1B80, 0x860301D5,
		0x1B80, 0x860301D7,
		0x1B80, 0x400B01E5,
		0x1B80, 0x400B01E7,
		0x1B80, 0xE02D01F5,
		0x1B80, 0xE02D01F7,
		0x1B80, 0x4B000205,
		0x1B80, 0x4B000207,
		0x1B80, 0x00070215,
		0x1B80, 0x00070217,
		0x1B80, 0x4C000225,
		0x1B80, 0x4C000227,
		0x1B80, 0x09090235,
		0x1B80, 0x09090237,
		0x1B80, 0x0F020245,
		0x1B80, 0x0F020247,
		0x1B80, 0x00220255,
		0x1B80, 0x00220257,
		0x1B80, 0x00040265,
		0x1B80, 0x00040267,
		0x1B80, 0x05C00275,
		0x1B80, 0x05C00277,
		0x1B80, 0x00070285,
		0x1B80, 0x00070287,
		0x1B80, 0x4B000295,
		0x1B80, 0x4B000297,
		0x1B80, 0x000202A5,
		0x1B80, 0x000202A7,
		0x1B80, 0x000402B5,
		0x1B80, 0x000402B7,
		0x1B80, 0x300002C5,
		0x1B80, 0x300002C7,
		0x1B80, 0xE1D402D5,
		0x1B80, 0xE1D402D7,
		0x1B80, 0xF01002E5,
		0x1B80, 0xF01002E7,
		0x1B80, 0xF11002F5,
		0x1B80, 0xF11002F7,
		0x1B80, 0xF2100305,
		0x1B80, 0xF2100307,
		0x1B80, 0xF3100315,
		0x1B80, 0xF3100317,
		0x1B80, 0xF4100325,
		0x1B80, 0xF4100327,
		0x1B80, 0xF5100335,
		0x1B80, 0xF5100337,
		0x1B80, 0xF6100345,
		0x1B80, 0xF6100347,
		0x1B80, 0xF7100355,
		0x1B80, 0xF7100357,
		0x1B80, 0xF8100365,
		0x1B80, 0xF8100367,
		0x1B80, 0xF9100375,
		0x1B80, 0xF9100377,
		0x1B80, 0xFA100385,
		0x1B80, 0xFA100387,
		0x1B80, 0xFB100395,
		0x1B80, 0xFB100397,
		0x1B80, 0xFD1003A5,
		0x1B80, 0xFD1003A7,
		0x1B80, 0xFE1003B5,
		0x1B80, 0xFE1003B7,
		0x1B80, 0xFF1003C5,
		0x1B80, 0xFF1003C7,
		0x1B80, 0x000103D5,
		0x1B80, 0x000103D7,
		0x1B80, 0x304D03E5,
		0x1B80, 0x304D03E7,
		0x1B80, 0x306503F5,
		0x1B80, 0x306503F7,
		0x1B80, 0x30B00405,
		0x1B80, 0x30B00407,
		0x1B80, 0x30B30415,
		0x1B80, 0x30B30417,
		0x1B80, 0x30670425,
		0x1B80, 0x30670427,
		0x1B80, 0x30720435,
		0x1B80, 0x30720437,
		0x1B80, 0x307D0445,
		0x1B80, 0x307D0447,
		0x1B80, 0x30BD0455,
		0x1B80, 0x30BD0457,
		0x1B80, 0x30B70465,
		0x1B80, 0x30B70467,
		0x1B80, 0x30CB0475,
		0x1B80, 0x30CB0477,
		0x1B80, 0x30D60485,
		0x1B80, 0x30D60487,
		0x1B80, 0x30E10495,
		0x1B80, 0x30E10497,
		0x1B80, 0x311004A5,
		0x1B80, 0x311004A7,
		0x1B80, 0x312104B5,
		0x1B80, 0x312104B7,
		0x1B80, 0x313604C5,
		0x1B80, 0x313604C7,
		0x1B80, 0xE16104D5,
		0x1B80, 0xE16104D7,
		0x1B80, 0x4D0404E5,
		0x1B80, 0x4D0404E7,
		0x1B80, 0x208004F5,
		0x1B80, 0x208004F7,
		0x1B80, 0x00000505,
		0x1B80, 0x00000507,
		0x1B80, 0x4D000515,
		0x1B80, 0x4D000517,
		0x1B80, 0x55070525,
		0x1B80, 0x55070527,
		0x1B80, 0xE1590535,
		0x1B80, 0xE1590537,
		0x1B80, 0xE1590545,
		0x1B80, 0xE1590547,
		0x1B80, 0x4D040555,
		0x1B80, 0x4D040557,
		0x1B80, 0x20880565,
		0x1B80, 0x20880567,
		0x1B80, 0x02000575,
		0x1B80, 0x02000577,
		0x1B80, 0x4D000585,
		0x1B80, 0x4D000587,
		0x1B80, 0x550F0595,
		0x1B80, 0x550F0597,
		0x1B80, 0xE15905A5,
		0x1B80, 0xE15905A7,
		0x1B80, 0x4F0205B5,
		0x1B80, 0x4F0205B7,
		0x1B80, 0x4E0005C5,
		0x1B80, 0x4E0005C7,
		0x1B80, 0x530205D5,
		0x1B80, 0x530205D7,
		0x1B80, 0x520105E5,
		0x1B80, 0x520105E7,
		0x1B80, 0xE15D05F5,
		0x1B80, 0xE15D05F7,
		0x1B80, 0x4D080605,
		0x1B80, 0x4D080607,
		0x1B80, 0x57100615,
		0x1B80, 0x57100617,
		0x1B80, 0x57000625,
		0x1B80, 0x57000627,
		0x1B80, 0x4D000635,
		0x1B80, 0x4D000637,
		0x1B80, 0x00010645,
		0x1B80, 0x00010647,
		0x1B80, 0xE1610655,
		0x1B80, 0xE1610657,
		0x1B80, 0x00010665,
		0x1B80, 0x00010667,
		0x1B80, 0x30870675,
		0x1B80, 0x30870677,
		0x1B80, 0x00230685,
		0x1B80, 0x00230687,
		0x1B80, 0xE1C70695,
		0x1B80, 0xE1C70697,
		0x1B80, 0x000206A5,
		0x1B80, 0x000206A7,
		0x1B80, 0x54E906B5,
		0x1B80, 0x54E906B7,
		0x1B80, 0x0BA606C5,
		0x1B80, 0x0BA606C7,
		0x1B80, 0x002306D5,
		0x1B80, 0x002306D7,
		0x1B80, 0xE1C706E5,
		0x1B80, 0xE1C706E7,
		0x1B80, 0x000206F5,
		0x1B80, 0x000206F7,
		0x1B80, 0x4D300705,
		0x1B80, 0x4D300707,
		0x1B80, 0x30A00715,
		0x1B80, 0x30A00717,
		0x1B80, 0x30830725,
		0x1B80, 0x30830727,
		0x1B80, 0x00220735,
		0x1B80, 0x00220737,
		0x1B80, 0xE1C70745,
		0x1B80, 0xE1C70747,
		0x1B80, 0x00020755,
		0x1B80, 0x00020757,
		0x1B80, 0x54E80765,
		0x1B80, 0x54E80767,
		0x1B80, 0x0BA60775,
		0x1B80, 0x0BA60777,
		0x1B80, 0x00220785,
		0x1B80, 0x00220787,
		0x1B80, 0xE1C70795,
		0x1B80, 0xE1C70797,
		0x1B80, 0x000207A5,
		0x1B80, 0x000207A7,
		0x1B80, 0x4D3007B5,
		0x1B80, 0x4D3007B7,
		0x1B80, 0x30A007C5,
		0x1B80, 0x30A007C7,
		0x1B80, 0x63F107D5,
		0x1B80, 0x63F107D7,
		0x1B80, 0xE16107E5,
		0x1B80, 0xE16107E7,
		0x1B80, 0xE1C707F5,
		0x1B80, 0xE1C707F7,
		0x1B80, 0x63F40805,
		0x1B80, 0x63F40807,
		0x1B80, 0xE1610815,
		0x1B80, 0xE1610817,
		0x1B80, 0xE1C70825,
		0x1B80, 0xE1C70827,
		0x1B80, 0x0BA80835,
		0x1B80, 0x0BA80837,
		0x1B80, 0x63F80845,
		0x1B80, 0x63F80847,
		0x1B80, 0xE1610855,
		0x1B80, 0xE1610857,
		0x1B80, 0xE1C70865,
		0x1B80, 0xE1C70867,
		0x1B80, 0x0BA90875,
		0x1B80, 0x0BA90877,
		0x1B80, 0x63FC0885,
		0x1B80, 0x63FC0887,
		0x1B80, 0xE1610895,
		0x1B80, 0xE1610897,
		0x1B80, 0xE1C708A5,
		0x1B80, 0xE1C708A7,
		0x1B80, 0x63FF08B5,
		0x1B80, 0x63FF08B7,
		0x1B80, 0xE16108C5,
		0x1B80, 0xE16108C7,
		0x1B80, 0xE1C708D5,
		0x1B80, 0xE1C708D7,
		0x1B80, 0x630008E5,
		0x1B80, 0x630008E7,
		0x1B80, 0xE16108F5,
		0x1B80, 0xE16108F7,
		0x1B80, 0xE1C70905,
		0x1B80, 0xE1C70907,
		0x1B80, 0x63030915,
		0x1B80, 0x63030917,
		0x1B80, 0xE1610925,
		0x1B80, 0xE1610927,
		0x1B80, 0xE1C70935,
		0x1B80, 0xE1C70937,
		0x1B80, 0xF4D40945,
		0x1B80, 0xF4D40947,
		0x1B80, 0x63070955,
		0x1B80, 0x63070957,
		0x1B80, 0xE1610965,
		0x1B80, 0xE1610967,
		0x1B80, 0xE1C70975,
		0x1B80, 0xE1C70977,
		0x1B80, 0xF5DB0985,
		0x1B80, 0xF5DB0987,
		0x1B80, 0x630B0995,
		0x1B80, 0x630B0997,
		0x1B80, 0xE16109A5,
		0x1B80, 0xE16109A7,
		0x1B80, 0xE1C709B5,
		0x1B80, 0xE1C709B7,
		0x1B80, 0x630E09C5,
		0x1B80, 0x630E09C7,
		0x1B80, 0xE16109D5,
		0x1B80, 0xE16109D7,
		0x1B80, 0xE1C709E5,
		0x1B80, 0xE1C709E7,
		0x1B80, 0x4D3009F5,
		0x1B80, 0x4D3009F7,
		0x1B80, 0x55010A05,
		0x1B80, 0x55010A07,
		0x1B80, 0x57040A15,
		0x1B80, 0x57040A17,
		0x1B80, 0x57000A25,
		0x1B80, 0x57000A27,
		0x1B80, 0x96000A35,
		0x1B80, 0x96000A37,
		0x1B80, 0x57080A45,
		0x1B80, 0x57080A47,
		0x1B80, 0x57000A55,
		0x1B80, 0x57000A57,
		0x1B80, 0x95000A65,
		0x1B80, 0x95000A67,
		0x1B80, 0x4D000A75,
		0x1B80, 0x4D000A77,
		0x1B80, 0x6C070A85,
		0x1B80, 0x6C070A87,
		0x1B80, 0x7B200A95,
		0x1B80, 0x7B200A97,
		0x1B80, 0x7A000AA5,
		0x1B80, 0x7A000AA7,
		0x1B80, 0x79000AB5,
		0x1B80, 0x79000AB7,
		0x1B80, 0x7F200AC5,
		0x1B80, 0x7F200AC7,
		0x1B80, 0x7E000AD5,
		0x1B80, 0x7E000AD7,
		0x1B80, 0x7D000AE5,
		0x1B80, 0x7D000AE7,
		0x1B80, 0x00010AF5,
		0x1B80, 0x00010AF7,
		0x1B80, 0x62850B05,
		0x1B80, 0x62850B07,
		0x1B80, 0xE1610B15,
		0x1B80, 0xE1610B17,
		0x1B80, 0x00010B25,
		0x1B80, 0x00010B27,
		0x1B80, 0x5C320B35,
		0x1B80, 0x5C320B37,
		0x1B80, 0xE1C30B45,
		0x1B80, 0xE1C30B47,
		0x1B80, 0xE18F0B55,
		0x1B80, 0xE18F0B57,
		0x1B80, 0x00010B65,
		0x1B80, 0x00010B67,
		0x1B80, 0x5C320B75,
		0x1B80, 0x5C320B77,
		0x1B80, 0x63F40B85,
		0x1B80, 0x63F40B87,
		0x1B80, 0x62850B95,
		0x1B80, 0x62850B97,
		0x1B80, 0x0BB00BA5,
		0x1B80, 0x0BB00BA7,
		0x1B80, 0xE1610BB5,
		0x1B80, 0xE1610BB7,
		0x1B80, 0xE1C70BC5,
		0x1B80, 0xE1C70BC7,
		0x1B80, 0x5C320BD5,
		0x1B80, 0x5C320BD7,
		0x1B80, 0x63FC0BE5,
		0x1B80, 0x63FC0BE7,
		0x1B80, 0x62850BF5,
		0x1B80, 0x62850BF7,
		0x1B80, 0x0BB10C05,
		0x1B80, 0x0BB10C07,
		0x1B80, 0xE1610C15,
		0x1B80, 0xE1610C17,
		0x1B80, 0xE1C70C25,
		0x1B80, 0xE1C70C27,
		0x1B80, 0x63030C35,
		0x1B80, 0x63030C37,
		0x1B80, 0xE1610C45,
		0x1B80, 0xE1610C47,
		0x1B80, 0xE1C70C55,
		0x1B80, 0xE1C70C57,
		0x1B80, 0xF7040C65,
		0x1B80, 0xF7040C67,
		0x1B80, 0x630B0C75,
		0x1B80, 0x630B0C77,
		0x1B80, 0xE1610C85,
		0x1B80, 0xE1610C87,
		0x1B80, 0xE1C70C95,
		0x1B80, 0xE1C70C97,
		0x1B80, 0x00010CA5,
		0x1B80, 0x00010CA7,
		0x1B80, 0x30EF0CB5,
		0x1B80, 0x30EF0CB7,
		0x1B80, 0x00230CC5,
		0x1B80, 0x00230CC7,
		0x1B80, 0xE1CC0CD5,
		0x1B80, 0xE1CC0CD7,
		0x1B80, 0x00020CE5,
		0x1B80, 0x00020CE7,
		0x1B80, 0x54E90CF5,
		0x1B80, 0x54E90CF7,
		0x1B80, 0x0BA60D05,
		0x1B80, 0x0BA60D07,
		0x1B80, 0x00230D15,
		0x1B80, 0x00230D17,
		0x1B80, 0xE1CC0D25,
		0x1B80, 0xE1CC0D27,
		0x1B80, 0x00020D35,
		0x1B80, 0x00020D37,
		0x1B80, 0x4D100D45,
		0x1B80, 0x4D100D47,
		0x1B80, 0x30A00D55,
		0x1B80, 0x30A00D57,
		0x1B80, 0x30E90D65,
		0x1B80, 0x30E90D67,
		0x1B80, 0x00220D75,
		0x1B80, 0x00220D77,
		0x1B80, 0xE1CC0D85,
		0x1B80, 0xE1CC0D87,
		0x1B80, 0x00020D95,
		0x1B80, 0x00020D97,
		0x1B80, 0x54E80DA5,
		0x1B80, 0x54E80DA7,
		0x1B80, 0x0BA60DB5,
		0x1B80, 0x0BA60DB7,
		0x1B80, 0x00220DC5,
		0x1B80, 0x00220DC7,
		0x1B80, 0xE1CC0DD5,
		0x1B80, 0xE1CC0DD7,
		0x1B80, 0x00020DE5,
		0x1B80, 0x00020DE7,
		0x1B80, 0x4D100DF5,
		0x1B80, 0x4D100DF7,
		0x1B80, 0x30A00E05,
		0x1B80, 0x30A00E07,
		0x1B80, 0x5C320E15,
		0x1B80, 0x5C320E17,
		0x1B80, 0x54F00E25,
		0x1B80, 0x54F00E27,
		0x1B80, 0x67F10E35,
		0x1B80, 0x67F10E37,
		0x1B80, 0xE18F0E45,
		0x1B80, 0xE18F0E47,
		0x1B80, 0xE1CC0E55,
		0x1B80, 0xE1CC0E57,
		0x1B80, 0x67F40E65,
		0x1B80, 0x67F40E67,
		0x1B80, 0xE18F0E75,
		0x1B80, 0xE18F0E77,
		0x1B80, 0xE1CC0E85,
		0x1B80, 0xE1CC0E87,
		0x1B80, 0x5C320E95,
		0x1B80, 0x5C320E97,
		0x1B80, 0x54F10EA5,
		0x1B80, 0x54F10EA7,
		0x1B80, 0x0BA80EB5,
		0x1B80, 0x0BA80EB7,
		0x1B80, 0x67F80EC5,
		0x1B80, 0x67F80EC7,
		0x1B80, 0xE18F0ED5,
		0x1B80, 0xE18F0ED7,
		0x1B80, 0xE1CC0EE5,
		0x1B80, 0xE1CC0EE7,
		0x1B80, 0x5C320EF5,
		0x1B80, 0x5C320EF7,
		0x1B80, 0x54F10F05,
		0x1B80, 0x54F10F07,
		0x1B80, 0x0BA90F15,
		0x1B80, 0x0BA90F17,
		0x1B80, 0x67FC0F25,
		0x1B80, 0x67FC0F27,
		0x1B80, 0xE18F0F35,
		0x1B80, 0xE18F0F37,
		0x1B80, 0xE1CC0F45,
		0x1B80, 0xE1CC0F47,
		0x1B80, 0x67FF0F55,
		0x1B80, 0x67FF0F57,
		0x1B80, 0xE18F0F65,
		0x1B80, 0xE18F0F67,
		0x1B80, 0xE1CC0F75,
		0x1B80, 0xE1CC0F77,
		0x1B80, 0x5C320F85,
		0x1B80, 0x5C320F87,
		0x1B80, 0x54F20F95,
		0x1B80, 0x54F20F97,
		0x1B80, 0x67000FA5,
		0x1B80, 0x67000FA7,
		0x1B80, 0xE18F0FB5,
		0x1B80, 0xE18F0FB7,
		0x1B80, 0xE1CC0FC5,
		0x1B80, 0xE1CC0FC7,
		0x1B80, 0x67030FD5,
		0x1B80, 0x67030FD7,
		0x1B80, 0xE18F0FE5,
		0x1B80, 0xE18F0FE7,
		0x1B80, 0xE1CC0FF5,
		0x1B80, 0xE1CC0FF7,
		0x1B80, 0xF9CC1005,
		0x1B80, 0xF9CC1007,
		0x1B80, 0x67071015,
		0x1B80, 0x67071017,
		0x1B80, 0xE18F1025,
		0x1B80, 0xE18F1027,
		0x1B80, 0xE1CC1035,
		0x1B80, 0xE1CC1037,
		0x1B80, 0xFAD31045,
		0x1B80, 0xFAD31047,
		0x1B80, 0x5C321055,
		0x1B80, 0x5C321057,
		0x1B80, 0x54F31065,
		0x1B80, 0x54F31067,
		0x1B80, 0x670B1075,
		0x1B80, 0x670B1077,
		0x1B80, 0xE18F1085,
		0x1B80, 0xE18F1087,
		0x1B80, 0xE1CC1095,
		0x1B80, 0xE1CC1097,
		0x1B80, 0x670E10A5,
		0x1B80, 0x670E10A7,
		0x1B80, 0xE18F10B5,
		0x1B80, 0xE18F10B7,
		0x1B80, 0xE1CC10C5,
		0x1B80, 0xE1CC10C7,
		0x1B80, 0x4D1010D5,
		0x1B80, 0x4D1010D7,
		0x1B80, 0x30A010E5,
		0x1B80, 0x30A010E7,
		0x1B80, 0x000110F5,
		0x1B80, 0x000110F7,
		0x1B80, 0x6C001105,
		0x1B80, 0x6C001107,
		0x1B80, 0x00061115,
		0x1B80, 0x00061117,
		0x1B80, 0x53001125,
		0x1B80, 0x53001127,
		0x1B80, 0x57F71135,
		0x1B80, 0x57F71137,
		0x1B80, 0x58211145,
		0x1B80, 0x58211147,
		0x1B80, 0x592E1155,
		0x1B80, 0x592E1157,
		0x1B80, 0x5A381165,
		0x1B80, 0x5A381167,
		0x1B80, 0x5B411175,
		0x1B80, 0x5B411177,
		0x1B80, 0x00071185,
		0x1B80, 0x00071187,
		0x1B80, 0x5C001195,
		0x1B80, 0x5C001197,
		0x1B80, 0x4B0011A5,
		0x1B80, 0x4B0011A7,
		0x1B80, 0x4E8F11B5,
		0x1B80, 0x4E8F11B7,
		0x1B80, 0x4F1511C5,
		0x1B80, 0x4F1511C7,
		0x1B80, 0x000411D5,
		0x1B80, 0x000411D7,
		0x1B80, 0xE1B111E5,
		0x1B80, 0xE1B111E7,
		0x1B80, 0xAB0011F5,
		0x1B80, 0xAB0011F7,
		0x1B80, 0x00011205,
		0x1B80, 0x00011207,
		0x1B80, 0x6C001215,
		0x1B80, 0x6C001217,
		0x1B80, 0x00061225,
		0x1B80, 0x00061227,
		0x1B80, 0x53001235,
		0x1B80, 0x53001237,
		0x1B80, 0x57F71245,
		0x1B80, 0x57F71247,
		0x1B80, 0x58211255,
		0x1B80, 0x58211257,
		0x1B80, 0x592E1265,
		0x1B80, 0x592E1267,
		0x1B80, 0x5A381275,
		0x1B80, 0x5A381277,
		0x1B80, 0x5B411285,
		0x1B80, 0x5B411287,
		0x1B80, 0x00071295,
		0x1B80, 0x00071297,
		0x1B80, 0x5C0012A5,
		0x1B80, 0x5C0012A7,
		0x1B80, 0x4B4012B5,
		0x1B80, 0x4B4012B7,
		0x1B80, 0x4E9712C5,
		0x1B80, 0x4E9712C7,
		0x1B80, 0x4F1112D5,
		0x1B80, 0x4F1112D7,
		0x1B80, 0x000412E5,
		0x1B80, 0x000412E7,
		0x1B80, 0xE1B112F5,
		0x1B80, 0xE1B112F7,
		0x1B80, 0xAB001305,
		0x1B80, 0xAB001307,
		0x1B80, 0x8B001315,
		0x1B80, 0x8B001317,
		0x1B80, 0xAB001325,
		0x1B80, 0xAB001327,
		0x1B80, 0x8A191335,
		0x1B80, 0x8A191337,
		0x1B80, 0x30211345,
		0x1B80, 0x30211347,
		0x1B80, 0x00011355,
		0x1B80, 0x00011357,
		0x1B80, 0x6C011365,
		0x1B80, 0x6C011367,
		0x1B80, 0x00061375,
		0x1B80, 0x00061377,
		0x1B80, 0x53011385,
		0x1B80, 0x53011387,
		0x1B80, 0x57F71395,
		0x1B80, 0x57F71397,
		0x1B80, 0x582113A5,
		0x1B80, 0x582113A7,
		0x1B80, 0x592E13B5,
		0x1B80, 0x592E13B7,
		0x1B80, 0x5A3813C5,
		0x1B80, 0x5A3813C7,
		0x1B80, 0x5B4113D5,
		0x1B80, 0x5B4113D7,
		0x1B80, 0x000713E5,
		0x1B80, 0x000713E7,
		0x1B80, 0x5C0013F5,
		0x1B80, 0x5C0013F7,
		0x1B80, 0x4B001405,
		0x1B80, 0x4B001407,
		0x1B80, 0x4E871415,
		0x1B80, 0x4E871417,
		0x1B80, 0x4F111425,
		0x1B80, 0x4F111427,
		0x1B80, 0x00041435,
		0x1B80, 0x00041437,
		0x1B80, 0xE1B11445,
		0x1B80, 0xE1B11447,
		0x1B80, 0xAB001455,
		0x1B80, 0xAB001457,
		0x1B80, 0x00061465,
		0x1B80, 0x00061467,
		0x1B80, 0x57771475,
		0x1B80, 0x57771477,
		0x1B80, 0x00071485,
		0x1B80, 0x00071487,
		0x1B80, 0x4E861495,
		0x1B80, 0x4E861497,
		0x1B80, 0x000414A5,
		0x1B80, 0x000414A7,
		0x1B80, 0x000114B5,
		0x1B80, 0x000114B7,
		0x1B80, 0x000114C5,
		0x1B80, 0x000114C7,
		0x1B80, 0x7B2414D5,
		0x1B80, 0x7B2414D7,
		0x1B80, 0x7A4014E5,
		0x1B80, 0x7A4014E7,
		0x1B80, 0x790014F5,
		0x1B80, 0x790014F7,
		0x1B80, 0x55031505,
		0x1B80, 0x55031507,
		0x1B80, 0x31591515,
		0x1B80, 0x31591517,
		0x1B80, 0x7B1C1525,
		0x1B80, 0x7B1C1527,
		0x1B80, 0x7A401535,
		0x1B80, 0x7A401537,
		0x1B80, 0x550B1545,
		0x1B80, 0x550B1547,
		0x1B80, 0x31591555,
		0x1B80, 0x31591557,
		0x1B80, 0x7B201565,
		0x1B80, 0x7B201567,
		0x1B80, 0x7A001575,
		0x1B80, 0x7A001577,
		0x1B80, 0x55131585,
		0x1B80, 0x55131587,
		0x1B80, 0x74011595,
		0x1B80, 0x74011597,
		0x1B80, 0x740015A5,
		0x1B80, 0x740015A7,
		0x1B80, 0x8E0015B5,
		0x1B80, 0x8E0015B7,
		0x1B80, 0x000115C5,
		0x1B80, 0x000115C7,
		0x1B80, 0x570215D5,
		0x1B80, 0x570215D7,
		0x1B80, 0x570015E5,
		0x1B80, 0x570015E7,
		0x1B80, 0x970015F5,
		0x1B80, 0x970015F7,
		0x1B80, 0x00011605,
		0x1B80, 0x00011607,
		0x1B80, 0x4F781615,
		0x1B80, 0x4F781617,
		0x1B80, 0x53881625,
		0x1B80, 0x53881627,
		0x1B80, 0xE16F1635,
		0x1B80, 0xE16F1637,
		0x1B80, 0x54801645,
		0x1B80, 0x54801647,
		0x1B80, 0x54001655,
		0x1B80, 0x54001657,
		0x1B80, 0xE16F1665,
		0x1B80, 0xE16F1667,
		0x1B80, 0x54811675,
		0x1B80, 0x54811677,
		0x1B80, 0x54001685,
		0x1B80, 0x54001687,
		0x1B80, 0xE16F1695,
		0x1B80, 0xE16F1697,
		0x1B80, 0x548216A5,
		0x1B80, 0x548216A7,
		0x1B80, 0x540016B5,
		0x1B80, 0x540016B7,
		0x1B80, 0xE17A16C5,
		0x1B80, 0xE17A16C7,
		0x1B80, 0xBF1D16D5,
		0x1B80, 0xBF1D16D7,
		0x1B80, 0x302116E5,
		0x1B80, 0x302116E7,
		0x1B80, 0xE14D16F5,
		0x1B80, 0xE14D16F7,
		0x1B80, 0xE1521705,
		0x1B80, 0xE1521707,
		0x1B80, 0xE1561715,
		0x1B80, 0xE1561717,
		0x1B80, 0xE15D1725,
		0x1B80, 0xE15D1727,
		0x1B80, 0xE1C31735,
		0x1B80, 0xE1C31737,
		0x1B80, 0x55131745,
		0x1B80, 0x55131747,
		0x1B80, 0xE1591755,
		0x1B80, 0xE1591757,
		0x1B80, 0x55151765,
		0x1B80, 0x55151767,
		0x1B80, 0xE15D1775,
		0x1B80, 0xE15D1777,
		0x1B80, 0xE1C31785,
		0x1B80, 0xE1C31787,
		0x1B80, 0x00011795,
		0x1B80, 0x00011797,
		0x1B80, 0x54BF17A5,
		0x1B80, 0x54BF17A7,
		0x1B80, 0x54C017B5,
		0x1B80, 0x54C017B7,
		0x1B80, 0x54A317C5,
		0x1B80, 0x54A317C7,
		0x1B80, 0x54C117D5,
		0x1B80, 0x54C117D7,
		0x1B80, 0x54A417E5,
		0x1B80, 0x54A417E7,
		0x1B80, 0x4C1817F5,
		0x1B80, 0x4C1817F7,
		0x1B80, 0xBF071805,
		0x1B80, 0xBF071807,
		0x1B80, 0x54C21815,
		0x1B80, 0x54C21817,
		0x1B80, 0x54A41825,
		0x1B80, 0x54A41827,
		0x1B80, 0xBF041835,
		0x1B80, 0xBF041837,
		0x1B80, 0x54C11845,
		0x1B80, 0x54C11847,
		0x1B80, 0x54A31855,
		0x1B80, 0x54A31857,
		0x1B80, 0xBF011865,
		0x1B80, 0xBF011867,
		0x1B80, 0xE1D11875,
		0x1B80, 0xE1D11877,
		0x1B80, 0x54DF1885,
		0x1B80, 0x54DF1887,
		0x1B80, 0x00011895,
		0x1B80, 0x00011897,
		0x1B80, 0x54BF18A5,
		0x1B80, 0x54BF18A7,
		0x1B80, 0x54E518B5,
		0x1B80, 0x54E518B7,
		0x1B80, 0x050A18C5,
		0x1B80, 0x050A18C7,
		0x1B80, 0x54DF18D5,
		0x1B80, 0x54DF18D7,
		0x1B80, 0x000118E5,
		0x1B80, 0x000118E7,
		0x1B80, 0x7F2018F5,
		0x1B80, 0x7F2018F7,
		0x1B80, 0x7E001905,
		0x1B80, 0x7E001907,
		0x1B80, 0x7D001915,
		0x1B80, 0x7D001917,
		0x1B80, 0x55011925,
		0x1B80, 0x55011927,
		0x1B80, 0x5C311935,
		0x1B80, 0x5C311937,
		0x1B80, 0xE1591945,
		0x1B80, 0xE1591947,
		0x1B80, 0xE15D1955,
		0x1B80, 0xE15D1957,
		0x1B80, 0x54801965,
		0x1B80, 0x54801967,
		0x1B80, 0x54001975,
		0x1B80, 0x54001977,
		0x1B80, 0xE1591985,
		0x1B80, 0xE1591987,
		0x1B80, 0xE15D1995,
		0x1B80, 0xE15D1997,
		0x1B80, 0x548119A5,
		0x1B80, 0x548119A7,
		0x1B80, 0x540019B5,
		0x1B80, 0x540019B7,
		0x1B80, 0xE15919C5,
		0x1B80, 0xE15919C7,
		0x1B80, 0xE15D19D5,
		0x1B80, 0xE15D19D7,
		0x1B80, 0x548219E5,
		0x1B80, 0x548219E7,
		0x1B80, 0x540019F5,
		0x1B80, 0x540019F7,
		0x1B80, 0xE17A1A05,
		0x1B80, 0xE17A1A07,
		0x1B80, 0xBFE91A15,
		0x1B80, 0xBFE91A17,
		0x1B80, 0x30211A25,
		0x1B80, 0x30211A27,
		0x1B80, 0x00231A35,
		0x1B80, 0x00231A37,
		0x1B80, 0x7B201A45,
		0x1B80, 0x7B201A47,
		0x1B80, 0x7A001A55,
		0x1B80, 0x7A001A57,
		0x1B80, 0x79001A65,
		0x1B80, 0x79001A67,
		0x1B80, 0xE1C71A75,
		0x1B80, 0xE1C71A77,
		0x1B80, 0x00021A85,
		0x1B80, 0x00021A87,
		0x1B80, 0x00011A95,
		0x1B80, 0x00011A97,
		0x1B80, 0x00221AA5,
		0x1B80, 0x00221AA7,
		0x1B80, 0x7B201AB5,
		0x1B80, 0x7B201AB7,
		0x1B80, 0x7A001AC5,
		0x1B80, 0x7A001AC7,
		0x1B80, 0x79001AD5,
		0x1B80, 0x79001AD7,
		0x1B80, 0xE1C71AE5,
		0x1B80, 0xE1C71AE7,
		0x1B80, 0x00021AF5,
		0x1B80, 0x00021AF7,
		0x1B80, 0x00011B05,
		0x1B80, 0x00011B07,
		0x1B80, 0x74021B15,
		0x1B80, 0x74021B17,
		0x1B80, 0x003F1B25,
		0x1B80, 0x003F1B27,
		0x1B80, 0x74001B35,
		0x1B80, 0x74001B37,
		0x1B80, 0x00021B45,
		0x1B80, 0x00021B47,
		0x1B80, 0x00011B55,
		0x1B80, 0x00011B57,
		0x1B80, 0x4D041B65,
		0x1B80, 0x4D041B67,
		0x1B80, 0x2EF81B75,
		0x1B80, 0x2EF81B77,
		0x1B80, 0x00001B85,
		0x1B80, 0x00001B87,
		0x1B80, 0x23301B95,
		0x1B80, 0x23301B97,
		0x1B80, 0x00241BA5,
		0x1B80, 0x00241BA7,
		0x1B80, 0x23E01BB5,
		0x1B80, 0x23E01BB7,
		0x1B80, 0x003F1BC5,
		0x1B80, 0x003F1BC7,
		0x1B80, 0x23FC1BD5,
		0x1B80, 0x23FC1BD7,
		0x1B80, 0xBFCE1BE5,
		0x1B80, 0xBFCE1BE7,
		0x1B80, 0x2EF01BF5,
		0x1B80, 0x2EF01BF7,
		0x1B80, 0x00001C05,
		0x1B80, 0x00001C07,
		0x1B80, 0x4D001C15,
		0x1B80, 0x4D001C17,
		0x1B80, 0x00011C25,
		0x1B80, 0x00011C27,
		0x1B80, 0x549F1C35,
		0x1B80, 0x549F1C37,
		0x1B80, 0x54FF1C45,
		0x1B80, 0x54FF1C47,
		0x1B80, 0x54001C55,
		0x1B80, 0x54001C57,
		0x1B80, 0x00011C65,
		0x1B80, 0x00011C67,
		0x1B80, 0x5C311C75,
		0x1B80, 0x5C311C77,
		0x1B80, 0x07141C85,
		0x1B80, 0x07141C87,
		0x1B80, 0x54001C95,
		0x1B80, 0x54001C97,
		0x1B80, 0x5C321CA5,
		0x1B80, 0x5C321CA7,
		0x1B80, 0x00011CB5,
		0x1B80, 0x00011CB7,
		0x1B80, 0x5C321CC5,
		0x1B80, 0x5C321CC7,
		0x1B80, 0x07141CD5,
		0x1B80, 0x07141CD7,
		0x1B80, 0x54001CE5,
		0x1B80, 0x54001CE7,
		0x1B80, 0x5C311CF5,
		0x1B80, 0x5C311CF7,
		0x1B80, 0x00011D05,
		0x1B80, 0x00011D07,
		0x1B80, 0x4C981D15,
		0x1B80, 0x4C981D17,
		0x1B80, 0x4C181D25,
		0x1B80, 0x4C181D27,
		0x1B80, 0x00011D35,
		0x1B80, 0x00011D37,
		0x1B80, 0x5C321D45,
		0x1B80, 0x5C321D47,
		0x1B80, 0x62841D55,
		0x1B80, 0x62841D57,
		0x1B80, 0x66861D65,
		0x1B80, 0x66861D67,
		0x1B80, 0x6C031D75,
		0x1B80, 0x6C031D77,
		0x1B80, 0x7B201D85,
		0x1B80, 0x7B201D87,
		0x1B80, 0x7A001D95,
		0x1B80, 0x7A001D97,
		0x1B80, 0x79001DA5,
		0x1B80, 0x79001DA7,
		0x1B80, 0x7F201DB5,
		0x1B80, 0x7F201DB7,
		0x1B80, 0x7E001DC5,
		0x1B80, 0x7E001DC7,
		0x1B80, 0x7D001DD5,
		0x1B80, 0x7D001DD7,
		0x1B80, 0x09011DE5,
		0x1B80, 0x09011DE7,
		0x1B80, 0x0C011DF5,
		0x1B80, 0x0C011DF7,
		0x1B80, 0x0BA61E05,
		0x1B80, 0x0BA61E07,
		0x1B80, 0x00011E15,
		0x1B80, 0x00011E17,
		0x1B80, 0x00000006,
		0x1B80, 0x00000002,

};

void
odm_read_and_config_mp_8821c_phy_reg(
	struct	PHY_DM_STRUCT *p_dm_odm
)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len = sizeof(array_mp_8821c_phy_reg)/sizeof(u32);
	u32	*array = array_mp_8821c_phy_reg;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> odm_read_and_config_mp_8821c_phy_reg\n"));

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  = (u8)((v1 & (BIT(29)|BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped?false:true;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (is_skipped == false) {
					if (check_positive(p_dm_odm, pre_v1, pre_v2, v1, v2)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else
					is_matched = false;
			}
		} else {
			if (is_matched)
				odm_config_bb_phy_8821c(p_dm_odm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8821c_phy_reg(void)
{
		return 36;
}

/******************************************************************************
*                           phy_reg_mp.TXT
******************************************************************************/

u32 array_mp_8821c_phy_reg_mp[] = {
		0x810, 0x21104285,

};

void
odm_read_and_config_mp_8821c_phy_reg_mp(
	struct	PHY_DM_STRUCT *p_dm_odm
)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len = sizeof(array_mp_8821c_phy_reg_mp)/sizeof(u32);
	u32	*array = array_mp_8821c_phy_reg_mp;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> odm_read_and_config_mp_8821c_phy_reg_mp\n"));

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  = (u8)((v1 & (BIT(29)|BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped?false:true;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (is_skipped == false) {
					if (check_positive(p_dm_odm, pre_v1, pre_v2, v1, v2)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else
					is_matched = false;
			}
		} else {
			if (is_matched)
				odm_config_bb_phy_8821c(p_dm_odm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8821c_phy_reg_mp(void)
{
		return 36;
}

/******************************************************************************
*                           phy_reg_pg.TXT
******************************************************************************/

u32 array_mp_8821c_phy_reg_pg[] = {
	0, 0, 0, 0x00000c20, 0xffffffff, 0x32343638,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x36363636,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x28303234,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x34363636,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x34363636,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x22222224,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x34343434,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x26283032,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x32343434,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x24262830,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x32343434,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x24262830,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x20202022
};

void
odm_read_and_config_mp_8821c_phy_reg_pg(
	struct PHY_DM_STRUCT	*p_dm_odm
)
{
	u32	i = 0;
	u32	array_len = sizeof(array_mp_8821c_phy_reg_pg)/sizeof(u32);
	u32	*array = array_mp_8821c_phy_reg_pg;

	ODM_RT_TRACE(p_dm_odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> odm_read_and_config_mp_8821c_phy_reg_pg\n"));

	p_dm_odm->phy_reg_pg_version = 1;
	p_dm_odm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i+1];
		u32	v3 = array[i+2];
		u32	v4 = array[i+3];
		u32	v5 = array[i+4];
		u32	v6 = array[i+5];

		odm_config_bb_phy_reg_pg_8821c(p_dm_odm, v1, v2, v3, v4, v5, v6);
	}
}


