/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSXMLHttpRequestUpload.h"

#include <wtf/GetPtr.h>

#include "Event.h"
#include "EventListener.h"
#include "Frame.h"
#include "JSDOMGlobalObject.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "XMLHttpRequestUpload.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSXMLHttpRequestUpload)

/* Hash table */

static const HashTableValue JSXMLHttpRequestUploadTableValues[7] =
{
    { "onabort", DontDelete, (intptr_t)jsXMLHttpRequestUploadOnabort, (intptr_t)setJSXMLHttpRequestUploadOnabort },
    { "onerror", DontDelete, (intptr_t)jsXMLHttpRequestUploadOnerror, (intptr_t)setJSXMLHttpRequestUploadOnerror },
    { "onload", DontDelete, (intptr_t)jsXMLHttpRequestUploadOnload, (intptr_t)setJSXMLHttpRequestUploadOnload },
    { "onloadstart", DontDelete, (intptr_t)jsXMLHttpRequestUploadOnloadstart, (intptr_t)setJSXMLHttpRequestUploadOnloadstart },
    { "onprogress", DontDelete, (intptr_t)jsXMLHttpRequestUploadOnprogress, (intptr_t)setJSXMLHttpRequestUploadOnprogress },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsXMLHttpRequestUploadConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXMLHttpRequestUploadTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSXMLHttpRequestUploadTableValues, 0 };
#else
    { 16, 15, JSXMLHttpRequestUploadTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSXMLHttpRequestUploadConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSXMLHttpRequestUploadConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSXMLHttpRequestUploadConstructorTableValues, 0 };
#else
    { 1, 0, JSXMLHttpRequestUploadConstructorTableValues, 0 };
#endif

class JSXMLHttpRequestUploadConstructor : public DOMObject {
public:
    JSXMLHttpRequestUploadConstructor(ExecState* exec)
        : DOMObject(JSXMLHttpRequestUploadConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSXMLHttpRequestUploadPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSXMLHttpRequestUploadConstructor::s_info = { "XMLHttpRequestUploadConstructor", 0, &JSXMLHttpRequestUploadConstructorTable, 0 };

bool JSXMLHttpRequestUploadConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXMLHttpRequestUploadConstructor, DOMObject>(exec, &JSXMLHttpRequestUploadConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSXMLHttpRequestUploadPrototypeTableValues[4] =
{
    { "addEventListener", DontDelete|Function, (intptr_t)jsXMLHttpRequestUploadPrototypeFunctionAddEventListener, (intptr_t)3 },
    { "removeEventListener", DontDelete|Function, (intptr_t)jsXMLHttpRequestUploadPrototypeFunctionRemoveEventListener, (intptr_t)3 },
    { "dispatchEvent", DontDelete|Function, (intptr_t)jsXMLHttpRequestUploadPrototypeFunctionDispatchEvent, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSXMLHttpRequestUploadPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSXMLHttpRequestUploadPrototypeTableValues, 0 };
#else
    { 8, 7, JSXMLHttpRequestUploadPrototypeTableValues, 0 };
#endif

const ClassInfo JSXMLHttpRequestUploadPrototype::s_info = { "XMLHttpRequestUploadPrototype", 0, &JSXMLHttpRequestUploadPrototypeTable, 0 };

JSObject* JSXMLHttpRequestUploadPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSXMLHttpRequestUpload>(exec);
}

bool JSXMLHttpRequestUploadPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSXMLHttpRequestUploadPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSXMLHttpRequestUpload::s_info = { "XMLHttpRequestUpload", 0, &JSXMLHttpRequestUploadTable, 0 };

JSXMLHttpRequestUpload::JSXMLHttpRequestUpload(PassRefPtr<Structure> structure, PassRefPtr<XMLHttpRequestUpload> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSXMLHttpRequestUpload::~JSXMLHttpRequestUpload()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSXMLHttpRequestUpload::createPrototype(ExecState* exec)
{
    return new (exec) JSXMLHttpRequestUploadPrototype(JSXMLHttpRequestUploadPrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSXMLHttpRequestUpload::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXMLHttpRequestUpload, Base>(exec, &JSXMLHttpRequestUploadTable, this, propertyName, slot);
}

JSValuePtr jsXMLHttpRequestUploadOnabort(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(asObject(slot.slotBase()))->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->onabort())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsXMLHttpRequestUploadOnerror(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(asObject(slot.slotBase()))->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->onerror())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsXMLHttpRequestUploadOnload(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(asObject(slot.slotBase()))->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->onload())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsXMLHttpRequestUploadOnloadstart(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(asObject(slot.slotBase()))->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->onloadstart())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsXMLHttpRequestUploadOnprogress(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(asObject(slot.slotBase()))->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->onprogress())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsXMLHttpRequestUploadConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSXMLHttpRequestUpload*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSXMLHttpRequestUpload::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSXMLHttpRequestUpload, Base>(exec, propertyName, value, &JSXMLHttpRequestUploadTable, this, slot);
}

void setJSXMLHttpRequestUploadOnabort(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnabort(globalObject->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

void setJSXMLHttpRequestUploadOnerror(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnerror(globalObject->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

void setJSXMLHttpRequestUploadOnload(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnload(globalObject->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

void setJSXMLHttpRequestUploadOnloadstart(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnloadstart(globalObject->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

void setJSXMLHttpRequestUploadOnprogress(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(static_cast<JSXMLHttpRequestUpload*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnprogress(globalObject->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

JSValuePtr JSXMLHttpRequestUpload::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSXMLHttpRequestUploadConstructor>(exec);
}

JSValuePtr jsXMLHttpRequestUploadPrototypeFunctionAddEventListener(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXMLHttpRequestUpload::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequestUpload* castedThisObj = static_cast<JSXMLHttpRequestUpload*>(asObject(thisValue));
    return castedThisObj->addEventListener(exec, args);
}

JSValuePtr jsXMLHttpRequestUploadPrototypeFunctionRemoveEventListener(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXMLHttpRequestUpload::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequestUpload* castedThisObj = static_cast<JSXMLHttpRequestUpload*>(asObject(thisValue));
    return castedThisObj->removeEventListener(exec, args);
}

JSValuePtr jsXMLHttpRequestUploadPrototypeFunctionDispatchEvent(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSXMLHttpRequestUpload::s_info))
        return throwError(exec, TypeError);
    JSXMLHttpRequestUpload* castedThisObj = static_cast<JSXMLHttpRequestUpload*>(asObject(thisValue));
    XMLHttpRequestUpload* imp = static_cast<XMLHttpRequestUpload*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Event* evt = toEvent(args.at(exec, 0));


    JSC::JSValuePtr result = jsBoolean(imp->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return result;
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, XMLHttpRequestUpload* object)
{
    return getDOMObjectWrapper<JSXMLHttpRequestUpload>(exec, object);
}
XMLHttpRequestUpload* toXMLHttpRequestUpload(JSC::JSValuePtr value)
{
    return value->isObject(&JSXMLHttpRequestUpload::s_info) ? static_cast<JSXMLHttpRequestUpload*>(asObject(value))->impl() : 0;
}

}
