/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMTrayIcon.h

Description:

    This file defines class PMTrayIcon.

Environment (opt):

    OS: Ubuntu,
    SE: Code::Blocks8.02

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Zhang Hui   2008-7-20

  =====================================================================

****************************************************************************/

#ifndef PMTRAYICON_H_INCLUDED
#define PMTRAYICON_H_INCLUDED

#include "wx/taskbar.h"
#include <wx/bitmap.h>

#include "PMMenu.h"
#include "PMBalloonWnd.h"
#include <wx/event.h>
#include <wx/utils.h>
#include <vector>
#include "PMApp.h"
#include "DialogRegister.h"
#include "PMDialog.h"
#include "BatteryInfoMgmtProxy.h"
#include "PMGlobalConstant.h"
using namespace std;

class PMMenu;
class PMBalloonWnd;
class PMDialog;
class BatteryInfoDialog;

//define callback function
void CALLBACK ENM_shutdown_lan_interface(int *result);
//define callback function
void CALLBACK ENM_shutdown_wlan_interface(int *result);

class PMTrayIcon: public wxTaskBarIcon
{
public:
    //constructor
    PMTrayIcon(bool bAutoStart);
    //destructor
    ~PMTrayIcon();

    //void OnLeftButtonDClick(wxTaskBarIconEvent&);
    //mouse over action
    void OnMouseOver(wxTaskBarIconEvent&);
    //mouse left up action
    void OnLeftButtonUp(wxTaskBarIconEvent&);
    //mouse right up action
    void OnRightButtonUp(wxTaskBarIconEvent&);
    //create pop-up menu
    wxMenu *CreatePopupMenu();
    //timer event to close balloon
    void OnTimerTick(wxTimerEvent & event);
    //timer event to get battery info
    void GetBatteryInfo(wxTimerEvent & event);
    //change balloon to device list
    void ChangeBalloonToList();
    //change balloon to power status
    void ChangeBalloonToStatus();
    //show pm dialog
    void ShowPMDlg();
    //show battery info dialog
    void ShowBatteryDlg();
    //show menu
    void ShowMenu();
    //update tray icon
    bool UpdateIcon(PDCS_Battery_Info batteryInfo);
    //switch power type
    void SwitchPower();
    //timer event to power type changed
    void PowerChangeEvent(wxTimerEvent & event);
    //timer event to close display
    void IdleTimeEvent(wxTimerEvent & event);
    //timer event to suspend
    void SuspendEvent(wxTimerEvent & event);
    //init the tray icon
    void Init();
    //check the system notification area exist
    static bool IsProtocolSupported();
    //show some info
    static void ShowMessageDialog(wxString message);
    //start close display and suspend timer
    void StartIdleTimer();
    //start timer for ENM
    void StartLANTimer();
    //timer out action for ENM
    void LANOverTimeHandler(wxTimerEvent & event);
   // void ClickTimeEvent(wxTimerEvent & event);

    static bool m_initState;
    //ENM response lan close
    friend void CALLBACK ENM_shutdown_lan_interface(int *result);
    //ENM response wlan close
    friend void CALLBACK ENM_shutdown_wlan_interface(int *result);

private:
    int m_isAC;
    bool m_bAutoStart; // indicate whether the application starts with system
    bool m_firstnotray;
    bool m_bDoubleClick;
    PMMenu* m_ptrMenu;
    PMBalloonWnd* m_ptrBalloonInfo;
    PMBalloonWnd* m_ptrDeviceListBall;
    wxTimer * m_Timer;
    wxTimer * m_batteryInfoTimer;
    wxTimer * m_idleTimer_closelcd;
    wxTimer * m_idleTimer_suspend;
    PMDialog* m_ptrPMDialog;
    BatteryInfoDialog* m_ptrBatteryDialog;

    PMBalloonWnd* m_switchPower;
    wxTimer* m_switchTimer;
    wxTimer* m_clickTimer;
    wxTimer m_lan_timer;
    wxTimer m_wlan_timer;

    //close balloon
    void CloseBalloonStatus();
    //close balloon
    void CloseBalloonList();
    //close balloon
    void ClosePowerSwitchBalloon();
    //map event
    DECLARE_EVENT_TABLE()
};

#endif // PMTRAYICON_H_INCLUDED
