/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          DialogRegister.cpp

Description:

    This file implements class DialogRegister.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Zhang Hui 2008-7-20

  =====================================================================

****************************************************************************/

#include "include/DialogRegister.h"

/**constructor*/
DialogRegister::DialogRegister()
{
    this->ptrBatteryInfoDialog = NULL;
    this->ptrPMDialog = NULL;
}

/**destructor*/
DialogRegister::~DialogRegister()
{
}

DialogRegister* DialogRegister::ptrDialogRegister = NULL;

/**************************************************************************************************
* Function Name : GetInstance
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
DialogRegister* DialogRegister::GetInstance()
{
    if (NULL == ptrDialogRegister)
    {
        ptrDialogRegister = new DialogRegister();
    }

    return ptrDialogRegister;
}

/**************************************************************************************************
* Function Name : SetPtrPMDialog
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
void DialogRegister::SetPtrPMDialog(PMDialog* ptrPMDialog)
{
    this->ptrPMDialog = ptrPMDialog;
}

/**************************************************************************************************
* Function Name : GetPtrPMDialog
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
PMDialog* DialogRegister::GetPtrPMDialog()
{
    return this->ptrPMDialog;
}

/**************************************************************************************************
* Function Name : SetPtrBatteryInfoDialog
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
void DialogRegister::SetPtrBatteryInfoDialog(BatteryInfoDialog* ptrBatteryInfoDialog)
{
    this->ptrBatteryInfoDialog = ptrBatteryInfoDialog;
}

/**************************************************************************************************
* Function Name : GetPtrBatteryInfoDialog
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
BatteryInfoDialog* DialogRegister::GetPtrBatteryInfoDialog()
{
    return this->ptrBatteryInfoDialog;
}

/**************************************************************************************************
* Function Name : SetPtrTask
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
void DialogRegister::SetPtrTask(PMTrayIcon* ptrTask)
{
    this->ptrTask = ptrTask;
}

/**************************************************************************************************
* Function Name : GetPtrTask
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
PMTrayIcon* DialogRegister::GetPtrTask()
{
    return this->ptrTask;
}
