/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMNew3Dialog.h

Description:

    This file defines class PMNew3Dialog.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Lin Xin 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef PMNEW3DIALOG_H
#define PMNEW3DIALOG_H
#include <wx/wizard.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/statline.h>
#include <wx/panel.h>
#include <wx/statbmp.h>
#include <wx/button.h>

//(*Headers(PMNew3Dialog)
#include <wx/stattext.h>
#include <wx/checkbox.h>
#include <wx/statbox.h>
#include <wx/statbmp.h>
#include <wx/dialog.h>
#include <wx/combobox.h>
#include <wx/gauge.h>
//*)

#include <wx/wx.h>
#include "PMUtility.h"
#include "PowerSchemeMgmtProxy.h"

class PMNew3Dialog : public wxWizardPageSimple
{
    public:
        //constructor
        PMNew3Dialog(wxWizard *wizard);
        //destructor
        ~PMNew3Dialog();

		wxStaticText* StaticTextBaner;
		wxStaticText* StaticTextBaner2;

 		//(*Declarations(PMNew3Dialog)
		wxStaticText* StaticText_UI_BatteryLife;
		wxGauge* Gauge_LCDBrightness;
		wxComboBox* ComboBox_SysStandby;
		wxComboBox* ComboBox_CloseLCD;
		wxCheckBox* CheckBox_LANStatus;
		wxStaticText* StaticText_UI_LCDBrightness2;
		wxStaticText* StaticText_BatteryLife;
		wxStaticText* StaticText_UI_LCDBrightness;
		wxComboBox* ComboBox_LCDBrightness;
		wxStaticBox* StaticBox1;
		wxComboBox* ComboBox_LANSpeed;
		wxStaticText* StaticText_UI_SysStandby;
		wxStaticText* StaticText_UI_EffectiveofSettings;
		wxStaticText* StaticText_UI_CloseLCD;
		wxCheckBox* CheckBox_WLANStatus;
		wxStaticText* StaticText_UI_LANSpeed;
		wxStaticText* StaticText_UI_Performance;
		wxGauge* Gauge_Performance;
		wxStaticBitmap* StaticBitmap_New3Top;
		//*)

	protected:

		//(*Identifiers(PMNew3Dialog)
		static const long ID_STATICBITMAP_NEW3TOP;
		static const long ID_STATICTEXT_UI_LCDBRIGHTNESS;
		static const long ID_STATICTEXT_UI_LANSPEED;
		static const long ID_STATICTEXT_UI_cLOSEDLCD;
		static const long ID_STATICTEXT_UI_SYSSTANDBY;
		static const long ID_COMBOBOX_LCDBRIGHTNESS;
		static const long ID_COMBOBOX_LANSPEED;
		static const long ID_COMBOBOX_CLOSELCD;
		static const long ID_COMBOBOX_SYSSTANDBY;
		static const long ID_STATICBOX1;
		static const long ID_GAUGE_PERFORMANCE;
		static const long ID_GAUGE_LCDBRIGHTNESS;
		static const long ID_STATICTEXT_UI_EFFECTIVEOFSETTINGS;
		static const long ID_STATICTEXT_UI_PERFORMANCE;
		static const long ID_STATICTEXT_UI_LCDBRIGHTNESS2;
		static const long ID_STATICTEXT_UI_BATTERYLIFE;
		static const long ID_STATICTEXT_BATTERYLIFE;
		static const long ID_CHECKBOX_LANSTATUS;
		static const long ID_CHECKBOX_WLANSTATUS;
		//*)
    private:
        //initial the dialog
        void Init();
        //set conboBox value
        void SetComboboxValue(void);
        //update effectiveness
        int UpdateEffectiveness(map<string, int>& valueMap);
        //comboBox select event
        void OnComboBox_Select(wxCommandEvent& event);

    private:

        wxWizardPageSimple *m_pagestep1;

        int m_iSchemeId;
        //
        SETTING_ITEM_VECTOR vLCDBrightnessItems;
        SETTING_ITEM_VECTOR vLANSpeedItems;
        SETTING_ITEM_VECTOR vCloseLCDItems;
        SETTING_ITEM_VECTOR vStandbyItems;
};
#endif
