#!/bin/sh 

set -e

#command --upstream-version version filename

[ $# -eq 3 ] || exit 255

echo

version="$2"
filename="$3"

tar xfz ${filename} 

dir=`tar tfz ${filename} | head -1 | sed 's,/.*,,g'`
rm -f ${filename}

rm -rf ${dir}/debian
rm -rf ${dir}/win32
mv ${dir} ${dir}+repack.orig

tar cf - ${dir}+repack.orig | gzip -9 > ${filename}

rm -rf ${dir}+repack.orig

echo "${filename} created."

