/*
%%% copyright-cmetz-99
This software is Copyright 1999-2001 by Craig Metz, All Rights Reserved.
The Inner Net License Version 3 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/

#ifndef _MISSING_H
#define _MISSING_H 1

#if !HAVE_ALLOCA
VOIDPTR alloca __P((unsigned int size));
#endif /* !HAVE_ALLOCA */

#if !HAVE_ATEXIT
VOIDRET atexit __P((void (*function)(void)));
#endif /* !HAVE_ATEXIT */

#if !HAVE_ENDSPENT
VOIDRET endspent __P((void));
#endif /* !HAVE_ENDSPENT */

#if !HAVE_ENDUTENT
VOIDRET endutent __P((void));
#endif /* !HAVE_ENDUTENT */

#if !HAVE_GETENV
char *getenv __P((char *name));
#endif /* !HAVE_GETENV */

#if !HAVE_SETENV
int setenv __P((char *name, char *value, int rewrite));
#endif /* !HAVE_SETENV */

#if !HAVE_UNSETENV
VOIDRET unsetenv __P((char *name));
#endif /* !HAVE_UNSETENV */

#if !HAVE_GETCWD
char *getcwd __P((char *c, int l));
#endif /* !HAVE_GETCWD */

#if !HAVE_GETSPNAM
struct spwd *getspnam __P((char *name));
#endif /* !HAVE_GETSPNAM */

#if !HAVE_GETUSERSHELL
char *getusershell __P((void));
#endif /* !HAVE_GETUSERSHELL */

#if !HAVE_ENDUSERSHELL
VOIDRET endusershell __P((void));
#endif /* !HAVE_ENDUSERSHELL */

#if !HAVE_GETUTLINE
struct utmp *getutline __P((struct utmp *utmp));
#endif /* !HAVE_GETUTLINE */

#if !HAVE_INITGROUPS
int initgroups __P((const char *uname, int agroup));
#endif /* !HAVE_INITGROUPS */

#if !HAVE_MEMCMP
int memcmp __P((unsigned char *s1, unsigned char *s2, int n));
#endif /* !HAVE_MEMCMP */

#if !HAVE_MEMCPY
VOIDPTR *memcpy __P((unsigned char *d, unsigned char *s, int n));
#endif /* !HAVE_MEMCPY */

#if !HAVE_MEMSET
VOIDPTR *memset __P((unsigned char *d, int v, int n));
#endif /* !HAVE_MEMSET */

#if !HAVE_PUTUTLINE
void pututline __P((struct utmp *utmp));
#endif /* !HAVE_PUTUTLINE */

#if !HAVE_SETEGID
int setegid __P((uid_t egid));
#endif /* !HAVE_SETEGID */

#if !HAVE_SETEUID
int seteuid __P((uid_t euid));
#endif /* !HAVE_SETEUID */

#if !HAVE_SETUTENT
VOIDRET setutent __P((void));
#endif /* !HAVE_SETUTENT */

#if !HAVE_SIGADDSET
int sigaddset __P((sigset_t *set, int signum));
#endif /* !HAVE_SIGADDSET */

#if !HAVE_SIGEMPTYSET
int sigemptyset __P((sigset_t *set));
#endif /* !HAVE_SIGEMPTYSET */

#if !HAVE_SIGPROCMASK
int sigprocmask __P((int how, sigset_t *set, sigset_t *oset));
#endif /* !HAVE_SIGPROCMASK */

#if !HAVE_STRCHR
char *strchr __P((char *s, int c));
#endif /* !HAVE_STRCHR */

#if !HAVE_STRERROR
char *strerror __P((int errnum));
#endif /* !HAVE_STRERROR */

#if !HAVE_STRNCASECMP
int strncasecmp __P((unsigned char *s1, unsigned char *s2, int n));
#endif /* !HAVE_STRNCASECMP */

#if !HAVE_STRRCHR
char *strrchr __P((char *s, int c));
#endif /* !HAVE_STRRCHR */

#if !HAVE_STRTOUL
unsigned long strtoul __P((const char *nptr, char **endptr, int base));
#endif /* !HAVE_STRTOUL */

#if !HAVE_SYSCONF
long sysconf __P((int name));
#ifndef _SC_OPEN_MAX
#define _SC_OPEN_MAX 1
#endif /* _SC_OPEN_MAX */
#endif /* !HAVE_SYSCONF */

#if !HAVE_UNAME
int uname __P((struct utsname *buf));
#endif /* !HAVE_UNAME */

#endif /* _MISSING_H_ */
