/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: NodeImpl.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hbrinkm $ $Date: 2006/11/01 09:14:34 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/*  Copyright 2005 Sun Microsystems, Inc. */

#include "NodeImpl.hxx"
#include <boost/assert.hpp>

namespace odiapi { namespace core {

    using namespace writerfilter;
    using namespace std;
	using namespace odiapi;

    Node::~Node() {}


	NodeImpl::NodeImpl(writerfilter::QName_t id, props::PropertyPoolHandle_Pointer_t poolHandle, const std::string& text) :
        mId(id),
		mPropertyPoolHandle(poolHandle),
        mText(text),
        mParent(NULL),
        mNext(NULL),
        mPrevious(NULL),
        mNextSibling(NULL),
        mPreviousSibling(NULL),
        mFirstChild(NULL),
        mLastChild(NULL)
    {
		mNext = this;
		mPrevious = this;
		mFirstChild = this;
		mLastChild = this;
    }

    QName_t NodeImpl::getId() const
    {
        return mId;
    }

	props::PropertyPoolHandle_Pointer_t NodeImpl::getProperties() const
	{
		return mPropertyPoolHandle;
	} 

    const string& NodeImpl::getText() const
    {
        return mText;
    }
	
	void NodeImpl::insertSibling(Node::Pointer_t sibling)
    {
        BOOST_ASSERT(sibling.get() && "Precondition violation");
		//BOOST_ASSERT(sibling->getParent() && "Precondition violation: Node must not have a parent");
		
		NodeImpl* psibl = dynamic_cast<NodeImpl*>(sibling.release());

		NodeImpl* lmd = getLeftMostDescendant(psibl);		
		NodeImpl* oldNext = hasNext() ? mNext : NULL;

		mNext = lmd;
		lmd->mPrevious = this;
        
        if (oldNext)
        {
            psibl->mNext = oldNext;
            oldNext->mPrevious = psibl;
        }

		psibl->mParent = mParent;		
        
        BOOST_ASSERT(psibl->mNext != this && psibl->mParent == mParent && "Post condition violation");
    }

	void NodeImpl::appendChildren(Node::Pointer_t children)
    {
        BOOST_ASSERT(children.get() && "Precondition violation");
		//BOOST_ASSERT(children->getParent() && "Precondition violation: Node must not have a parent");

		NodeImpl* pchild = dynamic_cast<NodeImpl*>(children.release());

		if (hasChildren())
		{
			NodeImpl* oldLastChildNext = mLastChild->mNext;
            NodeImpl* lmd = getLeftMostDescendant(pchild);
            mLastChild->mNext = lmd;
            lmd->mPrevious = mLastChild;
            pchild->mNext = oldLastChildNext;
		}
		else // has no children
        {
            mFirstChild = pchild;
            pchild->mNext = this;
        }

        mPrevious = pchild;
        pchild->mParent = this;
        mLastChild = getLastSibling(pchild);
    
        BOOST_ASSERT(mLastChild == children.get() && mLastChild->mNext == this && "Post condition violation");
    }

    bool NodeImpl::hasChildren() const
    {
        return mFirstChild != this;
    }
	
	NodeImpl* NodeImpl::getLeftMostDescendant(NodeImpl* node) const
	{
		while (node->hasPrevious())
		{
			node = node->mPrevious;
		}
		return node;
	}

    NodeImpl* NodeImpl::getLastSibling(NodeImpl* node) const
    {
        NodeImpl* n = NULL;
        while (n->hasNext())
        { 
            n = n->mNext;
            while (n->mParent != node->mParent)
            { 
                n = n->mParent;
            }
        }
        return n;
    }

    bool NodeImpl::hasPrevious() const
    {
        return mPrevious != this;
    }

    const Node& NodeImpl::getPrevious() const
    {
        return *mPrevious;
    }

    bool NodeImpl::hasNext() const
    {
        return mNext != this;
    }

    const Node& NodeImpl::getNext() const
    {
        return *mNext;
    }

    const Node& NodeImpl::getParent() const
    {
        return *mParent;
    }

    const Node& NodeImpl::getFirstChild() const
    {
        return *mFirstChild;
    }

    const Node& NodeImpl::getLastChild() const
    {
        return *mLastChild;
    }

    Node* NodeImpl::getNextSibling() const
    {
        return NULL;
    }

    Node* NodeImpl::getPrevSibling() const
    {
        return NULL;
    }

	Node::Pointer_t createNode(writerfilter::QName_t id, props::PropertyPoolHandle_Pointer_t poolHandle, const std::string& text)
    {
        return Node::Pointer_t(new NodeImpl(id, poolHandle, text));
    }

} } // namespace odiapi { namespace core {
