/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: docdesc.cxx,v $
 *
 *  $Revision: 1.39 $
 *
 *  last change: $Author: hr $ $Date: 2007/09/27 08:34:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"
#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif
#ifndef _SV_VIRDEV_HXX //autogen
#include <vcl/virdev.hxx>
#endif
#ifndef _SVDMODEL_HXX //autogen
#include <svx/svdmodel.hxx>
#endif
#ifndef _SVX_ULSPITEM_HXX //autogen
#include <svx/ulspitem.hxx>
#endif
#ifndef _SVX_LRSPITEM_HXX //autogen
#include <svx/lrspitem.hxx>
#endif
#ifndef _SVX_PAPERINF_HXX //autogen
#include <svx/paperinf.hxx>
#endif
#ifndef _SVX_FRMDIRITEM_HXX
#include "svx/frmdiritem.hxx"
#endif
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _SFXDOCFILE_HXX //autogen
#include <sfx2/docfile.hxx>
#endif
#ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
#include <unotools/localedatawrapper.hxx>
#endif
#ifndef _COM_SUN_STAR_DOCUMENT_PRINTERINDEPENDENTLAYOUT_HPP_
#include <com/sun/star/document/PrinterIndependentLayout.hpp>
#endif
#ifndef _FMTFSIZE_HXX //autogen
#include <fmtfsize.hxx>
#endif
#ifndef _FMTHDFT_HXX //autogen
#include <fmthdft.hxx>
#endif
#ifndef _FMTCNTNT_HXX //autogen
#include <fmtcntnt.hxx>
#endif
#ifndef _FMTPDSC_HXX //autogen
#include <fmtpdsc.hxx>
#endif
#ifndef _FTNINFO_HXX //autogen
#include <ftninfo.hxx>
#endif
#ifndef _FESH_HXX //autogen
#include <fesh.hxx>
#endif
#ifndef _NDOLE_HXX //autogen
#include <ndole.hxx>
#endif
#ifndef _MDIEXP_HXX
#include <mdiexp.hxx>
#endif
#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _DOCARY_HXX
#include <docary.hxx>
#endif
#ifndef _PAGEFRM_HXX
#include <pagefrm.hxx>	//Fuer DelPageDesc
#endif
#ifndef _ROOTFRM_HXX
#include <rootfrm.hxx>	//Fuer DelPageDesc
#endif
#ifndef _NDTXT_HXX
#include <ndtxt.hxx>
#endif
#ifndef _FRMTOOL_HXX
#include <frmtool.hxx>
#endif
#ifndef _PAGEDESC_HXX
#include <pagedesc.hxx>
#endif
#ifndef _POOLFMT_HXX
#include <poolfmt.hxx>
#endif
#ifndef _DOCSH_HXX
#include <docsh.hxx>
#endif
#ifndef _NDINDEX_HXX
#include <ndindex.hxx>
#endif
#ifndef _FTNIDX_HXX
#include <ftnidx.hxx>
#endif
#ifndef _FMTFTN_HXX
#include <fmtftn.hxx>
#endif
#ifndef _TXTFTN_HXX
#include <txtftn.hxx>
#endif
#ifndef _FNTCACHE_HXX
#include <fntcache.hxx>
#endif
#ifndef _VIEWSH_HXX
#include <viewsh.hxx>
#endif
#ifndef _VIEWOPT_HXX
#include <viewopt.hxx>
#endif
#ifndef _FLDBAS_HXX
#include <fldbas.hxx>
#endif
#ifndef _SWWAIT_HXX
#include <swwait.hxx>
#endif
#ifndef _GETMETRICVAL_HXX
#include <GetMetricVal.hxx>
#endif

#ifndef _STATSTR_HRC
#include <statstr.hrc>
#endif

#include <SwUndoPageDesc.hxx>
#include <headerfooterhelper.hxx>

using namespace com::sun::star;

static void lcl_DefaultPageFmt( sal_uInt16 nPoolFmtId,
                                SwFrmFmt &rFmt1,
                                SwFrmFmt &rFmt2 )
{
    // --> FME 2005-01-21 #i41075# Printer on demand
    // This function does not require a printer anymore.
    // The default page size is obtained from the application
    //locale
    // <--

	SwFmtFrmSize aFrmSize( ATT_FIX_SIZE );
    SvxPaper ePaper = SvxPaperInfo::GetDefaultSvxPaper( 
        static_cast<LanguageType>( GetAppLanguage() ) );
    const Size aPhysSize = SvxPaperInfo::GetPaperSize( ePaper );
    aFrmSize.SetSize( aPhysSize );

    //Auf Default-Raender vorbereiten.
    //Raender haben eine defaultmaessige Mindestgroesse.
    //wenn der Drucker einen groesseren Rand vorgibt, so
    //ist mir dass auch recht.
    // MIB 06/25/2002, #99397#: The HTML page desc had A4 as page size
    // always. This has been changed to take the page size from the printer.
    // Unfortunately, the margins of the HTML page desc are smaller than
    // the margins used here in general, so one extra case is required.
    // In the long term, this needs to be changed to always keep the
    // margins from the page desc.
    sal_Int32 nMinTop, nMinBottom, nMinLeft, nMinRight;
    if( RES_POOLPAGE_HTML == nPoolFmtId )
    {
        nMinRight = nMinTop = nMinBottom = GetMetricVal( CM_1 );
        nMinLeft = nMinRight * 2;
    }
    else if( MEASURE_METRIC == GetAppLocaleData().getMeasurementSystemEnum() )
    {
        nMinTop = nMinBottom = nMinLeft = nMinRight = 1134; //2 Zentimeter
    }
    else
    {
        nMinTop = nMinBottom = 1440;    //al la WW: 1Inch
        nMinLeft = nMinRight = 1800;    //          1,25 Inch
    }

    //Raender einstellen.
    SvxLRSpaceItem aLR( RES_LR_SPACE );
    SvxULSpaceItem aUL( RES_UL_SPACE );

    aUL.SetUpper( (USHORT)nMinTop );
    aUL.SetLower( (USHORT)nMinBottom );
    aLR.SetRight( nMinRight );
    aLR.SetLeft( nMinLeft );

	rFmt1.SetAttr( aFrmSize );
	rFmt1.SetAttr( aLR );
	rFmt1.SetAttr( aUL );

    rFmt2.SetAttr( aFrmSize );
	rFmt2.SetAttr( aLR );
	rFmt2.SetAttr( aUL );
}

/*************************************************************************
|*
|*	SwDoc::ChgPageDesc()
|*
|*	Ersterstellung		MA 25. Jan. 93
|*	Letzte Aenderung	MA 01. Mar. 95
|*
|*************************************************************************/

void lcl_DescSetAttr( const SwFrmFmt &rSource, SwFrmFmt &rDest,
						 const BOOL bPage = TRUE )
{
/////////////// !!!!!!!!!!!!!!!!
//JP 03.03.99:
// eigentlich sollte hier das Intersect von ItemSet benutzt werden, aber das
// funktioniert nicht richtig, wenn man unterschiedliche WhichRanges hat.
/////////////// !!!!!!!!!!!!!!!!
	//Die interressanten Attribute uebernehmen.
	USHORT __READONLY_DATA aIdArr[] = { RES_FRM_SIZE, RES_UL_SPACE,
										RES_BACKGROUND, RES_SHADOW,
										RES_COL, RES_COL,
										RES_FRAMEDIR, RES_FRAMEDIR,
                                        RES_TEXTGRID, RES_TEXTGRID,
                                        // --> FME 2005-04-18 #i45539#
                                        RES_HEADER_FOOTER_EAT_SPACING,
                                        RES_HEADER_FOOTER_EAT_SPACING,
                                        // <--
                                        RES_UNKNOWNATR_CONTAINER,
										RES_UNKNOWNATR_CONTAINER,
										0 };

	const SfxPoolItem* pItem;
	for( USHORT n = 0; aIdArr[ n ]; n += 2 )
	{
		for( USHORT nId = aIdArr[ n ]; nId <= aIdArr[ n+1]; ++nId )
		{
            // --> FME 2005-04-18 #i45539#
            // bPage == true:
            // All in aIdArr except from RES_HEADER_FOOTER_EAT_SPACING
            // bPage == false:
            // All in aIdArr except from RES_COL and RES_PAPER_BIN:
            // <--
            if( (  bPage && RES_HEADER_FOOTER_EAT_SPACING != nId ) ||
                ( !bPage && RES_COL != nId && RES_PAPER_BIN != nId ))
			{
				if( SFX_ITEM_SET == rSource.GetItemState( nId, FALSE, &pItem ))
					rDest.SetAttr( *pItem );
				else
					rDest.ResetAttr( nId );
			}
		}
	}

	// auch Pool-, Hilfe-Id's uebertragen
	rDest.SetPoolFmtId( rSource.GetPoolFmtId() );
	rDest.SetPoolHelpId( rSource.GetPoolHelpId() );
	rDest.SetPoolHlpFileId( rSource.GetPoolHlpFileId() );
}


void SwDoc::ChgPageDesc( USHORT i, const SwPageDesc &rChged )
{
	ASSERT( i < aPageDescs.Count(), "PageDescs ueberindiziert." );

	SwPageDesc *pDesc = aPageDescs[i];

    BOOL bDoesUndo = DoesUndo();
    if (DoesUndo())
    {
        AppendUndo(new SwUndoPageDesc(*pDesc, rChged, this));
        DoUndo(FALSE);
    }

	//Als erstes wird ggf. gespiegelt.
	if ( rChged.GetUseOn() == nsUseOnPage::PD_MIRROR )
		((SwPageDesc&)rChged).Mirror();
	else
		//sonst Werte aus Master nach Left uebertragen.
		::lcl_DescSetAttr( ((SwPageDesc&)rChged).GetMaster(),
					   ((SwPageDesc&)rChged).GetLeft() );

    //NumType uebernehmen.
	if( rChged.GetNumType().GetNumberingType() != pDesc->GetNumType().GetNumberingType() )
	{
		pDesc->SetNumType( rChged.GetNumType() );
		// JP 30.03.99: Bug 64121 - den Seitennummernfeldern bescheid sagen,
		//		das sich das Num-Format geaendert hat
		GetSysFldType( RES_PAGENUMBERFLD )->UpdateFlds();
		GetSysFldType( RES_REFPAGEGETFLD )->UpdateFlds();

		// Wenn sich die Numerierungsart geaendert hat, koennte es QuoVadis/
		// ErgoSum-Texte geben, die sich auf eine geaenderte Seite beziehen,
		// deshalb werden die Fussnoten invalidiert
		SwFtnIdxs& rFtnIdxs = GetFtnIdxs();
		for( USHORT nPos = 0; nPos < rFtnIdxs.Count(); ++nPos )
		{
			SwTxtFtn *pTxtFtn = rFtnIdxs[ nPos ];
			const SwFmtFtn &rFtn = pTxtFtn->GetFtn();
			pTxtFtn->SetNumber( rFtn.GetNumber(), &rFtn.GetNumStr());
		}
	}

	//Orientierung uebernehmen
	pDesc->SetLandscape( rChged.GetLandscape() );

    // #i46909# no undo if header or footer changed
    bool bHeaderFooterChanged = false;

	//Header abgleichen.
	const SwFmtHeader &rHead = rChged.GetMaster().GetHeader();
	if( bDoesUndo )
	{
        // #i46909# no undo if header or footer changed
		// hat sich an den Nodes etwas veraendert ?
		const SwFmtHeader &rOldHead = pDesc->GetMaster().GetHeader();
        bHeaderFooterChanged |=
            ( rHead.IsActive() != rOldHead.IsActive() ||
              rChged.IsHeaderShared() != pDesc->IsHeaderShared() );
	}
	pDesc->GetMaster().SetAttr( rHead );
	if ( rChged.IsHeaderShared() || !rHead.IsActive() )
	{
		//Left teilt sich den Header mit dem Master.
		pDesc->GetLeft().SetAttr( pDesc->GetMaster().GetHeader() );
	}
	else if ( rHead.IsActive() )
	{	//Left bekommt einen eigenen Header verpasst wenn das Format nicht
		//bereits einen hat.
		//Wenn er bereits einen hat und dieser auf die gleiche Section
		//wie der Rechte zeigt, so muss er einen eigenen bekommen. Der
		//Inhalt wird sinnigerweise kopiert.
		const SwFmtHeader &rLeftHead = pDesc->GetLeft().GetHeader();
		if ( !rLeftHead.IsActive() )
		{
            SwFmtHeader aHead( MakeLayoutFmt( RND_STD_HEADERL, 0 ) );
			pDesc->GetLeft().SetAttr( aHead );
			//Weitere Attribute (Raender, Umrandung...) uebernehmen.
			::lcl_DescSetAttr( *rHead.GetHeaderFmt(), *aHead.GetHeaderFmt(), FALSE);
		}
		else
		{
			const SwFrmFmt *pRight = rHead.GetHeaderFmt();
			const SwFmtCntnt &aRCnt = pRight->GetCntnt();
			const SwFmtCntnt &aLCnt = rLeftHead.GetHeaderFmt()->GetCntnt();
			if( !aLCnt.GetCntntIdx() )
                pDesc->GetLeft().SetAttr( rChged.GetLeft().GetHeader() );
            else if( (*aRCnt.GetCntntIdx()) == (*aLCnt.GetCntntIdx()) )
			{
				SwFrmFmt *pFmt = new SwFrmFmt( GetAttrPool(), "Header",
												GetDfltFrmFmt() );
				::lcl_DescSetAttr( *pRight, *pFmt, FALSE );
				//Der Bereich auf den das rechte Kopfattribut zeigt wird
				//kopiert und der Index auf den StartNode in das linke
				//Kopfattribut gehaengt.
				SwNodeIndex aTmp( GetNodes().GetEndOfAutotext() );
				SwStartNode* pSttNd = GetNodes().MakeEmptySection( aTmp, SwHeaderStartNode );
				SwNodeRange aRange( aRCnt.GetCntntIdx()->GetNode(), 0,
							*aRCnt.GetCntntIdx()->GetNode().EndOfSectionNode() );
				aTmp = *pSttNd->EndOfSectionNode();
				GetNodes()._Copy( aRange, aTmp, FALSE );

				pFmt->SetAttr( SwFmtCntnt( pSttNd ) );
				pDesc->GetLeft().SetAttr( SwFmtHeader( pFmt ) );
			}
			else
				::lcl_DescSetAttr( *pRight,
							   *(SwFrmFmt*)rLeftHead.GetHeaderFmt(), FALSE );

		}
	}
	pDesc->ChgHeaderShare( rChged.IsHeaderShared() );

	//Footer abgleichen.
	const SwFmtFooter &rFoot = rChged.GetMaster().GetFooter();
	if( bDoesUndo )
	{
        // #i46909# no undo if header or footer changed
		// hat sich an den Nodes etwas veraendert ?
        const SwFmtFooter &rOldFoot = pDesc->GetMaster().GetFooter();
        bHeaderFooterChanged |=
            ( rFoot.IsActive() != rOldFoot.IsActive() ||
              rChged.IsFooterShared() != pDesc->IsFooterShared() );
    }
	pDesc->GetMaster().SetAttr( rFoot );
	if ( rChged.IsFooterShared() || !rFoot.IsActive() )
		//Left teilt sich den Header mit dem Master.
		pDesc->GetLeft().SetAttr( pDesc->GetMaster().GetFooter() );
	else if ( rFoot.IsActive() )
	{	//Left bekommt einen eigenen Footer verpasst wenn das Format nicht
		//bereits einen hat.
		//Wenn er bereits einen hat und dieser auf die gleiche Section
		//wie der Rechte zeigt, so muss er einen eigenen bekommen. Der
		//Inhalt wird sinnigerweise kopiert.
		const SwFmtFooter &rLeftFoot = pDesc->GetLeft().GetFooter();
		if ( !rLeftFoot.IsActive() )
		{
            SwFmtFooter aFoot( MakeLayoutFmt( RND_STD_FOOTER, 0 ) );
			pDesc->GetLeft().SetAttr( aFoot );
			//Weitere Attribute (Raender, Umrandung...) uebernehmen.
			::lcl_DescSetAttr( *rFoot.GetFooterFmt(), *aFoot.GetFooterFmt(), FALSE);
		}
		else
		{
			const SwFrmFmt *pRight = rFoot.GetFooterFmt();
			const SwFmtCntnt &aRCnt = pRight->GetCntnt();
			const SwFmtCntnt &aLCnt = rLeftFoot.GetFooterFmt()->GetCntnt();
			if( !aLCnt.GetCntntIdx() )
                pDesc->GetLeft().SetAttr( rChged.GetLeft().GetFooter() );
			else if( (*aRCnt.GetCntntIdx()) == (*aLCnt.GetCntntIdx()) )
			{
				SwFrmFmt *pFmt = new SwFrmFmt( GetAttrPool(), "Footer",
												GetDfltFrmFmt() );
				::lcl_DescSetAttr( *pRight, *pFmt, FALSE );
				//Der Bereich auf den das rechte Kopfattribut zeigt wird
				//kopiert und der Index auf den StartNode in das linke
				//Kopfattribut gehaengt.
				SwNodeIndex aTmp( GetNodes().GetEndOfAutotext() );
				SwStartNode* pSttNd = GetNodes().MakeEmptySection( aTmp, SwFooterStartNode );
				SwNodeRange aRange( aRCnt.GetCntntIdx()->GetNode(), 0,
							*aRCnt.GetCntntIdx()->GetNode().EndOfSectionNode() );
				aTmp = *pSttNd->EndOfSectionNode();
				GetNodes()._Copy( aRange, aTmp, FALSE );

				pFmt->SetAttr( SwFmtCntnt( pSttNd ) );
				pDesc->GetLeft().SetAttr( SwFmtFooter( pFmt ) );
			}
			else
				::lcl_DescSetAttr( *pRight,
							   *(SwFrmFmt*)rLeftFoot.GetFooterFmt(), FALSE );
		}
	}
	pDesc->ChgFooterShare( rChged.IsFooterShared() );

    // if header/footer nodes are in undo area, copy them into the document
    // #i46909# no undo if header or footer changed
    //    saveHeaderFooterNodes( *pDesc, GetNodes() );

	if ( pDesc->GetName() != rChged.GetName() )
		pDesc->SetName( rChged.GetName() );

	// Dadurch wird ein RegisterChange ausgeloest, wenn notwendig
	pDesc->SetRegisterFmtColl( rChged.GetRegisterFmtColl() );

	//Wenn sich das UseOn oder der Follow aendern muessen die
	//Absaetze das erfahren.
	BOOL bUseOn  = FALSE;
	BOOL bFollow = FALSE;
	if ( pDesc->GetUseOn() != rChged.GetUseOn() )
	{   pDesc->SetUseOn( rChged.GetUseOn() );
		bUseOn = TRUE;
	}
	if ( pDesc->GetFollow() != rChged.GetFollow() )
	{	if ( rChged.GetFollow() == &rChged )
		{	if ( pDesc->GetFollow() != pDesc )
			{	pDesc->SetFollow( pDesc );
				bFollow = TRUE;
			}
		}
		else
		{	pDesc->SetFollow( rChged.pFollow );
			bFollow = TRUE;
		}
	}

	if ( (bUseOn || bFollow) && GetRootFrm() )
		//Layot benachrichtigen!
		GetRootFrm()->CheckPageDescs( (SwPageFrm*)GetRootFrm()->Lower() );

	//Jetzt noch die Seiten-Attribute uebernehmen.
	::lcl_DescSetAttr( rChged.GetMaster(), pDesc->GetMaster() );
	::lcl_DescSetAttr( rChged.GetLeft(), pDesc->GetLeft() );

	//Wenn sich FussnotenInfo veraendert, so werden die Seiten
	//angetriggert.
	if( !(pDesc->GetFtnInfo() == rChged.GetFtnInfo()) )
	{
		pDesc->SetFtnInfo( rChged.GetFtnInfo() );
		SwMsgPoolItem  aInfo( RES_PAGEDESC_FTNINFO );
		{
			SwClientIter aIter( pDesc->GetMaster() );
			for( SwClient* pLast = aIter.First(TYPE(SwFrm)); pLast;
					pLast = aIter.Next() )
				pLast->Modify( &aInfo, 0 );
		}
		{
			SwClientIter aIter( pDesc->GetLeft() );
			for( SwClient* pLast = aIter.First(TYPE(SwFrm)); pLast;
					pLast = aIter.Next() )
				pLast->Modify( &aInfo, 0 );
		}
	}
	SetModified();

    DoUndo(bDoesUndo);

    // #i46909# no undo if header or footer changed
    if( bHeaderFooterChanged )
    {
        ClearRedo();
        DelAllUndoObj();
    }
}

/*************************************************************************
|*
|*	SwDoc::DelPageDesc()
|*
|* 	Beschreibung		Alle Descriptoren, deren Follow auf den zu loeschenden
|*		zeigen muessen angepasst werden.
|*	Ersterstellung		MA 25. Jan. 93
|*	Letzte Aenderung	JP 04.09.95
|*
|*************************************************************************/

void lcl_RemoveFrms( SwFrmFmt& rFmt, BOOL& rbFtnsRemoved )
{
	SwClientIter aIter( rFmt );
	SwFrm *pFrm;
	for( pFrm = (SwFrm*)aIter.First(TYPE(SwFrm)); pFrm;
			pFrm = (SwFrm*)aIter.Next() )
		if ( !rbFtnsRemoved && pFrm->IsPageFrm() &&
				((SwPageFrm*)pFrm)->IsFtnPage() )
		{
            rFmt.getIDocumentLayoutAccess()->GetRootFrm()->RemoveFtns( 0, FALSE, TRUE );
			rbFtnsRemoved = TRUE;
		}
		else
		{
			pFrm->Cut();
			delete pFrm;
		}
}

// #i7983#
void SwDoc::PreDelPageDesc(SwPageDesc * pDel)
{
    if (0 == pDel)
        return;

	SwFmtPageDesc aDfltDesc( aPageDescs[0] );
	SwClientIter aIter( *pDel );
	SwClient* pLast;
	while( 0 != ( pLast = aIter.GoRoot() ))
	{
		if( pLast->ISA( SwFmtPageDesc ) )
		{
			const SwModify* pMod = ((SwFmtPageDesc*)pLast)->GetDefinedIn();
			if ( pMod )
			{
				if( pMod->ISA( SwCntntNode ) )
					((SwCntntNode*)pMod)->SetAttr( aDfltDesc );
				else if( pMod->ISA( SwFmt ))
					((SwFmt*)pMod)->SetAttr( aDfltDesc );
				else
				{
					ASSERT( !this, "was ist das fuer ein Mofify-Obj?" );
					aPageDescs[0]->Add( pLast );
				}
			}
			else	//Es kann noch eine Undo-Kopie existieren
				aPageDescs[0]->Add( pLast );
		}

		BOOL bFtnInf = FALSE;
		if ( TRUE == (bFtnInf = pLast == pFtnInfo->GetPageDescDep()) ||
			 pLast == pEndNoteInfo->GetPageDescDep() )
		{
			aPageDescs[0]->Add( pLast );
			if ( GetRootFrm() )
				GetRootFrm()->CheckFtnPageDescs( !bFtnInf );
		}
	}

	for ( USHORT j = 0; j < aPageDescs.Count(); ++j )
	{
		if ( aPageDescs[j]->GetFollow() == pDel )
		{
			aPageDescs[j]->SetFollow( 0 );
			//Clients des PageDesc sind die Attribute, denen sagen wir bescheid.
			//die Attribute wiederum reichen die Meldung an die Absaetze weiter.

			//Layot benachrichtigen!
			if( GetRootFrm() )  // ist nicht immer vorhanden!! (Orginizer)
				GetRootFrm()->CheckPageDescs( (SwPageFrm*)GetRootFrm()->Lower() );
		}
	}

	if( GetRootFrm() )        // ist nicht immer vorhanden!! (Orginizer)
	{
		//Wenn jetzt noch irgendwelche Seiten auf die FrmFmt'e (Master und Left)
		//Zeigen (z.B. irgendwelche Fussnotenseiten), so muessen die Seiten
		//vernichtet werden.

		// Wenn wir auf Endnotenseiten stossen, schmeissen wir alle Fussnoten weg,
		// anders kann die Reihenfolge der Seiten (FollowsPageDescs usw.)
		// nicht garantiert werden.
		BOOL bFtnsRemoved = FALSE;

		::lcl_RemoveFrms( pDel->GetMaster(), bFtnsRemoved );
		::lcl_RemoveFrms( pDel->GetLeft(), bFtnsRemoved );
	}
}

// #116530#
void SwDoc::BroadcastStyleOperation(String rName, SfxStyleFamily eFamily,
                                    USHORT nOp)
{
    if (pDocShell)
    {
        SfxStyleSheetBasePool * pPool = pDocShell->GetStyleSheetPool();

        if (pPool)
        {
            pPool->SetSearchMask(eFamily, SFXSTYLEBIT_ALL );
            SfxStyleSheetBase * pBase = pPool->Find(rName);

            if (pBase != NULL)
                pPool->Broadcast(SfxStyleSheetHint( nOp, *pBase ));
        }
    }
}

void SwDoc::DelPageDesc( USHORT i, BOOL bBroadcast )
{
	ASSERT( i < aPageDescs.Count(), "PageDescs ueberindiziert." );
	ASSERT( i != 0, "Default Pagedesc loeschen is nicht." );
	if ( i == 0 )
		return;

	SwPageDesc *pDel = aPageDescs[i];

    // -> #116530#
    if (bBroadcast)
        BroadcastStyleOperation(pDel->GetName(), SFX_STYLE_FAMILY_PAGE,
                                SFX_STYLESHEET_ERASED);
    // <- #116530#

    if (DoesUndo())
    {
        AppendUndo(new SwUndoPageDescDelete(*pDel, this));
    }

    PreDelPageDesc(pDel); // #i7983#

	aPageDescs.Remove( i );
	delete pDel;
	SetModified();
}



/*************************************************************************
|*
|*	SwDoc::MakePageDesc()
|*
|*	Ersterstellung		MA 25. Jan. 93
|*	Letzte Aenderung	MA 20. Aug. 93
|*
|*************************************************************************/

USHORT SwDoc::MakePageDesc( const String &rName, const SwPageDesc *pCpy,
                            BOOL bRegardLanguage, BOOL bBroadcast) // #116530#
{
	SwPageDesc *pNew;
	if( pCpy )
	{
		pNew = new SwPageDesc( *pCpy );
		pNew->SetName( rName );
		if( rName != pCpy->GetName() )
		{
			pNew->SetPoolFmtId( USHRT_MAX );
			pNew->SetPoolHelpId( USHRT_MAX );
			pNew->SetPoolHlpFileId( UCHAR_MAX );
		}
	}
	else
	{
		pNew = new SwPageDesc( rName, GetDfltFrmFmt(), this );
		//Default-Seitenformat einstellen.
        lcl_DefaultPageFmt( USHRT_MAX, pNew->GetMaster(), pNew->GetLeft() );

        SvxFrameDirection aFrameDirection = bRegardLanguage ?
            GetDefaultFrameDirection(GetAppLanguage())
            : FRMDIR_HORI_LEFT_TOP;

        pNew->GetMaster().SetAttr( SvxFrameDirectionItem(aFrameDirection, RES_FRAMEDIR) );
        pNew->GetLeft().SetAttr( SvxFrameDirectionItem(aFrameDirection, RES_FRAMEDIR) );
	}
	aPageDescs.Insert( pNew, aPageDescs.Count() );

    // -> #116530#
    if (bBroadcast)
        BroadcastStyleOperation(rName, SFX_STYLE_FAMILY_PAGE,
                                SFX_STYLESHEET_CREATED);
    // <- #116530#

    if (DoesUndo())
        AppendUndo(new SwUndoPageDescCreate(pNew, this));    //  #116530#

	SetModified();
	return (aPageDescs.Count()-1);
}

SwPageDesc* SwDoc::FindPageDescByName( const String& rName, USHORT* pPos ) const
{
	SwPageDesc* pRet = 0;
	if( pPos ) *pPos = USHRT_MAX;

	for( USHORT n = 0, nEnd = aPageDescs.Count(); n < nEnd; ++n )
		if( aPageDescs[ n ]->GetName() == rName )
		{
			pRet = aPageDescs[ n ];
			if( pPos )
				*pPos = n;
			break;
		}
	return pRet;
}

/******************************************************************************
 *  Methode     :   void SwDoc::PrtDataChanged()
 *	Beschreibung:
 *	Erstellt	:	OK 27.10.94 10:20
 *	Aenderung	:	MA 26. Mar. 98
 ******************************************************************************/

void SwDoc::PrtDataChanged()
{
//!!!!!!!! Bei Aenderungen hier bitte ggf. InJobSetup im Sw3io mitpflegen

    // --> FME 2005-01-21 #i41075#
    ASSERT( get(IDocumentSettingAccess::USE_VIRTUAL_DEVICE) ||
            0 != getPrinter( sal_False ), "PrtDataChanged will be called recursive!" )
    // <--

	SwWait *pWait = 0;
	BOOL bEndAction = FALSE;

	if( GetDocShell() )
		GetDocShell()->UpdateFontList();

	BOOL bDraw = TRUE;
	if ( GetRootFrm() )
	{
		ViewShell *pSh = GetRootFrm()->GetCurrShell();
        if( !get(IDocumentSettingAccess::BROWSE_MODE) ||
            ( pSh && pSh->GetViewOptions()->IsPrtFormat() ) )
		{
			if ( GetDocShell() )
				pWait = new SwWait( *GetDocShell(), TRUE );

			GetRootFrm()->StartAllAction();
			bEndAction = TRUE;

			bDraw = FALSE;
			if( pDrawModel )
            {
                pDrawModel->SetAddExtLeading( get(IDocumentSettingAccess::ADD_EXT_LEADING) );
                pDrawModel->SetRefDevice( getReferenceDevice( false ) );
            }

			pFntCache->Flush();
			GetRootFrm()->InvalidateAllCntnt();

			if ( pSh )
			{
				do
                {
                    pSh->InitPrt( pPrt );
					pSh = (ViewShell*)pSh->GetNext();
                }
                while ( pSh != GetRootFrm()->GetCurrShell() );
			}

		}
	}
    if ( bDraw && pDrawModel )
    {
        const sal_Bool bTmpAddExtLeading = get(IDocumentSettingAccess::ADD_EXT_LEADING);
        if ( bTmpAddExtLeading != pDrawModel->IsAddExtLeading() )
            pDrawModel->SetAddExtLeading( bTmpAddExtLeading );

        OutputDevice* pOutDev = getReferenceDevice( false );
        if ( pOutDev != pDrawModel->GetRefDevice() )
            pDrawModel->SetRefDevice( pOutDev );
    }

	PrtOLENotify( TRUE );

	if ( bEndAction )
		GetRootFrm()->EndAllAction();
	delete pWait;
}

//Zur Laufzeit sammeln wir die GlobalNames der Server, die keine
//Benachrichtigung zu Druckerwechseln wuenschen. Dadurch sparen wir
//das Laden vieler Objekte (gluecklicherweise werden obendrein alle
//Fremdobjekte unter einer ID abgebuildet). Init und DeInit vom Array
//ist in init.cxx zu finden.
extern SvPtrarr *pGlobalOLEExcludeList;

void SwDoc::PrtOLENotify( BOOL bAll )
{
	SwFEShell *pShell = 0;
	if ( GetRootFrm() && GetRootFrm()->GetCurrShell() )
	{
		ViewShell *pSh = GetRootFrm()->GetCurrShell();
		if ( !pSh->ISA(SwFEShell) )
			do
			{	pSh = (ViewShell*)pSh->GetNext();
			} while ( !pSh->ISA(SwFEShell) &&
					  pSh != GetRootFrm()->GetCurrShell() );

		if ( pSh->ISA(SwFEShell) )
			pShell = (SwFEShell*)pSh;
	}
	if ( !pShell )
	{
		//Das hat ohne Shell und damit ohne Client keinen Sinn, weil nur darueber
		//die Kommunikation bezueglich der Groessenaenderung implementiert ist.
		//Da wir keine Shell haben, merken wir uns diesen unguenstigen
		//Zustand am Dokument, dies wird dann beim Erzeugen der ersten Shell
		//nachgeholt.
		mbOLEPrtNotifyPending = TRUE;
		if ( bAll )
			mbAllOLENotify = TRUE;
	}
	else
	{
		if ( mbAllOLENotify )
			bAll = TRUE;

		mbOLEPrtNotifyPending = mbAllOLENotify = FALSE;


		SwOLENodes *pNodes = 0;
		SwClientIter aIter( *(SwModify*)GetDfltGrfFmtColl() );
		for( SwCntntNode* pNd = (SwCntntNode*)aIter.First( TYPE( SwCntntNode ) );
			 pNd;
			 pNd = (SwCntntNode*)aIter.Next() )
		{
			SwOLENode *pONd;
			if ( 0 != (pONd = pNd->GetOLENode()) &&
				 (bAll || pONd->IsOLESizeInvalid()) )
			{
				if ( !pNodes  )
					pNodes = new SwOLENodes;
				pNodes->Insert( pONd, pNodes->Count() );
			}
		}

		if ( pNodes )
		{
			::StartProgress( STR_STATSTR_SWGPRTOLENOTIFY,
							 0, pNodes->Count(), GetDocShell());
			GetRootFrm()->StartAllAction();

			for( USHORT i = 0; i < pNodes->Count(); ++i )
			{
				::SetProgressState( i, GetDocShell() );

				SwOLENode* pOLENd = (*pNodes)[i];
				pOLENd->SetOLESizeInvalid( FALSE );

				//Ersteinmal die Infos laden und festellen ob das Teil nicht
				//schon in der Exclude-Liste steht
				SvGlobalName aName;

                svt::EmbeddedObjectRef& xObj = pOLENd->GetOLEObj().GetObject();
                if ( xObj.is() )
                    aName = SvGlobalName( xObj->getClassID() );
                else  //Noch nicht geladen
				{
                        // TODO/LATER: retrieve ClassID of an unloaded object
                        // aName = ????
                }

				BOOL bFound = FALSE;
				for ( USHORT j = 0;
					  j < pGlobalOLEExcludeList->Count() && !bFound;
					  ++j )
				{
					bFound = *(SvGlobalName*)(*pGlobalOLEExcludeList)[j] ==
									aName;
				}
				if ( bFound )
					continue;

				//Kennen wir nicht, also muss das Objekt geladen werden.
				//Wenn es keine Benachrichtigung wuenscht
                if ( xObj.is() )
				{
                    //TODO/LATER: needs MiscStatus for ResizeOnPrinterChange
                    /*
					if ( SVOBJ_MISCSTATUS_RESIZEONPRINTERCHANGE & xRef->GetMiscStatus())
					{
						if ( pOLENd->GetFrm() )
						{
                            xObj->OnDocumentPrinterChanged( pPrt );
                            pShell->CalcAndSetScale( xObj );//Client erzeugen lassen.
						}
						else
							pOLENd->SetOLESizeInvalid( TRUE );
                    }
                    else */
						pGlobalOLEExcludeList->Insert(
                                new SvGlobalName( aName ),
								pGlobalOLEExcludeList->Count() );
				}
			}
			delete pNodes;
			GetRootFrm()->EndAllAction();
			::EndProgress( GetDocShell() );
		}
	}
}

IMPL_LINK( SwDoc, DoUpdateModifiedOLE, Timer *, )
{
	SwFEShell* pSh = (SwFEShell*)GetEditShell();
	if( pSh )
	{
		mbOLEPrtNotifyPending = mbAllOLENotify = FALSE;

		SwOLENodes aOLENodes;
		SwClientIter aIter( *(SwModify*)GetDfltGrfFmtColl() );
		for( SwCntntNode* pNd = (SwCntntNode*)aIter.First( TYPE( SwCntntNode ) );
			 pNd;
			 pNd = (SwCntntNode*)aIter.Next() )
		{
			SwOLENode *pONd = pNd->GetOLENode();
			if( pONd && pONd->IsOLESizeInvalid() )
			{
				aOLENodes.Insert( pONd, aOLENodes.Count() );
			}
		}

		if( aOLENodes.Count() )
		{
			::StartProgress( STR_STATSTR_SWGPRTOLENOTIFY,
							 0, aOLENodes.Count(), GetDocShell());
			GetRootFrm()->StartAllAction();
			SwMsgPoolItem aMsgHint( RES_UPDATE_ATTR );

			for( USHORT i = 0; i < aOLENodes.Count(); ++i )
			{
				::SetProgressState( i, GetDocShell() );

				SwOLENode* pOLENd = aOLENodes[i];
				pOLENd->SetOLESizeInvalid( FALSE );

				//Kennen wir nicht, also muss das Objekt geladen werden.
				//Wenn es keine Benachrichtigung wuenscht
                if( pOLENd->GetOLEObj().GetOleRef().is() ) //Kaputt?
				{
                    //TODO/LATER: needs MiscStatus for ResizeOnPrinterChange
                    /*
					if( SVOBJ_MISCSTATUS_RESIZEONPRINTERCHANGE &
							xRef->GetMiscStatus() )
					{
						if( pOLENd->GetFrm() )
						{
							xRef->OnDocumentPrinterChanged( pPrt );
							pSh->CalcAndSetScale( xRef );//Client erzeugen lassen.
						}
						else
							pOLENd->SetOLESizeInvalid( TRUE );
                    }*/
					// repaint it
					pOLENd->Modify( &aMsgHint, &aMsgHint );
				}
			}
			GetRootFrm()->EndAllAction();
			::EndProgress( GetDocShell() );
		}
	}
	return 0;
}

BOOL SwDoc::FindPageDesc( const String & rName, sal_uInt16 * pFound)
{
    BOOL bResult = FALSE;
    sal_uInt16 nI;
    for (nI = 0; nI < aPageDescs.Count(); nI++)
    {
        if (aPageDescs[nI]->GetName() == rName)
        {
            *pFound = nI;
            bResult = TRUE;
            break;
        }
    }

    return bResult;
}

SwPageDesc * SwDoc::GetPageDesc( const String & rName )
{
    SwPageDesc * aResult = NULL;

    sal_uInt16 nI;

    if (FindPageDesc(rName, &nI))
        aResult = aPageDescs[nI];

    return aResult;
}

void SwDoc::DelPageDesc( const String & rName, BOOL bBroadcast ) // #116530#
{
    sal_uInt16 nI;

    if (FindPageDesc(rName, &nI))
        DelPageDesc(nI, bBroadcast); // #116530#
}

void SwDoc::ChgPageDesc( const String & rName, const SwPageDesc & rDesc)
{
    sal_uInt16 nI;

    if (FindPageDesc(rName, &nI))
        ChgPageDesc(nI, rDesc);
}

/*
 * The HTML import cannot resist changing the page descriptions, I don't
 * know why. This function is meant to check the page descriptors for invalid
 * values.
 */
void SwDoc::CheckDefaultPageFmt()
{
    for ( USHORT i = 0; i < GetPageDescCnt(); ++i )
    {
        SwPageDesc& rDesc = _GetPageDesc( i );

        SwFrmFmt& rMaster = rDesc.GetMaster();
        SwFrmFmt& rLeft   = rDesc.GetLeft();

        const SwFmtFrmSize& rMasterSize  = rMaster.GetFrmSize();
        const SwFmtFrmSize& rLeftSize    = rLeft.GetFrmSize();

        const bool bSetSize = LONG_MAX == rMasterSize.GetWidth() ||
                              LONG_MAX == rMasterSize.GetHeight() ||
                              LONG_MAX == rLeftSize.GetWidth() ||
                              LONG_MAX == rLeftSize.GetHeight();

        if ( bSetSize )
            lcl_DefaultPageFmt( rDesc.GetPoolFmtId(), rDesc.GetMaster(), rDesc.GetLeft() );
    }
}
