/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: FactoryContainer.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2007/04/03 16:10:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SD_FRAMEWORK_FACTORY_CONTAINER_HXX
#define SD_FRAMEWORK_FACTORY_CONTAINER_HXX

#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FRAMEWORK_XMODULECONTROLLER_HPP_
#include <com/sun/star/drawing/framework/XModuleController.hpp>
#endif

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#include <comphelper/stl_types.hxx>
#include <hash_map>

namespace sd { namespace framework {

/** Container for resources of the drawing framework.
*/
class FactoryContainer
{
public:
    FactoryContainer (void);
    ~FactoryContainer (void);

    /** Provide the XModuleController object.
    */
    void SetModuleController (
        const ::com::sun::star::uno::Reference<
            com::sun::star::drawing::framework::XModuleController>& xModuleController);

    /** Register a factory for one type of resource.
        @param rsURL
            The type of the resource that will be created by the factory.
        @param rxFactory
            The factory that will create resource objects of the specfied type.
    */
    void AddFactory (
        const ::rtl::OUString& rsURL,
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::uno::XInterface>& rxFactory)
        throw (::com::sun::star::uno::RuntimeException);

    /** Unregister the specifed factory.
        @param rsURL
            Unregister only the factory for this URL.  When the same factory
            is registered for other URLs then these remain registered.
    */
    void RemoveFactoryForURL(
        const ::rtl::OUString& rsURL)
        throw (::com::sun::star::uno::RuntimeException);

    /** Unregister the specified factory.
        @param rxFactory
            Unregister the this factory for all URLs that it has been
            registered for.
    */
    void RemoveFactoryForReference(
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::uno::XInterface>& rxFactory)
        throw (::com::sun::star::uno::RuntimeException);

    /** Return a factory that can create resources specified by the given URL.
        @param rsURL
            This URL specifies the type of the resource.
        @return
            When a factory for the specified URL has been registered by a
            previous call to AddFactory() then a reference to that factory
            is returned.  Otherwise an empty reference is returned.
    */
    ::com::sun::star::uno::Reference<com::sun::star::uno::XInterface> GetFactory (
        const ::rtl::OUString& rsURL)
        throw (::com::sun::star::uno::RuntimeException);

private:
    ::osl::Mutex maMutex;
    typedef ::std::hash_map<
        ::rtl::OUString,
        ::com::sun::star::uno::Reference<com::sun::star::uno::XInterface>,
        ::comphelper::UStringHash,
        ::comphelper::UStringEqual> FactoryMap;
    FactoryMap maFactoryMap;
    ::com::sun::star::uno::Reference<com::sun::star::drawing::framework::XModuleController>
        mxModuleController;
};


} } // end of namespace sd::framework

#endif
