/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: XMLIndexTOCStylesContext.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2007/06/27 16:00:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _XMLOFF_XMLINDEXTOCSTYLESCONTEXT_HXX_
#define _XMLOFF_XMLINDEXTOCSTYLESCONTEXT_HXX_

#ifndef _XMLOFF_XMLICTXT_HXX 
#include <xmloff/xmlictxt.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_ 
#include <com/sun/star/uno/Reference.h>
#endif

#ifndef __SGI_STL_VECTOR
#include <vector>
#endif


namespace com { namespace sun { namespace star {
	namespace xml { namespace sax { class XAttributeList; } }
	namespace beans { class XPropertySet; }
} } }
namespace rtl {	class OUString; }


/**
 * Import <test:index-source-styles> elements and their children
 *
 * (Small hackery here: Because there's only one type of child
 * elements with only one interesting attribute, we completely handle
 * them inside the CreateChildContext method, rather than creating a
 * new import class for them. This must be changed if children become
 * more complex in future versions.)
 */
class XMLIndexTOCStylesContext : public SvXMLImportContext
{
	const ::rtl::OUString sLevelParagraphStyles;

	/// XPropertySet of the index
	::com::sun::star::uno::Reference<
		::com::sun::star::beans::XPropertySet> & rTOCPropertySet;

	/// style names for this level
	::std::vector< ::rtl::OUString > aStyleNames;

	/// outline level
	sal_Int32 nOutlineLevel;

public:

	TYPEINFO();

	XMLIndexTOCStylesContext(
		SvXMLImport& rImport, 
		::com::sun::star::uno::Reference<
			::com::sun::star::beans::XPropertySet> & rPropSet,
		sal_uInt16 nPrfx,
		const ::rtl::OUString& rLocalName );

	~XMLIndexTOCStylesContext();

protected:

	virtual void StartElement(
		const ::com::sun::star::uno::Reference< 
			::com::sun::star::xml::sax::XAttributeList> & xAttrList);

	virtual void EndElement();

	virtual SvXMLImportContext *CreateChildContext( 
		sal_uInt16 nPrefix,
		const ::rtl::OUString& rLocalName,
		const ::com::sun::star::uno::Reference< 
			::com::sun::star::xml::sax::XAttributeList> & xAttrList );
};

#endif
