/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: _XDrawPageDuplicator.java,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:38:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package ifc.drawing;

import lib.MultiMethodTest;

import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPageDuplicator;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;


/**
* Testing <code>com.sun.star.drawing.XDrawPageDuplicator</code>
* interface methods :
* <ul>
*  <li><code> duplicate()</code></li>
* </ul> <p>
* The object tested <b> must implement </b>
* <code>XDrawPagesSupplier</code> interface to have access to draw
* pages collection. <p>
* Test is <b> NOT </b> multithread compilant. <p>
* After test completion object environment has to be recreated.
* @see com.sun.star.drawing.XDrawPageDuplicator
*/
public class _XDrawPageDuplicator extends MultiMethodTest {
    public XDrawPageDuplicator oObj = null;

    /**
    * First queries object tested for <code>XDrawPagesSupplier</code>
    * interface and obtains one draw page from document. Then it
    * tries to duplicate it.<p>
    * Has <b> OK </b> status if the method returns not null value and
    * this value is not equal to the page which was duplicated. <p>
    */
    public void _duplicate(){
        boolean result = false;
        XInterface testobj = tEnv.getTestObject();
        XDrawPagesSupplier PS = (XDrawPagesSupplier)
            UnoRuntime.queryInterface(XDrawPagesSupplier.class, testobj);
        XDrawPages DPs = PS.getDrawPages();
        XDrawPage DP = null;
        try {
            DP = (XDrawPage) AnyConverter.toObject(
                    new Type(XDrawPage.class),DPs.getByIndex(0));
        } catch (com.sun.star.lang.WrappedTargetException e) {
            log.println("Exception occured while testing: " + e);
        } catch (com.sun.star.lang.IndexOutOfBoundsException e) {
            log.println("Exception occured while testing: " + e);
        } catch (com.sun.star.lang.IllegalArgumentException e) {
            log.println("Exception occured while testing: " + e);
        }

        if (DP != null) {
            XDrawPage newPage = oObj.duplicate(DP);
            result = (newPage != null) && !(newPage.equals(DP));
        }
        tRes.tested("duplicate()", result);
    }

}

