/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: res_ErrorBar.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2007/07/25 08:34:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef CHART2_RES_ERRORBAR_HXX
#define CHART2_RES_ERRORBAR_HXX

// header for class CheckBox
#ifndef _SV_BUTTON_HXX
#include <vcl/button.hxx>
#endif
// header for class FixedLine
#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
// header for class MetricField
#ifndef _SV_FIELD_HXX
#include <vcl/field.hxx>
#endif
// header for class ValueSet
#ifndef _VALUESET_HXX
#include <svtools/valueset.hxx>
#endif
// header for class SfxItemSet
#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif
// header for enum SvxChartKindError
#include "chartview/ChartSfxItemIds.hxx"
#ifndef _SVX_CHRTITEM_HXX
#include <svx/chrtitem.hxx>
#endif

//.............................................................................
namespace chart
{
//.............................................................................

class ErrorBarResources
{
public:
    ErrorBarResources( Window* pParent, const SfxItemSet& rInAttrs );
    virtual ~ErrorBarResources();

    void EnableTrendLine( bool bEnable );
    void SetAxisMinorStepWidthForErrorBarDecimals( double fMinorStepWidth );

    void Reset(const SfxItemSet& rInAttrs);
    BOOL FillItemSet(SfxItemSet& rOutAttrs) const;

    void FillValueSets();
    
private:
    CheckBox        m_aCbxAverage;
    FixedLine       m_aFlErrorCategory;
    RadioButton     m_aRbtNone;
    RadioButton     m_aRbtVariant;
    RadioButton     m_aRbtSigma;
    RadioButton     m_aRbtPercent;
    RadioButton     m_aRbtBigError;
    RadioButton     m_aRbtConst;
    MetricField     m_aMtrFldPercent;
    MetricField     m_aMtrFldBigError;
    FixedText       m_aFTConstPlus;
    MetricField     m_aMtrFldConstPlus;
    FixedText       m_aFTConstMinus;
    MetricField     m_aMtrFldConstMinus;
    FixedText       m_aFTIndicate;
    ValueSet        m_aIndicatorSet;
    FixedText       m_aFTTrendLine;
    ValueSet        m_aTrendLineSet;

    bool                m_bEnableTrendLine;
    SvxChartKindError   m_eErrorKind;
    SvxChartIndicate    m_eIndicate;
    SvxChartRegress     m_eTrendLineType;

    bool                m_bErrorKindUnique;
    bool                m_bIndicatorUnique;
    bool                m_bTrendLineUnique;
    bool                m_bPlusUnique;
    bool                m_bMinusUnique;

    DECL_LINK(RBtnClick, Button *);
    DECL_LINK(SelectIndicate, void *);
    DECL_LINK(SelectTrendLine, void *);
};

//.............................................................................
} //namespace chart
//.............................................................................

#endif
