/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: XMLTextColumnsContext.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 17:26:04 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _XMLTEXTCOLUMNSCONTEXT_HXX
#define _XMLTEXTCOLUMNSCONTEXT_HXX

#ifndef _XMLOFF_XMLELEMENTPROPERTYCONTEXT_HXX
#include "XMLElementPropertyContext.hxx"
#endif


namespace rtl { class OUString; }
namespace binfilter {
class XMLTextColumnsArray_Impl;
class XMLTextColumnSepContext_Impl;
class SvXMLTokenMap;

class XMLTextColumnsContext :public XMLElementPropertyContext
{
	const ::rtl::OUString sSeparatorLineIsOn;
	const ::rtl::OUString sSeparatorLineWidth;
	const ::rtl::OUString sSeparatorLineColor;
	const ::rtl::OUString sSeparatorLineRelativeHeight;
	const ::rtl::OUString sSeparatorLineVerticalAlignment;
	const ::rtl::OUString sIsAutomatic;
	const ::rtl::OUString sAutomaticDistance;


	XMLTextColumnsArray_Impl *pColumns;
	XMLTextColumnSepContext_Impl	 *pColumnSep;
	SvXMLTokenMap	 		 *pColumnAttrTokenMap;
	SvXMLTokenMap	 		 *pColumnSepAttrTokenMap;
	sal_Int16				 nCount;
    sal_Bool                 bAutomatic;
    sal_Int32                nAutomaticDistance;

public:
	TYPEINFO();

	XMLTextColumnsContext(
		SvXMLImport& rImport, sal_uInt16 nPrfx,
		const ::rtl::OUString& rLName,
		const ::com::sun::star::uno::Reference<
			::com::sun::star::xml::sax::XAttributeList > & xAttrList,
		const XMLPropertyState& rProp,
		::std::vector< XMLPropertyState > &rProps );

	virtual ~XMLTextColumnsContext();

	virtual SvXMLImportContext *CreateChildContext( sal_uInt16 nPrefix,
								   const ::rtl::OUString& rLocalName,
								   const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList > & xAttrList );

	virtual void EndElement();
};


}//end of namespace binfilter
#endif
