#!/bin/bash

echo "Rebind USB input devices"

BUSIDS="$(ls -l /sys/class/input/ | grep event | grep xhci-hcd | cut -d "/" -f 10 | sort -u)"
BOARD="$(tr -d '\0' < /proc/device-tree/compatible)"

if [[ $BOARD == *"kd240"* ]]; then
    echo "No need for usb rebind for KD240(Server Image)"
    exit 0
fi

for i in $BUSIDS; do
    if [[ $BOARD == *"kr260"* ]] && [ "$i" == "1-1" ]; then
        # DO NOT re-bind the USB bus to which the internal USB storage is connected
        continue
    fi
    echo "Re-bind /sys/bus/usb/drivers/usb/$i"
    sleep 1
    echo $i > /sys/bus/usb/drivers/usb/unbind
    sleep 1
    echo $i > /sys/bus/usb/drivers/usb/bind
done
