/*******************************************************************************
**3456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789
**      10        20        30        40        50        60        70        80
**
** notify-osd
**
** sd-bubble.h - implements the bubbles for snap-decisions
**
** Copyright 2012 Canonical Ltd.
**
** Authors:
**    Mirco "MacSlow" Mueller <mirco.mueller@canonical.com>
**
** This program is free software: you can redistribute it and/or modify it
** under the terms of the GNU General Public License version 3, as published
** by the Free Software Foundation.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranties of
** MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
** PURPOSE.  See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*******************************************************************************/

#ifndef __SD_BUBBLE_H
#define __SD_BUBBLE_H

#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include "settings.h"

G_BEGIN_DECLS

#define SD_BUBBLE_TYPE             (sd_bubble_get_type ())
#define SD_BUBBLE(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), SD_BUBBLE_TYPE, SdBubble))
#define SD_BUBBLE_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), SD_BUBBLE_TYPE, SdBubbleClass))
#define IS_SD_BUBBLE(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SD_BUBBLE_TYPE))
#define IS_SD_BUBBLE_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), SD_BUBBLE_TYPE))
#define SD_BUBBLE_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), SD_BUBBLE_TYPE, SdBubbleClass))

typedef struct _SdBubble        SdBubble;
typedef struct _SdBubbleClass   SdBubbleClass;
typedef struct _SdBubblePrivate SdBubblePrivate;

typedef enum
{
	SD_BUBBLE_STATE_NONE = 0,
	SD_BUBBLE_STATE_CONTRACTED,
	SD_BUBBLE_STATE_DEFAULT,
	SD_BUBBLE_STATE_EXPANDED
} SdBubbleState;

/* instance structure */
struct _SdBubble
{
	GObject parent;

	/* private */
	SdBubblePrivate* priv;
};

/* class structure */
struct _SdBubbleClass
{
	GObjectClass parent;

	/* signals */
	void (*timed_out) (SdBubble* sd_bubble);
	void (*closed) (SdBubble* sd_bubble);
	void (*state_changed) (SdBubble* sd_bubble);
	void (*focus_changed) (SdBubble* sd_bubble);
};

GType sd_bubble_get_type (void);

SdBubble*
sd_bubble_new (gchar**   actions,
               guint     size,
               Settings* settings);

const gchar*
sd_bubble_get_summary (SdBubble* self);

void
sd_bubble_set_summary (SdBubble* self,
                       gchar*    summary_text);

const gchar*
sd_bubble_get_body (SdBubble* self);

void
sd_bubble_set_body (SdBubble* self,
                    gchar*    body_text);

void
sd_bubble_set_icon_pixbuf (SdBubble*        self,
                           const GdkPixbuf* icon_pixbuf);

gboolean
sd_bubble_set_actions (SdBubble* self,
                       gchar**   actions,
                       guint     size);

guint
sd_bubble_get_num_actions (SdBubble* self);

const gchar*
sd_bubble_get_action_by_index (SdBubble* self,
                               guint     index);

gint
sd_bubble_get_x (SdBubble* self);

gint
sd_bubble_get_y (SdBubble* self);

gint
sd_bubble_get_width (SdBubble* self);

gint
sd_bubble_get_height (SdBubble* self);

gboolean
sd_bubble_set_state (SdBubble*     self,
                     SdBubbleState state);

SdBubbleState
sd_bubble_get_state (SdBubble* self);

gboolean
sd_bubble_set_notification_id (SdBubble* self,
                               guint     notification_id);

guint
sd_bubble_get_notification_id (SdBubble* self);

void
sd_bubble_show (SdBubble* self);

void
sd_bubble_close (SdBubble* self);

void
sd_bubble_move (SdBubble* self,
                gint      x,
                gint      y);

gboolean
sd_bubble_is_visible (SdBubble* self);

gboolean
sd_bubble_is_focused (SdBubble* self);

gboolean
sd_bubble_is_hovered (SdBubble* self);

void
sd_bubble_start_timer (SdBubble* self);

gboolean
sd_bubble_timed_out (SdBubble* self);

void
sd_bubble_set_dbus_sender (SdBubble*    self,
                           const gchar* dbus_sender);

gchar*
sd_bubble_get_dbus_sender (SdBubble* self);

void
sd_bubble_set_button_tint (SdBubble* self,
                           gboolean  uses_tint);

gboolean
sd_bubble_get_button_tint (SdBubble* self);

void
sd_bubble_fade_in (SdBubble* self);

void
sd_bubble_fade_out (SdBubble* self);

G_END_DECLS

#endif /* __SD_BUBBLE_H */
