/*  VER 020   TAB P   $Id: rnews.c,v 1.9 1998/09/21 10:04:29 src Exp $
 *
 *  handle rnews and inews
 *
 *  copyright 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: rnews.c,v $
 *  Revision 1.9  1998/09/21 10:04:29  src
 *  Added new command line options for --inews
 *
 *  Revision 1.8  1998/09/18 07:30:59  src
 *  Implemented --inews
 *
 *  Revision 1.7  1998/09/09 07:32:13  src
 *  Version 1.1
 *
 *  Revision 1.6  1998/09/02 06:50:31  src
 *  newsx version 1.0
 *
 *  Revision 1.5  1998/08/24 07:10:53  src
 *  Removed HAVE_SENDMAIL and HAVE_RNEWS
 */

#include "common.h"
#include "options.h"
#include "proto.h"

/*
 *  initiate rnews or inews pipe
 */
FILE *
open_rnews(int *pidp)
{
    FILE *f;
    progtitle("pipe to rnews");

    log_msg(L_DEBUGMORE,"forking...");
    if (!(f=fork_write(rnews_path, pidp,inews_options,NULL))) {
	log_msg(L_ERR,"can't run %s: %s", rnews_name, rnews_path);
	return 0;
    }
    log_msg(L_DEBUGMORE,"opened %s pipe, pid %d", rnews_name, *pidp);
    return f; /* fix by: per@erix.ericsson.se */
}

/*
 *  close rnews pipe
 *  return true if OK
 */
int 
close_rnews(FILE *f, int pid)
{
    int n;

    fclose(f);
    /* BUG: error check here.. */

    /* wait for child to finish */
    log_msg(L_DEBUGMORE,"wait pid %d...",pid);
    n = wait_pid(pid);
    log_msg(L_DEBUG,"%s status is %d",
			rnews_name, n);
    return n==0;
}
