
#ifndef _CRYPTO_H
#define _CRYPTO_H

#include <stdlib.h>

void md4_vector(size_t num_elem, const unsigned char* addr[], const size_t* len, unsigned char* mac);

void md5_vector(size_t num_elem, const unsigned char* addr[], const size_t* len, unsigned char* mac);

void sha1_vector( size_t num_elem, const unsigned char* addr[], const size_t* len, unsigned char* mac);

void sha1_transform(unsigned char* state, const unsigned char data[64]);

void des_encrypt(const unsigned char* clear, const unsigned char* key, unsigned char* cypher);

void * aes_encrypt_init(const unsigned char* key, size_t len);

void aes_encrypt(void* ctx, const unsigned char* plain, unsigned char* crypt);

void aes_encrypt_deinit(void *ctx);

void * aes_decrypt_init(const unsigned char* key, size_t len);

void aes_decrypt(void *ctx, const unsigned char* crypt, unsigned char* plain);

void aes_decrypt_deinit(void *ctx);

#endif // _CRYPTO_H
