
#include "crypto.h"

#if OPENSSL_VERSION_NUMBER < 0x00907000

#define DES_key_schedule des_key_schedule
#define DES_cblock des_cblock
#define DES_set_key(key, schedule) des_set_key((key), *(schedule))
#define DES_ecb_encrypt(input, output, ks, enc) des_ecb_encrypt((input), (output), *(ks), (enc))

#endif

#ifdef EAP_TLS_FUNCS

void md5_vector(size_t num_elem, const unsigned char *addr[], const size_t *len, unsigned char *mac)
{
	MD5_CTX ctx;
	size_t i;

	MD5_Init(&ctx);
	for (i = 0; i < num_elem; i++)
		MD5_Update(&ctx, addr[i], len[i]);
	MD5_Final(mac, &ctx);
}

void sha1_vector(size_t num_elem, const unsigned char *addr[], const size_t *len, unsigned char *mac)
{
	SHA_CTX ctx;
	size_t i;

	SHA1_Init(&ctx);
	for (i = 0; i < num_elem; i++)
		SHA1_Update(&ctx, addr[i], len[i]);
	SHA1_Final(mac, &ctx);
}

void sha1_transform(unsigned char *state, const unsigned char data[64])
{
	SHA_CTX context;
	memset(&context, 0, sizeof(context));
	memcpy(&context.h0, state, 5 * 4);
	SHA1_Transform(&context, data);
	memcpy(state, &context.h0, 5 * 4);
}

void * aes_encrypt_init(const unsigned char *key, size_t len)
{
	AES_KEY *ak;
	ak = malloc(sizeof(*ak));
	if (ak == NULL)
		return NULL;
	if (AES_set_encrypt_key(key, 8 * len, ak) < 0) {
		free(ak);
		return NULL;
	}
	return ak;
}

void aes_encrypt(void *ctx, const unsigned char *plain, unsigned char *crypt)
{
	AES_encrypt(plain, crypt, ctx);
}

void aes_encrypt_deinit(void *ctx)
{
	free(ctx);
}

void * aes_decrypt_init(const unsigned char *key, size_t len)
{
	AES_KEY *ak;
	ak = malloc(sizeof(*ak));
	if (ak == NULL)
		return NULL;
	if (AES_set_decrypt_key(key, 8 * len, ak) < 0) {
		free(ak);
		return NULL;
	}
	return ak;
}

void aes_decrypt(void *ctx, const unsigned char *crypt, unsigned char *plain)
{
	AES_decrypt(crypt, plain, ctx);
}

void aes_decrypt_deinit(void *ctx)
{
	free(ctx);
}

#endif // EAP_TLS_FUNCS
