#include "XMLOperator.h"
#include "ENMUtil.h"
//#include <wx/wx.h>
#include <wx/dir.h>


#if defined(__WXMSW__)
const wxString XMLOperator::PASSWORDFILEPATH = ENMUtil::GetAllUserAppDataFolder() + wxT("\\Network Neighborhood\\password.xml");
const wxString XMLOperator::POLICYFILEPATH = ENMUtil::GetAllUserAppDataFolder() + wxT("\\Network Neighborhood\\NetworkPolicy.xml");
const wxString XMLOperator::CLIENTFILEPATH = ENMUtil::GetAllUserAppDataFolder() + wxT("\\Network Neighborhood\\ClientInfo.xml");
const wxString XMLOperator::VERSIONFILEPATH = ENMUtil::GetAllUserAppDataFolder() + wxT("\\Network Neighborhood\\VersionInfo.xml");
const wxString XMLOperator::NNFILEPATH = ENMUtil::GetAllUserAppDataFolder() + wxT("\\Network Neighborhood\\");
//const wxString XMLOperator::MESHCONFIGURATIONFILEPATH = ENMUtil::GetAllUserAppDataFolder() + wxT("\\Network Neighborhood\\MeshConfiguation.xml");
#endif

#if defined(__UNIX__)

const wxString XMLOperator::PASSWORDFILEPATH = wxT("/etc/Network Neighborhood/password.xml");
const wxString XMLOperator::POLICYFILEPATH = wxT("/etc/Network Neighborhood/NetworkPolicy.xml");
const wxString XMLOperator::CLIENTFILEPATH =  wxT("/etc/Network Neighborhood/ClientInfo.xml");
const wxString XMLOperator::VERSIONFILEPATH =  wxT("/etc/Network Neighborhood/VersionInfo.xml");
const wxString XMLOperator::NNFILEPATH =  wxT("/etc/Network Neighborhood/");
const wxString XMLOperator::MESHCONFIGURATIONFILEPATH = wxT("MeshConfiguation.xml");

const wxString XMLOperator::SYSTEM_MESH_DIR = wxT("/etc/Network Neighborhood/");
const wxString XMLOperator::USER_MESH_DIR = ENMUtil::GetCurrentUserAppDataFolder() + _T("/Network Neighborhood/");
//const wxChar XMLOperator::PATH_SEPARATOR(_T('/'));
#endif

wxString  XMLOperator::GetNNfilePath()
{
    return NNFILEPATH;
}

 XMLOperator::XMLOperator()
{
    //ctor

}

XMLOperator::~XMLOperator()
{
    //dtor
}
//bool XMLOperator::CheckPasswordfile()
//{
//     wxString filePath = PASSWORDFILEPATH;
//    //create xmlfile
//    TiXmlDocument myDocument(filePath.mb_str( wxConvUTF8 ));
//    if(!myDocument.LoadFile())
//    {
//        return false;
//    }
//
//    return true;
//}
//
//bool  XMLOperator::SetPasswordValue( const wxString &PasswordValue)
//{
//    //load xml file
//    wxString filePath = PASSWORDFILEPATH;
//
//    TiXmlDocument myDocument (filePath.mb_str( wxConvUTF8 ));
//    myDocument.LoadFile();
//
//    //get root element
//    TiXmlElement *RootElement = myDocument.RootElement();
//    if(NULL == RootElement)
//    {
//        return false;
//    }
//    RootElement->SetAttribute(PASSWORDS, PasswordValue.mb_str( wxConvUTF8 ));
//
//    if(!myDocument.SaveFile(filePath.mb_str( wxConvUTF8 )))
//    {
//        return false;
//    }
//
//    return  true;
//}
//bool  XMLOperator::ReadPasswordXmlFile(wxString &password)
//{
//    //load xmlfile
//    wxString filePath = PASSWORDFILEPATH;
//    TiXmlDocument myDocument(filePath.mb_str( wxConvUTF8 ));
//    myDocument.LoadFile();
//
//    //get root element
//    TiXmlElement *RootElement = myDocument.RootElement();
//    if(NULL == RootElement)
//    {
//        return false;
//    }
//    //get password value
//    wxString wxsPassword(RootElement->Attribute(PASSWORDS) , wxConvUTF8);
//    password = wxsPassword;
//    return true;
//}
//bool  XMLOperator::CreatePasswordXmlFile(const wxString &PasswordValue)
//{
//
//    //create xmlfile
//    wxString filePath = PASSWORDFILEPATH;
//    TiXmlDocument myDocument(filePath.mb_str(wxConvUTF8));
//    //create rootelement and link
//    TiXmlElement RootElement(ADMINISTRATOR);
//    RootElement.SetAttribute(PASSWORDS, PasswordValue.mb_str( wxConvUTF8 ));
//    myDocument.InsertEndChild(RootElement);
//
//    //save the file
//    if ( !wxDir::Exists(NNFILEPATH) && !::wxMkdir(NNFILEPATH) )
//        return false;
//    if(!myDocument.SaveFile(filePath.mb_str( wxConvUTF8) ))
//    {
//        return false;
//    }
//    return true;
//
//}
//
//bool  XMLOperator::CreatePolicyXmlFile( PolicyEntity policy)
//{
//     //create xml document
//    TiXmlDocument *myDocument = new TiXmlDocument();
//    if(NULL == myDocument)
//    {
//        return false;
//    }
//
//    TiXmlDeclaration *declaration = new TiXmlDeclaration("1.0","","");
//    if(NULL == declaration)
//    {
//        return false;
//    }
//    myDocument->LinkEndChild(declaration);
//    //create root element
//    TiXmlElement RootElement(POLICY);
//    myDocument->LinkEndChild(&RootElement);
//    //create EnableMesh element
//    TiXmlElement EnableMeshElement(ENABLEMESHNETWORK);
//    EnableMeshElement.SetAttribute(VALUES, policy.GetMeshNetworkPolicy());
//    RootElement.InsertEndChild(EnableMeshElement);
//    //create EnableScan element
//    TiXmlElement EnableScanElement(ENABLENETWORKSCAN);
//    EnableScanElement.SetAttribute(VALUES, policy.GetNetworkScanPolicy());
//    RootElement.InsertEndChild(EnableScanElement);
//    //create AllowProfile element
//    TiXmlElement AllowProfileElement(ALLOWOWNERPROFILE);
//    AllowProfileElement.SetAttribute(VALUES, policy.GetOwnerProfilePolicy());
//    RootElement.InsertEndChild(AllowProfileElement);
//    //create AllowWireless element
//    TiXmlElement AllowWirelessElement(ALLOWTURNONWIRELESS);
//    AllowWirelessElement.SetAttribute(VALUES, policy.GetTurnOnWirelessPolicy());
//    RootElement.InsertEndChild(AllowWirelessElement);
//
//    //save the file
//    if ( !wxDir::Exists(NNFILEPATH) && !::wxMkdir(NNFILEPATH) )
//        return false;
//    wxString filePath = POLICYFILEPATH;
//    if(!myDocument->SaveFile( filePath.mb_str( wxConvUTF8 )))
//    {
//        return false;
//    }
//    return true;
//
//}
//
//bool  XMLOperator::ReadPolicyXmlFile(PolicyEntity &policy)
//{
//
//    //load xml file
//    wxString filePath = POLICYFILEPATH;
//    TiXmlDocument myDocument(filePath.mb_str( wxConvUTF8 ));
//    if(!myDocument.LoadFile())
//    {
//        return false;
//    }
//    //get root element
//    TiXmlElement *RootElement = myDocument.RootElement();
//    if(NULL == RootElement)
//    {
//        return false;
//    }
//
//    TiXmlElement *EnableMeshElement = RootElement->FirstChildElement();
//    if(NULL == EnableMeshElement)
//    {
//        return false;
//    }
//    policy.SetMeshNetworkPolicy(atoi(EnableMeshElement->Attribute(VALUES)));
//
//    TiXmlElement *EnableScanElement = EnableMeshElement->NextSiblingElement();
//    if(NULL == EnableScanElement)
//    {
//        return false;
//    }
//    policy.SetNetworkScanPolicy(atoi(EnableScanElement->Attribute(VALUES)));
//
//    TiXmlElement *AllowProfileElement = EnableScanElement->NextSiblingElement();
//    if(NULL == AllowProfileElement)
//    {
//        return false;
//    }
//    policy.SetOwnerProfilePolicy(atoi(AllowProfileElement->Attribute(VALUES)));
//
//    TiXmlElement *AllowWirelessElement = AllowProfileElement->NextSiblingElement();
//    if(NULL == AllowWirelessElement)
//    {
//        return false;
//    }
//    policy.SetTurnOnWirelessPolicy(atoi(AllowWirelessElement->Attribute(VALUES)));
//
//
//    return true;
//}
//
//bool  XMLOperator::CreateClientInfoXmlFile( ClientPCInfoList clientpcinfolist)
//{
//    //create xml document
//    TiXmlDocument *myDocument = new TiXmlDocument();
//    if(NULL == myDocument)
//    {
//        return false;
//    }
//    //create root element
//    TiXmlElement *RootElement = new TiXmlElement(CLIENTS);
//    myDocument->LinkEndChild(RootElement);
//    Iter iter;
//    for (iter = clientpcinfolist.begin(); iter!= clientpcinfolist.end(); iter++)
//    {
//        //create client element
//        TiXmlElement *ClientElement = new TiXmlElement(CLIENT);
//        ClientElement->SetAttribute(NAMES, (iter->GetStudentName()).mb_str(wxConvUTF8));
//        RootElement->LinkEndChild(ClientElement);
//
//         //create CanConnect element
//        TiXmlElement *CanConnectElement = new TiXmlElement(CANCONNECT);
//        ClientElement->LinkEndChild(CanConnectElement);
//        CanConnectElement->SetAttribute(VALUES, iter->GetConnectStatus());
//
//        //create HaveDeployed element
//        TiXmlElement *HaveDeployedElement = new TiXmlElement(HAVEDEPLOYED);
//        HaveDeployedElement->SetAttribute(VALUES, iter->GetDeployedStatus());
//        ClientElement->LinkEndChild(HaveDeployedElement);
//
//        //create selected element
//        TiXmlElement *SelectedElement = new TiXmlElement(SELECTED);
//        SelectedElement->SetAttribute(VALUES, iter->GetSelectStatus());
//        ClientElement->LinkEndChild(SelectedElement);
//
//        //create IPAddress element
//        TiXmlElement *IPAddressElement = new TiXmlElement(IPADDRESS);
//        IPAddressElement->SetAttribute(VALUES, (iter->GetIPAddress()).mb_str(wxConvUTF8));
//        ClientElement->LinkEndChild(IPAddressElement);
//
//        //create MACAddress element
//        TiXmlElement *MACAddressElement = new TiXmlElement(MACADDRESS);
//        MACAddressElement->SetAttribute(VALUES, (iter->GetMacAddress()).mb_str(wxConvUTF8));
//        ClientElement->LinkEndChild(MACAddressElement);
//
//        //create ProfileVersion element
//        TiXmlElement *ProfileVersionElement = new TiXmlElement(PROFILEVERSION);
//        ProfileVersionElement->SetAttribute(VALUES, (iter->GetProfileVersion()).mb_str(wxConvUTF8));
//        ClientElement->LinkEndChild(ProfileVersionElement);
//
//        //create ServiceName element
//        TiXmlElement *ServiceNameElement = new TiXmlElement("ServiceName");
//        ServiceNameElement->SetAttribute(VALUES, (iter->GetServiceName()).mb_str(wxConvUTF8));
//        ClientElement->LinkEndChild(ServiceNameElement);
//    }
//
//    //save the file
//    if ( !wxDir::Exists(NNFILEPATH) && !::wxMkdir(NNFILEPATH) )
//        return false;
//    wxString filePath = CLIENTFILEPATH;
//    return (myDocument->SaveFile( filePath.mb_str( wxConvUTF8 )));
//
//}
//bool  XMLOperator::ReadClientInfoXmlFile(ClientPCInfoList &clientpcinfolist)
//{
//
//    //load xml file
//    wxString filePath = CLIENTFILEPATH;
//    TiXmlDocument myDocument(filePath.mb_str( wxConvUTF8 ));
//    if(!myDocument.LoadFile())
//    {
//        return false;
//    }
//
//    //get root element
//    TiXmlElement *RootElement = myDocument.RootElement();
//    if(NULL == RootElement)
//    {
//        return false;
//    }
//
//    ClientPCInfo clientpcinfo;
//
//    TiXmlElement* ClientElement = RootElement->FirstChildElement();
//    while(ClientElement)
//    {
//        wxString studentname(ClientElement->Attribute(NAMES), wxConvUTF8);
//        clientpcinfo.SetStudentName(studentname);
//
//        TiXmlElement* CanConnectElement = ClientElement->FirstChildElement();
//        clientpcinfo.SetConnectStatus(atoi(CanConnectElement->Attribute(VALUES)));
//
//        TiXmlElement *HaveDeployedElement = CanConnectElement->NextSiblingElement();
//        clientpcinfo.SetDeployedStatus(atoi(HaveDeployedElement->Attribute(VALUES)));
//
//        TiXmlElement *SelectedElement = HaveDeployedElement->NextSiblingElement();
//        clientpcinfo.SetSelectStatus(atoi(SelectedElement->Attribute(VALUES)));
//
//        TiXmlElement *IPAddressElement = SelectedElement->NextSiblingElement();
//        wxString IPAddress(IPAddressElement->Attribute(VALUES), wxConvUTF8);
//        clientpcinfo.SetIPAddress(IPAddress);
//
//        TiXmlElement *MACAddressElement = IPAddressElement->NextSiblingElement();
//        wxString MacAddress(MACAddressElement->Attribute(VALUES), wxConvUTF8);
//        clientpcinfo.SetMacAddress(MacAddress);
//
//        TiXmlElement *ProfileVersionElement = MACAddressElement->NextSiblingElement();
//        wxString ProfileVersion(ProfileVersionElement->Attribute(VALUES), wxConvUTF8);
//        clientpcinfo.SetProfileVersion(ProfileVersion);
//
//        TiXmlElement *ServiceNameElement = ProfileVersionElement->NextSiblingElement();
//        wxString ServiceName(ServiceNameElement->Attribute(VALUES), wxConvUTF8);
//        clientpcinfo.SetServiceName(ServiceName);
//
//        clientpcinfolist.push_back(clientpcinfo);
//
//        ClientElement = ClientElement->NextSiblingElement();
//    }
//    return true;
//}

 bool  XMLOperator::CreateVersionInfoXmlFile(const wxArrayString& VersionInfo)
{
     //create xml document
    TiXmlDocument *myDocument = new TiXmlDocument();
    if(NULL == myDocument)
    {
        return false;
    }
    //create root element
    TiXmlElement *RootElement = new TiXmlElement(VERSIONINFO);
    myDocument->LinkEndChild(RootElement);
    RootElement->SetAttribute(VERSION, (VersionInfo.Item(0)).mb_str(wxConvUTF8));
    /*create File elements*/
    for(size_t i = 1; i < VersionInfo.GetCount(); i++)
    {
        TiXmlElement *FileElement = new TiXmlElement(FILES);
        RootElement->LinkEndChild(FileElement);
        FileElement->SetAttribute(NAMES,(VersionInfo.Item(i)).mb_str(wxConvUTF8));
    }
    /*save the file*/
    if ( !wxDir::Exists(NNFILEPATH) && !::wxMkdir(NNFILEPATH) )
        return false;
    wxString filePath = VERSIONFILEPATH;
    return (myDocument->SaveFile( filePath.mb_str( wxConvUTF8 )));
}

bool   XMLOperator::ReadVersionInfoXmlFile(wxArrayString &VersionInfo)
{
    //load xml file
    wxString filePath = VERSIONFILEPATH;
    TiXmlDocument myDocument(filePath.mb_str( wxConvUTF8 ));
    if(!myDocument.LoadFile())
    {
        return false;
    }
     //get root element
    TiXmlElement *RootElement = myDocument.RootElement();
    if(NULL == RootElement)
    {
        return false;
    }

    wxString version(RootElement->Attribute(VERSION), wxConvUTF8);
    VersionInfo.Add(version);

    TiXmlElement* FileElement = RootElement->FirstChildElement();
    while(FileElement)
    {
        wxString filename(FileElement->Attribute(NAMES), wxConvUTF8);
        VersionInfo.Add(filename);
        FileElement = FileElement->NextSiblingElement();
    }
    return true;
}



/*=================================================================
 Function Name  : XMLOperator::CreateMeshLocalHostNameXmlFile
 Description    : Create mesh local host name file
 Date           : 2008-9-16 16:28:53
 Parameter      : const wxString &strMeshLocalHostName
 Return Code    : bool
 Author         : liyang
 =================================================================*/
bool  XMLOperator::CreateMeshConfigurationXmlFile(MeshConfigurationEntity &meshConfiguration)
{
    //create xml document
    TiXmlDocument *myDocument = new TiXmlDocument();
    if (NULL == myDocument)
    {
        return false;
    }

    TiXmlDeclaration *declaration = new TiXmlDeclaration("1.0","","");
    if (NULL == declaration)
    {
        return false;
    }
    myDocument->LinkEndChild(declaration);
    //create root element
    TiXmlElement RootElement("Mesh");
    myDocument->LinkEndChild(&RootElement);
    //
    TiXmlElement MeshLocalHostNameElement(MESH_LOCAL_HOST_NAME);
    MeshLocalHostNameElement.SetAttribute(VALUES, meshConfiguration.GetMeshLocalHostName().mb_str(wxConvUTF8));
    RootElement.InsertEndChild(MeshLocalHostNameElement);

    //create EnableScan element
    TiXmlElement MeshChannelElement(MESH_CHANNEL);
    MeshChannelElement.SetAttribute(VALUES, meshConfiguration.GetMeshChannel());
    RootElement.InsertEndChild(MeshChannelElement);
    //create AllowProfile element
    TiXmlElement MeshAdvertiseTimeElement(MESH_ADVERTISE_TIME);
    MeshAdvertiseTimeElement.SetAttribute(VALUES, meshConfiguration.GetMeshAdvertiseTime());
    RootElement.InsertEndChild(MeshAdvertiseTimeElement);


    //save the file
    bool isAdminUser = ENMUtil::IsAdministrator();
    wxString filePath;
    if (isAdminUser)
    {
        filePath = SYSTEM_MESH_DIR;
    }
    else
    {
        filePath = USER_MESH_DIR;
    }
    if ( !wxDir::Exists(filePath) && !::wxMkdir(filePath) )
        return false;
    //make file writable
    //SetFileWritable(filePath);

    //if (!myDocument->SaveFile( filePath.mb_str( wxConvUTF8 )))
    //MESHCONFIGURATIONFILEPATH
    if (!myDocument->SaveFile( (filePath + MESHCONFIGURATIONFILEPATH).mb_str( wxConvUTF8 )))
    {
        return false;
    }
    return true;

}


/*=================================================================
 Function Name  : XMLOperator::ReadMeshLocalHostNameXmlFile
 Description    : Read mesh local host name from file
 Date           : 2008-9-16 16:28:47
 Parameter      : wxString &strMeshLocalHostName
 Return Code    : bool
 Author         : liyang
 =================================================================*/
bool  XMLOperator::ReadMeshConfigurationXmlFile(MeshConfigurationEntity &meshConfiguration)
{
    //load xml file

    bool isAdminUser = ENMUtil::IsAdministrator();

    wxString filePath;
    if (isAdminUser)
    {

        filePath = SYSTEM_MESH_DIR;

        //printf("%s\n",filePath.mb_str(wxConvUTF8));
    }
    else
    {

        filePath = USER_MESH_DIR;
    }


    TiXmlDocument myDocument((filePath + MESHCONFIGURATIONFILEPATH).mb_str( wxConvUTF8 ));

    if (!myDocument.LoadFile())
    {

        return false;
    }

    //make file writable
//    SetFileWritable(filePath);

    //get root element
    TiXmlElement *RootElement = myDocument.RootElement();
    if (NULL == RootElement)
    {

        return false;
    }

    //read MeshLocalHostName element
    TiXmlElement *MeshLocalHostNameElement = RootElement->FirstChildElement();
    if (NULL == MeshLocalHostNameElement)
    {
        return false;
    }

    wxString wxStr(MeshLocalHostNameElement->Attribute(VALUES),wxConvUTF8);


    meshConfiguration.SetMeshLocalHostName(wxStr);


    //read EnableScan element
    TiXmlElement *MeshChannelElement = MeshLocalHostNameElement->NextSiblingElement();
    if (NULL == MeshChannelElement)
    {
        return false;
    }

    int iMeshChannel = atoi(MeshChannelElement->Attribute(VALUES));

    meshConfiguration.SetMeshChannel(iMeshChannel);

   TiXmlElement *MeshAdvertiseTimeElement = MeshChannelElement->NextSiblingElement();
    if (NULL == MeshAdvertiseTimeElement)
    {
        return false;
    }

    int iMeshAdvertiseTime = atoi(MeshAdvertiseTimeElement->Attribute(VALUES));

    meshConfiguration.SetMeshAdvertiseTime(iMeshAdvertiseTime);

    return true;
}
