#ifndef WIRELESSSCANNER_H_INCLUDED
#define WIRELESSSCANNER_H_INCLUDED

#include "WlanScanner.h"
#if defined(__UNIX__)
#include <net/if.h>
#endif
#include <wx/timer.h>
#include "ScanEvent.h"
#include "ScanAPThread.h"
class SearchThread;
class WirelessScanner : public WlanScanner
{
    public:
        WirelessScanner();
        ~WirelessScanner();
        #if defined(__UNIX__)
        int ScanWireless();
        void GetInterface();
        int OpenSockets();
        int GetExt(int skfd,char* ifname,int request,struct iwreq* pwrq);
        void ParseFile(AccessPointList* pList);
        void ParseConfFile();
        void GetConnect(APStatus* ap);
        void GetIfname();
        void AllocateIP();
        bool IfConnect();
        struct ifconf ifc;
        char name[IFNAMSIZ];
        SearchThread *m_pThread;
        ScanAPThread* m_scanThread;
        bool UpdateCurrentAP(APStatus& apStatus);
        WlanResult ConnectWlanNetwork(const APStatus& ap, const wxString key = wxT(""),const wxString usingAdpterName = wxT(""));
        SearchThread* CreateSearchThread();
        AccessPointList* m_pAPList;
        void ScanOver(ScanEvent& event);
        #endif
        DECLARE_EVENT_TABLE()
};

#endif // WIRELESSSCANNER_H_INCLUDED
