#include "TaskBarBalloon.h"
#include <wx/msgdlg.h>
#include "ENMApp.h"
#include "CustomStaticText.h"
#if defined(__WXMSW__)
#include <windows.h>
#endif

#include "ENMUtil.h"

const long TaskBarBalloon::ID_STATICTEXT_SUCCTIP = wxNewId();
const long TaskBarBalloon::ID_STATICTEXT_TYPETIP = wxNewId();
const long TaskBarBalloon::ID_STATICTEXT_TYPE = wxNewId();
const long TaskBarBalloon::ID_STATICTEXT_SPEEDTIP = wxNewId();
const long TaskBarBalloon::ID_STATICTEXT_SPEED = wxNewId();
const long TaskBarBalloon::ID_STATICTEXT_STATUSTIP = wxNewId();
const long TaskBarBalloon::ID_STATICTEXT_STATUS = wxNewId();
const long TaskBarBalloon::ID_STATICTEXT_SIGNALQUALITYTIP = wxNewId();
const long TaskBarBalloon::ID_STATICBITMAP_SIGNALQUALITY = wxNewId();
const long TaskBarBalloon::ID_STATICTEXT_SIGNALQUALITY = wxNewId();
//const long TaskBarBalloon::ID_BTN_CLOSE = wxNewId();
const int WIDTH = 270;
const int HEIGHT = 180;

BEGIN_EVENT_TABLE(TaskBarBalloon, wxBitmapDialog)
//    EVT_BUTTON(ID_BTN_CLOSE, TaskBarBalloon::OnButtonClick)
END_EVENT_TABLE()

#if defined(__UNIX__)
TaskBarBalloon::TaskBarBalloon(wxBitmapDialog *dlg, const wxString &title)
    : wxBitmapDialog(wxBitmap(::wxGetApp().strAppPath + _T("pic/balloon.png"),wxBITMAP_TYPE_PNG),(wxWindow*)dlg, (wxWindowID)wxID_ANY, wxEmptyString)
{
    m_SuccTip = new CustomStaticText(this, ID_STATICTEXT_SUCCTIP, _T(""), wxPoint(35,18), wxSize(200,14), 0, _T("ID_STATICTEXT_SUCCTIP"));
	m_SuccTip->SetForegroundColour(wxColor(0, 0, 255));
	wxFont StaticText1Font(11, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_SuccTip->SetFont(StaticText1Font);
	m_TypeTip = new CustomStaticText(this, ID_STATICTEXT_TYPETIP, _("Type:"), wxPoint(35,72), wxSize(90,14), 0, _T("ID_STATICTEXT_TYPETIP"));
	m_Type = new CustomStaticText(this, ID_STATICTEXT_TYPE, _T(""), wxPoint(150,72), wxSize(96,14), 0, _T("ID_STATICTEXT_TYPE"));
	m_SpeedTip = new CustomStaticText(this, ID_STATICTEXT_SPEEDTIP, _("Speed:"), wxPoint(35,96), wxSize(90,14), 0, _T("ID_STATICTEXT_SPEEDTIP"));
	m_Speed = new CustomStaticText(this, ID_STATICTEXT_SPEED, _T(""), wxPoint(150,96), wxSize(88,14), 0, _T("ID_STATICTEXT_SPEED"));
	m_StatusTip = new CustomStaticText(this, ID_STATICTEXT_STATUSTIP, _("Name:"), wxPoint(35,48), wxSize(90,14), 0, _T("ID_STATICTEXT_STATUSTIP"));
	m_Status = new CustomStaticText(this, ID_STATICTEXT_STATUS, _T(""), wxPoint(150,48), wxSize(88,14), 0, _T("ID_STATICTEXT_STATUS"));
	m_SignalQualityTip = new CustomStaticText(this, ID_STATICTEXT_SIGNALQUALITYTIP, _("Signal Quality:"), wxPoint(35,125), wxSize(90,14), 0, _T("ID_STATICTEXT_SIGNALQUALITYTIP"));
	m_bmpSignalQuality = new wxStaticBitmap(this, ID_STATICBITMAP_SIGNALQUALITY, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/empty.png"))), wxPoint(150,120), wxDefaultSize, 0, _T("ID_STATICBITMAP_SIGNALQUALITY"));
	m_SignalQuality = new CustomStaticText(this, ID_STATICTEXT_SIGNALQUALITY, _T(""), wxPoint(220,128), wxDefaultSize, 0, _T("ID_STATICTEXT_SIGNALQUALITY"));

	this->Center();

    const int miniLap = 15;
    wxRect clientRect = ::wxGetClientDisplayRect();
    wxPoint finalPos = wxPoint(clientRect.width - WIDTH - miniLap + clientRect.x, miniLap + clientRect.y);
    this->Move(finalPos);
}
#endif

#if defined(__WXMSW__)
TaskBarBalloon::TaskBarBalloon(wxBitmapDialog *dlg, const wxString &title)
    : wxBitmapDialog(wxBitmap(::wxGetApp().strAppPath + _T("pic\\balloon.png"),wxBITMAP_TYPE_PNG),(wxWindow*)dlg, (wxWindowID)wxID_ANY, wxEmptyString)
{
    m_SuccTip = new CustomStaticText(this, ID_STATICTEXT_SUCCTIP, _T(""), wxPoint(35,18), wxSize(200,14), 0, _T("ID_STATICTEXT_SUCCTIP"));
	m_SuccTip->SetForegroundColour(wxColor(0, 0, 255));
	wxFont StaticText1Font(11, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_SuccTip->SetFont(StaticText1Font);
	m_TypeTip = new CustomStaticText(this, ID_STATICTEXT_TYPETIP, _("Type:"), wxPoint(35,72), wxSize(90,14), 0, _T("ID_STATICTEXT_TYPETIP"));
	m_Type = new CustomStaticText(this, ID_STATICTEXT_TYPE, _T(""), wxPoint(150,72), wxSize(96,14), 0, _T("ID_STATICTEXT_TYPE"));
	m_SpeedTip = new CustomStaticText(this, ID_STATICTEXT_SPEEDTIP, _("Speed:"), wxPoint(35,96), wxSize(90,14), 0, _T("ID_STATICTEXT_SPEEDTIP"));
	m_Speed = new CustomStaticText(this, ID_STATICTEXT_SPEED, _T(""), wxPoint(150,96), wxSize(88,14), 0, _T("ID_STATICTEXT_SPEED"));
	m_StatusTip = new CustomStaticText(this, ID_STATICTEXT_STATUSTIP, _("Name:"), wxPoint(35,48), wxSize(90,14), 0, _T("ID_STATICTEXT_STATUSTIP"));
	m_Status = new CustomStaticText(this, ID_STATICTEXT_STATUS, _T(""), wxPoint(150,48), wxSize(88,14), 0, _T("ID_STATICTEXT_STATUS"));
	m_SignalQualityTip = new CustomStaticText(this, ID_STATICTEXT_SIGNALQUALITYTIP, _("Signal Quality:"), wxPoint(35,125), wxSize(90,14), 0, _T("ID_STATICTEXT_SIGNALQUALITYTIP"));
	m_bmpSignalQuality = new wxStaticBitmap(this, ID_STATICBITMAP_SIGNALQUALITY, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\empty.png"))), wxPoint(150,120), wxDefaultSize, 0, _T("ID_STATICBITMAP_SIGNALQUALITY"));
	m_SignalQuality = new CustomStaticText(this, ID_STATICTEXT_SIGNALQUALITY, _T(""), wxPoint(220,128), wxDefaultSize, 0, _T("ID_STATICTEXT_SIGNALQUALITY"));

	this->Center();

	const int miniLap = 15;
    wxRect clientRect = ::wxGetClientDisplayRect();
    wxPoint finalPos = wxPoint(clientRect.width - WIDTH - miniLap + clientRect.x, clientRect.height - HEIGHT - miniLap + clientRect.y);

    this->Move(finalPos);

    SetWindowLong((HWND)this->m_hWnd, GWL_EXSTYLE, WS_EX_TOOLWINDOW | WS_EX_DLGMODALFRAME);
}
#endif


void TaskBarBalloon::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);

    int iWidth = 0, iHeight = 0;
    this->GetClientSize( &iWidth, &iHeight );

    wxPen pen(this->GetForegroundColour());
    dc.SetPen(pen);

    wxBrush brush(this->GetBackgroundColour());
    dc.SetBrush(brush);

    dc.Clear();
    dc.DrawRectangle(0,0,iWidth,iHeight);
}

/** showing frame and running timer */
void TaskBarBalloon::showBalloon()
{
    this->Show(false);
    this->Show(true);
    //this->timer->Start(iTimeout,wxTIMER_ONE_SHOT);
}

void TaskBarBalloon::OnClick(wxMouseEvent&)
{
}

void TaskBarBalloon::SetConnectionTip(wxString wxsSuccTip)
{
    m_SuccTip->SetLabel(wxsSuccTip);

}

void TaskBarBalloon::SetConnectionType(wxString wxsType)
{
    m_Type->SetLabel(wxsType);
}

void TaskBarBalloon::SetConnectionSpeed(wxString wxsSpeed)
{
    m_Speed->SetLabel(wxsSpeed);
}

void TaskBarBalloon::SetConnectionStatus(wxString wxsStatus)
{
    m_Status->SetLabel(wxsStatus);
}

void TaskBarBalloon::SetSignalQuality(int iSignalQuality)
{
    m_SignalQuality->SetLabel(wxString::Format(_T("%d"), iSignalQuality) + _T("%"));
}

void TaskBarBalloon::SetSignalQualityBmp(int iSignalQuality)
{
    if ( iSignalQuality < 0 )
    {
        iSignalQuality = (-iSignalQuality) % 100;
    }

    if ( 0 == iSignalQuality )
    {
        #if defined(__UNIX__)
        m_bmpSignalQuality->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/signal-0.png"))));
        #endif

        #if defined(__WXMSW__)
        m_bmpSignalQuality->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\signal-0.png"))));
        #endif
    }
    else if ( (0 < iSignalQuality) && (iSignalQuality <= 20) )
    {
        #if defined(__UNIX__)
        m_bmpSignalQuality->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/signal-20.png"))));
        #endif

        #if defined(__WXMSW__)
        m_bmpSignalQuality->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\signal-20.png"))));
        #endif
    }
    else if ( (20 < iSignalQuality) && (iSignalQuality <= 40) )
    {
        #if defined(__UNIX__)
        m_bmpSignalQuality->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/signal-40.png"))));
        #endif

        #if defined(__WXMSW__)
        m_bmpSignalQuality->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\signal-40.png"))));
        #endif
    }
    else if ( (40 < iSignalQuality) && (iSignalQuality <= 60) )
    {
        #if defined(__UNIX__)
        m_bmpSignalQuality->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/signal-60.png"))));
        #endif

        #if defined(__WXMSW__)
        m_bmpSignalQuality->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\signal-60.png"))));
        #endif
    }
    else if ( (60 < iSignalQuality) && (iSignalQuality <= 80) )
    {
        #if defined(__UNIX__)
        m_bmpSignalQuality->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/signal-80.png"))));
        #endif

        #if defined(__WXMSW__)
        m_bmpSignalQuality->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\signal-80.png"))));
        #endif
    }
    else if ( (80 < iSignalQuality) && (iSignalQuality <= 100) )
    {
        #if defined(__UNIX__)
        m_bmpSignalQuality->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/signal-100.png"))));
        #endif

        #if defined(__WXMSW__)
        m_bmpSignalQuality->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\signal-100.png"))));
        #endif
    }
}

