#ifndef _SCHOOL_SETTING_IMPORTER_H_
#define _SCHOOL_SETTING_IMPORTER_H_

#include <wx/event.h>

class SchoolSettingImporter : public wxEvtHandler
{
    public:
        SchoolSettingImporter();
        virtual ~SchoolSettingImporter();

        bool ImportSchoolSetting(const wxString& strTarFile, wxArrayString* pasFailed);
        bool LoadSchoolSetting(const wxString& strTarFile, wxArrayString* pasFailed);
        bool CheckServerCertification(wxString strImportDir);
    protected:
        static const wxString destDir;
        wxString m_strTempDir;
        long m_iCount;

        void ClearTempDir(const wxString& dir);
        int ConfirmOverwrite(const wxString& strFileName);

    DECLARE_EVENT_TABLE()
};

#endif // _SCHOOL_SETTING_IMPORTER_H_
