
#include "SchoolSettingImporter.h"
#include "FileTar.h"
#include <wx/filename.h>
#include <wx/dir.h>
#include <wx/msgdlg.h>
#include <wx/timer.h>

#if defined(__WXMSW__)
#include <ENM/ENMApi.h>
//#include "applink.c"
#else
#include <sdk/ENMApi.h>
#include <ENMDef.h>
#endif
#include "ENMUtil.h"
#include "verify.h"
#if defined(__WXMSW__)
const wxString SchoolSettingImporter::destDir = _T("C:\\Documents and Settings\\Default User\\Application Data\\Network Neighborhood");
#else
const wxString SchoolSettingImporter::destDir = _T("/etc/Network Neighborhood");
#endif

static wxString dcLogimporter(_T("C:\\SchoolSettingImporter.log"));

BEGIN_EVENT_TABLE(SchoolSettingImporter, wxEvtHandler)
END_EVENT_TABLE()

SchoolSettingImporter::SchoolSettingImporter()
        : wxEvtHandler(), m_iCount(::wxGetUTCTime())
{
    m_strTempDir = wxFileName::GetTempDir() + wxFileName::GetPathSeparator() + _T("enm");
    wxFileName::Mkdir(m_strTempDir, 0755, wxPATH_MKDIR_FULL);
}

SchoolSettingImporter::~SchoolSettingImporter()
{
    ClearTempDir(m_strTempDir);
}

void SchoolSettingImporter::ClearTempDir(const wxString& dir)
{
    if ( !wxFileName::DirExists(dir) )
        return;

    // remove all files
    wxArrayString as;
    size_t nCount = wxDir::GetAllFiles(dir, &as, wxEmptyString, wxDIR_FILES);
    if ( nCount != (size_t)-1 )
    {
        for ( size_t i = 0; i < nCount; i++ )
        {
            ::wxRemoveFile(as.Item(i));
        }
    }

    // remove all subdirectories
    wxDir tempDir(dir);
    wxString subDir;
    bool found = tempDir.GetFirst(&subDir, wxEmptyString, wxDIR_DIRS);
    while ( found )
    {
        ClearTempDir(dir + wxFileName::GetPathSeparator() + subDir);
        found = tempDir.GetNext(&subDir);
    }

    // remove this directory
    wxFileName::Rmdir(dir);
}

int SchoolSettingImporter::ConfirmOverwrite(const wxString& strFileName)
{
    wxString suffix(_T(".profile"));
    if ( strFileName.Find(suffix) + suffix.Length() != strFileName.Length() )
        return wxID_YES;

    wxString message = strFileName + _(" already exists. \n\nAre you sure you want to overwrite it?");
    wxMessageDialog dlg(NULL, message, _("Confirm"), wxYES_NO | wxNO_DEFAULT | wxICON_EXCLAMATION);
    return dlg.ShowModal();
}

bool SchoolSettingImporter::ImportSchoolSetting(const wxString& strTarFile, wxArrayString* pasFailed)
{
    bool result = false;
    // depress the tar file to a temp directory
    wxString strImportDir = m_strTempDir + wxFileName::GetPathSeparator() + wxString::Format(_T("%d"), m_iCount++);
    wxString strDirWithSep = strImportDir + wxFileName::GetPathSeparator();
    wxFileName::Mkdir(strImportDir, 0755, wxPATH_MKDIR_FULL);
    if ( FileTar::UnTar(strTarFile, strDirWithSep) == 0 )
    {
        if(!CheckServerCertification(strImportDir))
            return true;
        result = true;
        // copy files from temp directory to the directory of global profiles
        wxArrayString as;
        wxDir::GetAllFiles(strImportDir, &as, wxEmptyString, wxDIR_FILES);
        for ( size_t i = 0; i < as.Count(); i++ )
        {
            wxString name, ext;
            wxFileName::SplitPath(as.Item(i), NULL, NULL, &name, &ext);
            wxString file = name + _T(".") + ext;
            if ( !wxFileName::FileExists(destDir + wxFileName::GetPathSeparator() + file) || ConfirmOverwrite(file) == wxID_YES )
            {
                ENM_String srcFile;
                memset(&srcFile, 0, sizeof(ENM_String));
                strcpy((char*)srcFile.dcsString, wxConvFileName->cWC2MB(wxConvLocal.cWX2WC(as.Item(i).c_str())));
                DCS_Return_Code dcsRet = DCS_WriteFile(&srcFile);
                if ( dcsRet != DCS_SUCCESS )
                {
                    result = false;
                    if ( pasFailed != NULL )
                        pasFailed->Add(file);
                }
//                result &= ::wxCopyFile(as.Item(i), destDir + wxFileName::GetPathSeparator() + file, true);
            }
        }
    }
    ClearTempDir(strImportDir);
    return result;
}
bool SchoolSettingImporter::LoadSchoolSetting(const wxString& strTarFile, wxArrayString* pasFailed)
{
//    wxMessageBox(m_strTempDir);
    bool result = false;
    // depress the tar file to a temp directory
    wxString strImportDir = m_strTempDir + wxFileName::GetPathSeparator() + wxString::Format(_T("%d"), m_iCount++);
    wxString strDirWithSep = strImportDir + wxFileName::GetPathSeparator();
    wxFileName::Mkdir(strImportDir, 0755, wxPATH_MKDIR_FULL);
//    const char *c1 = wxConvFileName->cWC2MB(wxConvLocal.cWX2WC(strTarFile.c_str()));
//    const char *c2 = wxConvFileName->cWC2MB(wxConvLocal.cWX2WC(strDirWithSep.c_str()));
//    if ( CFileTar::UnTar(wxConvFileName->cWC2MB(wxConvLocal.cWX2WC(strTarFile.c_str())), wxConvFileName->cWC2MB(wxConvLocal.cWX2WC(strDirWithSep.c_str()))) == 0 )
    printf("LoadSchoolSetting\n");
    if ( FileTar::UnTar(strTarFile, strDirWithSep) == 0 )
    {
        if(!CheckServerCertification(strImportDir))
            return true;
        result = true;
        // copy files from temp directory to the directory of global profiles
        wxArrayString as;
        wxDir::GetAllFiles(strImportDir, &as, wxEmptyString, wxDIR_FILES);
        for ( size_t i = 0; i < as.Count(); i++ )
        {
            wxString name, ext;
            wxFileName::SplitPath(as.Item(i), NULL, NULL, &name, &ext);
            wxString file = name + _T(".") + ext;
//            if ( !wxFileName::FileExists(destDir + wxFileName::GetPathSeparator() + file) || ConfirmOverwrite(file) == wxID_YES )
            {
                ENM_String srcFile;
                memset(&srcFile, 0, sizeof(ENM_String));
                strcpy((char*)srcFile.dcsString, wxConvFileName->cWC2MB(wxConvLocal.cWX2WC(as.Item(i).c_str())));
                DCS_Return_Code dcsRet = DCS_WriteFile(&srcFile);
                if ( dcsRet != DCS_SUCCESS )
                {
                    result = false;
                    if ( pasFailed != NULL )
                        pasFailed->Add(file);
                }
//                result &= ::wxCopyFile(as.Item(i), destDir + wxFileName::GetPathSeparator() + file, true);
            }
        }
    }
    printf("FileTar::UnTar\n");
    ClearTempDir(strImportDir);
    return result;
}

bool SchoolSettingImporter::CheckServerCertification(wxString strImportDir)
{
    printf("enter CheckServerCertification\n");
    bool bTrust = true;
    wxString strCAPath = ENMUtil::m_appPath + wxT("cacert.pem");
    wxString strServerCertPath = strImportDir + wxFileName::GetPathSeparator() + wxT("sslservercert.pem");
    string szCACert,szServerCert;
//    printf("string szCACert,szServerCert;\n");
    szCACert = ENMUtil::WxStringToString(strCAPath);
    szServerCert = ENMUtil::WxStringToString(strServerCertPath);
//    ENMUtil::Log(dcLogimporter, wxString::Format(_T("strCAPath = %s"),strCAPath));
//    ENMUtil::Log(dcLogimporter, wxString::Format(_T("strServerCertPath = %s"),strServerCertPath));

//    printf("initial wxString\n");
    char* p_cCacert;
    char* p_cServercert;
    try
    {
        p_cCacert = new char[szCACert.size() + 1];
        p_cServercert = new char[szServerCert.size() + 1];
    }
    catch (...)
    {
        bTrust = false;
    }
//    printf("try catch\n");
    memset(p_cCacert, 0, szCACert.size() + 1);
    memset(p_cServercert, 0, szServerCert.size() + 1);
    memcpy(p_cCacert, szCACert.c_str(), szCACert.size());
    memcpy(p_cServercert, szServerCert.c_str(), szServerCert.size());
//    printf("memset\n");
    char arrVerify[7] =
    { 'v', 'e', 'r', 'i', 'f', 'y', '\0' };
    char CAfile[8] =
    { '-', 'C', 'A', 'f', 'i', 'l', 'e', '\0' };
    const int iacArg1=4;
    char* acArg1[iacArg1] = { arrVerify, CAfile, p_cCacert, p_cServercert };
//    printf("char* acArg1[iacArg1]\n");
//    ENMUtil::Log(dcLogimporter, _T("0 == MyVerify(iacArg1, acArg1)"));
    int nResult = MyVerify(iacArg1, acArg1);
//    ENMUtil::Log(dcLogimporter, wxString::Format(_T("strCAPath = %d"),nResult));
    if (0 == nResult)
    {
        //iReturn = SES_API_FAILURE;
        ENMUtil::Log(dcLogimporter, _T("bTrust = false"));
        bTrust = false;
    }
    ENMUtil::Log(dcLogimporter, _T("bTrust = true"));
    delete p_cCacert;
    delete p_cServercert;
    printf("delete p_cServercert;\n");

    return bTrust;
}
