#include "Receiver_Multicast.h"
#include "ENMApp.h"
#include <string.h>
#include <stdio.h>
#include <ace/INET_Addr.h>
#include "NNClientSocket.h"

Receiver_Multicast::Receiver_Multicast()
:mcast_addr_(MULTICAST_PORT, DEFAULT_MULTICAST_ADDR),
remote_addr_((u_short)0)
{
    //ctor
//    data_buf = new char[DATA_BUFFER_SIZE];
    // Subscribe to multicast address.
}

Receiver_Multicast::~Receiver_Multicast()
{
    //dtor
//    if (NULL != data_buf)
//    {
//        delete data_buf;
//        data_buf = NULL;
//    }


}

int Receiver_Multicast::Join_Multicast()
{
    if (mcast_dgram_.join (mcast_addr_) == -1)
    {
        ACE_DEBUG((LM_DEBUG,"Error in join Multicast address. errno = %d; %s\n", errno, strerror(errno)));
        //Leave_Multicast();
        return -1;
    }

    return 0;
}

int Receiver_Multicast::Leave_Multicast()
{
    if(mcast_dgram_.leave(mcast_addr_)==-1)
    {
        ACE_DEBUG((LM_ERROR,"Error in leaving Mcast group\n"));
        return -1;
    }
    if(mcast_dgram_.close()==-1)
    {
        ACE_DEBUG((LM_ERROR,"Error in CLOSE Mcast group\n"));
        return -1;
    }
    return 0;
}

//Receive data from someone who is sending data on the multicast group
//address. To do so it must use the multicast datagram component
//mcast_dgram_.
int Receiver_Multicast::recv_multicast()
{
    printf("start  recv_multicast \n");
    //get ready to receive data from the sender.
    if(mcast_dgram_.recv (data_buf, DATA_BUFFER_SIZE, remote_addr_)==-1)
    {
        printf("[Client] Receive multicast error\n");
        return -1;
    }
    else
    {
        printf("[Client] Receive multicast ok.%s \n", data_buf);

        //char string[] = "192.168.140.1|192.168.140.2|192.168.140.3|192.168.140.110|";
        char seps[]   = "@";
        //ACE_INET_Addr clientAddr;
        //mcast_dgram_.get_local_addr(clientAddr);
//        char* szAddress = new char[remote_addr_.get_addr_size()+1];
//        strcpy(szAddress,remote_addr_.get_host_addr());
        ACE_INET_Addr   *the_addr_array;
        size_t   count   =   0;
        int   rc   =   ACE::get_ip_interfaces(count,the_addr_array);
        char sz[MAXHOSTNAMELEN];
        int n = the_addr_array->addr_to_string(sz,MAXHOSTNAMELEN);
        char   address[30];
        bool bIPExist = false;

        printf("count = %d\n",count);
        while   (count--)
        {
            the_addr_array->addr_to_string(address,   sizeof(address));

            //strcat(address, ":0|");
            if(strcmp(address,"127.0.0.1:0")==0)
            {
                ++the_addr_array;
                continue;
            }

            bIPExist = FindIP(data_buf,address,seps);
            if (bIPExist)
            {
                break;
            }
            ++the_addr_array;
        }
//      memset(address,0,sizeof(address));
//      memcpy(address, "192.168.140.110");
        printf("[Client] Local Address %s\n", address);

        if(bIPExist)
        {
            char seps1[]   = ".";
            int timedelay = GetLastIP(address, seps1)*10000;
            printf("[Client] Time Delay %d\n", timedelay);
            usleep(timedelay);
            //wxMutexGuiEnter();
//            wxGetApp().StartDeploy(remote_addr_.get_host_addr());
            NNClientSocket::DownloadSetting((char *)remote_addr_.get_host_addr());
            //NNClientSocket::DownloadSetting("192.168.140.102");

            printf("[Client]IP Exist\n");
            //wxMutexGuiLeave();
        }
        else
        {
            printf("[Client]IP isn't Exist\n");

        }
        printf("return recv_multicast \n");
        return 0;
    }
    printf("end recv_multicast \n");
}
bool Receiver_Multicast::FindIP(const char*szList, char* szIP,char* szSeps)
{
    char *token;

    //printf( "%s\n\nTokens:\n", szList );
    char  list[100];
    strcpy(list, szList);
   /* Establish string and get the first token: */
   token = strtok( list, szSeps );
   while( token != NULL )
   {
      /* While there are tokens in "string" */
      printf( " token %s ip %s\n", token,szIP );

      if(strcmp(token,szIP)==0)
          return true;

      /* Get next token: */
      token = strtok( NULL, szSeps );
   }

   return false;

}

int Receiver_Multicast::GetLastIP(char*szList, char* szSeps)
{
    char *token;

    int nLastIP = 0;
    int n=0;

   /* Establish string and get the first token: */
   token = strtok( szList, szSeps );
   while( token != NULL )
   {
       if(n==3)
     {
      nLastIP = atoi(token);
      return nLastIP;
     }

      /* Get next token: */
      token = strtok( NULL, szSeps );
      n++;
   }
   return nLastIP;

}
