
#include "ProfileEditor.h"
#include <wx/string.h>

#ifndef byte
typedef unsigned char byte;
#endif

ProfileEditor::ProfileEditor()
{
}

ProfileEditor::~ProfileEditor()
{
}

int ProfileEditor::ReadProfile( ProfileList_t &tagProfile, const char *pcFileName )
{
    int iRet = 0;

    if ( NULL == pcFileName )
    {
        return iRet;
    }

    TiXmlDocument doc( pcFileName );

    if ( !doc.LoadFile() )
    {
//        printf("open file error!\n");
        return iRet;
    }

    //cout << endl << "Read profile Setting" << endl;

    TiXmlElement* xmlRootElement = 0;
    TiXmlAttribute* pAttrib = 0;
	TiXmlNode * pNode = 0;

    pNode = doc.FirstChild(ROOT);
    if (NULL == pNode)
	{
	    return iRet;
	}

	//get ProfileName
    xmlRootElement = pNode->ToElement();

    pAttrib = xmlRootElement->FirstAttribute();
    if (NULL == pAttrib)
	{
	    return iRet;
	}
    tagProfile.sPermission = DecryptPassword(pAttrib->Value());
    //cout << "tagProfile->sPermission is : " << tagProfile.sPermission << endl;

    pAttrib=pAttrib->Next();
    if (NULL == pAttrib)
	{
	    return iRet;
	}
    tagProfile.sPriority = DecryptPassword(pAttrib->Value());
//    cout << "tagProfile.sPriority : " << tagProfile.sPriority << endl;

    pAttrib=pAttrib->Next();
    if (NULL == pAttrib)
	{
	    return iRet;
	}
    tagProfile.sProfileIcon = DecryptPassword(pAttrib->Value());
    //cout << "tagProfile->sProfileIcon is : " << tagProfile.sProfileIcon << endl;

    pAttrib=pAttrib->Next();
    if (NULL == pAttrib)
	{
	    return iRet;
	}
    tagProfile.sShow = DecryptPassword(pAttrib->Value());
    //cout << "tagProfile->sShow is : " << tagProfile.sShow << endl;

    //get the general setting info
    if ( !GetGeneralSettings(tagProfile.stGenernalSet, pcFileName ) )
    {
        return iRet;
    }

    //get the wireless setting info
    if ( !GetWirelessSettings(tagProfile.stWirelessSet, pcFileName ) )
    {
        return iRet;
    }

    //get the Other setting info
    if ( !GetOtherSettings(tagProfile.stOtherSet, pcFileName ) )
    {
        return iRet;
    }

    iRet = 1;
    return iRet;
}

int ProfileEditor::GetGeneralSettings( GenernalSettings_t &stGeneral, const char *pcFileName )
{
    int iRet = 0;

    TiXmlDocument doc( pcFileName );

    if ( !doc.LoadFile() )
    {
       //cout << "open file error!\n" << endl;
        return iRet;
    }

    //cout << endl << "Read General Setting" << endl;

    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;

	TiXmlNode * pNode = 0;

    pNode = doc.FirstChild(ROOT);
    if (NULL == pNode)
	{
	    return iRet;
	}
	xmlRootElement = pNode->ToElement();

    pNode = xmlRootElement->FirstChild( GENERNALSETTINGS.c_str() );

    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    pNode = xmlSubElement->FirstChild( CONNECTTYPE.c_str() );

    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    stGeneral.ConnecType = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stGeneral->ConnecType is : " << stGeneral.ConnecType << endl;

//    pNode = pNode->NextSibling();
//    if ( NULL == pNode )
//    {
//        return iRet;
//    }
//
//    xmlSubElement = pNode->ToElement();
//    stGeneral.Authentication = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
//    //cout << "stGeneral->Authentication is : " << stGeneral.Authentication << endl;
//
//    pNode = xmlSubElement->FirstChild( DAUTHENTICATION.c_str() );
//
//    if ( NULL == pNode )
//    {
//        return iRet;
//    }
//
//    xmlSubElement = pNode->ToElement();
//    stGeneral.DetailAuthentication = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
//    //cout << "stGeneral->DetailAuthentication is : " << stGeneral.DetailAuthentication << endl;
//
//    pNode = pNode->Parent();
//    if ( NULL == pNode )
//    {
//        return iRet;
//    }
//
//    pNode = pNode->NextSibling();
//    if ( NULL == pNode )
//    {
//        return iRet;
//    }
//
//    xmlSubElement = pNode->ToElement();
//    stGeneral.IsDisconnectNet = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
//    //cout << "stGeneral->IsDisconnectNet is : " << stGeneral.IsDisconnectNet << endl;

    iRet = 1;
    return iRet;
}

int ProfileEditor::GetWirelessSettings( WirelessSettings_t &stWireless, const char *pcFileName )
{
    int iRet = 0;

    if ( NULL == pcFileName )
    {
        return iRet;
    }

    TiXmlDocument doc( pcFileName );

    if ( !doc.LoadFile() )
    {
//        printf("open file error!\n");
        return iRet;
    }

    //cout << endl << "Read Wireless Setting" << endl;

    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;
//    TiXmlElement* xmlItemElement = 0;
	TiXmlNode * pNode = 0;

    pNode = doc.FirstChild(ROOT);
    if (NULL == pNode)
	{
	    return iRet;
	}
	xmlRootElement = pNode->ToElement();


    pNode = xmlRootElement->FirstChild( WIRELESSSETTINGS.c_str() );

    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    pNode = xmlSubElement->FirstChild( SSID.c_str() );

    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    stWireless.SSID = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stWireless->SSID is : " << stWireless.SSID << endl;

    pNode = pNode->NextSibling();
    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    stWireless.WirlessType = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stWireless->WirlessType is : " << stWireless.WirlessType << endl;

    pNode = pNode->NextSibling();
    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    stWireless.WlanSecurity = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stWireless->WlanSecurity is : " << stWireless.WlanSecurity << endl;

    pNode = xmlSubElement->FirstChild( WEPSETTINGS.c_str() );
    xmlSubElement = pNode->ToElement();

    if ( NULL == pNode )
    {
        return iRet;
    }

    stWireless.stWEPSecurity.value = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    stWireless.stWEPSecurity.keyIndex = DecryptPassword(xmlSubElement->Attribute( KEY_INDEX.c_str() ));
    //cout << "stWireless->stWEPSecurity->value is : " << (stWireless.stWEPSecurity).value << endl;

    pNode = pNode->NextSibling();
    if ( NULL == pNode )
    {
        return iRet;
    }
    xmlSubElement = pNode->ToElement();
    stWireless.stWPASecurity.value = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stWireless->stWPASecurity->value is : " << (stWireless.stWPASecurity).value << endl;

    iRet = 1;
    return iRet;
}

int ProfileEditor::GetOtherSettings( OtherSettings_t &stOther, const char *pcFileName )
{
    int iRet = 0;

    if ( NULL == pcFileName )
    {
        return iRet;
    }

    TiXmlDocument doc( pcFileName );

    if ( !doc.LoadFile() )
    {
//        printf("open file error!\n");
        return iRet;
    }

    //cout << endl << "Read Other Setting" << endl;

    TiXmlElement* xmlRootElement = 0;
    TiXmlElement* xmlSubElement = 0;
//    TiXmlElement* xmlItemElement = 0;
	TiXmlNode * pNode = 0;

    pNode = doc.FirstChild(ROOT);
    if ( NULL == pNode )
	{
	    return iRet;
	}
	xmlRootElement = pNode->ToElement();


    pNode = xmlRootElement->FirstChild( OTHERSETTINGS.c_str() );

    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    pNode = xmlSubElement->FirstChild( NETSECURITY.c_str() );

    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    stOther.NetworkSecurity = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stOther->NetworkSecurity is : " << stOther.NetworkSecurity << endl;

    pNode = xmlSubElement->FirstChild( FORBIDFILE.c_str() );

    if ( NULL == pNode )
    {
        return iRet;
    }
    xmlSubElement = pNode->ToElement();
    stOther.stNetSecurity.sForbidShareFileAndPrint = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stOther->stNetSecurity->sForbidShareFileAndPrint is : " << stOther.stNetSecurity.sForbidShareFileAndPrint << endl;

    pNode = pNode->NextSibling();
    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    stOther.stNetSecurity.sForbidShareInternet = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stOther->stNetSecurity->sForbidShareInternet is : " << stOther.stNetSecurity.sForbidShareInternet << endl;

    pNode = pNode->NextSibling();
    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    stOther.stNetSecurity.sStartWindowFirewall = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stOther->stNetSecurity.sStartWindowFirewall is : " << stOther.stNetSecurity.sStartWindowFirewall << endl;

    pNode = pNode->Parent();
    if ( NULL == pNode )
    {
        return iRet;
    }

    pNode = pNode->NextSibling();
    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    stOther.AutoRunAppFlag = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stOther->AutoRunAppFlag is : " << stOther.AutoRunAppFlag << endl;

    //pNode = xmlSubElement->FirstChild( AUTORUNAPP.c_str() );

	TiXmlNode * pNodeTemp = pNode;
	pNodeTemp = xmlSubElement->FirstChild( AUTORUNAPP.c_str() );

    if ( NULL != pNodeTemp )
    {
        pNode = pNodeTemp;

        int iFlag = 1;
        int iNum = 0;
        while ( iFlag )
        {
            xmlSubElement = pNode->ToElement();
            stOther.AutoRunApp.push_back( DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() )) );
            //cout << "stOther->AUToRunApp is : " << stOther.AutoRunApp[iNum] << endl;
            iNum++;
            if ( pNode->NextSibling() )
            {
                pNode = pNode->NextSibling();
            }
            else
            {
                iFlag = 0;
            }
        }

        pNode = pNode->Parent();
        if ( NULL == pNode )
        {
            return iRet;
        }
    }

    pNode = pNode->NextSibling();
    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    stOther.IPDNSFlag = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stOther->IPDNSFlag is : " << stOther.IPDNSFlag << endl;

    pNode = xmlSubElement->FirstChild( IPVALUE.c_str() );
    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    stOther.stIPDNSSet.IPvalue = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stOther->stIPDNSSet->IPvalue is : " << stOther.stIPDNSSet.IPvalue << endl;

    pNode = pNode->NextSibling();
    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    stOther.stIPDNSSet.SubnetAddress = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stOther->stIPDNSSet->SubnetAddress is : " << stOther.stIPDNSSet.SubnetAddress << endl;

    pNode = pNode->NextSibling();
    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    stOther.stIPDNSSet.NetGateway = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stOther->stIPDNSSet->NetGateway is : " << stOther.stIPDNSSet.NetGateway << endl;

    pNode = pNode->NextSibling();
    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    stOther.stIPDNSSet.DNSvalue = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stOther->stIPDNSSet->DNSvalue is : " << stOther.stIPDNSSet.DNSvalue << endl;

    pNode = pNode->Parent();
    if ( NULL == pNode )
    {
        return iRet;
    }

    pNode = pNode->NextSibling();
    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    stOther.IsHomepage = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stOther->IsHomepage is : " << stOther.IsHomepage << endl;

    pNode = xmlSubElement->FirstChild( HOMEPAGE.c_str() );

    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    stOther.Homepage = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stOther->Homepage is : " << stOther.Homepage << endl;

    pNode = pNode->Parent();
    if ( NULL == pNode )
    {
        return iRet;
    }

    pNode = pNode->NextSibling();
    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    stOther.ProxyFlag = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stOther->ProxyFlag is : " << stOther.ProxyFlag << endl;

    pNode = xmlSubElement->FirstChild( PROXY.c_str() );
    xmlSubElement = pNode->ToElement();

    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    stOther.stProxySet.Proxy = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stOther->stProxySet->Proxy is : " << stOther.stProxySet.Proxy << endl;

    pNode = pNode->NextSibling();
    if ( NULL == pNode )
    {
        return iRet;
    }

    xmlSubElement = pNode->ToElement();
    stOther.stProxySet.Port = DecryptPassword(xmlSubElement->Attribute( VALUE.c_str() ));
    //cout << "stOther->stProxySet->Port is : " << stOther.stProxySet.Port << endl;

    iRet = 1;
    return iRet;
}

int ProfileEditor::WriteProfile( ProfileList_t &tagProfile, const char *pcFileName, const char * pcPriority )
{
    int iRet = 0;

    if ( NULL == pcFileName )
    {
        //cout << "The file name is null!" << endl;
        return iRet;
    }

    TiXmlDocument doc;
    TiXmlDeclaration * decl = new TiXmlDeclaration( "1.0", "UTF-8", "" );
    doc.LinkEndChild( decl );

    TiXmlElement * root = new TiXmlElement( ROOT.c_str() );
    doc.LinkEndChild( root );

    root->SetAttribute( PERMISSION.c_str(), EncryptPassword(tagProfile.sPermission) );

    if ( NULL == pcPriority )
    {
        root->SetAttribute( PRIORITY.c_str(), (EncryptPassword(tagProfile.sPriority)).c_str() );
    }
    else
    {
        string spcPriority(pcPriority);
        root->SetAttribute( PRIORITY.c_str(), EncryptPassword(spcPriority).c_str() );
    }

    root->SetAttribute( ICON.c_str(), EncryptPassword(tagProfile.sProfileIcon) );
    root->SetAttribute( SHOW.c_str(), EncryptPassword(tagProfile.sShow) );

    //General Settings
    TiXmlElement * GerneralSettings = new TiXmlElement( GENERNALSETTINGS.c_str() );
    root->LinkEndChild( GerneralSettings );

    TiXmlElement * ConnectType = new TiXmlElement( CONNECTTYPE.c_str() );
    GerneralSettings->LinkEndChild( ConnectType );
    ConnectType->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stGenernalSet.ConnecType) );

    TiXmlElement * WirelessSettings = new TiXmlElement( WIRELESSSETTINGS.c_str() );
    root->LinkEndChild( WirelessSettings );

    TiXmlElement * ssid = new TiXmlElement( SSID.c_str() );
    WirelessSettings->LinkEndChild( ssid );
    ssid->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stWirelessSet.SSID) );

    TiXmlElement * WirlessType = new TiXmlElement( WIRELESSTYPE.c_str() );
    WirelessSettings->LinkEndChild( WirlessType );
    WirlessType->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stWirelessSet.WirlessType) );

    TiXmlElement * WlanSecurity = new TiXmlElement( WLANSECURITY.c_str() );
    WirelessSettings->LinkEndChild( WlanSecurity );
    WlanSecurity->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stWirelessSet.WlanSecurity) );

    TiXmlElement * WEPSettings = new TiXmlElement( WEPSETTINGS.c_str() );
    WlanSecurity->LinkEndChild( WEPSettings );
    WEPSettings->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stWirelessSet.stWEPSecurity.value) );
    WEPSettings->SetAttribute(KEY_INDEX.c_str(), EncryptPassword(tagProfile.stWirelessSet.stWEPSecurity.keyIndex) );

    TiXmlElement * WPASettings = new TiXmlElement( WPASETTINGS.c_str() );
    WlanSecurity->LinkEndChild( WPASettings );
    WPASettings->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stWirelessSet.stWPASecurity.value) );

    TiXmlElement * OtherSettings = new TiXmlElement( OTHERSETTINGS.c_str() );
    root->LinkEndChild( OtherSettings );
    //
    TiXmlElement * NetworkSecurity = new TiXmlElement( NETSECURITY.c_str() );
    OtherSettings->LinkEndChild( NetworkSecurity );
    NetworkSecurity->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stOtherSet.NetworkSecurity) );

    TiXmlElement * ForbidShareFileAndPrint = new TiXmlElement( FORBIDFILE.c_str() );
    NetworkSecurity->LinkEndChild( ForbidShareFileAndPrint );
    ForbidShareFileAndPrint->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stOtherSet.stNetSecurity.sForbidShareFileAndPrint) );

    TiXmlElement * ForbidShareInternet = new TiXmlElement( FORBIDINTERNET.c_str() );
    NetworkSecurity->LinkEndChild( ForbidShareInternet );
    ForbidShareInternet->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stOtherSet.stNetSecurity.sForbidShareInternet) );

    TiXmlElement * StartWindowFirewall = new TiXmlElement( STARTFIREWALL.c_str() );
    NetworkSecurity->LinkEndChild( StartWindowFirewall );
    StartWindowFirewall->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stOtherSet.stNetSecurity.sStartWindowFirewall) );
    //
    TiXmlElement * AutoRunAppFlag = new TiXmlElement( AUTORUNAPPFLAG );
    OtherSettings->LinkEndChild( AutoRunAppFlag );
    AutoRunAppFlag->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stOtherSet.AutoRunAppFlag) );

    for (vector<string>::size_type ix = 0; ix != (tagProfile.stOtherSet.AutoRunApp).size(); ++ix )
    {
        TiXmlElement * AutoRunApp = new TiXmlElement( AUTORUNAPP.c_str() );
        AutoRunAppFlag->LinkEndChild( AutoRunApp );
        AutoRunApp->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stOtherSet.AutoRunApp[ix] ));
    }

    //
    TiXmlElement * IPDNSFlag = new TiXmlElement( IPDNS.c_str() );
    OtherSettings->LinkEndChild( IPDNSFlag );
    IPDNSFlag->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stOtherSet.IPDNSFlag) );

    TiXmlElement * IPvalue = new TiXmlElement( IPVALUE.c_str() );
    IPDNSFlag->LinkEndChild( IPvalue );
    IPvalue->SetAttribute( VALUE.c_str(), EncryptPassword(tagProfile.stOtherSet.stIPDNSSet.IPvalue) );

    TiXmlElement * SubnetAddress = new TiXmlElement( SUBNET.c_str() );
    IPDNSFlag->LinkEndChild( SubnetAddress );
    SubnetAddress->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stOtherSet.stIPDNSSet.SubnetAddress) );

    TiXmlElement * NetGateway = new TiXmlElement( NETGATE.c_str() );
    IPDNSFlag->LinkEndChild( NetGateway );
    NetGateway->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stOtherSet.stIPDNSSet.NetGateway) );

    TiXmlElement * DNSvalue = new TiXmlElement( DNSVALUE.c_str() );
    IPDNSFlag->LinkEndChild( DNSvalue );
    DNSvalue->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stOtherSet.stIPDNSSet.DNSvalue) );
    //
    TiXmlElement * IsHomepage = new TiXmlElement( HOMEPAGEFLAG.c_str() );
    OtherSettings->LinkEndChild( IsHomepage );
    IsHomepage->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stOtherSet.IsHomepage) );

    TiXmlElement * Homepage = new TiXmlElement( HOMEPAGE.c_str() );
    IsHomepage->LinkEndChild( Homepage );
    Homepage->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stOtherSet.Homepage) );
    //
    TiXmlElement * ProxyFlag = new TiXmlElement( PROXYFLAG.c_str() );
    OtherSettings->LinkEndChild( ProxyFlag );
    ProxyFlag->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stOtherSet.ProxyFlag) );

    TiXmlElement * Proxy = new TiXmlElement( PROXY.c_str() );
    ProxyFlag->LinkEndChild( Proxy );
    Proxy->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stOtherSet.stProxySet.Proxy) );

    TiXmlElement * Port = new TiXmlElement( PORT.c_str() );
    ProxyFlag->LinkEndChild( Port );
    Port->SetAttribute(VALUE.c_str(), EncryptPassword(tagProfile.stOtherSet.stProxySet.Port) );

    if ( !doc.SaveFile( pcFileName ) )
    {
        return iRet;
    }

    iRet = 1;
    return iRet;
}

int ProfileEditor::EditProfile( ProfileList_t &tagProfile, const char *pcFileName, const char * pcPriority  )
{
   int iRet = 0;

    TiXmlDocument doc( pcFileName );

    if ( !doc.LoadFile() )
    {
        return iRet;
        //cout << "open file error!\n" << endl;
    }

    if ( WriteProfile( tagProfile, pcFileName, pcPriority ))
    {
        //cout << "Edit Error!" << endl;
        return iRet;
    }

    iRet = 1;
    return iRet;
}

int ProfileEditor::DeleteProfile( const char * pcFileName )
{
    int iRet = 0;

    if ( NULL == pcFileName )
    {
        //cout << "File is null!" << endl;
        return iRet;
    }

    if( -1 == remove( pcFileName ) )
    {
        //cout << "Could not delete!" << endl;
        return iRet;
    }
    else
    {
        //cout << "Deleted " << pcFileName << endl;
        iRet = 1;
        return iRet;
    }
}

string ProfileEditor::EncryptPassword(const string& orpassword)
{
    wxString wxorpassword = wxString(orpassword.c_str(), wxConvUTF8);

    int length = wxorpassword.Len();
    char *cstr = new char[length+1];
    strcpy(cstr, wxorpassword.mb_str());
    int nTemp = 0;
    byte bSingle = 0;
    byte bHighByte = 0;
    byte bLowByte = 0;
    byte TransByte = 0;
    wxString wxenpassword;

    for (int i=0; i<length; i++)
    {
        nTemp = cstr[i];
        bSingle = (byte)nTemp;
        bHighByte = (byte)(bSingle>>4);
        bLowByte = (byte)(bSingle&0x0F);
        TransByte = (byte)(bLowByte<<4|bHighByte);
        nTemp = (int)TransByte;
        wxString str;
        str.Printf(wxT("%0x"), nTemp);

        if((byte)(TransByte&0xF0) == (byte)0)
        {
            /* if single byte, add "0"*/
            wxenpassword += wxT("0");
            wxenpassword += str;
        }

        else
        {
            wxenpassword += str;
        }

    }
    delete cstr;

    string enpassword(wxenpassword.mb_str(wxConvUTF8));

    return enpassword;
}

string ProfileEditor::DecryptPassword(const string& enpassword)
{
    wxString wxenpassword = wxString(enpassword.c_str(), wxConvUTF8);

    int length = wxenpassword.Len();
    wxString strTemp;
    long l;
    int nTemp = 0;
    char cTemp[2];

    byte bSingle = 0;
    byte bHighByte = 0;
    byte bLowByte = 0;
    byte TransByte = 0;
    wxString wxdepassword;

    for (int i=0; i<length-1; i+=2)
    {
        strTemp = wxenpassword.Mid(i, 2);
        strTemp.ToLong(&l, 16);
        bSingle = (byte)l;
        bHighByte = (byte)(bSingle>>4);
        bLowByte = (byte)(bSingle&0x0F);
        TransByte = (byte)(bLowByte<<4|bHighByte);

        nTemp = (int)TransByte;
        cTemp[0] = nTemp;
        cTemp[1] = '\0';
        wxdepassword += wxString(cTemp, wxConvUTF8);
//        if (i>0)
//        {
//            wxdepassword = wxdepassword.Left(wxdepassword.Len()-1);
//        }
    }

    string depassword(wxdepassword.mb_str(wxConvUTF8));

    return depassword;
}
