#ifndef _PROFILE_H_
#define _PROFILE_H_

#include <vector>
#include <string>
using namespace std;

typedef struct tagNetworkSecuritySet_t
{
    string sForbidShareFileAndPrint;
    string sForbidShareInternet;
    string sStartWindowFirewall;
}
NetworkSecuritySet_t, *PNetworkSecuritySet_t;

typedef struct tagIPDNSSet_t
{
    string IPvalue;
    string SubnetAddress;
    string NetGateway;
    string DNSvalue;
}
IPDNSSet_t, *PIPDNSSet_t;

typedef struct tagProxySet_t
{
    string Proxy;
    string Port;
}
ProxySet_t, *PProxySet_t;

typedef struct tagWEPSecurity_t
{
    string value;
    string keyIndex;
}
WEPSecurity_t, *PWEPSecurity_t;

typedef struct tagWPASecurity_t
{
    string value;
}
WPASecurity_t, *PWPASecurity_t;

typedef struct tagGenernalSettings_t
{
    string ConnecType;
//    string Authentication;
//    string IsDisconnectNet;
//    string DetailAuthentication;
}
GenernalSettings_t, *PGenernalSettings_t;

typedef struct tagWirelessSettings_t
{
    string SSID;
    string WirlessType;
    string WlanSecurity;

    WPASecurity_t stWPASecurity;
    WEPSecurity_t stWEPSecurity;
}
WirelessSettings_t, *PWirelessSettings_t;

typedef struct tagOtherSettings_t
{
    string NetworkSecurity;
    string AutoRunAppFlag;
    vector<string> AutoRunApp;
    string IPDNSFlag;
    string IsHomepage;
    string Homepage;
    string ProxyFlag;

    NetworkSecuritySet_t stNetSecurity;
    IPDNSSet_t stIPDNSSet;
    ProxySet_t stProxySet;
}
OtherSettings_t, *POtherSettings_t;

typedef struct tagProfileList_t
{
    string sProfileName;
    string sPermission;
    string sPriority;
    string sProfileIcon;
    string sShow;

    GenernalSettings_t stGenernalSet;
    WirelessSettings_t stWirelessSet;
    OtherSettings_t stOtherSet;
}
ProfileList_t, *PProfileList_t;

bool operator == (const NetworkSecuritySet_t& s1, const NetworkSecuritySet_t& s2);
bool operator == (const IPDNSSet_t& s1, const IPDNSSet_t& s2);
bool operator == (const ProxySet_t& s1, const ProxySet_t& s2);
bool operator == (const WEPSecurity_t& s1, const WEPSecurity_t& s2);
bool operator == (const WPASecurity_t& s1, const WPASecurity_t& s2);

bool operator == (const GenernalSettings_t& s1, const GenernalSettings_t& s2);
bool operator == (const WirelessSettings_t& s1, const WirelessSettings_t& s2);
bool operator == (const OtherSettings_t& s1, const OtherSettings_t& s2);

bool operator == (const ProfileList_t& pf1, const ProfileList_t& pf2);
bool operator != (const ProfileList_t& pf1, const ProfileList_t& pf2);

#endif // _PROFILE_H_
