#ifndef POPUPDIALOG_H
#define POPUPDIALOG_H

#include <wx/stattext.h>
#include <wx/bmpbuttn.h>
#include <wx/statbmp.h>
#include <wx/dialog.h>
#include <wx/bitmap.h>
#include <wx/dcmemory.h>
#include "CustomStaticText.h"
#include <wx/timer.h>

class PopupDialog: public wxDialog
{
	public:

		PopupDialog(wxWindow* parent, const wxBitmap& bitmap, wxWindowID id=wxID_ANY);
		virtual ~PopupDialog();
		void SetTitle(wxString strTitle);
		void SetContentLine1(wxString strContent);
		void SetContentLine2(wxString strContent);
		void SetContentLine3(wxString strContent);
		int ShowModal();
		void EndModal(int retCode);

	private:

		static const long ID_STATICBITMAP1;
		static const long ID_STATICTEXT_TITLE;
		static const long ID_STATICTEXT_CONTENT_LINE1;
		static const long ID_STATICTEXT_CONTENT_LINE2;
		static const long ID_STATICTEXT_CONTENT_LINE3;
//		static const long ID_BTN_CLOSE;
		static const long ID_BTN_OK;
		static const long ID_BTN_CANCEL;
		static const long ID_TIMER_TICK;
		static const long ID_STATICTEXTOK;
		static const long ID_STATICTEXTCANCEL;


		wxBitmapButton* m_btnOK;
//		wxBitmapButton* m_btnClose;
		wxBitmapButton* m_btnCancel;

		wxBitmap m_bitmap;
        bool m_hasShape;
        wxBitmap *m_pBkmapMute;
        wxBitmap *m_pBkmapnormal;
        wxBitmap *m_pBkmapover;
        wxBitmap *m_pBkmapdown;
        wxBitmap *m_pBkmapdisable;

        CustomStaticText* m_pTitle;
        CustomStaticText* m_pContentLine1;
        CustomStaticText* m_pContentLine2;
        CustomStaticText* m_pContentLine3;
        wxStaticText* m_pBtnOK;
        wxStaticText* m_pBtnCancel;

        wxTimer m_Timer;

        void OnInit(wxInitDialogEvent& event);
		void OnButtonClick(wxCommandEvent& event);
        void SetWindowShape();
		void OnEraseBkgnd(wxEraseEvent&  event);
		void OnPaint(wxPaintEvent& event);
        void OnWindowCreate(wxWindowCreateEvent& evt);
        void ButtonState(wxString drawtext, wxBitmap* bitmap, wxBitmap* bitmap_back, wxMemoryDC* dc);
        void RedrawBitmapBtn(wxString stText, wxBitmapButton* m_pBitmapBtn, wxBitmap* pBitmap, wxMemoryDC* pDC);
        void OnTimerTick(wxTimerEvent & event);


		DECLARE_EVENT_TABLE()
};

#endif
