
#include "NetworkManagerDlg.h"
#include <wx/msgdlg.h>

#include <wx/settings.h>
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/string.h>
#include "ENMApp.h"

#include "AboutDialog.h"
#include "pic/icon_manage.xpm"

#if defined(__UNIX__)
#include <arpa/inet.h>
//#include <net/if.h>
#include "DataCenterLinux.h"
#endif // defined(__UNIX__)

#if defined(__WXMSW__)
#include <wininet.h>
#include <Iphlpapi.h>
#include <wx/msw/registry.h>
#endif // defined(__WXMSW__)

#include "ENMUtil.h"
#include "FileTar.h"
#include "PolicyManager.h"
#include "ProfileManagerDlg.h"
#include "ProfileManagementControl.h"
#include "MeshConfigurationDlg.h"
#include "ViewMeshNeighborsDlg.h"
#if defined(__WXMSW__)
static wxString logFile(_T("C:\\NetworkManagerDlg.log"));
#else
static wxString logFile(_T("/tmp/NetworkManagerDlg.log"));
#endif

const int BUFFERSIZE = 80;
const int MAX_KEY_LENGTH = 255;
const int MAX_DES_LENGTH = 50;
const int MAX_SERV_LENGTH = 50;
const int MAX_VALUE_NAME = 16383;
const int ADPR_LENGTH = 50;

const long NetworkManagerDlg::ID_CMBSWITCHPRFL = wxNewId();
const long NetworkManagerDlg::ID_STCNPTITLE = wxNewId();
const long NetworkManagerDlg::ID_STBNWINFO = wxNewId();
const long NetworkManagerDlg::ID_STCSQTITLE = wxNewId();
const long NetworkManagerDlg::ID_STCIPADDRTITLE = wxNewId();
const long NetworkManagerDlg::ID_STCIPADDR = wxNewId();
const long NetworkManagerDlg::ID_STCSTATUS = wxNewId();
const long NetworkManagerDlg::ID_STCTYPE = wxNewId();
const long NetworkManagerDlg::ID_STCTYPETITLE = wxNewId();
const long NetworkManagerDlg::ID_STCSQVAL = wxNewId();
const long NetworkManagerDlg::ID_STCSTATUSTITLE = wxNewId();
const long NetworkManagerDlg::ID_GAUGESQ = wxNewId();
const long NetworkManagerDlg::ID_BTNSCANNW = wxNewId();
const long NetworkManagerDlg::ID_BTNVIEWNGHBR = wxNewId();
const long NetworkManagerDlg::ID_BTNPRFLMGR = wxNewId();
const long NetworkManagerDlg::ID_SCANNTBTNTEXT = wxNewId();
const long NetworkManagerDlg::ID_NEIGHBORTEXT = wxNewId();
const long NetworkManagerDlg::ID_PRFLMGRTEXT = wxNewId();
const long NetworkManagerDlg::ID_SCANMWBMP = wxNewId();
const long NetworkManagerDlg::ID_NGHBRBMP = wxNewId();
const long NetworkManagerDlg::ID_PRFLMGRBMP = wxNewId();
const long NetworkManagerDlg::ID_PANELRIGHT = wxNewId();
const long NetworkManagerDlg::ID_STCCURRENTPROF = wxNewId();
const long NetworkManagerDlg::ID_BTNCTRLCONNECT = wxNewId();
const long NetworkManagerDlg::ID_BTNCTRLWRLS = wxNewId();
const long NetworkManagerDlg::ID_NWINFOBMP = wxNewId();
const long NetworkManagerDlg::ID_PANELLEFT = wxNewId();
const long NetworkManagerDlg::ID_IMPORT = wxNewId();
const long NetworkManagerDlg::ID_EXIT = wxNewId();
const long NetworkManagerDlg::ID_CNCTPRFL = wxNewId();
const long NetworkManagerDlg::ID_SCANNW = wxNewId();
const long NetworkManagerDlg::ID_VIEWNGHBR = wxNewId();
const long NetworkManagerDlg::ID_PRFLMGR = wxNewId();
const long NetworkManagerDlg::ID_MDC = wxNewId();
const long NetworkManagerDlg::ID_CTRLWRLS = wxNewId();
const long NetworkManagerDlg::ID_HLPCONT = wxNewId();
const long NetworkManagerDlg::ID_ABOUT = wxNewId();
const long NetworkManagerDlg::ID_BMPSCANNW = wxNewId();
const long NetworkManagerDlg::ID_BMPNEIGHBOR = wxNewId();
const long NetworkManagerDlg::ID_BMPPRFLMGR = wxNewId();
const long NetworkManagerDlg::ID_STCPRFLBMP = wxNewId();
const long NetworkManagerDlg::ID_MESHCONFIGURATION = wxNewId();
const int NetworkManagerDlg::ID_TIMER_PROFILE = wxNewId();
const int NetworkManagerDlg::ID_TIMER_WIRELESS = wxNewId();

BEGIN_EVENT_TABLE(NetworkManagerDlg, wxFrame)
    EVT_WLAN_ACM(ID_WLAN_ACM_CONNECT, NetworkManagerDlg::OnWlanAcmEvent)
    EVT_PROFILE(ID_PROFILE_CHANGED, NetworkManagerDlg::OnProfileChangedEvent)
    EVT_PROFILE(ID_PROFILE_APPLY, NetworkManagerDlg::OnProfileChangedEvent)
    EVT_WIRELESS(ID_WIRELESS_NETWORK_SWITCH, NetworkManagerDlg::OnWirelessNetworkChanged)
    EVT_SWITCH_ADAPTER(ID_SWITCH_ADAPTER, NetworkManagerDlg::OnSwitchAdapterEvent)
    EVT_TIMER(ID_TIMER_PROFILE, NetworkManagerDlg::OnTimer)
    EVT_TIMER(ID_TIMER_WIRELESS, NetworkManagerDlg::OnTimer)
#if defined(__WXMSW__)
    EVT_ACTIVATE(NetworkManagerDlg::OnActivate)
#endif
END_EVENT_TABLE()

NetworkManagerDlg::NetworkManagerDlg(wxWindow* parent,wxWindowID id)
        : wxFrame(), m_importer(), m_pGaugeDialog(NULL)
        , m_timerProfile(this, ID_TIMER_PROFILE), m_timerWireless(this, ID_TIMER_WIRELESS)
{
    wxMenu* mbFile;
    wxMenu* mbTool;
    wxMenu* mbSetting;
    wxMenu* mbHelp;

    viewAPNeighborsDlg = new ViewAPNeighborsDlg(this);
    bConnectFinish = true;

    Create(parent, wxID_ANY, _("Network Manager"), wxDefaultPosition, wxDefaultSize, wxMINIMIZE_BOX | wxSYSTEM_MENU | wxCAPTION | wxCLOSE_BOX | wxCLIP_CHILDREN, _T("ENM_Network_Manager"));
    SetClientSize(wxSize(580,375));
    Move(wxPoint(-1,-1));

    m_pGaugeDialog = new GaugeDialog(NULL);

    //Panel
    m_pnlLeft = new wxPanel(this, ID_PANELLEFT, wxPoint(8,20), wxSize(520,388), wxTAB_TRAVERSAL, _T("ID_PANELLEFT"));
    m_pnlLeft->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOW));
    m_pnlRight = new wxPanel(m_pnlLeft, ID_PANELRIGHT, wxPoint(425,0), wxSize(152,352), wxTAB_TRAVERSAL, _T("ID_PANELRIGHT"));
    m_pnlRight->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_MENUBAR));

    //BitmapComboBox
    m_cmbSwitchPrfl = new wxBitmapComboBox(m_pnlLeft, ID_CMBSWITCHPRFL, _T(""), wxPoint(110,24), wxSize(202,27), 0, 0,wxCB_READONLY|wxCB_DROPDOWN, wxDefaultValidator, _T("ID_CMBSWITCHPRFL"));
    m_cmbSwitchPrfl->SetPopupMaxHeight(200);

    //Control connect/disconnect profile button
    m_btnCtrlConnect = new wxButton(m_pnlLeft, ID_BTNCTRLCONNECT, _("Connect"), wxPoint(320,23), wxSize(96,29), 0, wxDefaultValidator, _T("ID_BTNCTRLCONNECT"));

    //Static---Network profile
    m_stcNpTitle = new wxStaticText(m_pnlLeft, ID_STCNPTITLE, _("Network Profile:"), wxPoint(8,28), wxSize(100,20), 0, _T("ID_STCNPTITLE"));

    //StaticBox
    m_stbNwInfo = new wxStaticBox(m_pnlLeft, ID_STBNWINFO, _("Network Status"), wxPoint(8,68), wxSize(408,278), 0, _T("ID_STBNWINFO"));
    m_stbNwInfo->SetForegroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_HIGHLIGHT));
    wxFont m_stbNwInfoFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxBOLD,false,_T("Arial"),wxFONTENCODING_DEFAULT);
    m_stbNwInfo->SetFont(m_stbNwInfoFont);

    //Static---Curent connecting profile name
    m_stcCurrentPfle = new wxStaticText(m_pnlLeft, ID_STCCURRENTPROF, _T(""), wxPoint(24,178), wxSize(96,17), 0, _T("ID_STCCURRENTPROF"));
    wxFont m_stcCurrentPfleFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxBOLD,false,_T("Arial"),wxFONTENCODING_DEFAULT);
    m_stcCurrentPfle->SetFont(m_stcCurrentPfleFont);

    //Signal Quality
 	#if defined(__WXMSW__)
    m_stcSQTitle = new wxStaticText(m_pnlLeft, ID_STCSQTITLE, _("Signal Quality:"), wxPoint(24,210), wxSize(110,24), 0, _T("ID_STCSQTITLE"));
    wxFont m_stcSQTitleFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Arial"),wxFONTENCODING_DEFAULT);
    m_stcSQTitle->SetFont(m_stcSQTitleFont);
    m_gueSQ = new wxGauge(m_pnlLeft, ID_GAUGESQ, 100, wxPoint(150,210), wxSize(158,16), wxGA_SMOOTH);
    m_gueSQ->SetShadowWidth(22);
    m_stcSQVal = new wxStaticText(m_pnlLeft, ID_STCSQVAL, _T(""), wxPoint(318,210), wxSize(40,24), 0, _T("ID_STCSQVAL"));
	#endif

	#if defined(__UNIX__)
    m_stcSQTitle = new wxStaticText(m_pnlLeft, ID_STCSQTITLE, _("Signal Quality:"), wxPoint(24,210), wxSize(80,24), 0, _T("ID_STCSQTITLE"));
    wxFont m_stcSQTitleFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Arial"),wxFONTENCODING_DEFAULT);
    m_stcSQTitle->SetFont(m_stcSQTitleFont);
    m_gueSQ = new wxGauge(m_pnlLeft, ID_GAUGESQ, 100, wxPoint(160,210), wxSize(158,16), wxGA_SMOOTH);
    m_gueSQ->SetShadowWidth(22);
    m_stcSQVal = new wxStaticText(m_pnlLeft, ID_STCSQVAL, _T(""), wxPoint(328,210), wxSize(40,24), 0, _T("ID_STCSQVAL"));
	#endif

    wxFont m_stcSQValFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Arial"),wxFONTENCODING_DEFAULT);
    m_stcSQVal->SetFont(m_stcSQValFont);

    //Status
    #if defined(__WXMSW__)
    m_stcStatusTitle = new wxStaticText(m_pnlLeft, ID_STCSTATUSTITLE, _("Status:"), wxPoint(24,240), wxSize(110,24), 0, _T("ID_STCSTATUSTITLE"));
    wxFont m_stcStatusTitleFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Arial"),wxFONTENCODING_DEFAULT);
    m_stcStatusTitle->SetFont(m_stcStatusTitleFont);
    m_stcStatus = new wxStaticText(m_pnlLeft, ID_STCSTATUS, _T(""), wxPoint(150,240), wxSize(216,24), 0, _T("ID_STCSTATUS"));
	#endif

	#if defined(__UNIX__)
    m_stcStatusTitle = new wxStaticText(m_pnlLeft, ID_STCSTATUSTITLE, _("Status:"), wxPoint(24,240), wxSize(96,24), 0, _T("ID_STCSTATUSTITLE"));
    wxFont m_stcStatusTitleFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Arial"),wxFONTENCODING_DEFAULT);
    m_stcStatusTitle->SetFont(m_stcStatusTitleFont);
    m_stcStatus = new wxStaticText(m_pnlLeft, ID_STCSTATUS, _T(""), wxPoint(160,240), wxSize(216,24), 0, _T("ID_STCSTATUS"));
	#endif

    wxFont m_stcStatusFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Arial"),wxFONTENCODING_DEFAULT);
    m_stcStatus->SetFont(m_stcStatusFont);

    //Type
    #if defined(__WXMSW__)
    m_stcTypeTitle = new wxStaticText(m_pnlLeft, ID_STCTYPETITLE, _("Type:"), wxPoint(24,270), wxSize(110,24), 0, _T("ID_STCTYPETITLE"));
    wxFont m_stcTypeTitleFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Arial"),wxFONTENCODING_DEFAULT);
    m_stcTypeTitle->SetFont(m_stcTypeTitleFont);
    m_stcType = new wxStaticText(m_pnlLeft, ID_STCTYPE, _T(""), wxPoint(150,270), wxSize(216,24), 0, _T("ID_STCTYPE"));
	#endif

	#if defined(__UNIX__)
    m_stcTypeTitle = new wxStaticText(m_pnlLeft, ID_STCTYPETITLE, _("Type:"), wxPoint(24,270), wxSize(96,24), 0, _T("ID_STCTYPETITLE"));
    wxFont m_stcTypeTitleFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Arial"),wxFONTENCODING_DEFAULT);
    m_stcTypeTitle->SetFont(m_stcTypeTitleFont);
    m_stcType = new wxStaticText(m_pnlLeft, ID_STCTYPE, _T(""), wxPoint(160,270), wxSize(216,24), 0, _T("ID_STCTYPE"));
	#endif

    wxFont m_stcTypeFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Arial"),wxFONTENCODING_DEFAULT);
    m_stcType->SetFont(m_stcTypeFont);

    //IP Address
    #if defined(__WXMSW__)
    m_stcIPAddrTitle = new wxStaticText(m_pnlLeft, ID_STCIPADDRTITLE,_("IP Address:"), wxPoint(24,300), wxSize(110,24), 0, _T("ID_STCIPADDRTITLE"));
    wxFont m_stcIPAddrTitleFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Arial"),wxFONTENCODING_DEFAULT);
    m_stcIPAddrTitle->SetFont(m_stcIPAddrTitleFont);

    m_stcIPAddr = new wxStaticText(m_pnlLeft, ID_STCIPADDR, _T(""), wxPoint(150,300), wxSize(216,24), 0, _T("ID_STCIPADDR"));
	#endif

	#if defined(__UNIX__)
    m_stcIPAddrTitle = new wxStaticText(m_pnlLeft, ID_STCIPADDRTITLE,_("IP Address:"), wxPoint(24,300), wxSize(96,24), 0, _T("ID_STCIPADDRTITLE"));
    wxFont m_stcIPAddrTitleFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Arial"),wxFONTENCODING_DEFAULT);
    m_stcIPAddrTitle->SetFont(m_stcIPAddrTitleFont);

    m_stcIPAddr = new wxStaticText(m_pnlLeft, ID_STCIPADDR, _T(""), wxPoint(160,300), wxSize(216,24), 0, _T("ID_STCIPADDR"));
	#endif

    wxFont m_stcIPAddrFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Arial"),wxFONTENCODING_DEFAULT);
    m_stcIPAddr->SetFont(m_stcIPAddrFont);

    m_mbFile = new wxMenuBar();
    mbFile = new wxMenu();
    m_menuImpSetting = new wxMenuItem(mbFile, ID_IMPORT, _("&Import School Settings ..."), wxEmptyString, wxITEM_NORMAL);
    mbFile->Append(m_menuImpSetting);
    mbFile->AppendSeparator();
    m_menuExitDlg = new wxMenuItem(mbFile, ID_EXIT, _("&Exit"), wxEmptyString, wxITEM_NORMAL);
    mbFile->Append(m_menuExitDlg);
    m_mbFile->Append(mbFile, _("&File"));
    mbTool = new wxMenu();
    m_menuCnctPrfl = new wxMenuItem(mbTool, ID_CNCTPRFL, _("&Connect"), wxEmptyString, wxITEM_NORMAL);
    mbTool->Append(m_menuCnctPrfl);
    mbTool->AppendSeparator();
    m_menuScanNW = new wxMenuItem(mbTool, ID_SCANNW, _("&Scan for Networks"), wxEmptyString, wxITEM_NORMAL);
    mbTool->Append(m_menuScanNW);
    m_menuViewNghbr = new wxMenuItem(mbTool, ID_VIEWNGHBR, _("&View Neighbors"), wxEmptyString, wxITEM_NORMAL);
    mbTool->Append(m_menuViewNghbr);
    m_mbFile->Append(mbTool, _("&Tools"));
    mbSetting = new wxMenu();
    m_menuPrflMgr = new wxMenuItem(mbSetting, ID_PRFLMGR, _("&Profile Manager"), wxEmptyString, wxITEM_NORMAL);
    mbSetting->Append(m_menuPrflMgr);

    m_menuMeshDC = new wxMenuItem(mbSetting, ID_MESHCONFIGURATION, _("&Mesh Configure"), wxEmptyString, wxITEM_NORMAL);
    mbSetting->Append(m_menuMeshDC);
    m_menuMeshDC->Enable(false);

    mbSetting->AppendSeparator();

    m_menuCtrlWrls = new wxMenuItem(mbSetting, ID_CTRLWRLS, _("T&urn on wireless"), wxEmptyString, wxITEM_NORMAL);

    mbSetting->Append(m_menuCtrlWrls);
    m_mbFile->Append(mbSetting, _("&Settings"));
    mbHelp = new wxMenu();
    m_menuHelpContent = new wxMenuItem(mbHelp, ID_HLPCONT, _("Help &Contents  \tF1"), wxEmptyString, wxITEM_NORMAL);
    mbHelp->Append(m_menuHelpContent);
    m_menuAboutContent = new wxMenuItem(mbHelp, ID_ABOUT, _("&About"), wxEmptyString, wxITEM_NORMAL);
    mbHelp->Append(m_menuAboutContent);
    m_mbFile->Append(mbHelp, _("&Help"));
    SetMenuBar(m_mbFile);

#if defined(__WXMSW__)
    wxBitmap bitmapScanNw(wxImage(::wxGetApp().strAppPath + _T("pic\\Scannw.png")));
    wxBitmap bitmapScanDisabled(wxImage(::wxGetApp().strAppPath + _T("pic\\Scannw_d.png")));
    m_bBtnScanNw = new CmpcBitmapButton(m_pnlRight, ID_BTNSCANNW, 128, 80, _("Scan for Networks"), bitmapScanNw);
    m_bBtnScanNw->Move(10,24);
    m_bBtnScanNw->SetDisabledBitmap(bitmapScanDisabled);

    wxBitmap bitmapNeighbors(wxImage(::wxGetApp().strAppPath + _T("pic\\Neighbors.png")));
    wxBitmap bitmapNeighborsDisabled(wxImage(::wxGetApp().strAppPath + _T("pic\\Neighbors_d.png")));
    m_bBtnViewNeighbor = new CmpcBitmapButton(m_pnlRight, ID_BTNVIEWNGHBR, 128, 80, _("Neighbors"), bitmapNeighbors);
    m_bBtnViewNeighbor->Move(10,120);
    m_bBtnViewNeighbor->SetDisabledBitmap(bitmapNeighborsDisabled);

    wxBitmap bitmapPrflMgr(wxImage(::wxGetApp().strAppPath + _T("pic\\NetManager.png")));
    wxBitmap bitmapPrflMgrDisabled(wxImage(::wxGetApp().strAppPath + _T("pic\\NetManager.png")));
    m_bBtnPrflMgr = new CmpcBitmapButton(m_pnlRight, ID_BTNPRFLMGR, 128, 80, _("Profile Manager"), bitmapPrflMgr);
    m_bBtnPrflMgr->Move(10,216);
    m_bBtnPrflMgr->SetDisabledBitmap(bitmapPrflMgrDisabled);

    m_btnCtrlWireless = new wxButton(m_pnlRight, ID_BTNCTRLWRLS, _("Turn off wireless"), wxPoint(10,314), wxSize(m_bBtnPrflMgr->GetSize().GetWidth(), 32), 0, wxDefaultValidator, _T("ID_BTNCTRLWRLS"));
#endif

#if defined(__UNIX__)
    m_btnScanNwLnx = new wxButton(m_pnlRight, ID_BTNSCANNW, wxEmptyString, wxPoint(16,24), wxSize(128,80), 0, wxDefaultValidator, _T("ID_BTNSCANNW"));
    wxFont m_btnScanNwFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Arial"),wxFONTENCODING_DEFAULT);
    m_btnScanNwLnx->SetFont(m_btnScanNwFont);
    m_btnViewNghbrLnx = new wxButton(m_pnlRight, ID_BTNVIEWNGHBR, wxEmptyString, wxPoint(16,120), wxSize(128,80), 0, wxDefaultValidator, _T("ID_BTNVIEWNGHBR"));
    wxFont m_btnViewNghbrFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Arial"),wxFONTENCODING_DEFAULT);
    m_btnViewNghbrLnx->SetFont(m_btnViewNghbrFont);
    m_btnPrflMgrLnx = new wxButton(m_pnlRight, ID_BTNPRFLMGR, wxEmptyString, wxPoint(16,216), wxSize(128,80), 0, wxDefaultValidator, _T("ID_BTNPRFLMGR"));
    ScanNtBtnText = new wxStaticText(m_pnlRight, ID_SCANNTBTNTEXT, _("Scan for Networks"), wxPoint(20,80), wxSize(120,17), wxALIGN_RIGHT|wxALIGN_CENTRE, _T("ID_SCANNTBTNTEXT"));
    NeightorText = new wxStaticText(m_pnlRight, ID_NEIGHBORTEXT, _("Neighbors"), wxPoint(32,176), wxSize(96,17), wxALIGN_CENTRE, _T("ID_NEIGHBORTEXT"));
    PrflMgrText = new wxStaticText(m_pnlRight, ID_PRFLMGRTEXT, _("Profile Manager"), wxPoint(28,272), wxSize(104,17), wxALIGN_RIGHT, _T("ID_PRFLMGRTEXT"));
    ScanNwBmp = new wxStaticBitmap(m_pnlRight, ID_SCANMWBMP, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/Scannw.png"))), wxPoint(58,35), wxDefaultSize, 0, _T("ID_SCANMWBMP"));
    NeighborBmp = new wxStaticBitmap(m_pnlRight, ID_NGHBRBMP, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/Neighbors.png"))), wxPoint(58,131), wxDefaultSize, 0, _T("ID_NGHBRBMP"));
    PrflMgrBmp = new wxStaticBitmap(m_pnlRight, ID_PRFLMGRBMP, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/NetManager.png"))), wxPoint(58,227), wxDefaultSize, 0, _T("ID_PRFLMGRBMP"));

    m_btnCtrlWireless = new wxButton(m_pnlRight, ID_BTNCTRLWRLS, _("Turn off wireless"), wxPoint(15,314), wxSize(129,32), 0, wxDefaultValidator, _T("ID_BTNCTRLWRLS"));
#endif

    Center();

    Connect(ID_CMBSWITCHPRFL,wxEVT_COMMAND_COMBOBOX_SELECTED,(wxObjectEventFunction)&NetworkManagerDlg::Onm_cmbSwitchPrflSelect);
    Connect(ID_BTNCTRLCONNECT,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&NetworkManagerDlg::OnButtonCtrlCnctClick);
    Connect(ID_BTNSCANNW,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&NetworkManagerDlg::OnButtonScanNwClick);
    Connect(ID_BTNVIEWNGHBR,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&NetworkManagerDlg::OnButtonViewNghbrClick);
    Connect(ID_BTNPRFLMGR,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&NetworkManagerDlg::OnButtonPrflMgrClick);
    Connect(ID_BTNCTRLWRLS,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&NetworkManagerDlg::OnButtonCtrlWrlsClick);

    Connect(ID_IMPORT,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&NetworkManagerDlg::ImportSchoolSetting);
    Connect(ID_EXIT,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&NetworkManagerDlg::Exit);
    Connect(ID_CNCTPRFL,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&NetworkManagerDlg::ConnectProfile);
    Connect(ID_SCANNW,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&NetworkManagerDlg::MenuScanNw);
    Connect(ID_VIEWNGHBR,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&NetworkManagerDlg::MenuViewNghbr);
    Connect(ID_PRFLMGR,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&NetworkManagerDlg::MenuProfileMgr);
    Connect(ID_MESHCONFIGURATION,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&NetworkManagerDlg::MenuMeshConf);
    Connect(ID_CTRLWRLS,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&NetworkManagerDlg::MenuCtrlWrls);
    Connect(ID_HLPCONT,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&NetworkManagerDlg::MenuHelpContent);
    Connect(ID_ABOUT,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&NetworkManagerDlg::MenuAbout);

#if defined(__WXMSW__)
    m_NwInfoBmp = new wxStaticBitmap(m_pnlLeft, ID_NWINFOBMP, wxBitmap(wxImage(::wxGetApp().strAppPath +_T("pic\\cnctimage_wired.png"))), wxPoint(24,98), wxSize(370,70), 0, _T("ID_NWINFOBMP"));
#endif

#if defined(__UNIX__)
    m_NwInfoBmp = new wxStaticBitmap(m_pnlLeft, ID_NWINFOBMP, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/cnctimage_wired.png"))), wxPoint(24,98), wxSize(370,70), 0, _T("ID_NWINFOBMP"));
#endif
    m_isApplyingProfile = false;
    m_iSelectedToApply = -1;
    wxIcon icon_manager(icon_manage_xpm);
    SetIcon(icon_manager);
}

NetworkManagerDlg::~NetworkManagerDlg()
{
    m_pGaugeDialog->Destroy();
    m_pGaugeDialog = NULL;
}

void NetworkManagerDlg::OnActivate(wxActivateEvent& event)
{
    if ( event.GetActive() )
    {
        Show(true);
        Raise();
    }
    event.Skip();
}

bool NetworkManagerDlg::Destroy()
{
    if ( ::wxGetApp().GetENMTaskTray()->IsProtocolSupported() )
    {
        Show(false);
    }
    else
    {
        ::wxExit();
    }
    return true;
}

bool NetworkManagerDlg::Show(bool show)
{
    if ( show )
    {
        SetNetworkProfile();
    }
    else
    {
        m_pGaugeDialog->Show(false);
    }
    return wxFrame::Show(show);
}

void NetworkManagerDlg::SetNetworkProfile()
{
    ProfileManagementControl* pController = DataCenter::GetInstance()->GetProfileController();
    wxString currentProfile = pController->GetCurrentProfile();
    ProfileList_t cp = pController->GetCurrentUsedProfile();
//    m_stcCurrentPfle->SetLabel(currentProfile);
    int iSelection = -1;
    if ( !pController->GetUserProfiles(m_profileVector, ENMUtil::IsAdministrator(), true) )
        return;

    unsigned int i;
    for ( i=0; i < m_cmbSwitchPrfl->GetCount(); i++ )
    {
        int* pInt = static_cast<int*>(m_cmbSwitchPrfl->GetClientData(i));
        m_cmbSwitchPrfl->SetClientData(i, NULL);
        delete pInt;
    }
    m_cmbSwitchPrfl->Clear();

    if ( m_profileVector.size() == 0 )
    {
        m_btnCtrlConnect->Enable(false);
        m_menuCnctPrfl->Enable(false);
        return;
    }

    m_cmbSwitchPrfl->SetValue(currentProfile);

    if ( currentProfile.length() == 0 )
    {
        m_btnCtrlConnect->Enable(false);
        m_menuCnctPrfl->Enable(false);
    }
    i = 0;
    wxString strBmpName = wxT("");
    for ( vector<ProfileList_t>::size_type index = 0; index < m_profileVector.size(); index++ )
    {
        ProfileList_t profile = m_profileVector.at(index);
        if ( profile.sShow != "1" )
            continue;

        int bmpNum = atoi(profile.sProfileIcon.c_str());
        switch(bmpNum)
        {
            #if defined(__WXMSW__)
            case 0:
                strBmpName = wxT("pic\\general.png");
                break;
            case 1:
                strBmpName = wxT("pic\\home.png");
                break;
            case 2:
                strBmpName = wxT("pic\\personal.png");
                break;
            case 3:
                strBmpName = wxT("pic\\house.png");
                break;
            case 4:
                strBmpName = wxT("pic\\hospital.png");
                break;
            case 5:
                strBmpName = wxT("pic\\building.png");
                break;
            case 6:
                strBmpName = wxT("pic\\bucket.png");
                break;
            case 7:
                strBmpName = wxT("pic\\airport.png");
                break;
            default:
                strBmpName = wxT("pic\\empty_profile.png");
                break;
            #endif
            #if defined(__UNIX__)
            case 0:
                strBmpName = wxT("pic/general.png");
                break;
            case 1:
                strBmpName = wxT("pic/home.png");
                break;
            case 2:
                strBmpName = wxT("pic/personal.png");
                break;
            case 3:
                strBmpName = wxT("pic/house.png");
                break;
            case 4:
                strBmpName = wxT("pic/hospital.png");
                break;
            case 5:
                strBmpName = wxT("pic/building.png");
                break;
            case 6:
                strBmpName = wxT("pic/bucket.png");
                break;
            case 7:
                strBmpName = wxT("pic/airport.png");
                break;
            default:
                strBmpName = wxT("pic/empty_profile.png");
                break;
            #endif
        }
        wxBitmap iconBmp(::wxGetApp().strAppPath + strBmpName, wxBITMAP_TYPE_PNG);
        wxString profileName = wxString::FromUTF8(profile.sProfileName.c_str());
        m_cmbSwitchPrfl->Insert(profileName, iconBmp, i);
        m_cmbSwitchPrfl->SetClientData(i, new int(index));
        if ( profileName.Cmp(currentProfile) == 0 && profile.sPermission == cp.sPermission )
        {
            iSelection = i;
        }
        i++;
    }
    m_cmbSwitchPrfl->SetSelection(iSelection);
    m_iSelectedToApply = iSelection;
}

void NetworkManagerDlg::SetNetworkProfile_NN()
{
    ProfileManagementControl* pController = DataCenter::GetInstance()->GetProfileController();
    wxString currentProfile = pController->GetCurrentProfile();
    ProfileList_t cp = pController->GetCurrentUsedProfile();
//    m_stcCurrentPfle->SetLabel(currentProfile);
    int iSelection = -1;
    if ( !pController->GetUserProfiles(m_profileVector, ENMUtil::IsAdministrator(), true) )
        return;

    unsigned int i;
    for ( i=0; i < m_cmbSwitchPrfl->GetCount(); i++ )
    {
        int* pInt = static_cast<int*>(m_cmbSwitchPrfl->GetClientData(i));
        m_cmbSwitchPrfl->SetClientData(i, NULL);
        delete pInt;
    }
    m_cmbSwitchPrfl->Clear();

    if ( m_profileVector.size() == 0 )
    {
        m_btnCtrlConnect->Enable(false);
        m_menuCnctPrfl->Enable(false);
        return;
    }

    m_cmbSwitchPrfl->SetValue(currentProfile);

    if ( currentProfile.length() == 0 )
    {
        m_btnCtrlConnect->Enable(false);
        m_menuCnctPrfl->Enable(false);
    }
    i = 0;
    wxString strBmpName = wxT("");
    for ( vector<ProfileList_t>::size_type index = 0; index < m_profileVector.size(); index++ )
    {
        ProfileList_t profile = m_profileVector.at(index);
        if ( profile.sShow != "1" )
            continue;

        int bmpNum = atoi(profile.sProfileIcon.c_str());
        switch(bmpNum)
        {
            #if defined(__WXMSW__)
            case 0:
                strBmpName = wxT("pic\\general.png");
                break;
            case 1:
                strBmpName = wxT("pic\\home.png");
                break;
            case 2:
                strBmpName = wxT("pic\\personal.png");
                break;
            case 3:
                strBmpName = wxT("pic\\house.png");
                break;
            case 4:
                strBmpName = wxT("pic\\hospital.png");
                break;
            case 5:
                strBmpName = wxT("pic\\building.png");
                break;
            case 6:
                strBmpName = wxT("pic\\bucket.png");
                break;
            case 7:
                strBmpName = wxT("pic\\airport.png");
                break;
            default:
                strBmpName = wxT("pic\\empty_profile.png");
                break;
            #endif
            #if defined(__UNIX__)
            case 0:
                strBmpName = wxT("pic/general.png");
                break;
            case 1:
                strBmpName = wxT("pic/home.png");
                break;
            case 2:
                strBmpName = wxT("pic/personal.png");
                break;
            case 3:
                strBmpName = wxT("pic/house.png");
                break;
            case 4:
                strBmpName = wxT("pic/hospital.png");
                break;
            case 5:
                strBmpName = wxT("pic/building.png");
                break;
            case 6:
                strBmpName = wxT("pic/bucket.png");
                break;
            case 7:
                strBmpName = wxT("pic/airport.png");
                break;
            default:
                strBmpName = wxT("pic/empty_profile.png");
                break;
            #endif
        }
        m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + strBmpName, wxBITMAP_TYPE_PNG);
        wxString profileName = wxString::FromUTF8(profile.sProfileName.c_str());
        m_cmbSwitchPrfl->Insert(profileName, *m_bmpPrfl, i);
        m_cmbSwitchPrfl->SetClientData(i, new int(index));
        if ( profileName.Cmp(currentProfile) == 0 && profile.sPermission == cp.sPermission )
        {
            iSelection = i;
        }
        i++;
    }
//    m_cmbSwitchPrfl->SetSelection(iSelection);
    m_cmbSwitchPrfl->SetText(wxT("        ") +currentProfile);
    m_iSelectedToApply = iSelection;
}

void NetworkManagerDlg::ImportSchoolSetting(wxCommandEvent& event)
{
    if ( DataCenter::GetInstance()->GetProfileManagerDlgHandle()->IsShown() )
    {
        wxMessageDialog msg(this, _("The Profile Manager dialog is already open. \nPlease close it before importing school settings."), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        return;
    }

    wxFileDialog dialog(this, _("Please choose a file to import"), wxEmptyString, wxEmptyString, _T("Tar files (*.tar)|*.tar"), wxOPEN);
    if ( dialog.ShowModal() == wxID_OK )
    {
        wxString strTarFile = dialog.GetPath();
        wxArrayString as;
        if ( m_importer.ImportSchoolSetting(strTarFile, &as) )
        {
            wxMessageDialog msg(this, _("Import successful."), _("Message"), wxOK | wxICON_INFORMATION);
            msg.ShowModal();
            SetNetworkProfile();
        }
        else
        {
            wxString message(_("Failed to import school settings.\n"));
            if ( as.GetCount() > 0 )
            {
                message += _("\nThe following files were not imported.");
                for ( size_t i = 0; i < as.Count(); i++ )
                {
                    message += (_T("\n") + as.Item(i));
                }
            }
            wxMessageDialog msg(this, message, _("Message"), wxOK | wxICON_INFORMATION);
            msg.ShowModal();
        }
        // import policy
        DataCenter::GetInstance()->ReloadSchoolPolicy();
    }
}

void NetworkManagerDlg::Exit(wxCommandEvent& event)
{
    Close();
}

void NetworkManagerDlg::ConnectProfile(wxCommandEvent& event)
{
    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }
//    DataCenter::GetInstance()->SetAutoWirelessFlag(false);
    OnConnectProfile();
}

void NetworkManagerDlg::MenuScanNw(wxCommandEvent& event)
{
    OnButtonScanNwClick(event);
}

void NetworkManagerDlg::MenuViewNghbr(wxCommandEvent& event)
{
//    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
//    {
//        return;
//    }
//	if ( NULL == viewAPNeighborsDlg )
//    {
//        viewAPNeighborsDlg = new ViewAPNeighborsDlg(NULL);
//    }
//    viewAPNeighborsDlg->ShowModal();
    OnButtonViewNghbrClick(event);
}

void NetworkManagerDlg::MenuProfileMgr(wxCommandEvent& event)
{
    OnButtonPrflMgrClick(event);
}

void NetworkManagerDlg::MenuCtrlWrls(wxCommandEvent& event)
{
    OnButtonCtrlWrlsClick(event);
}

void NetworkManagerDlg::MenuHelpContent(wxCommandEvent& event)
{
#if defined(__UNIX__)
    if(wxFileExists(wxT("/usr/share/doc/easy-network/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf.gz")))
    {
        wxString cmd = wxT("evince /usr/share/doc/easy-network/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf.gz --page-label=21");
        wxExecute(cmd);
    }
#endif
#if defined(__WXMSW__)
    // just for test
    ENMUtil::ShowContextHelp(this, wxEmptyString);
#endif
}

void NetworkManagerDlg::MenuAbout(wxCommandEvent& event)
{
    AboutDialog dlg(this);
    dlg.ShowModal();
}

void NetworkManagerDlg::OnButtonCtrlCnctClick(wxCommandEvent& event)
{
    if ( ::wxGetApp().m_nMeshStatus != MESHSTATUS_MESHCLOSE &&
     ::wxGetApp().m_nMeshStatus != MESHSTATUS_MESHSERVER)
    {
        DCS_TurnOnMesh(FALSE);
        ::wxGetApp().m_nMeshStatus = MESHSTATUS_MESHCLOSE;
    }
    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }

    ScanNetworkDlg* pScanNetworkDlg = DataCenter::GetInstance()->GetScanNetworkDlgHandle();
    if ( pScanNetworkDlg->IsShown() )
    {
        pScanNetworkDlg->CloseDialog(wxID_CANCEL);
    }

//    DataCenter::GetInstance()->SetAutoWirelessFlag(false);
    OnConnectProfile();
}

void NetworkManagerDlg::OnButtonScanNwClick(wxCommandEvent& event)
{
    PolicyManager* p = DataCenter::GetInstance()->GetPolicyManager();
    if ( !p->IsScanEnable() )
    {
        wxMessageDialog dlg(this, _("The current policy forbids scanning for wireless networks."), _("Message"), wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }

    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }
    if ( IsApplyingProfile() )
    {
        return;
    }

    ScanNetworkDlg* pScanNetworkDialog = DataCenter::GetInstance()->GetScanNetworkDlgHandle();
    pScanNetworkDialog->SetDialogMode(true);
    pScanNetworkDialog->ShowModal();
}

void NetworkManagerDlg::OnButtonViewNghbrClick(wxCommandEvent& event)
{
    if(::wxGetApp().m_nMeshStatus != MESHSTATUS_MESHCLOSE)
    {
        ViewMeshNeighborsDlg dlg(0);
        dlg.ShowModal();
        return;
    }
    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }
    if ( NULL == viewAPNeighborsDlg )
    {
        viewAPNeighborsDlg = new ViewAPNeighborsDlg(NULL);
    }
//    viewAPNeighborsDlg->Move(257, 110);
    viewAPNeighborsDlg->ShowModal();
}

void NetworkManagerDlg::OnButtonPrflMgrClick(wxCommandEvent& event)
{
    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }

    PolicyManager* p = DataCenter::GetInstance()->GetPolicyManager();
    if ( !p->IsAllowOwnerProfile() )
    {
        wxMessageDialog dlg(this, _("The current policy forbids maintaining profiles."), _("Message"), wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }

    ScanNetworkDlg* pScanNetworkDlg = DataCenter::GetInstance()->GetScanNetworkDlgHandle();
    if ( pScanNetworkDlg != NULL && pScanNetworkDlg->IsShown() )
        pScanNetworkDlg->CloseDialog(wxID_CANCEL);

    ProfileManagerDlg* pProfileManagerDlg = DataCenter::GetInstance()->GetProfileManagerDlgHandle();
    if( NULL == pProfileManagerDlg )
    {
        return;
    }
    pProfileManagerDlg->Iconize(false);
    pProfileManagerDlg->Show(true);
    pProfileManagerDlg->Raise();
}

void NetworkManagerDlg::Onm_cmbSwitchPrflSelect(wxCommandEvent& event)
{
    if ( m_cmbSwitchPrfl->GetCount() == 0 )
        return;
    m_iSelectedToApply = event.GetSelection();
    if ( m_iSelectedToApply == wxNOT_FOUND )
        return;

    int* pInt = static_cast<int*>(m_cmbSwitchPrfl->GetClientData(m_iSelectedToApply));
    ProfileList_t cp = m_profileVector.at(*pInt);
    m_strFromMenu = DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile();
    ProfileList_t profile = DataCenter::GetInstance()->GetProfileController()->GetCurrentUsedProfile();
    //m_stcPrflBmp->Show(false);

    if ( cp.sProfileName == profile.sProfileName && cp.sPermission == profile.sPermission )
    {
        m_btnCtrlConnect->SetLabel(_("Disconnect"));
        m_menuCnctPrfl->SetText(_("&Disconnect"));
    }
    else
    {
        m_btnCtrlConnect->SetLabel(_("Connect"));
        m_menuCnctPrfl->SetText(_("&Connect"));
    }

    m_btnCtrlConnect->Enable(true);
    m_menuCnctPrfl->Enable(true);
}

void NetworkManagerDlg::OnButtonCtrlWrlsClick(wxCommandEvent& event)
{
    if ( ::wxGetApp().m_nMeshStatus != MESHSTATUS_MESHCLOSE &&
     ::wxGetApp().m_nMeshStatus != MESHSTATUS_MESHSERVER)
    {
        DCS_TurnOnMesh(FALSE);
        ::wxGetApp().m_nMeshStatus = MESHSTATUS_MESHCLOSE;
        DataCenter::GetInstance()->SetNetworkMode(NETWORK_MODE_DISCONNECTED);
    }

    PolicyManager* p = DataCenter::GetInstance()->GetPolicyManager();
    if ( !p->IsAllowTurnOnWireless() )
    {
        wxMessageDialog dlg(this, _("The current policy forbids turning on/off wireless."), _("Message"), wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }

    bool wlanFoundAdapter = false;
#if defined(__WXMSW__)
    wxArrayString array = DataCenter::GetInstance()->GetNetworkAdapterName(ADAPTER_WIREDLESS);
    wlanFoundAdapter = array.GetCount() > 0;
#endif
#if defined(__UNIX__)
    BOOL existWirelessAdapter;
    DCS_IsExistAdapter(DCS_ADAPTER_WIREDLESS, &existWirelessAdapter);
    wlanFoundAdapter = existWirelessAdapter ? true : false;
//    wlanFoundAdapter  = true;
#endif
    if ( !wlanFoundAdapter )
    {
        wxMessageDialog msg(this, _("Cannot find wireless adapter!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
    }
    else
    {
        SetWirelessSwitch();
    }
}

void NetworkManagerDlg::SetWirelessSwitch()
{
    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }

    if ( IsApplyingProfile() )
    {
        return;
    }

    m_btnCtrlWireless->Enable(false);
    m_timerWireless.Start(30000, wxTIMER_ONE_SHOT);

    DataCenter* pDataCenter = DataCenter::GetInstance();
    NETWORK_MODE networkMode = pDataCenter->GetCurrentNetworkMode();
    ENMUtil::Log(logFile, wxString::Format(_T("networkMode is %d"), networkMode));
    switch ( networkMode )
    {
    case NETWORK_MODE_WIRED_LAN_CONNECT:
    case NETWORK_MODE_WIRED_LAN_DISCONNECT:
        pDataCenter->SwitchAdapterParameter(ADAPTER_WIRED, ADAPTER_WIREDLESS, this);
        pDataCenter->SetShowBalloonFlag(false);
//        pDataCenter->EnableNetworkAdapter(ADAPTER_WIRED,false);
//        pDataCenter->EnableNetworkAdapter(ADAPTER_WIREDLESS,true);
        break;

    case NETWORK_MODE_WIRELESS_LAN_CONNECT:
    case NETWORK_MODE_WIRELESS_LAN_DISCONNECT:
        ENMTaskTray::GetInstance()->SetWaitingForSwitch(true);
        pDataCenter->SwitchAdapterParameter(ADAPTER_WIREDLESS, ADAPTER_WIRED, this);
//        pDataCenter->EnableNetworkAdapter(ADAPTER_WIREDLESS,false);
//        pDataCenter->EnableNetworkAdapter(ADAPTER_WIRED,true);
        break;

    case NETWORK_MODE_DISCONNECTED:
        pDataCenter->SwitchAdapterParameter(ADAPTER_NONE, ADAPTER_WIREDLESS, this);
//        pDataCenter->EnableNetworkAdapter(ADAPTER_WIREDLESS,true);
        break;

    default:
        break;
    }
}

void NetworkManagerDlg::DisableSQInfo()
{
    m_gueSQ->SetValue(0);
    m_gueSQ->Enable(false);
    m_stcSQTitle->Enable(false);
    m_stcSQVal->Show(false);
}

void NetworkManagerDlg::EnableSQInfo()
{
    m_gueSQ->Enable(true);
    m_stcSQTitle->Enable(true);
    m_stcSQVal->Show(true);
}

void NetworkManagerDlg::DisableScanNTandViewNb()
{
#if defined(__WXMSW__)
    m_bBtnScanNw->Enable(false);
    m_menuScanNW->Enable(false);
    m_bBtnViewNeighbor->Enable(false);
    m_menuViewNghbr->Enable(false);
#endif
#if defined(__UNIX__)
    m_btnScanNwLnx->Enable(false);
    ScanNtBtnText->Enable(false);
    ScanNwBmp->Enable(false);
    m_menuScanNW->Enable(false);

    m_btnViewNghbrLnx->Enable(false);
    NeightorText->Enable(false);
    NeighborBmp->Enable(false);
    m_menuViewNghbr->Enable(false);
#endif
}

void NetworkManagerDlg::EnableScanNTandViewNb()
{
#if defined(__WXMSW__)
    m_bBtnScanNw->Enable(true);
    m_menuScanNW->Enable(true);
    m_bBtnViewNeighbor->Enable(true);
    m_menuViewNghbr->Enable(true);
#endif
#if defined(__UNIX__)
    m_btnScanNwLnx->Enable(true);
    ScanNtBtnText->Enable(true);
    ScanNwBmp->Enable(true);
    m_menuScanNW->Enable(true);

    m_btnViewNghbrLnx->Enable(true);
    NeightorText->Enable(true);
    NeighborBmp->Enable(true);
    m_menuViewNghbr->Enable(true);
#endif
}
void NetworkManagerDlg::EnableViewNb()
{
    m_btnViewNghbrLnx->Enable(true);
    NeightorText->Enable(true);
    NeighborBmp->Enable(true);
    m_menuViewNghbr->Enable(true);
}

void NetworkManagerDlg::UI_UpdateNetworkMode(NETWORK_MODE networkMode)
{
    if ( !m_cmbSwitchPrfl->GetValue().Cmp(_T("")) )
    {
         m_btnCtrlConnect->Enable(false);
         m_menuCnctPrfl->Enable(false);
         m_btnCtrlConnect->SetLabel(_("Connect"));
         m_menuCnctPrfl->SetText(_("&Connect"));
    }
    else
    {
        m_btnCtrlConnect->Enable(true);
        m_menuCnctPrfl->Enable(true);
    }

    wxBitmap bitmap ;
    switch ( networkMode )
    {
        case NETWORK_MODE_WIRED_LAN_CONNECT:
        {
#if defined(__WXMSW__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\cnctimage_wired.png")));
#endif
#if defined(__UNIX__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/cnctimage_wired.png")));
#endif
            DisableSQInfo();
            DisableScanNTandViewNb();

            m_btnCtrlWireless->SetLabel(_("Turn on wireless"));
            m_menuCtrlWrls->SetText(_("T&urn on wireless"));
            if ( m_cmbSwitchPrfl->GetValue().Cmp(_T("")) && DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile().length() != 0 )
            {
	            m_btnCtrlConnect->SetLabel(_("Disconnect"));
	            m_menuCnctPrfl->SetText(_("&Disconnect"));
            }
            else
            {
                m_btnCtrlConnect->SetLabel(_("Connect"));
	            m_menuCnctPrfl->SetText(_("&Connect"));
            }

        }
        break;
        case NETWORK_MODE_WIRED_LAN_DISCONNECT:
        {
#if defined(__WXMSW__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\cnctimage_disconnect.png")));
#endif
#if defined(__UNIX__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/cnctimage_disconnect.png")));
#endif
            DisableSQInfo();
            DisableScanNTandViewNb();

            m_btnCtrlWireless->SetLabel(_("Turn on wireless"));
            m_menuCtrlWrls->SetText(_("T&urn on wireless"));

            if ( m_cmbSwitchPrfl->GetValue().Cmp(_T("")) )
            {
	            m_btnCtrlConnect->SetLabel(_("Connect"));
	            m_menuCnctPrfl->SetText(_("&Connect"));
            }
        }
        break;
        case NETWORK_MODE_WIRELESS_LAN_CONNECT:
        {
#if defined(__WXMSW__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\cnctimage.png")));
#endif
#if defined(__UNIX__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/cnctimage.png")));
#endif
            EnableSQInfo();
            EnableScanNTandViewNb();

            m_btnCtrlWireless->SetLabel(_("Turn off wireless"));
            m_menuCtrlWrls->SetText(_("T&urn off wireless"));

            if ( m_cmbSwitchPrfl->GetValue().Cmp(_T("")) && DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile().length() != 0 )
            {
	            m_btnCtrlConnect->SetLabel(_("Disconnect"));
	            m_menuCnctPrfl->SetText(_("&Disconnect"));
            }
            else
            {
                m_btnCtrlConnect->SetLabel(_("Connect"));
	            m_menuCnctPrfl->SetText(_("&Connect"));
            }
        }
        break;
        case NETWORK_MODE_WIRELESS_LAN_DISCONNECT:
        {
#if defined(__WXMSW__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\cnctimage_disconnect.png")));
#endif
#if defined(__UNIX__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/cnctimage_disconnect.png")));
#endif
            EnableSQInfo();
            EnableScanNTandViewNb();

            m_btnCtrlWireless->SetLabel(_("Turn off wireless"));
            m_menuCtrlWrls->SetText(_("T&urn off wireless"));

            if ( m_cmbSwitchPrfl->GetValue().Cmp(_T("")) )
            {
	            m_btnCtrlConnect->SetLabel(_("Connect"));
	            m_menuCnctPrfl->SetText(_("&Connect"));
            }
        }
        break;

        case NETWORK_MODE_DISCONNECTED:
        {
#if defined(__WXMSW__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\cnctimage_disconnect.png")));
#endif
#if defined(__UNIX__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/cnctimage_disconnect.png")));
#endif
            m_btnCtrlWireless->SetLabel(_("Turn on wireless"));
            m_menuCtrlWrls->SetText(_("T&urn on wireless"));

            if ( m_cmbSwitchPrfl->GetValue().Cmp(_T("")) )
            {
	            m_btnCtrlConnect->SetLabel(_("Connect"));
	            m_menuCnctPrfl->SetText(_("&Connect"));
            }
            DisableSQInfo();
            DisableScanNTandViewNb();
        }
        break;

        case NETWORK_MODE_MESH_CONNECT:
        {
#if defined(__WXMSW__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\cnctimage_mesh.png")));
#endif
#if defined(__UNIX__)
            bitmap = wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/cnctimage_mesh.png")));
#endif
            EnableSQInfo();
            DisableScanNTandViewNb();
            if(::wxGetApp().m_nMeshStatus == MESHSTATUS_MESHSERVER)
                EnableScanNTandViewNb();
            EnableViewNb();

            m_btnCtrlWireless->SetLabel(_("Turn on wireless"));
            m_menuCtrlWrls->SetText(_("T&urn on wireless"));

            if ( m_cmbSwitchPrfl->GetValue().Cmp(_T("")) && DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile().length() != 0 )
            {
	            m_btnCtrlConnect->SetLabel(_("Disconnect"));
	            m_menuCnctPrfl->SetText(_("&Disconnect"));
            }
            else
            {
                m_btnCtrlConnect->SetLabel(_("Connect"));
	            m_menuCnctPrfl->SetText(_("&Connect"));
            }
        }
        break;
        default:
        break;
    }

    m_NwInfoBmp->SetBitmap(bitmap);
    m_NwInfoBmp->Refresh();
//    m_btnCtrlWireless->Enable(true);
//    RefreshProfileName();
}

void NetworkManagerDlg::UI_UpdateNetworkStatusInfo(NETWORK_MODE networkMode, UI_NETWORK_STATUS_INFO& statusInfo)
{
        static int nTwice = 0;

    static bool bChange = false;

    if( wxOldIP.Cmp( statusInfo.IPAddress )!=0 )
    {
        bChange = true;
        nTwice = 0;
    }

    if(bChange)
    {
        nTwice++;
    }
//    if(nTwice ==1)
//    {
//         printf("NetworkManagerDlg::ReconnectPublish\n");
//         wxGetApp().StopPublish();
//         ENMUtil::Log(logFile, _T(" ip have changed nTwice = 1 ,stoppublish"));
//    }

    if(nTwice ==3)
    {

        bChange = false;
        nTwice = 0;
        if(statusInfo.IPAddress.Cmp(wxT(""))!=0)
        {
//            printf("NetworkManagerDlg::ReconnectPublish\n");
//            wxGetApp().ReconnectPublish();
              wxGetApp().StartPublishTimer();
//            ENMUtil::Log(logFile, _T(" ip have changed, nTwice = 3 "));
        }
    }

    wxOldIP = statusInfo.IPAddress;
    printf("nTwice = %d\n",nTwice);

     wxString strCurrentSelection = m_cmbSwitchPrfl->GetValue().Trim(false);
     wxString strCurrentProfile = DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile();
     switch ( networkMode )
     {
        case NETWORK_MODE_WIRED_LAN_CONNECT:
            m_stcStatus->SetLabel(_("Connected"));
            m_stcType->SetLabel(statusInfo.Type);
            m_stcIPAddr->SetLabel(statusInfo.IPAddress);
            break;
        case NETWORK_MODE_WIRED_LAN_DISCONNECT:
            m_stcStatus->SetLabel(_("Disconnected"));
            m_stcType->SetLabel(_T(""));
            //m_stcIPAddr->SetLabel(statusInfo.IPAddress);
            m_stcIPAddr->SetLabel(_T(""));
            break;
        case NETWORK_MODE_WIRELESS_LAN_CONNECT:
            m_gueSQ->SetValue(statusInfo.SignalQuality);
            m_stcSQVal->SetLabel(wxString::Format(_T("%d"),statusInfo.SignalQuality) + _T("%"));
            m_stcStatus->SetLabel(_("Connected"));
            m_stcType->SetLabel(statusInfo.Type);
            m_stcIPAddr->SetLabel(statusInfo.IPAddress);
//            m_stcIPAddr->SetLabel(_T(""));
            break;
        case NETWORK_MODE_WIRELESS_LAN_DISCONNECT:
            m_gueSQ->SetValue(0);
            m_stcSQVal->SetLabel(_T(""));
            m_stcStatus->SetLabel(_("Disconnected"));
            m_stcType->SetLabel(_T(""));
            m_stcIPAddr->SetLabel(_T(""));
            break;
        case NETWORK_MODE_DISCONNECTED:
            m_stcStatus->SetLabel(_T(""));
            m_stcType->SetLabel(_T(""));
            m_stcIPAddr->SetLabel(_T(""));
            break;
        case NETWORK_MODE_MESH_CONNECT:
            m_stcStatus->SetLabel(_("Connected"));
            m_stcType->SetLabel(statusInfo.Type);
            m_stcIPAddr->SetLabel(statusInfo.IPAddress);
            break;
        default:
            break;
     }
     RefreshProfileName();
}

void NetworkManagerDlg::ShowApplyingProcessDialog(const wxString& profileName, bool show)
{
    m_isApplyingProfile = show;
    wxString label = _("Applying profile ") + profileName + _T("...");
    m_pGaugeDialog->SetProcessLabel(label);
    m_pGaugeDialog->Show(show);
    #if defined(__UNIX__)
    m_pGaugeDialog->Move(377, 270);
    #endif
}

void NetworkManagerDlg::SetComboxCurrentProfileName()
{
    m_cmbSwitchPrfl->SetValue(DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile());
}

void NetworkManagerDlg::OnWlanAcmEvent(WlanAcmEvent& event)
{
    m_stcCurrentPfle->SetLabel(DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile());
}

void NetworkManagerDlg::OnTimer(wxTimerEvent& event)
{
    int id = event.GetId();
    if ( id == ID_TIMER_PROFILE )
    {
        wxString strProfile = m_cmbSwitchPrfl->GetValue();
        if ( strProfile.Length() != 0 )
        {
            m_btnCtrlConnect->Enable(true);
            m_menuCnctPrfl->Enable(true);
        }
    }
    else if ( id == ID_TIMER_WIRELESS )
    {
        m_btnCtrlWireless->Enable(true);
    }
}

void NetworkManagerDlg::OnConnectProfile()
{
//    wxString profileName = m_cmbSwitchPrfl->GetValue();
//    if ( profileName.Cmp(_T("")) == 0 )
//        return;

    ProfileManagementControl* pController = DataCenter::GetInstance()->GetProfileController();
    bConnectFinish = false;
    if ( !m_btnCtrlConnect->GetLabel().Cmp(_("Connect")) )
    {
        DataCenter::GetInstance()->SetShowBalloonFlag(false);
        if ( m_iSelectedToApply == wxNOT_FOUND )
            return;
        int* pProfileIndex = static_cast<int*>(m_cmbSwitchPrfl->GetClientData(m_iSelectedToApply));
        ProfileList_t profile = m_profileVector.at(*pProfileIndex);
        wxString profileName = wxString::FromUTF8(profile.sProfileName.c_str());
        ShowApplyingProcessDialog(profileName, true);
        pController->ApplyProfile(profile);
    }
    else
    {
        DataCenter::GetInstance()->SetShowBalloonFlag(true);
        pController->DisconnectCurrentProfile();
        bConnectFinish = true;
    }
    m_timerProfile.Start(20000, wxTIMER_ONE_SHOT);
    m_btnCtrlConnect->Enable(false);
    m_menuCnctPrfl->Enable(false);
}

void NetworkManagerDlg::OnProfileChangedEvent(ProfileEvent& event)
{
    ENMUtil::Log(logFile, _T("Enter NetworkManagerDlg::OnProfileChangedEvent"));
    SetNetworkProfile();
    unsigned int id = event.GetId();
    unsigned long code = event.GetEventCode();
    if ( id == ID_PROFILE_APPLY )
    {
        ENMUtil::Log(logFile, _T("\t Apply profile"));
    //    if ( code != PEVT_PROFILE_APPLY_DISCONNECT )
    //    {
    //        m_btnCtrlConnect->Enable(true);
    //    }
        switch ( code )
        {
        case PEVT_PROFILE_APPLY_SUCCESS:
            m_btnCtrlConnect->Enable(true);
            m_menuCnctPrfl->Enable(true);
            m_btnCtrlConnect->SetLabel(_("Disconnect"));
            m_menuCnctPrfl->SetText(_("&Disconnect"));
            // continue going through, no break
        case PEVT_PROFILE_APPLY_FAILED:
            ShowApplyingProcessDialog(wxEmptyString, false);
            break;
        case PEVT_PROFILE_APPLY_REAPPLY:
        {
            ENMUtil::Log(logFile, _T("\t Reapply profile"));
            ProfileList_t profile = DataCenter::GetInstance()->GetProfileController()->GetCurrentUsedProfile();
            wxString strProfileName = wxString::FromUTF8(profile.sProfileName.c_str());
            ENMUtil::Log(logFile, _T("\t re-apply profile: \"") + strProfileName + _T("\""));
            ENMUtil::Log(logFile, wxString::Format(_T("NETWORK_MODE is %d"), DataCenter::GetInstance()->GetCurrentNetworkMode()));
            if ( profile.sProfileName.length() == 0 )
            {
                ENMUtil::Log(logFile, _T("length is 0"));
//                if ( profile.stGenernalSet.ConnecType == "wireless" )
                NETWORK_MODE mode = DataCenter::GetInstance()->GetCurrentNetworkMode();
                if ( mode == NETWORK_MODE_WIRELESS_LAN_CONNECT || mode == NETWORK_MODE_WIRELESS_LAN_DISCONNECT )
                {
//                    DataCenter::GetInstance()->SetAutoWirelessFlag(false);
                    ENMTaskTray::GetInstance()->SetApplyWirelessFlag(false);
                    ENMTaskTray::GetInstance()->ApplyWirelessProfile();
                }
                else if ( mode == NETWORK_MODE_WIRED_LAN_CONNECT || mode == NETWORK_MODE_WIRED_LAN_DISCONNECT )
                {
                    ENMTaskTray::GetInstance()->SetApplyWiredFlag(false);
                    ENMTaskTray::GetInstance()->ApplyWiredProfile();
                }
            }
            else
            {
                DataCenter::GetInstance()->GetProfileController()->ApplyProfile(profile);
                DataCenter::GetInstance()->StartGlobalTimer();
            }
        }
            break;
        default:
            break;
        }
    }
    else if ( (unsigned int)id == ID_PROFILE_CHANGED )
    {
        ENMUtil::Log(logFile, _T("\t Profile changed"));
        ProfileEvent profileEvent(ID_PROFILE_CHANGED, PEVT_CURRENT_PROFILE_CHANGED);
        ::wxPostEvent(DataCenter::GetInstance()->GetProfileManagerDlgHandle(), profileEvent);
    }
    ENMUtil::Log(logFile, _T("Return NetworkManagerDlg::OnProfileChangedEvent\n"));
}

void NetworkManagerDlg::OnSwitchAdapterEvent(SwitchAdapterEvent& event)
{
    m_btnCtrlWireless->Enable(true);
    m_timerWireless.Stop();
    if ( event.GetEnabledAdapterType() == ADAPTER_WIREDLESS && event.IsSuccess() )
    {
//        DataCenter::GetInstance()->SetAutoWirelessFlag(false);
//        ENMTaskTray::GetInstance()->SetApplyWirelessFlag(false);
//        ENMTaskTray::GetInstance()->ApplyWirelessProfile();
    }
}

void NetworkManagerDlg::RefreshProfileName()
{
    wxString strProfile = DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile();
    APStatus* pAP = DataCenter::GetInstance()->GetCurrentAPStatus();
    if ( strProfile.Length() == 0 && pAP != NULL )
    {
        strProfile = wxString::FromUTF8((const char*)pAP->ssid.ucSsid);
    }

    if ( strProfile.Length() == 0 && DataCenter::GetInstance()->IsInterfaceEnabled(ADAPTER_WIRED) )
    {
        strProfile = _("Wired LAN");
    }
    DataCenter* pDataCenter = DataCenter::GetInstance();
    NETWORK_MODE networkMode = pDataCenter->GetCurrentNetworkMode();
    if( networkMode ==  NETWORK_MODE_MESH_CONNECT)
    {
        strProfile = _("Mesh");
    }
    m_stcCurrentPfle->SetLabel(strProfile);
}

void NetworkManagerDlg::OnWirelessNetworkChanged(const WirelessSwitchEvent& event)
{
    RefreshProfileName();
}

bool NetworkManagerDlg::IsApplyingProfile() const
{
    return m_isApplyingProfile;
}

void NetworkManagerDlg::RefreshProfileList()
{
    m_cmbSwitchPrfl->Refresh();
}
void NetworkManagerDlg::MenuMeshConf(wxCommandEvent& event)
{
    MeshConfigurationDlg dlg(0);
    dlg.ShowModal();
}
