#include <ace/Auto_Ptr.h>
#include <ace/INET_Addr.h>
#include <ace/Log_Msg.h>
#include <ace/OS.h>
#include <ace/SOCK_Acceptor.h>
#include <ace/SOCK_Connector.h>
#include <ace/SOCK_Stream.h>
#include <ace/streams.h>
#include <ace/SSL/SSL_SOCK_Connector.h>

#include "NNClientSocket.h"
#include <wx/filename.h>
#include "NNClientSubject.h"
#include "ENMUtil.h"
#include "ENMApp.h"
#include <openssl/bio.h>
#include <openssl/ssl.h>
#include <openssl/err.h>

static wxString dcLogFileClientSocket(_T("C:\\NNClientSocket.log"));

NNClientSocket::NNClientSocket(void)
{
}

NNClientSocket::~NNClientSocket(void)
{
}

int NNClientSocket::DownloadSetting(char* szServerIP)
{

//    ENMUtil::Log(dcLogFileClientSocket, _T("\DownloadSetting start \n"));
	// init the SSL context
	ACE_SSL_Context *context = ACE_SSL_Context::instance ();
	wxString wxfilepath;
	wxfilepath = ::wxGetApp().strAppPath + wxT("cacert.pem");
	ACE_SSL_Context::instance()->load_trusted_ca(wxfilepath.mb_str(wxConvUTF8));

    bool bCertExist = wxFileName::FileExists(wxfilepath);
	// the server listens on localhost on default port (from common.h)
	ACE_INET_Addr serverAddr(NNPORT, szServerIP);
	ACE_SSL_SOCK_STREAM stream;
	ACE_SSL_SOCK_CONNECTOR connector;
	printf("[Client] connect to server: %s\n",szServerIP);
	ENMUtil::Log(dcLogFileClientSocket, _T("[Client] connect to server \n"));

	// connect to the server and get the stream
	if (connector.connect(stream, serverAddr) == -1)
	{
		ACE_ERROR((LM_ERROR,
			ACE_TEXT("%N:%l: Failed to connect to ")
			ACE_TEXT ("server. (errno = %i: %m)\n"), errno));
		return 1;
	}

	// verify server
	long lResult = SSL_get_verify_result(stream.ssl());
	printf("[Client] SSL_get_verify_result = %d\n",lResult);

	try
	{
		// send lResult
//		int nIP = 12;
		if (stream.send(&lResult, sizeof(lResult),&connTimeout) != sizeof(lResult))
		{
			ACE_ERROR((LM_ERROR, ACE_TEXT("%N:%l: Failed to  send ")
				ACE_TEXT ("request. (errno = %i: %m)\n"), errno));
			throw 1;
		}
		printf("[Client] send lResult = %d\n", lResult);
		ENMUtil::Log(dcLogFileClientSocket, _T("[Client] send lResult: "));
		ENMUtil::Log(dcLogFileClientSocket, wxString::Format(_T("%d"), lResult));

		// receive the msg size
		int nFileSize =0;
		if (stream.recv(&nFileSize, sizeof(nFileSize),&connTimeout) != sizeof(nFileSize)) {
			ACE_ERROR((LM_ERROR, ACE_TEXT("%N: %l: Failed to receive ")
				ACE_TEXT ("1st response. (errno = %i: %m)\n"), errno));

			ENMUtil::Log(dcLogFileClientSocket, _T("stream.recv: Failed to receive \n"));

			throw 1;
		}
		printf("[Client] receive the File size = %d\n",nFileSize);
		ENMUtil::Log(dcLogFileClientSocket, _T("[Client] receive the File size "));
		ENMUtil::Log(dcLogFileClientSocket, wxString::Format(_T("%d"), nFileSize));

		// check nFileSize for plausability then allocate memory
		char response ='N';

		if(nFileSize>0)
		{
			response = 'K';
		}

		if (response == 'K')
		{
			printf("[Client] allocate the memory nDataSize:%d\n", nFileSize);
			ENMUtil::Log(dcLogFileClientSocket, _T("[Client] allocate the memory nDataSize \n"));

			// send the response ok, server will be send msg
			if (stream.send(&response, sizeof(response),&connTimeout) != sizeof(response)) {
				ACE_ERROR((LM_ERROR, ACE_TEXT("%N:%l: Failed to send ")
					ACE_TEXT ("someData. (errno = %i: %m)\n"), errno));
				throw 1;
			}

            //wxString wxStrFileDir = wxFileName::GetTempDir() + wxFileName::GetPathSeparator();
            //wxString wxStrFilePath = wxStrFileDir + wxT("SchoolSettings.tar");

			// open and create school network manager
//			wxString wxfilepath;
			if ( lResult != 0 && !bCertExist)
			{
//			    wxfilepath = ::wxGetApp().strAppPath + wxT("cacert.pem");
			    ENMUtil::Log(dcLogFileClientSocket, wxfilepath);
            }
            else
            {
			#if defined(__UNIX__)
			wxfilepath = wxT("/tmp/SchoolSettings.tar");
			#endif
			#if defined(__WXMSW__)
			wxfilepath = wxFileName::GetTempDir() + wxFileName::GetPathSeparator() + wxT("SchoolSettings.tar");
            #endif
            }


			FILE *fw = fopen(wxfilepath.char_str(wxConvUTF8), "wb");
			if (NULL == fw)
			{
//				printf( "Failed to open the file. %ld\n" ,::GetLastError());
				stream.close();
				return false;
			}
			int nRemainSize = nFileSize;
			int nReceiveSize = nRemainSize;

			while (nRemainSize > 0)
			{
				char szData[1030];
				if (nRemainSize>=1024)
					nReceiveSize = 1024;
				else
					nReceiveSize = nRemainSize;

				// get huge data
				if (stream.recv(szData, nReceiveSize,&connTimeout) != nReceiveSize)
				{
					ACE_ERROR((LM_ERROR, ACE_TEXT("%N: %l: Failed to receive ")
						ACE_TEXT ("2nd response. (errno = %i: %m)\n"), errno));
					response = 'N';
					throw 1;
				}
				//printf("[Client] receive the msg = %s\n",szData);

				// send the response ok, server will be send msg
				if (stream.send(&response, sizeof(response),&connTimeout) != sizeof(response))
				{
					ACE_ERROR((LM_ERROR, ACE_TEXT("%N:%l: Failed to send ")
						ACE_TEXT ("someData. (errno = %i: %m)\n"), errno));
					throw 1;
				}
				//printf("[Client] send the response = %c\n",response);
				fwrite(szData, sizeof(char), nReceiveSize, fw);

				nRemainSize -= 1024;
			}
			fclose(fw);
		}
		if ( lResult == 0 )
		{
            ENMUtil::Log(dcLogFileClientSocket, _T("[Client] before GetInstance()->Publish \n"));
            NNClientSubject::GetInstance()->Publish();
		}
	}
	catch (...)
	{
		// ok we know an error occurred, we need to close the socket.
		// The we'll try again.
		stream.close();

		ENMUtil::Log(dcLogFileClientSocket, _T("[Client] catch \n"));
	}

	// close the current stream
	if (stream.close() == -1)
	{
		ACE_ERROR((LM_ERROR, ACE_TEXT("%N:%l: Failed to close ")
			ACE_TEXT ("socket. (errno = %i: %m)\n"), errno));
		return 1;
	}
	cout << "Bye. Bye" << endl;
	ENMUtil::Log(dcLogFileClientSocket, _T("[Client] end socket \n"));
	return 0;
}
