/****************************************************************************

Copyright (c) Intel Corporation (2007).

DISCLAIMER OF WARRANTY
NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR
CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY
OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS
EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR
FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT
THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL
BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON
ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.
SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL
NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,
TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY
UPDATES, ENHANCEMENTS OR EXTENSIONS.

File Name:   	MeshConfigurationEntity.cpp

Description:
	implementation file of the MeshConfigurationEntity class


Environment (opt):
	OS: WindowsXP SP2
	SE: CodeBlock 8.02 + wxWidgets 2.8.7

Notes (opt):


  =====================================================================
  Revision   Revision History               Author     Date
  =====================================================================
  0.1        Create                         Guo xixiu     2008-09-01
  =====================================================================

****************************************************************************/

#include "MeshConfigurationEntity.h"


/*=================================================================
 Function Name  : MeshConfigurationEntity::MeshConfigurationEntity
 Description    : Construction function
 Date           : 2008-9-17 14:44:37
 Return Code    : none
 Author         : Li Yang
 =================================================================*/
MeshConfigurationEntity::MeshConfigurationEntity()
:m_strMeshLocalHostName(wxEmptyString),m_nMeshChannel(1),
m_nMeshAdvertiseTime(10)
{
    //ctor
//    xmlOperator.ReadMeshLocalHostNameXmlFile(m_strMeshLocalHostName);
    //xmlOperator.ReadMeshChannelXmlFile(m_nMeshChannel);
    //xmlOperator.ReadMeshAdvertiseTimeXmlFile(m_nMeshAdvertiseTime);
}


/*=================================================================
 Function Name  : MeshConfigurationEntity::~MeshConfigurationEntity
 Description    : Destruction function
 Date           : 2008-9-17 14:44:56
 Return Code    : none
 Author         : Guo xixiu
 =================================================================*/
MeshConfigurationEntity::~MeshConfigurationEntity()
{
    //dtor
}


/*=================================================================
 Function Name  : PolicyEntity::GetMeshLocalHostName
 Description    : Get mesh local host name
 Date           : 2008-9-17 14:45:06
 Return Code    : bool
 Author         : Guo xixiu
 =================================================================*/
wxString MeshConfigurationEntity::GetMeshLocalHostName()
{
    return m_strMeshLocalHostName;
}

/*=================================================================
 Function Name  : PolicyEntity::SetMeshLocalHostName
 Description    : Set mesh local host name
 Date           : 2008-9-17 14:46:13
 Parameter      : string strMeshLocalHostName
 Return Code    : void
 Author         : Guo xixiu
 =================================================================*/
void MeshConfigurationEntity::SetMeshLocalHostName(wxString strMeshLocalHostName)
{
//    wxMessageBox(strMeshLocalHostName);
    m_strMeshLocalHostName = strMeshLocalHostName;
//    wxMessageBox(m_strMeshLocalHostName);
}


/*=================================================================
 Function Name  : PolicyEntity::GetMeshChannel
 Description    : Get mesh channel
 Date           : 2008-9-17 14:45:06
 Return Code    : int
 Author         : Guo xixiu
 =================================================================*/
int MeshConfigurationEntity::GetMeshChannel()
{
    return m_nMeshChannel;
}

/*=================================================================
 Function Name  : PolicyEntity::SetMeshChannel
 Description    : Set mesh channel
 Date           : 2008-9-17 14:46:13
 Parameter      : int nMeshChannel
 Return Code    : void
 Author         : Guo xixiu
 =================================================================*/
void MeshConfigurationEntity::SetMeshChannel(int nMeshChannel)
{
    m_nMeshChannel = nMeshChannel;
}

/*=================================================================
 Function Name  : PolicyEntity::GetMeshAdvertiseTime
 Description    : Get mesh advertise time
 Date           : 2008-9-17 14:45:06
 Return Code    : int
 Author         : Guo xixiu
 =================================================================*/
int MeshConfigurationEntity::GetMeshAdvertiseTime()
{
    return m_nMeshAdvertiseTime;
}

/*=================================================================
 Function Name  : PolicyEntity::SetMeshAdvertiseTime
 Description    : Set mesh advertise time
 Date           : 2008-9-17 14:46:13
 Parameter      : int nMeshAdvertiseTime
 Return Code    : void
 Author         : Guo xixiu
 =================================================================*/
void MeshConfigurationEntity::SetMeshAdvertiseTime(int nMeshAdvertiseTime)
{
    m_nMeshAdvertiseTime = nMeshAdvertiseTime;
}
