#include "MeshConfigurationDlg.h"

//(*InternalHeaders(MeshConfigurationDlg)
#include <wx/bitmap.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
//*)
#include "MeshConfigurationEntity.h"
#include "ENMDef.h"
#include "ENMUtil.h"
#include <sdk/ENMApi.h>
#include <wx/wx.h>
#include "ENMApp.h"


//(*IdInit(MeshConfigurationDlg)
const long MeshConfigurationDlg::ID_STATICTEXT1 = wxNewId();
const long MeshConfigurationDlg::ID_STATICTEXT2 = wxNewId();
const long MeshConfigurationDlg::ID_STATICTEXT3 = wxNewId();
const long MeshConfigurationDlg::ID_STATICTEXT4 = wxNewId();
const long MeshConfigurationDlg::ID_STATICTEXT5 = wxNewId();
const long MeshConfigurationDlg::ID_STATICTEXT6 = wxNewId();
const long MeshConfigurationDlg::ID_STATICTEXT7 = wxNewId();
const long MeshConfigurationDlg::ID_TEXTCTRL_LOCAL_HOST_NAME = wxNewId();
const long MeshConfigurationDlg::ID_TEXTCTRL_MESH_CHANNEL = wxNewId();
const long MeshConfigurationDlg::ID_TEXTCTRL_ADVERTISEMENT_TIME = wxNewId();
const long MeshConfigurationDlg::ID_BUTTON_OK = wxNewId();
const long MeshConfigurationDlg::ID_BUTTON_CANCEL = wxNewId();
const long MeshConfigurationDlg::ID_STATICBITMAP1 = wxNewId();
const long MeshConfigurationDlg::ID_PANEL1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(MeshConfigurationDlg,wxDialog)
	//(*EventTable(MeshConfigurationDlg)
	//*)
END_EVENT_TABLE()

MeshConfigurationDlg::MeshConfigurationDlg(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{

    wxString  wxStrImagepath(::wxGetApp().strAppPath + wxT("pic/MeshConfiguration.png"));

	//(*Initialize(MeshConfigurationDlg)
	Create(parent, wxID_ANY, _("Mesh Network Configuration"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	SetClientSize(wxSize(420,330));
	Panel1 = new wxPanel(this, ID_PANEL1, wxPoint(0,0), wxSize(420,328), wxTAB_TRAVERSAL, _T("ID_PANEL1"));
	StaticText1 = new wxStaticText(Panel1, ID_STATICTEXT1, _("You can set Mesh network configuration as follows:"), wxPoint(60,20), wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	StaticText2 = new wxStaticText(Panel1, ID_STATICTEXT2, _("Advertise Time Interval:"), wxPoint(16,208), wxSize(160,40), 0, _T("ID_STATICTEXT2"));
	StaticText3 = new wxStaticText(Panel1, ID_STATICTEXT3, _("Example:Matin, David_Teacher..."), wxPoint(176,96), wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	StaticText4 = new wxStaticText(Panel1, ID_STATICTEXT4, _("Default Mesh Channel:"), wxPoint(16,136), wxDefaultSize, 0, _T("ID_STATICTEXT4"));
	StaticText5 = new wxStaticText(Panel1, ID_STATICTEXT5, _("Local Hostname:"), wxPoint(16,64), wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	StaticText6 = new wxStaticText(Panel1, ID_STATICTEXT6, _("Mesh channel ranges from 1 to 14"), wxPoint(176,168), wxDefaultSize, 0, _T("ID_STATICTEXT6"));
	StaticText7 = new wxStaticText(Panel1, ID_STATICTEXT7, _("Time interval to advertise Internet Sharing Server"), wxPoint(176,240), wxSize(224,40), 0, _T("ID_STATICTEXT7"));
	TextCtrlLocalHostName = new wxTextCtrl(Panel1, ID_TEXTCTRL_LOCAL_HOST_NAME, wxEmptyString, wxPoint(176,64), wxSize(224,27), 0, wxDefaultValidator, _T("ID_TEXTCTRL_LOCAL_HOST_NAME"));
	TextCtrlLocalHostName->SetMaxLength(24);
	TextCtrlLocalHostName->SetFocus();
	TextCtrlMeshChannel = new wxTextCtrl(Panel1, ID_TEXTCTRL_MESH_CHANNEL, wxEmptyString, wxPoint(176,136), wxSize(224,27), 0, wxDefaultValidator, _T("ID_TEXTCTRL_MESH_CHANNEL"));
	TextCtrlAdvertisementTime = new wxTextCtrl(Panel1, ID_TEXTCTRL_ADVERTISEMENT_TIME, wxEmptyString, wxPoint(176,208), wxSize(224,27), 0, wxDefaultValidator, _T("ID_TEXTCTRL_ADVERTISEMENT_TIME"));
	ButtonOK = new wxButton(Panel1, ID_BUTTON_OK, _("OK"), wxPoint(216,288), wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON_OK"));
	ButtonCancel = new wxButton(Panel1, ID_BUTTON_CANCEL, _("Cancel"), wxPoint(312,288), wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON_CANCEL"));
	StaticBitmap1 = new wxStaticBitmap(Panel1, ID_STATICBITMAP1, wxBitmap(wxImage(wxStrImagepath).Rescale(wxSize(48,48).GetWidth(),wxSize(48,48).GetHeight())), wxPoint(8,8), wxSize(48,48), 0, _T("ID_STATICBITMAP1"));

	Connect(ID_BUTTON_OK,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&MeshConfigurationDlg::OnButtonOKClick);
	Connect(ID_BUTTON_CANCEL,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&MeshConfigurationDlg::OnButtonCancelClick);
	Connect(wxID_ANY,wxEVT_INIT_DIALOG,(wxObjectEventFunction)&MeshConfigurationDlg::OnInit);
	//*)

    wxIcon icon;
    wxBitmap bitmap(wxStrImagepath, wxBITMAP_TYPE_PNG);
    icon.CopyFromBitmap(bitmap);
    SetIcon(icon);

}

MeshConfigurationDlg::~MeshConfigurationDlg()
{
	//(*Destroy(MeshConfigurationDlg)
	//*)
}


void MeshConfigurationDlg::OnInit(wxInitDialogEvent& event)
{
    printf("OnInit");
    bool bRead = xmlOperator.ReadMeshConfigurationXmlFile(meshConfigurationEntity);
    if (!bRead )
    {
        ENM_String* sHostName = new ENM_String();
        memset(sHostName, 0, sizeof(ENM_String));
        int MeshChannel;

        DCS_GetMeshHostName(sHostName);
        DCS_GetMeshChannel(&MeshChannel);

        wxString strHostName = ENMUtil::StringToWxString((char *)(sHostName->dcsString));
        if (strHostName.IsEmpty())
        {
            meshConfigurationEntity.SetMeshLocalHostName(wxT("Mesh_User"));
            meshConfigurationEntity.SetMeshChannel(1);
        }
        else
        {
            meshConfigurationEntity.SetMeshLocalHostName(strHostName);
            meshConfigurationEntity.SetMeshChannel(MeshChannel);
        }
        meshConfigurationEntity.SetMeshAdvertiseTime(60);
    }

    wxString strMeshHostName, strMeshChannel, strMeshAdvertiseTime;
    strMeshHostName = meshConfigurationEntity.GetMeshLocalHostName();
    int nMeshChannel = meshConfigurationEntity.GetMeshChannel();
    int nMeshAdvertiseTime = meshConfigurationEntity.GetMeshAdvertiseTime();


    strMeshChannel = wxString::Format(_T("%d"), nMeshChannel);
    strMeshAdvertiseTime = wxString::Format(_T("%d"), nMeshAdvertiseTime);

    TextCtrlLocalHostName->SetValue(strMeshHostName);
    TextCtrlMeshChannel->SetValue(strMeshChannel);
    TextCtrlAdvertisementTime->SetValue(strMeshAdvertiseTime);
}

void MeshConfigurationDlg::OnButtonOKClick(wxCommandEvent& event)
{
    //wxMessageBox(TextCtrlLocalHostName->GetValue());
    if ( !CheckMeshSettings() )
    {
        return;
    }
    long lMeshChannel = 0;
    TextCtrlMeshChannel->GetValue().ToLong(&lMeshChannel);
    long lAdvertisementTime = 0;
    TextCtrlAdvertisementTime->GetValue().ToLong(&lAdvertisementTime);
    int nMeshChannel =lMeshChannel;
    int nAdvertisementTime = lAdvertisementTime;
    meshConfigurationEntity.SetMeshLocalHostName(TextCtrlLocalHostName->GetValue());
    meshConfigurationEntity.SetMeshChannel(nMeshChannel);
    meshConfigurationEntity.SetMeshAdvertiseTime(nAdvertisementTime);
    xmlOperator.CreateMeshConfigurationXmlFile(meshConfigurationEntity);

    ENM_String* sHostName = new ENM_String();
    memset(sHostName, 0, sizeof(ENM_String));
    strcpy((char*)sHostName->dcsString, ENMUtil::WxStringToString(TextCtrlLocalHostName->GetValue()).c_str());
    DCS_SetMeshHostName(sHostName);
    DCS_SetMeshChannel(nMeshChannel);

    SetReturnCode(wxID_OK);
    EndModal(wxID_OK);
    Destroy();
}

void MeshConfigurationDlg::OnButtonCancelClick(wxCommandEvent& event)
{
    SetReturnCode(wxID_CANCEL);
    EndModal(wxID_CANCEL);
    Destroy();
}

bool MeshConfigurationDlg::CheckMeshSettings()
{
    wxString LocalHostName = TextCtrlLocalHostName->GetValue();
    wxString MeshChannel = TextCtrlMeshChannel->GetValue();
    wxString AdvertisementTime = TextCtrlAdvertisementTime->GetValue();

    long lMeshChannel = 0;
    MeshChannel.ToLong(&lMeshChannel);
    long lAdvertisementTime = 0;
    AdvertisementTime.ToLong(&lAdvertisementTime);


    if ( 0 == LocalHostName.Len() )
    {
        wxString msg = _("Please input HostName");
        wxMessageDialog dlg(this, msg, _("Message"), wxOK | wxICON_EXCLAMATION);
        dlg.ShowModal();

        TextCtrlLocalHostName->SetFocus();
        return false;
    }

    else if ( 0 == LocalHostName.Cmp(wxT("CMPC_GW")) )
    {
        wxString msg = _("CMPC_GW is not allowed, please input another name");
        wxMessageDialog dlg(this, msg, _("Message"), wxOK | wxICON_EXCLAMATION);
        dlg.ShowModal();
        TextCtrlLocalHostName->Clear();
        TextCtrlLocalHostName->SetFocus();
        return false;
    }
    else if ( ENMUtil::CHECK_ILLEGAL == ENMUtil::CheckValide(LocalHostName) )
    {
        wxMessageDialog msg(this, _("HostName cannot contain any of the following characters\n \\ / : * ? \" ' < > |"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();

        TextCtrlLocalHostName->Clear();
        TextCtrlLocalHostName->SetFocus();
        return false;
    }
    else if ( 0 == MeshChannel.Len() )
    {
        wxString msg = _("Please input mesh channel");
        wxMessageDialog dlg(this, msg, _("Message"), wxOK | wxICON_EXCLAMATION);
        dlg.ShowModal();

        TextCtrlMeshChannel->SetFocus();
        return false;
    }
    else if ( !(MeshChannel.IsNumber() && lMeshChannel <=14 && lMeshChannel >=1) )
    {
        wxString msg = _("Invalid mesh channel!\n\nMust contain only numbers 1-14");
        wxMessageDialog dlg(this, msg, _("Message"), wxOK | wxICON_EXCLAMATION);
        dlg.ShowModal();

        TextCtrlMeshChannel->Clear();
        TextCtrlMeshChannel->SetFocus();
        return false;
    }
    else if ( 0 == AdvertisementTime.Len() )
    {
        wxString msg = _("Please input advertise time interval");
        wxMessageDialog dlg(this, msg, _("Message"), wxOK | wxICON_EXCLAMATION);
        dlg.ShowModal();

        TextCtrlAdvertisementTime->SetFocus();
        return false;
    }
    else if ( !(AdvertisementTime.IsNumber() && lAdvertisementTime <= 60 && lAdvertisementTime >= 1) )
    {
        wxString msg = _("Invalid Advertise time!\n\nMust contain only numbers 1-60");
        wxMessageDialog dlg(this, msg, _("Message"), wxOK | wxICON_EXCLAMATION);
        dlg.ShowModal();

        TextCtrlAdvertisementTime->Clear();
        TextCtrlAdvertisementTime->SetFocus();
        return false;
    }
    return true;
}
