
#include "IconPositionCalculator.h"

IconPositionCalculator::IconPositionCalculator()
{
    Reset();
}

IconPositionCalculator::~IconPositionCalculator()
{
}

bool IconPositionCalculator::CalculatePosition(const APStatus& ap, wxPoint& pos, int* charsOfLabel)
{
    int circle = (ap.signalQuality == 100 ? 99 : ap.signalQuality) / 20;
    if ( circle >= 5 )
        return false;
    while ( circle >= 0 && circleButtonCount[circle] >= CIRCLE_AP_COUNT[circle] )
        circle--;
    if ( circle < 0 )
        return false;

    pos.x = POSITION[circle][circleButtonCount[circle]][0];
    pos.y = POSITION[circle][circleButtonCount[circle]][1];
    if ( charsOfLabel != NULL )
    {
        *charsOfLabel = POSITION[circle][circleButtonCount[circle]][2];
    }
    circleButtonCount[circle] ++;
    return true;
}

void IconPositionCalculator::Reset()
{
    for ( size_t i = 0 ; i < CIRCLE_COUNT ; i++ )
        circleButtonCount[i] = 0;
}
