#include "EditProfileDialog.h"

//(*InternalHeaders(EditProfileDialog)
#include <wx/intl.h>
#include <wx/string.h>
//*)
#include <wx/file.h>
#include <wx/msgdlg.h>
#include "ENMApp.h"
#include "ProxySettings.h"
#include "IPSettings.h"
#include "AutoRunSettings.h"
#include "ENMUtil.h"
#include "PolicyManager.h"
#include "ProfileManagementControl.h"
#include "ProfileManagerDlg.h"
#include "ScanNetworkDlg.h"

//(*IdInit(EditProfileDialog)
const long EditProfileDialog::ID_OKBUTTON = wxNewId();
const long EditProfileDialog::ID_CANCLEBUTTON = wxNewId();
const long EditProfileDialog::ID_NAMESTATICTEXT = wxNewId();
const long EditProfileDialog::ID_CONTYPESTATICTEXT = wxNewId();
const long EditProfileDialog::ID_NAMETEXTCTRL = wxNewId();
const long EditProfileDialog::ID_NAMECOMBOBOX = wxNewId();
const long EditProfileDialog::ID_CONTYPECOMBOBOX = wxNewId();
const long EditProfileDialog::ID_AUTHCHECKBOX = wxNewId();
const long EditProfileDialog::ID_DISABLECHECKBOX = wxNewId();
const long EditProfileDialog::ID_AUTHENTYPETEXTCTRL = wxNewId();
const long EditProfileDialog::ID_GENERALPANEL = wxNewId();
const long EditProfileDialog::ID_WIRELESSNAMESTATICTEXT = wxNewId();
const long EditProfileDialog::ID_WIRELESSTYPESTATICTEXT = wxNewId();
const long EditProfileDialog::ID_SECTYPESTATICTEXT = wxNewId();
const long EditProfileDialog::ID_SSIDTEXTCTRL = wxNewId();
const long EditProfileDialog::ID_SCANBUTTON = wxNewId();
const long EditProfileDialog::ID_WIRELESSTYPECOMBOBOX = wxNewId();
const long EditProfileDialog::ID_SECRITYTYPECOMBOBOX = wxNewId();
const long EditProfileDialog::ID_WIRELESSPANEL = wxNewId();
const long EditProfileDialog::ID_NETWORKSECRITYCHECKBOX = wxNewId();
const long EditProfileDialog::ID_APPCHECKBOX = wxNewId();
const long EditProfileDialog::ID_DEFAULTCHECKBOX = wxNewId();
const long EditProfileDialog::ID_NSBUTTON = wxNewId();
const long EditProfileDialog::ID_APPBUTTON = wxNewId();
const long EditProfileDialog::ID_DEFAULTBUTTON = wxNewId();
const long EditProfileDialog::ID_PROXYBUTTON = wxNewId();
const long EditProfileDialog::ID_BROWSERSTATICBOX = wxNewId();
const long EditProfileDialog::ID_HOMEPAGECHECKBOX = wxNewId();
const long EditProfileDialog::ID_PROXYCHECKBOX = wxNewId();
const long EditProfileDialog::ID_HOMEPAGETEXTCTRL = wxNewId();
const long EditProfileDialog::ID_OTHERSPANEL = wxNewId();
const long EditProfileDialog::ID_EDITNOTEBOOK = wxNewId();
const long EditProfileDialog::ID_EDITPANEL = wxNewId();
const long EditProfileDialog::ID_KEYSTATICTEXT = wxNewId();
const long EditProfileDialog::ID_TIPSTATICTEXT = wxNewId();
const long EditProfileDialog::ID_KEYTEXTCTRL = wxNewId();
//*)
const long EditProfileDialog::ID_HELP = wxNewId();
BEGIN_EVENT_TABLE(EditProfileDialog, wxDialog)
	EVT_BUTTON(ID_OKBUTTON, EditProfileDialog::Onm_buttonOKClick)
	EVT_BUTTON(ID_CANCLEBUTTON, EditProfileDialog::Onm_buttonCancelClick)
END_EVENT_TABLE()

EditProfileDialog::EditProfileDialog(wxWindow* parent, const ProfileList_t& profile, bool create)
{
	m_profile = profile;
	m_strOldName = wxString::FromUTF8(m_profile.sProfileName.c_str());
	m_isForCreate = create;
	Create(parent, wxID_ANY, _("Edit Network Profile"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE & ~wxCLOSE_BOX, _T("wxID_ANY"));
	SetClientSize(wxSize(510,332));
	m_editPanel = new wxPanel(this, ID_EDITPANEL, wxPoint(0,0), wxSize(500,336), wxTAB_TRAVERSAL, _T("ID_EDITPANEL"));

    #if defined(__WXMSW__)
	m_buttonOK = new wxButton(m_editPanel, ID_OKBUTTON, _("&OK"), wxPoint(325,296), wxSize(80,27), 0, wxDefaultValidator, _T("ID_OKBUTTON"));
	m_buttonCancel = new wxButton(m_editPanel, ID_CANCLEBUTTON, _("&Cancel"), wxPoint(415,296), wxSize(80,27), 0, wxDefaultValidator, _T("ID_CANCLEBUTTON"));

	m_nbEdit = new wxNotebook(m_editPanel, ID_EDITNOTEBOOK, wxPoint(16,16), wxSize(480,272), 0, _T("ID_EDITNOTEBOOK"));
	m_generalPanel = new wxPanel(m_nbEdit, ID_GENERALPANEL, wxPoint(103,115), wxSize(500,221), wxTAB_TRAVERSAL, _T("ID_GENERALPANEL"));

   	m_labelName = new wxStaticText(m_generalPanel, ID_NAMESTATICTEXT, _("Profile Name:"), wxPoint(10,24), wxSize(240,32), 0, _T("ID_NAMESTATICTEXT"));
	m_labelConType = new wxStaticText(m_generalPanel, ID_CONTYPESTATICTEXT, _("Network Connection Type:"), wxPoint(10,63), wxSize(240,32), 0, _T("ID_CONTYPESTATICTEXT"));
	m_textName = new wxTextCtrl(m_generalPanel, ID_NAMETEXTCTRL, wxEmptyString, wxPoint(250,19), wxSize(160,24), 0, wxDefaultValidator, _T("ID_NAMETEXTCTRL"));
	m_textName->SetMaxLength(32);

//  	m_textName->Disable();
    m_cbName = new wxBitmapComboBox(m_generalPanel, ID_NAMECOMBOBOX, wxEmptyString, wxPoint(420,19), wxSize(42,24), 0, 0, wxCB_READONLY, wxDefaultValidator, _T("ID_NAMECOMBOBOX"));

    m_cbName->SetPopupMaxHeight(110);
    wxString strPrflName = _T("");
    #endif

    #if defined(__UNIX__)
	m_buttonOK = new wxButton(m_editPanel, ID_OKBUTTON, _("&OK"), wxPoint(305,296), wxSize(88,32), 0, wxDefaultValidator, _T("ID_OKBUTTON"));
	m_buttonCancel = new wxButton(m_editPanel, ID_CANCLEBUTTON, _("&Cancel"), wxPoint(405,296), wxSize(88,32), 0, wxDefaultValidator, _T("ID_CANCLEBUTTON"));

	m_nbEdit = new wxNotebook(m_editPanel, ID_EDITNOTEBOOK, wxPoint(16,16), wxSize(480,272), 0, _T("ID_EDITNOTEBOOK"));
	m_generalPanel = new wxPanel(m_nbEdit, ID_GENERALPANEL, wxPoint(103,115), wxSize(500,221), wxTAB_TRAVERSAL, _T("ID_GENERALPANEL"));

   	m_labelName = new wxStaticText(m_generalPanel, ID_NAMESTATICTEXT, _("Profile Name:"), wxPoint(10,24), wxSize(190,32), 0, _T("ID_NAMESTATICTEXT"));
	m_labelConType = new wxStaticText(m_generalPanel, ID_CONTYPESTATICTEXT, _("Network Connection Type:"), wxPoint(10,63), wxSize(190,32), 0, _T("ID_CONTYPESTATICTEXT"));
	m_textName = new wxTextCtrl(m_generalPanel, ID_NAMETEXTCTRL, wxEmptyString, wxPoint(250,19), wxSize(150,24), 0, wxDefaultValidator, _T("ID_NAMETEXTCTRL"));
	m_textName->SetMaxLength(32);

//	m_textName->Disable();
	m_cbName = new wxBitmapComboBox(m_generalPanel, ID_NAMECOMBOBOX, wxEmptyString, wxPoint(405,19), wxSize(54,24), 0, 0, wxCB_READONLY, wxDefaultValidator, _T("ID_NAMECOMBOBOX"));

    m_cbName->SetPopupMaxHeight(110);
    wxString strPrflName = _T("");
    #endif

    #if defined(__UNIX__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic/general.png"), wxBITMAP_TYPE_PNG);
    #endif

    #if defined(__WXMSW__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\general.png"), wxBITMAP_TYPE_PNG);
    #endif

    m_cbName->Insert(strPrflName,*m_bmpPrfl,0);

    #if defined(__UNIX__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic/home.png"), wxBITMAP_TYPE_PNG);
    #endif

    #if defined(__WXMSW__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\home.png"), wxBITMAP_TYPE_PNG);
    #endif

    m_cbName->Insert(strPrflName,*m_bmpPrfl,1);

    #if defined(__UNIX__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic/personal.png"), wxBITMAP_TYPE_PNG);
    #endif

    #if defined(__WXMSW__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\personal.png"), wxBITMAP_TYPE_PNG);
    #endif

    m_cbName->Insert(strPrflName,*m_bmpPrfl,2);

    #if defined(__UNIX__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic/house.png"), wxBITMAP_TYPE_PNG);
    #endif

    #if defined(__WXMSW__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\house.png"), wxBITMAP_TYPE_PNG);
    #endif

    m_cbName->Insert(strPrflName,*m_bmpPrfl,3);

    #if defined(__UNIX__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic/hospital.png"), wxBITMAP_TYPE_PNG);
    #endif

    #if defined(__WXMSW__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\hospital.png"), wxBITMAP_TYPE_PNG);
    #endif

    m_cbName->Insert(strPrflName,*m_bmpPrfl,4);

    #if defined(__UNIX__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic/building.png"), wxBITMAP_TYPE_PNG);
    #endif

    #if defined(__WXMSW__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\building.png"), wxBITMAP_TYPE_PNG);
    #endif

    m_cbName->Insert(strPrflName,*m_bmpPrfl,5);

    #if defined(__UNIX__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic/bucket.png"), wxBITMAP_TYPE_PNG);
    #endif

    #if defined(__WXMSW__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\bucket.png"),wxBITMAP_TYPE_PNG);
    #endif

    m_cbName->Insert(strPrflName,*m_bmpPrfl,6);

    #if defined(__UNIX__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic/airport.png"),wxBITMAP_TYPE_PNG);
    #endif

    #if defined(__WXMSW__)
    m_bmpPrfl = new wxBitmap(::wxGetApp().strAppPath + _T("pic\\airport.png"),wxBITMAP_TYPE_PNG);
    #endif

    m_cbName->Insert(strPrflName,*m_bmpPrfl,7);

    #if defined(__WXMSW__)
	m_cbConType = new wxComboBox(m_generalPanel, ID_CONTYPECOMBOBOX, wxEmptyString, wxPoint(250,60), wxSize(210,32), 0, 0, wxCB_READONLY, wxDefaultValidator, _T("ID_CONTYPECOMBOBOX"));
    #endif

    #if defined(__UNIX__)
	m_cbConType = new wxComboBox(m_generalPanel, ID_CONTYPECOMBOBOX, wxEmptyString, wxPoint(250,60), wxSize(210,29), 0, 0, wxCB_READONLY, wxDefaultValidator, _T("ID_CONTYPECOMBOBOX"));
    #endif

	m_cbConType->Append(_("Wireless LAN"));
	m_cbConType->Append(_("Wired LAN"));
/*
    #if defined(__WXMSW__)
	m_checkboxAuthen = new wxCheckBox(m_generalPanel, ID_AUTHCHECKBOX, _("Enable IEEE 802.1x authentication for this network"), wxPoint(10,104), wxSize(414,40), 0, wxDefaultValidator, _T("ID_AUTHCHECKBOX"));
    #endif

    #if defined(__UNIX__)
	m_checkboxAuthen = new wxCheckBox(m_generalPanel, ID_AUTHCHECKBOX, _("Enable IEEE 802.1x authentication for this network"), wxPoint(10,104), wxSize(414,40), 0, wxDefaultValidator, _T("ID_AUTHCHECKBOX"));
    #endif

	m_checkboxAuthen->SetValue(false);
	#if defined(__UNIX__)
	wxString tip = _T("Please install xsupplicant first!");
	m_checkboxAuthen->SetToolTip(tip);
	#endif
*/
    #if defined(__WXMSW__)
//	m_textAuthenType = new wxTextCtrl(m_generalPanel, ID_AUTHENTYPETEXTCTRL, _("Smart Card or the Certificate Properties"), wxPoint(12,160), wxSize(450,24), 0, wxDefaultValidator, _T("ID_AUTHENTYPETEXTCTRL"));
//	m_textAuthenType->Disable();
//	m_textAuthenType->SetEditable(false);
	m_wirelessPanel = new wxPanel(m_nbEdit, ID_WIRELESSPANEL, wxPoint(102,15), wxSize(500,221), wxTAB_TRAVERSAL, _T("ID_WIRELESSPANEL"));
	m_labelWirelessName = new wxStaticText(m_wirelessPanel, ID_WIRELESSNAMESTATICTEXT, _("Wireless Network Name(SSID):"), wxPoint(10,23), wxSize(170,40), 0, _T("ID_WIRELESSNAMESTATICTEXT"));
	m_textWirelessType = new wxStaticText(m_wirelessPanel, ID_WIRELESSTYPESTATICTEXT, _("Wireless Type:"), wxPoint(10,86), wxSize(176,32), 0, _T("ID_WIRELESSTYPESTATICTEXT"));
	m_textSecType = new wxStaticText(m_wirelessPanel, ID_SECTYPESTATICTEXT, _("Security Type:"), wxPoint(10,122), wxSize(176,32), 0, _T("ID_SECTYPESTATICTEXT"));
	m_textSSID = new wxTextCtrl(m_wirelessPanel, ID_SSIDTEXTCTRL, wxEmptyString, wxPoint(190,19), wxSize(269,24), 0, wxDefaultValidator, _T("ID_SSIDTEXTCTRL"));
	m_textSSID->SetMaxLength(32);
	m_buttonScan = new wxButton(m_wirelessPanel, ID_SCANBUTTON, _("Scan for Networks"), wxPoint(275,49), wxSize(185,27), 0, wxDefaultValidator, _T("ID_SCANBUTTON"));
	m_cbbWirelessType = new wxComboBox(m_wirelessPanel, ID_WIRELESSTYPECOMBOBOX, wxEmptyString, wxPoint(190,84), wxSize(130,27), 0, 0, wxCB_READONLY, wxDefaultValidator, _T("ID_WIRELESSTYPECOMBOBOX"));
	m_cbbWirelessType->Append(_("Automatic"));
	m_cbbWirelessType->Append(_T("802.11b"));
	m_cbbWirelessType->Append(_T("802.11g"));
	m_cbbWirelessType->Append(_T("802.11n"));
	m_cbbSecType = new wxComboBox(m_wirelessPanel, ID_SECRITYTYPECOMBOBOX, wxEmptyString, wxPoint(190,120), wxSize(130,32), 0, 0, wxCB_READONLY, wxDefaultValidator, _T("ID_SECRITYTYPECOMBOBOX"));
	m_cbbSecType->Append(_("NONE"));
	m_cbbSecType->Append(_T("WEP"));
	m_cbbSecType->Append(_T("WPA-PSK"));
	m_cbbSecType->Append(_("UNKNOWN"));
    m_textKey = new wxStaticText(m_wirelessPanel, ID_KEYSTATICTEXT, _("Key:"), wxPoint(10,155), wxDefaultSize, 0, _T("ID_KEYSTATICTEXT"));
    m_tcKey = new wxTextCtrl(m_wirelessPanel, ID_KEYTEXTCTRL, wxEmptyString, wxPoint(190,155), wxSize(270,24), wxTE_PASSWORD, wxDefaultValidator, _T("ID_KEYTEXTCTRL"));
    m_tcKey->Disable();
    m_textKeyIdx = new wxStaticText(m_wirelessPanel, wxID_ANY, _("Key Index:"), wxPoint(10,187), wxDefaultSize);
	m_cbbIndex = new wxComboBox(m_wirelessPanel, wxID_ANY, wxEmptyString, wxPoint(190,187), wxSize(60,28), 0, 0, wxCB_READONLY, wxDefaultValidator);
	m_cbbIndex->Append(_T("1"));
	m_cbbIndex->Append(_T("2"));
	m_cbbIndex->Append(_T("3"));
	m_cbbIndex->Append(_T("4"));
	m_cbbIndex->SetValue(_T("1"));
	m_cbbIndex->Enable(false);
    m_textTip = new wxStaticText(m_wirelessPanel, ID_TIPSTATICTEXT, wxEmptyString, wxPoint(190,215), wxDefaultSize, 0, _T("ID_TIPSTATICTEXT"));
	#endif

	#if defined(__UNIX__)
//	m_textAuthenType = new wxTextCtrl(m_generalPanel, ID_AUTHENTYPETEXTCTRL, _("Smart Card or the Certificate Properties"), wxPoint(12,150), wxSize(447,24), 0, wxDefaultValidator, _T("ID_AUTHENTYPETEXTCTRL"));
//	m_textAuthenType->Disable();
//	m_textAuthenType->SetEditable(false);
	m_wirelessPanel = new wxPanel(m_nbEdit, ID_WIRELESSPANEL, wxPoint(102,15), wxSize(500,221), wxTAB_TRAVERSAL, _T("ID_WIRELESSPANEL"));
	m_labelWirelessName = new wxStaticText(m_wirelessPanel, ID_WIRELESSNAMESTATICTEXT, _("Wireless Network Name(SSID):"), wxPoint(10,23), wxSize(170,50), 0, _T("ID_WIRELESSNAMESTATICTEXT"));
	m_textWirelessType = new wxStaticText(m_wirelessPanel, ID_WIRELESSTYPESTATICTEXT, _("Wireless Type:"), wxPoint(10,89), wxSize(176,32), 0, _T("ID_WIRELESSTYPESTATICTEXT"));
	m_textSecType = new wxStaticText(m_wirelessPanel, ID_SECTYPESTATICTEXT, _("Security Type:"), wxPoint(10,125), wxSize(176,32), 0, _T("ID_SECTYPESTATICTEXT"));
	m_textSSID = new wxTextCtrl(m_wirelessPanel, ID_SSIDTEXTCTRL, wxEmptyString, wxPoint(190,19), wxSize(280,24), 0, wxDefaultValidator, _T("ID_SSIDTEXTCTRL"));
	m_textSSID->SetMaxLength(32);
	m_buttonScan = new wxButton(m_wirelessPanel, ID_SCANBUTTON, _("Scan for Networks"), wxPoint(275,47), wxSize(195,32), 0, wxDefaultValidator, _T("ID_SCANBUTTON"));
	m_cbbWirelessType = new wxComboBox(m_wirelessPanel, ID_WIRELESSTYPECOMBOBOX, wxEmptyString, wxPoint(190,84), wxSize(130,32), 0, 0, wxCB_READONLY, wxDefaultValidator, _T("ID_WIRELESSTYPECOMBOBOX"));
	m_cbbWirelessType->Append(_("Automatic"));
	m_cbbWirelessType->Append(_T("802.11b"));
	m_cbbWirelessType->Append(_T("802.11g"));
	m_cbbWirelessType->Append(_T("802.11n"));
	m_cbbSecType = new wxComboBox(m_wirelessPanel, ID_SECRITYTYPECOMBOBOX, wxEmptyString, wxPoint(190,120), wxSize(130,32), 0, 0, wxCB_READONLY, wxDefaultValidator, _T("ID_SECRITYTYPECOMBOBOX"));
	m_cbbSecType->Append(_("NONE"));
	m_cbbSecType->Append(_T("WEP"));
	m_cbbSecType->Append(_T("WPA-PSK"));
	m_cbbSecType->Append(_("UNKNOWN"));
    m_textKey = new wxStaticText(m_wirelessPanel, ID_KEYSTATICTEXT, _("Key:"), wxPoint(10,155), wxDefaultSize, 0, _T("ID_KEYSTATICTEXT"));
    m_tcKey = new wxTextCtrl(m_wirelessPanel, ID_KEYTEXTCTRL, wxEmptyString, wxPoint(190,155), wxSize(270,24), wxTE_PASSWORD, wxDefaultValidator, _T("ID_KEYTEXTCTRL"));
    m_tcKey->Disable();
    m_textKeyIdx = new wxStaticText(m_wirelessPanel, wxID_ANY, _("Key Index:"), wxPoint(10,182), wxSize(70,40));
	m_cbbIndex = new wxComboBox(m_wirelessPanel, wxID_ANY, wxEmptyString, wxPoint(190,182), wxSize(60,28), 0, 0, wxCB_READONLY, wxDefaultValidator);
	m_cbbIndex->Append(_T("1"));
	m_cbbIndex->Append(_T("2"));
	m_cbbIndex->Append(_T("3"));
	m_cbbIndex->Append(_T("4"));
	m_cbbIndex->SetValue(_T("1"));
	m_cbbIndex->Enable(false);
    m_textTip = new wxStaticText(m_wirelessPanel, ID_TIPSTATICTEXT, wxEmptyString, wxPoint(190,215), wxDefaultSize, 0, _T("ID_TIPSTATICTEXT"));
	#endif

    #if defined(__WXMSW__)
	m_othersPanel = new wxPanel(m_nbEdit, ID_OTHERSPANEL, wxPoint(97,7), wxSize(500,221), wxTAB_TRAVERSAL, _T("ID_OTHERSPANEL"));
	m_cbNetworkSecrity = new wxCheckBox(m_othersPanel, ID_NETWORKSECRITYCHECKBOX, _("Network Security"), wxPoint(10,10), wxSize(260,40), 0, wxDefaultValidator, _T("ID_NETWORKSECRITYCHECKBOX"));
	m_cbNetworkSecrity->SetValue(false);
	m_cbApp = new wxCheckBox(m_othersPanel, ID_APPCHECKBOX, _("Automatically enable applications"), wxPoint(10,50), wxSize(260,40), 0, wxDefaultValidator, _T("ID_APPCHECKBOX"));
	m_cbApp->SetValue(false);
	m_cbDefault = new wxCheckBox(m_othersPanel, ID_DEFAULTCHECKBOX, _("Overwrite default TCP/IP and DNS"), wxPoint(10,90), wxSize(260,40), 0, wxDefaultValidator, _T("ID_DEFAULTCHECKBOX"));
	m_cbDefault->SetValue(false);
	m_buttonNs = new wxButton(m_othersPanel, ID_NSBUTTON, _("Settings"), wxPoint(280,15), wxSize(130,27), 0, wxDefaultValidator, _T("ID_NSBUTTON"));
	m_buttonNs->Disable();
	m_buttonApp = new wxButton(m_othersPanel, ID_APPBUTTON, _("Settings"), wxPoint(280,55), wxSize(130,27), 0, wxDefaultValidator, _T("ID_APPBUTTON"));
	m_buttonApp->Disable();
	m_buttonDefault = new wxButton(m_othersPanel, ID_DEFAULTBUTTON, _("Settings"), wxPoint(280,95), wxSize(130,27), 0, wxDefaultValidator, _T("ID_DEFAULTBUTTON"));
	m_buttonDefault->Disable();
	m_buttonProxy = new wxButton(m_othersPanel, ID_PROXYBUTTON, _("Settings"), wxPoint(280,193), wxSize(130,27), 0, wxDefaultValidator, _T("ID_PROXYBUTTON"));
	m_buttonProxy->Disable();
	m_buttonBrowser = new wxStaticBox(m_othersPanel, ID_BROWSERSTATICBOX, _("Customize Firefox Browser"), wxPoint(5,130), wxSize(457,107), 0, _T("ID_BROWSERSTATICBOX"));
	m_cbHomepage = new wxCheckBox(m_othersPanel, ID_HOMEPAGECHECKBOX, _("Overwrite homepage"), wxPoint(10,151), wxSize(260,32), 0, wxDefaultValidator, _T("ID_HOMEPAGECHECKBOX"));
	m_cbHomepage->SetValue(false);
	m_cbProxy = new wxCheckBox(m_othersPanel, ID_PROXYCHECKBOX, _("Overwrite proxy configuration"), wxPoint(10,186), wxSize(260,40), 0, wxDefaultValidator, _T("ID_PROXYCHECKBOX"));
	m_textHomepage = new wxTextCtrl(m_othersPanel, ID_HOMEPAGETEXTCTRL, wxEmptyString, wxPoint(280,156), wxSize(169,24), 0, wxDefaultValidator, _T("ID_HOMEPAGETEXTCTRL"));
 	#endif

	#if defined(__UNIX__)
	m_othersPanel = new wxPanel(m_nbEdit, ID_OTHERSPANEL, wxPoint(97,7), wxSize(500,221), wxTAB_TRAVERSAL, _T("ID_OTHERSPANEL"));
	m_cbNetworkSecrity = new wxCheckBox(m_othersPanel, ID_NETWORKSECRITYCHECKBOX, _("Network Security"), wxPoint(10,10), wxSize(270,32), 0, wxDefaultValidator, _T("ID_NETWORKSECRITYCHECKBOX"));
	m_cbNetworkSecrity->SetValue(false);
	m_cbApp = new wxCheckBox(m_othersPanel, ID_APPCHECKBOX, _("Automatically enable applications"), wxPoint(10,50), wxSize(270,32), 0, wxDefaultValidator, _T("ID_APPCHECKBOX"));
	m_cbApp->SetValue(false);
	m_cbDefault = new wxCheckBox(m_othersPanel, ID_DEFAULTCHECKBOX, _("Overwrite default TCP/IP and DNS"), wxPoint(10,90), wxSize(270,30), 0, wxDefaultValidator, _T("ID_DEFAULTCHECKBOX"));
	m_cbDefault->SetValue(false);
	m_buttonNs = new wxButton(m_othersPanel, ID_NSBUTTON, _("Settings"), wxPoint(280,15), wxSize(145,27), 0, wxDefaultValidator, _T("ID_NSBUTTON"));
	m_buttonNs->Disable();
	m_buttonApp = new wxButton(m_othersPanel, ID_APPBUTTON, _("Settings"), wxPoint(280,55), wxSize(145,27), 0, wxDefaultValidator, _T("ID_APPBUTTON"));
	m_buttonApp->Disable();
	m_buttonDefault = new wxButton(m_othersPanel, ID_DEFAULTBUTTON, _("Settings"), wxPoint(280,95), wxSize(145,27), 0, wxDefaultValidator, _T("ID_DEFAULTBUTTON"));
	m_buttonDefault->Disable();
	m_buttonProxy = new wxButton(m_othersPanel, ID_PROXYBUTTON, _("Settings"), wxPoint(280,189), wxSize(145,27), 0, wxDefaultValidator, _T("ID_PROXYBUTTON"));
	m_buttonProxy->Disable();
	m_buttonBrowser = new wxStaticBox(m_othersPanel, ID_BROWSERSTATICBOX, _("Customize Internet Explorer or Firefox Browser"), wxPoint(5,133), wxSize(457,112), 0, _T("ID_BROWSERSTATICBOX"));
	m_cbHomepage = new wxCheckBox(m_othersPanel, ID_HOMEPAGECHECKBOX, _("Overwrite homepage"), wxPoint(10,152), wxSize(270,32), 0, wxDefaultValidator, _T("ID_HOMEPAGECHECKBOX"));
	m_cbHomepage->SetValue(false);
	m_cbProxy = new wxCheckBox(m_othersPanel, ID_PROXYCHECKBOX, _("Overwrite proxy configuration"), wxPoint(10,188), wxSize(270,32), 0, wxDefaultValidator, _T("ID_PROXYCHECKBOX"));
	m_textHomepage = new wxTextCtrl(m_othersPanel, ID_HOMEPAGETEXTCTRL, wxEmptyString, wxPoint(280,158), wxSize(169,24), 0, wxDefaultValidator, _T("ID_HOMEPAGETEXTCTRL"));
	#endif

	m_cbProxy->SetValue(false);
    m_textHomepage->Disable();
	m_textHomepage->SetEditable(false);
	m_nbEdit->AddPage(m_generalPanel, _("General Settings"), false);
	m_nbEdit->AddPage(m_wirelessPanel, _("Wireless Settings"), false);
	m_nbEdit->AddPage(m_othersPanel, _("Other"), false);

	m_textName->SetValue(wxString::FromUTF8(m_profile.sProfileName.c_str()));
    m_textName->SetFocus();
	if ( !m_profile.sProfileIcon.empty() )
	{
	    m_cbName->SetSelection(atoi(m_profile.sProfileIcon.c_str()));
    }
	if ( (m_profile.stGenernalSet.ConnecType == "wireless") )
	{
	    m_cbConType->SetValue(_("Wireless LAN"));
//	    SetIPAddress(ADAPTER_WIREDLESS);
//	    m_checkboxAuthen->Enable(false);
//	    m_cbDefault->Enable(false);
    }
    else
    {
        m_cbConType->SetValue(_("Wired LAN"));
        m_nbEdit->RemovePage(1);
        m_cbNetworkSecrity->Enable(false);
//        SetIPAddress(ADAPTER_WIRED);
    }
    m_cbConType->Enable(false);
//    if ( m_profile.stGenernalSet.Authentication == "1" )
//    {
//        m_checkboxAuthen->SetValue(true);
//        if ( m_profile.stGenernalSet.ConnecType == "wireless" )
//        {
//            m_textAuthenType->Disable();
//        }
//        else
//        {
//            m_textAuthenType->Enable();
//        }
//    }

    m_textSSID->SetValue(wxString::FromUTF8(m_profile.stWirelessSet.SSID.c_str()));

    if ( !m_profile.stWirelessSet.WirlessType.empty() )
    {
        m_cbbWirelessType->SetValue(wxString::FromUTF8(m_profile.stWirelessSet.WirlessType.c_str()));
    }

    if (!m_profile.stWirelessSet.WlanSecurity.empty())
    {
        if ( m_profile.stWirelessSet.WlanSecurity == "none" )
        {
            m_cbbSecType->SetSelection(0);
            m_textTip->SetLabel(_T(""));
            m_cbbIndex->Enable(false);
        }
        else if (m_profile.stWirelessSet.WlanSecurity == "wep")
        {
            m_cbbSecType->SetSelection(1);
            m_sWepKey = ENMUtil::StringToWxString(m_profile.stWirelessSet.stWEPSecurity.value);
            m_tcKey->Enable();
            m_cbbIndex->Enable(true);
            m_tcKey->SetValue(wxString::FromUTF8(m_profile.stWirelessSet.stWEPSecurity.value.c_str()));
            m_cbbIndex->SetValue(wxString::FromUTF8(m_profile.stWirelessSet.stWEPSecurity.keyIndex.c_str()));
            m_textTip->SetLabel(_("Use hexadecimal digits (0-9, a-f)"));
//            m_buttonSTSettings->Enable();
//            wepKeyDlg.m_TcKeyOne->SetValue(wxString::FromUTF8(m_profile.stWirelessSet.stWEPSecurity.value.c_str()));
        }
        else if (m_profile.stWirelessSet.WlanSecurity == "wpa-psk")
        {
            m_cbbSecType->SetSelection(2);
            m_sWpaKey = ENMUtil::StringToWxString(m_profile.stWirelessSet.stWPASecurity.value);
            m_tcKey->Enable();
            m_cbbIndex->Enable(false);
            m_tcKey->SetValue(wxString::FromUTF8(m_profile.stWirelessSet.stWPASecurity.value.c_str()));
            m_textTip->SetLabel(_T(""));
//            m_buttonSTSettings->Enable();
        }
        else
        {
            m_cbbSecType->SetSelection(3);
            m_textTip->SetLabel(_T(""));
            m_cbbIndex->Enable(false);
        }
    }

    if ( m_profile.stOtherSet.NetworkSecurity == "1" )
    {
        m_cbNetworkSecrity->SetValue(true);
        m_buttonNs->Enable(true);
        m_strForbidShareFileAndPrint = m_profile.stOtherSet.stNetSecurity.sForbidShareFileAndPrint;
        m_strForbidShareInternet = m_profile.stOtherSet.stNetSecurity.sForbidShareInternet;
        m_strStartWindowFirewall = m_profile.stOtherSet.stNetSecurity.sStartWindowFirewall;
    }

    if ( m_profile.stOtherSet.AutoRunAppFlag == "1" )
    {
        m_cbApp->SetValue(true);
        m_buttonApp->Enable(true);
        AutoRunApp = m_profile.stOtherSet.AutoRunApp;
    }

    if ( m_profile.stOtherSet.IPDNSFlag == "1" )
    {
        m_cbDefault->SetValue(true);
        m_buttonDefault->Enable(true);
        m_strIP = ENMUtil::StringToWxString(m_profile.stOtherSet.stIPDNSSet.IPvalue);
        m_strSubMask = ENMUtil::StringToWxString(m_profile.stOtherSet.stIPDNSSet.SubnetAddress);
        m_strGateWayAddr = ENMUtil::StringToWxString(m_profile.stOtherSet.stIPDNSSet.NetGateway);
        m_strDNS = ENMUtil::StringToWxString(m_profile.stOtherSet.stIPDNSSet.DNSvalue);
    }

    if ( m_profile.stOtherSet.IsHomepage == "1" )
    {
        m_cbHomepage->SetValue(true);
        m_buttonBrowser->Enable(true);
        m_textHomepage->Enable();
        m_textHomepage->SetEditable(true);
        m_textHomepage->SetValue(wxString::FromUTF8(m_profile.stOtherSet.Homepage.c_str()));
    }

    if ( m_profile.stOtherSet.ProxyFlag == "1" )
    {
        m_cbProxy->SetValue(true);
        m_buttonProxy->Enable(true);
        m_strProxy = ENMUtil::StringToWxString(m_profile.stOtherSet.stProxySet.Proxy);
        m_strPort = ENMUtil::StringToWxString(m_profile.stOtherSet.stProxySet.Port);
    }

    if ( create )
    {
        m_textName->Enable(false);
        m_textSSID->Enable(false);
        m_cbbSecType->Enable(false);
        m_cbbWirelessType->Enable(false);
        m_tcKey->Enable(false);
        m_cbbIndex->Enable(false);
        m_buttonScan->Enable(false);
    }

    Centre();
	Connect(ID_AUTHCHECKBOX,wxEVT_COMMAND_CHECKBOX_CLICKED,(wxObjectEventFunction)&EditProfileDialog::Onm_checkboxAuthen1Click);
	Connect(ID_SECRITYTYPECOMBOBOX,wxEVT_COMMAND_COMBOBOX_SELECTED,(wxObjectEventFunction)&EditProfileDialog::Onm_cbbSecTypeSelect);

	Connect(ID_NETWORKSECRITYCHECKBOX,wxEVT_COMMAND_CHECKBOX_CLICKED,(wxObjectEventFunction)&EditProfileDialog::Onm_cbNetworkSecrityClick);
	Connect(ID_APPCHECKBOX,wxEVT_COMMAND_CHECKBOX_CLICKED,(wxObjectEventFunction)&EditProfileDialog::Onm_cbAppClick);
	Connect(ID_DEFAULTCHECKBOX,wxEVT_COMMAND_CHECKBOX_CLICKED,(wxObjectEventFunction)&EditProfileDialog::Onm_cbDefaultClick);
	Connect(ID_HOMEPAGECHECKBOX,wxEVT_COMMAND_CHECKBOX_CLICKED,(wxObjectEventFunction)&EditProfileDialog::Onm_cbHomePageClick);
	Connect(ID_PROXYCHECKBOX,wxEVT_COMMAND_CHECKBOX_CLICKED,(wxObjectEventFunction)&EditProfileDialog::Onm_cbProxyClick);

	Connect(ID_NSBUTTON,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&EditProfileDialog::Onm_buttonNsClick);
	Connect(ID_APPBUTTON,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&EditProfileDialog::Onm_buttonAppClick);
	Connect(ID_DEFAULTBUTTON,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&EditProfileDialog::Onm_buttonDefaultClick);
	Connect(ID_PROXYBUTTON,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&EditProfileDialog::Onm_buttonProxyClick);
    Connect(ID_SCANBUTTON,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&EditProfileDialog::Onm_buttonSnClick);
	Connect(wxID_ANY,wxEVT_INIT_DIALOG,(wxObjectEventFunction)&EditProfileDialog::OnInit);
    Connect(ID_HELP,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&EditProfileDialog::OnF1Press);

#if defined(__WXMSW__)
    static const int AcceleratorEntryCount = 3;
#else
    static const int AcceleratorEntryCount = 1;
#endif
    wxAcceleratorEntry entries[AcceleratorEntryCount];
    entries[0].Set( wxACCEL_NORMAL, WXK_F1, ID_HELP );
#if defined(__WXMSW__)
    entries[1].Set( wxACCEL_ALT, (int)'C', ID_CANCLEBUTTON );
    entries[2].Set( wxACCEL_ALT, (int)'O', ID_OKBUTTON );
#endif
    wxAcceleratorTable accel(AcceleratorEntryCount, entries);
    SetAcceleratorTable(accel);
}

EditProfileDialog::~EditProfileDialog()
{
}

ProfileList_t EditProfileDialog::GetProfile() const
{
    return m_profile;
}

void EditProfileDialog::OnInit(wxInitDialogEvent& event)
{
    if ( !m_isForCreate )
    {
        NETWORK_MODE networkMode = DataCenter::GetInstance()->GetCurrentNetworkMode();
        m_buttonScan->Enable( networkMode == NETWORK_MODE_WIRELESS_LAN_CONNECT || networkMode == NETWORK_MODE_WIRELESS_LAN_DISCONNECT );
        wxString strCurrentProfile = DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile();
        m_textName->Enable(wxString::FromUTF8(m_profile.sProfileName.c_str()).Cmp(strCurrentProfile) != 0);
    }
}

void EditProfileDialog::Onm_buttonOKClick(wxCommandEvent& event)
{
    wxString strNewName = m_textName->GetValue();
    strNewName = strNewName.Trim(false).Trim(true);
    if ( strNewName.Length() == 0 )
    {
        wxMessageDialog msg(this, _("Profile name cannot be empty!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        m_textName->SetFocus();
        return;
    }
    if ( ENMUtil::CheckValide(strNewName) == ENMUtil::CHECK_ILLEGAL )
    {
        wxMessageDialog msg(this, _("Profile name cannot contain any of the following characters\n \\ / : * ? \" ' < > |"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        m_textName->SetFocus();
        return;
    }

    if ( !m_isForCreate )
    {
        string strEnterProfile = ENMUtil::WxStringToString(strNewName);
        ENMUtil::StringToLowerCase(strEnterProfile);
        ProfileManagerDlg* pDialog = DataCenter::GetInstance()->GetProfileManagerDlgHandle();
        if ( pDialog->IsProfileExist(strNewName, m_strOldName) )
        {
            wxMessageDialog msg(this, _("A profile with the name you specified already exists.\nPlease specify a different name!"), _("Message"), wxOK | wxICON_INFORMATION);
            msg.ShowModal();
            m_textName->SetFocus();
            return;
        }
    }

    if ( m_cbConType->GetValue().Cmp(_("Wireless LAN")) == 0 )
    {
        if ( ENMUtil::CheckValide(m_textSSID->GetValue()) == ENMUtil::CHECK_EMPTY )
        {
            wxMessageDialog msg(this, _("SSID cannot be empty!"), _("Message"), wxOK | wxICON_INFORMATION);
            msg.ShowModal();
            m_textSSID->SetFocus();
            return;
        }
        if ( !m_textSSID->GetValue().IsAscii() )
        {
            wxMessageDialog msg(this, _("Invalid SSID!"), _("Message"), wxOK | wxICON_INFORMATION);
            msg.ShowModal();
            m_textSSID->SetFocus();
            return;
        }
        if ( ENMUtil::CheckValide(m_textSSID->GetValue()) == ENMUtil::CHECK_ILLEGAL )
        {
            wxMessageDialog msg(this, _("SSID cannot contain any of the following characters\n \\ / : * % ? \" ' < > |"), _("Message"), wxOK | wxICON_INFORMATION);
            msg.ShowModal();
            m_textSSID->SetFocus();
            return;
        }
        wxString currentText = m_cbbSecType->GetValue();
        if ( currentText.Cmp(_T("WEP")) == 0 )
        {
            wxString strWepKey = m_tcKey->GetValue();
            if ( strWepKey.IsEmpty() )
            {
                wxMessageDialog msg(this, _("WEP key cannot be empty!"), _("Message"), wxOK | wxICON_INFORMATION);
                msg.ShowModal();
                return;
            }
            if ( !ENMUtil::IsHexNumber(strWepKey) )
            {
                wxMessageDialog msg(this, _("WEP key must be hexadecimal. \n(Must contain only numbers 0-9 and letters a-f)"), _("Message"), wxOK | wxICON_INFORMATION);
                msg.ShowModal();
                return;
            }
        }

        if (currentText.Cmp(_T("WPA-PSK")) == 0)
        {
            if (m_tcKey->GetValue().IsEmpty())
            {
                wxMessageDialog msg(this, _("WPA key cannot be empty!"), _("Message"), wxOK | wxICON_INFORMATION);
                msg.ShowModal();
                return;
            }
        }
    }

    wxString strProfileName = m_textName->GetValue();
    strProfileName = strProfileName.Trim(true).Trim(false);
    m_textName->SetValue(strProfileName);
    m_profile.sProfileName = ENMUtil::WxStringToString(strProfileName);
    m_profile.sProfileIcon = ENMUtil::WxStringToString(wxString::Format(_T("%d"),m_cbName->GetSelection()));
    if( !(m_cbConType->GetValue().Cmp(_("Wireless LAN"))) )
    {
        m_profile.stGenernalSet.ConnecType = "wireless";
    }
    else
    {
        m_profile.stGenernalSet.ConnecType = "lan";
    }

/*
    if (m_checkboxAuthen->IsChecked())
    {
        m_profile.stGenernalSet.Authentication = "1";
    }
    else
    {
         m_profile.stGenernalSet.Authentication = "0";
    }
    m_profile.stGenernalSet.DetailAuthentication = ENMUtil::WxStringToString(m_textAuthenType->GetValue());
*/

    //2nd
    wxString strEssidName = m_textSSID->GetValue();
    strEssidName = strEssidName.Trim(true);
    strEssidName = strEssidName.Trim(false);
    m_profile.stWirelessSet.SSID = ENMUtil::WxStringToString(strEssidName);
    if ( !m_cbbWirelessType->GetValue().Cmp(_("Automatic")) )
    {
        m_profile.stWirelessSet.WirlessType  = "Automatic";
    }
    else if (!m_cbbWirelessType->GetValue().Cmp(_T("802.11b")))
    {
        m_profile.stWirelessSet.WirlessType  = "802.11b";
    }
    else if (!m_cbbWirelessType->GetValue().Cmp(_T("802.11g")))
    {
        m_profile.stWirelessSet.WirlessType  = "802.11g";
    }
    else
    {
        m_profile.stWirelessSet.WirlessType  = "802.11n";
    }
    switch( m_cbbSecType->GetSelection() )
    {
    case 0:
        m_profile.stWirelessSet.WlanSecurity = "none";
        m_profile.stWirelessSet.stWEPSecurity.keyIndex = "1";
        break;
    case 1:
        m_profile.stWirelessSet.WlanSecurity = "wep";
        m_profile.stWirelessSet.stWEPSecurity.value = ENMUtil::WxStringToString(m_tcKey->GetValue());
        m_profile.stWirelessSet.stWEPSecurity.keyIndex = ENMUtil::WxStringToString(m_cbbIndex->GetValue());
        break;
    case 2:
        m_profile.stWirelessSet.WlanSecurity = "wpa-psk";
        m_profile.stWirelessSet.stWPASecurity.value = ENMUtil::WxStringToString(m_tcKey->GetValue());
        m_profile.stWirelessSet.stWEPSecurity.keyIndex = "1";
        break;
    case 3:
        m_profile.stWirelessSet.WlanSecurity = "unknown";
        break;
    }

    //3th
    if(m_cbNetworkSecrity->IsChecked())
    {
        m_profile.stOtherSet.NetworkSecurity = "1";
    }
    else
    {
        m_profile.stOtherSet.NetworkSecurity = "0";
    }

    if(m_cbApp->IsChecked())
    {
        m_profile.stOtherSet.AutoRunAppFlag = "1";
    }
    else
    {
        m_profile.stOtherSet.AutoRunAppFlag = "0";
    }

    if(m_cbDefault->IsChecked())
    {
        m_profile.stOtherSet.IPDNSFlag = "1";
    }
    else
    {
        m_profile.stOtherSet.IPDNSFlag = "0";
    }

    if(m_cbHomepage->IsChecked())
    {
        m_profile.stOtherSet.IsHomepage = "1";
    }
    else
    {
        m_profile.stOtherSet.IsHomepage = "0";
    }

    if(m_cbProxy->IsChecked())
    {
        m_profile.stOtherSet.ProxyFlag = "1";
    }
    else
    {
        m_profile.stOtherSet.ProxyFlag = "0";
    }

    m_profile.stOtherSet.stNetSecurity.sForbidShareFileAndPrint = m_strForbidShareFileAndPrint;
    m_profile.stOtherSet.stNetSecurity.sForbidShareInternet = m_strForbidShareInternet;
    m_profile.stOtherSet.stNetSecurity.sStartWindowFirewall = m_strStartWindowFirewall;

    wxString currentHomePage = m_textHomepage->GetValue();
    currentHomePage = currentHomePage.Trim(true);
    currentHomePage = currentHomePage.Trim(false);
    m_profile.stOtherSet.Homepage = ENMUtil::WxStringToString(currentHomePage);
    m_profile.stOtherSet.stIPDNSSet.IPvalue = ENMUtil::WxStringToString(m_strIP);
    m_profile.stOtherSet.stIPDNSSet.SubnetAddress = ENMUtil::WxStringToString(m_strSubMask);
    m_profile.stOtherSet.stIPDNSSet.NetGateway = ENMUtil::WxStringToString(m_strGateWayAddr);
    m_profile.stOtherSet.stIPDNSSet.DNSvalue = ENMUtil::WxStringToString(m_strDNS);
    m_profile.stOtherSet.stProxySet.Proxy = ENMUtil::WxStringToString(m_strProxy);
    m_profile.stOtherSet.stProxySet.Port = ENMUtil::WxStringToString(m_strPort);
    m_profile.stOtherSet.AutoRunApp = AutoRunApp;

    EndModal(wxID_OK);
}

void EditProfileDialog::Onm_checkboxAuthen1Click(wxCommandEvent& event)
{
#if 0
    if (m_checkboxAuthen->IsChecked())
    {
#if defined(__UNIX__)
        wxString cFileName = _T("/usr/sbin/xsupplicant");
        if ( wxFile::Exists(cFileName) )
        {
            m_textAuthenType->Enable();
        }
        else
        {
            wxMessageDialog msg(this, _("Please install xsupplicant first!\n\nAfter that you can enable IEEE 802.1x authentication."), _T("Message"), wxOK | wxICON_INFORMATION);
            msg.ShowModal();
            m_checkboxAuthen->SetValue(false);
            m_textAuthenType->Disable();
            return;
        }
#endif
#if defined(__WXMSW__)
        m_textAuthenType->Enable();
#endif
    }
    else
    {
        m_textAuthenType->Disable();
    }
#endif
}

void EditProfileDialog::Onm_buttonCancelClick(wxCommandEvent& event)
{
    wxMessageDialog dialog(this, _("Are you sure you want to cancel the operation?"), _("Confirm"), wxYES_NO | wxNO_DEFAULT | wxICON_QUESTION);
    if ( dialog.ShowModal() == wxID_YES )
    {
        Close();
    }
}

void EditProfileDialog::Onm_cbbSecTypeSelect(wxCommandEvent& event)
{
    wxString currentText = m_cbbSecType->GetValue();
    if (currentText.Cmp(_T("WPA-PSK")) == 0 )
    {
        m_tcKey->Enable();
        m_tcKey->SetValue(wxString::FromUTF8(m_profile.stWirelessSet.stWPASecurity.value.c_str()));
        m_cbbIndex->Enable(false);
        m_textTip->SetLabel(_T(""));
    }
    if ( currentText.Cmp(_T("WEP")) == 0 )
    {
        m_tcKey->Enable();
        m_tcKey->SetValue(wxString::FromUTF8(m_profile.stWirelessSet.stWEPSecurity.value.c_str()));
//        m_cbbIndex->SetValue(wxString::FromUTF8(m_profile.stWirelessSet.stWEPSecurity.keyIndex.c_str()));
        m_cbbIndex->Enable(true);
        m_textTip->SetLabel(_("Use hexadecimal digits (0-9, a-f)"));
    }
    if ( currentText.Cmp(_T("NONE")) == 0 || currentText.Cmp(_T("UNKNOWN")) == 0 )
    {
        m_tcKey->Disable();
        m_tcKey->SetValue(_T(""));
        m_cbbIndex->Enable(false);
        m_textTip->SetLabel(_T(""));
    }
}

void EditProfileDialog::Onm_cbNetworkSecrityClick(wxCommandEvent& event)
{
    if (m_cbNetworkSecrity->IsChecked())
    {
        m_buttonNs->Enable();
    }

    else
    {
        m_buttonNs->Disable();
    }
}

void EditProfileDialog::Onm_cbAppClick(wxCommandEvent& event)
{
    if (m_cbApp->IsChecked())
    {
        m_buttonApp->Enable();
    }

    else
    {
        m_buttonApp->Disable();
    }
}

void EditProfileDialog::Onm_cbDefaultClick(wxCommandEvent& event)
{
    if (m_cbDefault->IsChecked())
    {
        m_buttonDefault->Enable();
    }

    else
    {
        m_buttonDefault->Disable();
    }
}

void EditProfileDialog::Onm_cbProxyClick(wxCommandEvent& event)
{
    if (m_cbProxy->IsChecked())
    {
        m_buttonProxy->Enable();
    }

    else
    {
        m_buttonProxy->Disable();
    }
}

void EditProfileDialog::Onm_buttonNsClick(wxCommandEvent& event)
{
    NetSecrityDlg netSecrityDlg(this);
    if ( m_strForbidShareInternet == "1" )
    {
        netSecrityDlg.m_cbInternet->SetValue(true);
    }
#if defined(__WXMSW__)
    if ( m_strForbidShareFileAndPrint == "1" )
    {
        netSecrityDlg.m_cbFile->SetValue(true);
    }

    if ( m_strStartWindowFirewall == "1" )
    {
        netSecrityDlg.m_cbFirewall->SetValue(true);
    }
#endif
    if ( netSecrityDlg.ShowModal() == wxID_OK )
    {
        if ( netSecrityDlg.m_cbInternet->IsChecked() )
        {
            m_strForbidShareInternet = "1";
        }
        else
        {
            m_strForbidShareInternet = "0";
        }
#if defined(__WXMSW__)
        if ( netSecrityDlg.m_cbFile->IsChecked() )
        {
            m_strForbidShareFileAndPrint = "1";
        }
        else
        {
            m_strForbidShareFileAndPrint = "0";
        }

        if ( netSecrityDlg.m_cbFirewall->IsChecked() )
        {
            m_strStartWindowFirewall = "1";
        }
        else
        {
            m_strStartWindowFirewall = "0";
        }
#endif
    }
    else
    {
        if (m_strForbidShareInternet.empty() || "0" == m_strForbidShareInternet )
        {
            netSecrityDlg.m_cbInternet->SetValue(false);
        }
        else
        {
            netSecrityDlg.m_cbInternet->SetValue(true);
        }
#if defined(__WXMSW__)
        if (m_strForbidShareFileAndPrint.empty() || "0" == m_strForbidShareFileAndPrint )
        {
            netSecrityDlg.m_cbFile->SetValue(false);
        }
        else
        {
            netSecrityDlg.m_cbFile->SetValue(true);
        }
        if (m_strStartWindowFirewall.empty() || "0" == m_strStartWindowFirewall )
        {
            netSecrityDlg.m_cbFirewall->SetValue(false);
        }
        else
        {
            netSecrityDlg.m_cbFirewall->SetValue(true);
        }
#endif
    }
}

void EditProfileDialog::Onm_buttonAppClick(wxCommandEvent& event)
{
    wxArrayString as;
    for ( vector<string>::size_type i = 0; i < AutoRunApp.size(); i++ )
    {
        wxString strAppName = wxString::FromUTF8(AutoRunApp[i].c_str());
        as.Add(strAppName);
    }
    AutoRunSettings autoRunDlg(this);
    autoRunDlg.SetApplications(as);
    if(autoRunDlg.ShowModal() == wxID_OK)
    {
        as.Empty();
        as = autoRunDlg.GetApplications();
        AutoRunApp.clear();
        for( size_t i = 0; i < as.GetCount(); i++ )
        {
            wxString strAppName = as.Item(i);
            string strName = ENMUtil::WxStringToString(strAppName);
            //const char * pName = strName.c_str();
            AutoRunApp.push_back(strName);
        }
    }
}

void EditProfileDialog::Onm_buttonDefaultClick(wxCommandEvent& event)
{
    IPSettings ipDlg(this);

    if ( m_cbDefault->IsChecked() )
    {
        if ( m_strIP.IsEmpty() )
        {
            ipDlg.m_TcIP->SetValue(wxString::FromUTF8(m_profile.stOtherSet.stIPDNSSet.IPvalue.c_str()));
        }
        else
        {
            ipDlg.m_TcIP->SetValue(m_strIP);
        }

        if ( m_strSubMask.IsEmpty() )
        {
            ipDlg.m_TcSm->SetValue(wxString::FromUTF8(m_profile.stOtherSet.stIPDNSSet.SubnetAddress.c_str()));
        }
        else
        {
            ipDlg.m_TcSm->SetValue(m_strSubMask);
        }

        if ( m_strGateWayAddr.IsEmpty() )
        {
            ipDlg.m_TcGa->SetValue(wxString::FromUTF8(m_profile.stOtherSet.stIPDNSSet.NetGateway.c_str()));
        }
        else
        {
            ipDlg.m_TcGa->SetValue(m_strGateWayAddr);
        }

        if ( m_strDNS.IsEmpty() )
        {
            ipDlg.m_TcDns->SetValue(wxString::FromUTF8(m_profile.stOtherSet.stIPDNSSet.DNSvalue.c_str()));
        }
        else
        {
            ipDlg.m_TcDns->SetValue(m_strDNS);
        }
    }

    if(ipDlg.ShowModal() == wxID_OK)
    {
        m_strIP = ipDlg.m_TcIP->GetValue();
        m_strSubMask = ipDlg.m_TcSm->GetValue();
        m_strGateWayAddr = ipDlg.m_TcGa->GetValue();
        m_strDNS = ipDlg.m_TcDns->GetValue();
    }
    else
    {
        ipDlg.m_TcIP->SetValue(m_strIP);
        ipDlg.m_TcSm->SetValue(m_strSubMask);
        ipDlg.m_TcGa->SetValue(m_strGateWayAddr);
        ipDlg.m_TcDns->SetValue(m_strDNS);
    }
}

void EditProfileDialog::Onm_buttonProxyClick(wxCommandEvent& event)
{
    ProxySettings pxoxyDlg(this);
    if ( m_cbProxy->IsChecked() )
    {
        if ( m_strProxy.IsEmpty() )
        {
            pxoxyDlg.m_TcPcoxy->SetValue(wxString::FromUTF8(m_profile.stOtherSet.stProxySet.Proxy.c_str()));
        }
        else
        {
            pxoxyDlg.m_TcPcoxy->SetValue(m_strProxy);
        }

        if ( m_strPort.IsEmpty() )
        {
            pxoxyDlg.m_TcPort->SetValue(wxString::FromUTF8(m_profile.stOtherSet.stProxySet.Port.c_str()));
        }
        else
        {
            pxoxyDlg.m_TcPort->SetValue(m_strPort);
        }
    }

    if(pxoxyDlg.ShowModal() == wxID_OK)
    {
        m_strProxy = pxoxyDlg.m_TcPcoxy->GetValue();
        m_strPort = pxoxyDlg.m_TcPort->GetValue();
    }
    else
    {
        pxoxyDlg.m_TcPcoxy->SetValue(m_strProxy);
        pxoxyDlg.m_TcPort->SetValue(m_strPort);
    }
}

void EditProfileDialog::Onm_buttonSnClick(wxCommandEvent& event)
{
    PolicyManager* p = DataCenter::GetInstance()->GetPolicyManager();
    if ( !p->IsScanEnable() )
    {
        wxMessageDialog dlg(this, _("The current policy forbids scanning for wireless networks."), _("Message"), wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }
    if ( (DataCenter::GetInstance()->GetCurrentNetworkMode() != NETWORK_MODE_WIRELESS_LAN_CONNECT) && (DataCenter::GetInstance()->GetCurrentNetworkMode() != NETWORK_MODE_WIRELESS_LAN_DISCONNECT) )
    {
        wxMessageDialog msg(this, _("Cannot find WLAN adapter!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        return;
    }

    ScanNetworkDlg* pScanNetworkDialog = DataCenter::GetInstance()->GetScanNetworkDlgHandle();
    if ( NULL == pScanNetworkDialog )
        return;

    if ( pScanNetworkDialog->IsShown() )
        pScanNetworkDialog->CloseDialog(wxID_CANCEL);
    pScanNetworkDialog->SetDialogMode(false);
    APStatus ap;
    if ( pScanNetworkDialog->ShowModal() == wxID_OK && pScanNetworkDialog->GetSelectedNetwork(&ap) )
    {
        m_textSSID->SetValue(wxString::FromUTF8((const char*)ap.ssid.ucSsid, ap.ssid.length));
        if (0 == ap.auth || 100 == ap.auth)
        {
            m_cbbSecType->SetSelection(0);
        }
        else if (1 == ap.auth)
        {
            m_cbbSecType->SetSelection(1);
        }
        else if (2 == ap.auth)
        {
            m_cbbSecType->SetSelection(2);
        }
        else
        {
            m_cbbSecType->SetSelection(3);
        }

        if (0 == ap.type)
        {
            m_cbbWirelessType->SetValue(_T("802.11b"));
        }
        else if (1 == ap.type)
        {
            m_cbbWirelessType->SetValue(_T("802.11g"));
        }
        else if (2 == ap.type)
        {
            m_cbbWirelessType->SetValue(_T("802.11n"));
        }
        else
        {
            m_cbbWirelessType->SetValue(_("Automatic"));
        }
        wxString currentText = m_cbbSecType->GetValue();
        if ( currentText.Cmp(_T("WPA-PSK")) == 0 )
        {
            m_textTip->SetLabel(_T(""));
            m_tcKey->Enable();
            m_tcKey->SetValue(_T(""));
            m_cbbIndex->Enable(false);
        }
        if ( currentText.Cmp(_T("WEP")) == 0 )
        {
            m_textTip->SetLabel(_("Use hexadecimal digits (0-9, a-f)"));
            m_tcKey->Enable();
            m_tcKey->SetValue(_T(""));
            m_cbbIndex->Enable(true);
        }
        if ( currentText.Cmp(_T("NONE")) == 0 ||  currentText.Cmp(_T("UNKNOWN")) == 0 )
        {
            m_textTip->SetLabel(_T(""));
            m_tcKey->Disable();
            m_tcKey->SetValue(_T(""));
            m_cbbIndex->Enable(false);
        }
    }
}

void EditProfileDialog::Onm_cbHomePageClick(wxCommandEvent& event)
{
    if (m_cbHomepage->IsChecked())
    {
        m_textHomepage->Enable();
        m_textHomepage->SetEditable(true);
    }
    else
    {
        m_textHomepage->Disable();
        m_textHomepage->SetEditable(false);
    }
}
void EditProfileDialog::OnF1Press(wxCommandEvent& event)
{
#if defined(__UNIX__)
    if(wxFileExists(wxT("/usr/share/EasyNetworkManager/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf")))
    {
        wxString cmd = wxT("evince /usr/share/EasyNetworkManager/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf --page-label=31");
        //wxExecute(cmd);
    }
#endif
#if defined(__WXMSW__)
    ENMUtil::ShowContextHelp(this, _T("EditProfile"));
#endif
}

void EditProfileDialog::SetIPAddress(ADAPTER_TYPE adapterType)
{
    if ( !m_cbDefault->IsChecked() )
    {
        bool success = ENMUtil::GetIPAddress(m_strIP, m_strSubMask, m_strGateWayAddr, m_strDNS, adapterType);
        m_cbDefault->SetValue(success);
        m_buttonDefault->Enable(success);
    }
}
