#ifndef _ENM_POPUP_MENU_H
#define _ENM_POPUP_MENU_H

#include <wx/wx.h>
#include "XMLOperator.h"
#include "MeshConfigurationEntity.h"
#include "DataCenterLinux.h"
class ENMPopupMenu : public wxMenu
{
    public:
        ENMPopupMenu();
        virtual ~ENMPopupMenu();

    private:

        XMLOperator xmlOperator;


        const int id;
        wxBitmap* m_pBmpCheck;
        wxBitmap* m_pBmpEmpty;

        wxMenuItem* m_pmiHelp;
        wxMenuItem* m_pmiManage;
        wxMenuItem* m_pmiScan;
        wxMenuItem* m_pmiProfile;
        wxMenuItem* m_pmiMesh;

        static const int ID_MENU_ITEM_HELP;
        static const int ID_MENU_ITEM_MANAGE;
        static const int ID_MENU_ITEM_SCAN;
        static const int ID_MENU_ITEM_PROFILE;
        static const int ID_MENU_ITEM_PROFILE_MIN;
        static const int MENU_ITEM_PROFILE_MARGIN_WIDTH;
        static const int MENU_ITEM_MARGIN_WIDTH;
        static const int ID_MENU_ITEM_CONNCETTOMESH;
        static const int ID_MENU_ITEM_SHARE_MY_INTERNET;
        static const int ID_MENU_ITEM_USER_OTHERS_INTERNET;
        static const int ID_MENU_ITEM_TURNON_MESH;
        static const int ID_MENU_ITEM_MESH;

        static const wxBitmap BITMAP_MENU_ITEM_HELP;
        static const wxBitmap BITMAP_MENU_ITEM_MANAGE;
        static const wxBitmap BITMAP_MENU_ITEM_SCAN;
        static const wxBitmap BITMAP_MENU_ITEM_PROFILE;

        void InitMenu();
        void LoadProfileMenuItems();
        void LoadMeshMenuItems();

        void OnMenuItemHelpClicked(wxCommandEvent& event);
        void OnMenuItemManageClicked(wxCommandEvent& event);
        void OnMenuItemScanClicked(wxCommandEvent& event);
        void OnMenuItemProfileClicked(wxCommandEvent& event);
        void OnMenuItemTurnOnClicked(wxCommandEvent& event);
        void OnMenuItemTurnOffClicked(wxCommandEvent& event);
        void OnMenuItemShareMyInternetClicked(wxCommandEvent& event);
        void OnMenuItemUseOthersInternetClicked(wxCommandEvent& event);

};

#endif // _ENM_POPUP_MENU_H
