
#ifndef _ENM_APP_H_
#define _ENM_APP_H_

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif

#include <wx/app.h>
#include "ENMTaskTray.h"
#include <wx/snglinst.h>
#include <fcntl.h>

#include "PublishThread.h"
//#include "StopPublishThread.h"
#include "ListenThread.h"
#include "ENExistBalloon.h"

#define MESHSTATUS_MESHCLOSE    1
#define MESHSTATUS_MESHONLY     2
#define MESHSTATUS_MESHSERVER   3
#define MESHSTATUS_MESHCLIENT   4
class ENMApp : public wxApp
{
    public:
        ENMApp();
        virtual bool OnInit();
        virtual int OnExit();

        bool SetImage(char* image);
        ENMTaskTray* GetENMTaskTray();

        wxString strAppPath;
        wxLocale m_locale;
    bool m_popBalloon;

        void Republish();
        void ReconnectPublish();
        void StopPublish();
        void StartDeploy(const char *ipaddress);
        wxCriticalSection m_critsectPublish;
        void StartPublishTimer();
        void StartBrowseTimer();
        static bool   m_bStartPublishTimer;
        static bool   m_bStartBrowseTimer;
        int m_nMeshStatus;
        NETWORK_MODE m_BeforeMeshNetworkMode;
        wxString m_BeforeMeshAppliedProfile;
    private:
        static const int ID_TIMER_INIT;
        static const int ID_TIMER_EXIT;
        static const int ID_NOTI_TIMER;

        wxTimer m_timerInit;
        wxTimer m_timerExit;
        wxTimer* m_notificationtimer;
        ENMTaskTray* m_taskBarIcon;
        ENExistBalloon* m_notificationDlg;
        wxSingleInstanceChecker* m_checker;
        bool m_ifExit;
        bool GetLock();
        bool ShowMainFrame();
        bool InitializeDCS();
        bool IsProtocolSupported();

        void OnTimerInit(wxTimerEvent& event);
        void OnTimerExit(wxTimerEvent& event);
        void PopupNotification();
        void CloseNotificationHandler();

        void ReBrowse();
        PublishThread *pthread;
        ListenThread *lthread;
        void CloseNotification(wxTimerEvent& event);

        DECLARE_EVENT_TABLE()
};

DECLARE_APP(ENMApp)

void CALLBACK DCSAbortHandler();

#endif // _ENM_APP_H_
